/* BDEOUT: export IBM Basic Data Exchange data-sets from DEC FILES-11 files */

#include <stdio.h>
#include <cx.h>
#include <qiofun.h>
#include <spcio.h>
#define ERROR -1
#define LUN 6
#define EFN 6
FILE	*ioptr;			/* FILES-11 file read in */
#include "ebcdic.h"		/* EBCDIC equivalents of ASCII characters */
char	sector[128];
int	prl[6];			/* QIO parameter block */
int	isb[2];			/* I/O status block returned from QIO */

helpless()
{printf("BDEOUT is a RSX program to export data to IBM Basic Data Exchange Diskettes\n");
 printf("i.e. 8\" soft-sectored single-sided single-density IBM diskette-1 type.\n");
 printf("Program is invoked by the following, where \"MCR>\" is the RSX prompt:\n");
 printf("\t\tMCR>BDEOUT filespec\n");
 printf("The filespec is a standard RSX unambiguous filespec, no file type.\n");
 printf("The filespec may not have more than 8 letters. No UIC. No version.\n");
 printf("The dataset exported will have the same name as the RSX filename\n");
 printf("The RSX file is in ASCII, the IBM dataset is in EBCDIC.\n");
 printf("The IBM diskette is assumed to be in drive DY0: .\n");
 printf("The input file is expected to have records delimited by \\r\\n .\n");
 printf("Output records are padded up to 128 bytes with spaces.\n");
 printf("This pathetic version of BDEOUT destroys all prior data on the destination disk.\n");
 exit();
}

main(argc,argv)
int	argc;
char	**argv;
{
 int		i;
 char		*p;
 unsigned	secnum;
 unsigned	spot;
 unsigned	track;
 int		dsw;
 int		devnam;
 int		devunt;
 if	(argc!=2)
	{printf("\7Expect exactly ONE argument\n");
	 helpless();
	}
 ;
 devnam = 'DY';
 devunt = 0;
 dsw = alun(LUN,devnam,devunt);
 if	(dsw!=IS_SUC)
	{error("Can't attach device! dsw=%oo devnam=%oo devunt=%oo",dsw,devnam,devunt);
	}
 ;
 dsw = qiow(IO_ATT,LUN,EFN,isb,0,prl);
 if	(dsw!=IS_SUC||(isb[0]&0xFF)!=IS_SUC)	error("dsw=%oo isb[0]=%oo isb[1]=%oo \7IO_ATT",dsw,isb[0],isb[1]);
#ifdef SMD
 prl[0] = 0;	/* RX01 density: 3740 standard */
 dsw = qiow(IO_SMD,LUN,EFN,isb,0,prl);
 if	(dsw!=IS_SUC||(isb[0]&0xFF)!=IS_SUC)	error("dsw=%oo isb[0]=%oo isb[1]=%oo \7IO_SMD",dsw,isb[0],isb[1]);
#endif
 /* write data to track 1:73 */
 for	(p=argv[1]; *p; p++)
	{*p = toupper(*p);
	}
 ;
 if	(!(ioptr=fopen(argv[1],"r")))
	{error("Can't find file \"%s\"\7\n",argv[1]);
	}
 ;
 secnum = 25;	/* last sector number used */
 while	(secnum < 1924)	/* still another data sector */
	{p = sector;
	 setmem(sector,128,' ');
	 while	(i=getc(ioptr)
		,(i=(i==EOF?ERROR:i))
		,i!='\n' && i!=ERROR
		)
		{if	(i!='\r')	*p++ = i;
		}
	 ;
	 if	(i==ERROR)	break;
	 /* must have been '\n' */
	 for	(p=sector,i=128;	i;	i--,p++)
		{*p = ebcdic[*p];
		}
	 ;
	 d1put128(sector,++secnum);
	}
 ;
 /* here with secnum == last sector used */
 setmem(sector,80,0x40);
 setmem(sector+80,128-80,0x00);
 d1put128(sector,0);	/* IMPL */
 d1put128(sector,1);
 d1put128(sector,2);	/* cystern scratch */
			/* (you scratch ceramic cysterns with a file) */
 d1put128(sector,3);	/* reserved */
 sector[0]=ebcdic['E'];
 sector[1]=ebcdic['R'];
 sector[2]=ebcdic['M'];
 sector[3]=ebcdic['A'];
 sector[4]=ebcdic['P'];
 d1put128(sector,4);	/* error map */
 setmem(sector,5,0x40);
 d1put128(sector,5);	/* reserved */
 strcpy(sector,
"VOL1IBMIRD PashunfingazDunIt Beware of the Bull                                W"
	)
 ;
 for	(p=sector,i=80;	i;	i--,p++)	*p=ebcdic[*p];
 d1put128(sector,6);	/* volume ID */
 strcpy(sector,
"HDR1                  00128 01001 73026                                   ee0ee "
	)
 ;
 copy(sector+5,argv[1],strlen(argv[1]));
 secnum++;
 track = secnum/26;
 spot = secnum%26 + 1;	/* 1-org sector numbers */
printf("secnum=%d. track=%d. spot=%d.\n",secnum,track,spot);
 sector[74] = track/10 + '0';
 sector[75] = track%10 + '0';
 sector[77] = spot/10 + '0';
 sector[78] = spot%10 + '0';
 for	(p=sector,i=80;	i;	i--,p++)	*p=ebcdic[*p];
 d1put128(sector,7);	/* dataset label */
 setmem(sector,80,ebcdic[' ']);
 sector[0] = ebcdic['D'];
 for	(i=8;	i<26;	i++)	d1put128(sector,i);
}

setmem(base,len,byte)
char	*base;
unsigned	len;
char	byte;
{while	(len--)	*base++=byte;
}

d1put128(data,where)
char	*data;
unsigned where;	/* 0-org sector number */
{
 int	dsw;
 prl[0] = data;
 prl[1] = 128;
 prl[4] = where;
 dsw = qiow(IO_WPB,LUN,EFN,isb,0,prl);
 if	(dsw!=IS_SUC||(isb[0]&0xFF)!=IS_SUC)	error("dsw=%oo isb[0]=%oo isb[1]=%oo \7IO_WPB",dsw,isb[0],isb[1]);
}

/* end: BDEOUT */
