/*
 * RSX11M V3.2 System Definition Headers for C.
 *
 * FileName Block ( NBOFF$ )
 *
 * #include  CX.H
 *
 * (Ab)used with FCS calls and DECUS C I/O system
 *
 * Dean Elsner
 * 26-Mar-82
 *
 */

#define	s_fnam	6
#define	s_ftyp	2
#define	s_fnty	((s_fnam+s_ftyp)/2)


typedef	struct	{
		unsigned	fid_fnum;	/* file number */
		unsigned	fid_fseq;	/* file sequence */
		unsigned	fid_3rd;	/* reserved */
		}
fid;	/* file ID */

typedef	struct	{
		fid		n_fid;		/* file ID */
		char		n_fnam[s_fnam];	/* file name */
		char		n_ftyp[s_ftyp];	/* file type */
		unsigned	n_fver;		/* version */
		}
nfen;	/* file name entry */

typedef struct	{
		nfen		n_nfen;		/* file name entry */
		unsigned	n_stat;		/* status */
#define					nb_ver	0000001	/* explicit file version number */
#define					nb_typ	0000002	/* explicit file type */
#define					nb_nam	0000004	/* explicit file name */
#define					nb_svr	0000010	/* wild file version */
#define					nb_stp	0000020	/* wild file type */
#define					nb_snm	0000040	/* wild file name */
#define					nb_dir	0000100	/* explicit uic */
#define					nb_dev	0000200	/* explicit device */
#define					nb_sd1	0000400	/* wild group of UIC */
#define					nb_sd2	0001000	/* wild owner of UIC */
#define					nb_smi	0040000	/* semicolon seen */
#define					nb_dot	0100000	/* dot seen */
		unsigned	n_next;		/* find-next temporary */
		fid		n_did;		/* directory's fid */
		char		n_dvnm[2];	/* device name ASCII */
		int		n_unit;		/* unit number */
		}
fnb;	/* file name block */
