/*
 * RSX11M V3.2 System Definition Headers for C.
 *
 * File Descriptor Block ( FDOFF$ )
 *
 * #include  CX.H  NBOFF.H
 *
 * (Ab)used with FCS calls and DECUS C I/O system
 *
 * Dean Elsner
 * 25-Mar-82
 *
 */

typedef	struct	{
		unsigned	bd_len;	/* buffer length */
		char*		bd_adr;	/* buffer address */
		}
fcsbd;	/* FCS buffer descriptor */

typedef	struct	{
		long		b_mumble;
		long		b_vbn;	/* virtual block number this buffer */
		unsigned	b_bbfs;	/* bytes read/written */
		char*		b_nxbd;	/* pointer to next buffer descriptor */
		char		b_spare;/* */
		char		b_bfst;	/* buffer status */
#define					bd_fre	0000001	/* buffer available */
		int		b_foo;	/* */
		}
bd;	/* buffer descriptor - internal to fcs */

typedef	struct	{
		char		f_rtyp;	/* record type */
#define					r_fix	1	/* fixed-length records */
#define					r_var	2	/* variable-length records */
#define					r_seq	3	/* sequenced records */
		char		f_ratt;	/* record attributes */
#define					fd_ftn	0000001	/* fortran carriage control bit */
#define					fd_cr	0000002	/* insert CRs between records */
#define					fd_prn	0000004	/* R.SEQ/VFC print file */
#define					fd_blk	0000010	/* records don't cross block boundaries */
		unsigned	f_rsiz;	/* record size */
		long		f_hibk;	/* highest virtual block number allocated */
		long		f_efbk;	/* end-of-file virtual block number */
		unsigned	f_ffby;	/* first free byte in file-end block */
					/* maximum block size for mtape */
		}
fatt;	/* file attribute section of fdb */

typedef	struct	{
		fatt		f_fatt;	/* file attribute section */
		char		f_racc;	/* record access method */
#define					fd_rwm	0000001	/* read/write not get/put */
#define					fd_ran	0000002	/* random not sequential */
#define					fd_plc	0000004	/* partial locate not sequential */
#define					fd_ins	0000010	/* put sequential inserts not truncates */
		char		f_rctl;	/* device characteristics */
#define					fd_rec	0000001	/* record oriented not block oriented */
#define					fd_ccl	0000002	/* carriage-control */
#define					fd_tty	0000004	/* TTY */
#define					fd_dir	0000010	/* directory */
#define					fd_sdi	0000020	/* single directory */
#define					fd_sqd	0000040	/* sequential */
#define					fd_isp	0002000	/* input spooling */
#define					fd_isp	0004000	/* output spooling */
#define					fd_pse	0010000
#define					fd_com	0020000
#define					fd_f11	0040000
#define					fd_mnt	0100000
		fcsbd		f_urbd;	/* user record buffer descriptor */
					/* also f_bkds: block I/O buffer descriptor */
		fcsbd		f_nrbd;	/* next record buffer descriptor */
					/* also f_bkst & f_bkdn */
		unsigned	f_nrec;	/* address of the next record in the block */
					/* also f_ovbs: overriding block size */
		char*		f_eobb; /* end of block buffer */
		long		f_rcnm;	/* record number */
					/* also f_cntg & f_stbk */
		unsigned	f_aloc;	/* extension increment */
		char		f_lun;	/* LUN */
		char		f_facc;	/* access mode */
#define					fa_rd	0000001	/* read only */
#define					fa_wrt	0000002	/* write */
#define					fa_ext	0000004	/* extend */
#define					fa_cre	0000010	/* create new */
#define					fa_tmp	0000020	/* temporary */
#define					fa_shr	0000040	/* shared */
#define					fa_apd	0000100	/* existing file, position to EOF */
#define					fa_nsp	0000100	/* new file, don't supercede */
#define					fa_nsr	0000200	/* don't upward directory search */
#define					fo_rd	(fa_rd)
#define					fo_wrt	(fa_wrt|fa_ext|fa_cre)
#define					fo_apd	(fa_wrt|fa_ext|fa_apd)
#define					fo_mfy	(fa_wrt)
#define					fo_upd	(fa_wrt|fa_ext)
		char*		f_dspt;	/* address of dataset descriptor */
		char*		f_dfnb;	/* address of default filename block */
		char		f_efn;	/* record I/O event flag */
					/* also f_bkef: block I/O event flag */
		char		f_bkp1;	/* bookkeeping */
#define					fd_wrt	0000001	/* this buffer has been altered */
#define					fd_eof	0000002	/* last put was at EOF */
#define					fd_efb	0000004	/* this vbn is EOF */
#define					fd_ef1	0000010	/* delayed EOF report */
#define					fd_dvr	0000020	/* create, default version */
#define					fd_oer	0000040	/* buffer access/allocate failure */
#define					fd_inv	0000100	/* invalid data (no block read) */
#define					fd_spl	0000200	/* automatic spooling */
		char		f_err;	/* error code */
		char		f_err1;	/* DSW */
		char		f_mbct;	/* number of buffers wanted */
		char		f_mbc1;	/* actual bufers in use */
		char		f_mbfg;	/* multi-buffer flag word */
#define					fd_rah	0000001	/* read ahead */
#define					fd_wbh	0000002	/* write behind */
							/* fd_rah & fd_wbh is error */
#define					fd_bgb	0000004	/* big buffers used */
#define					fd_bgd	0000010	/* force dump of big buffer */
		char		f_bgbc;	/* big-buffer block count */
		unsigned	f_vbsz;	/* virtual block size */
		unsigned	f_bbfs;	/* block buffer size */
		long		f_vbn;	/* virtual block number */
		fcsbd		*f_bdb;	/* address of block buffer descriptor block */
					/* zero implies file closed */
		unsigned	f_spdv;	/* rad50 spooler output device (IAS only) */
		char		f_spun;	/* spooler output unit (IAS only) */
		char		f_chr;	/* ACP global volume characteristics */
#define					ch_and	0000001	/* ANSI 'D' tape */
		int		f_actl;	/* two bytes: low: number of retrieval pointers */
					/* high: bits for user and FCS */
#define					fa_dlk	0001000	/* don't lock on abnormal close */
#define					fa_exc	0002000	/* exclusive use */
#define					fa_rwd	0004000	/* enable rewind control magtape */
#define					fa_pos	0010000	/* magtape file creation position control */
#define					fa_wck	0020000	/* enable write check */
#define					fa_seq	0040000	/* sequential process only */
#define					fa_enb	0100000	/* use f_actl */
		unsigned	f_seqn;	/* sequence number this record */
		fnb		f_fnb;	/* filename block */
		}
fdb;

#define FDB fdb
