/* pagetype.c - pause every page as we filter chars */

/*
 *		E D I T   H I S T O R Y
 *
 * 12May85 PF001	Make a non-empty input line mean ABORT
 *			so we dont have problem of ^C MCR>ABO sending
 *			one last page before this kludge dies.
 *			ALGOL68ify it
 *			Tart up error messages & help.
 */

#include <stdio.h>
#include <algol68.h>

#define BIG 9999
#define hope

FILE	*iptr;
FILE	*optr;
int	lopage;			/* lowest page number to type */
int	hipage;			/* highest page number to type */
int	height;			/* page height (lines) */
char	*myname;		/* program's name */

char	*help[]	=
{" "
," This program has MCR not UNIX syntax!"
," It will copy an input-file to a typewriter."
," At every formfeed the program will pause until you strike [RETURN]."
," If you want to quit just then, type [Q] [RETURN]."
," The program has two optional switches:"
,"  /PAGE:lo[:hi]"
,"   Only type pages between 'lo'(default 1) and 'hi'(default 9999)"
,"   The first page is number one."
,"  /HEIGHT:n"
,"   Assume a page is only 'n' lines high, and force a pause after 'n'"
,"   lines on a page. NOTE: also bump the page number up by one, in case"
,"   you are using /PAGE."
,""
};

char	*swit[]=
{"PAGE"
,"HEIGHT"
};

helpless(s)
char	*s;
BEGIN
char	**p;
	puts(s);
	printf("usage: %s typewriter-name=file-name/switches\n",myname);
	FOR	(p=help;	**p;	p++)
	DO	puts(*p);
	OD
	exit();
END

main(argc,argv)
int	argc;
char	**argv;
BEGIN
int	lineonpage;
int	pageinfile;
int	c;
char	*p;

	myname = *argv;
	IF	(argc!=2)
	THEN	helpless("just one command argument, please");
	FI
	FOR	(p=argv[1];	*p!='=';	p++)
	DO	IF	(!*p)
		THEN	helpless("'=' required");
		FI
	OD
	*p++=0;
	/* now have broken MCR string into input file (p) and output file (argv[1]) */
	height = BIG;
	lopage = 1;
	hipage = BIG;
	slash(p);
	slash(argv[1]);
#ifndef hope
printf("height=%d. lopage=%d. hipage=%d.\n",height,lopage,hipage);
#endif
 	IF	(!(iptr=fopen(p,"r")))
	THEN	error("\7Can't find input file \"%s\"",p);
	FI
	IF	(!(optr=fopen(argv[1],"w")))
	THEN	error("\7Can't create output file \"%s\"",argv[1]);
	FI
	lineonpage=1;
	pageinfile = 1;
	WHILE	((c=getc(iptr))!=EOF)
	DO	IF	(pageinfile>=lopage && pageinfile<=hipage && c!='\f')
		THEN	putc(c,optr);
		FI
		IF	(c=='\n')
		THEN	lineonpage++;
			IF	(lineonpage>height)
			THEN	c = '\f';
			FI
		FI
		IF	(c=='\f')
		THEN	IF	(pageinfile>=lopage && pageinfile<hipage)
			THEN	puts("strike [RETURN] to continue,   or strike [Q] [RETURN] to quit immediately");
				WHILE	(getchar()!='\n')
				DO	exit();			/*$PF001*/
				OD
			FI
			pageinfile++;
			lineonpage=1;
		FI
	OD
END

slash(s)	/* process any switches */
char	*s;	/* a file-spec, with optional switches */
BEGIN
char	**sw;
char	c;
char	*p;
	FOR	(;	*s;	s++)
	DO	/* scan whole filespec */
		IF	(*s=='/')
		THEN	/* we have a switch: cut the string here */
			*s++ = 0;
			/* identify switch */
			FOR	(p=s;	isalpha(*p);	p++)
			DO	*p=toupper(*p);
			OD
			/* switch name is in s:p-1 */
			c = *p;
			*p++ = 0;
			/* now have switch name as string */
			FOR	(sw=swit;	**sw;	sw++)
			DO	IF	(strneq(*sw,s,min(strlen(s),strlen(*sw))))
				THEN	break;
				FI
			OD
			switch	(sw-swit)
				{
			case 0:	/* page */
				IF	(c!=':')
				THEN	error("':' expected after /PAGE\7");
				FI
				lopage = scannum(&p);
				IF	(*p==':')
				THEN	p++;
					hipage = scannum(&p);
				FI
				IF	(*p && *p!='/')
				THEN	error("/7garbage follows /PAGE switch: \"%s\"",p);
				FI
				break;
			case 1:	/* /HEIGHT */
				IF	(c!=':')
				THEN	error("\7need ':' after /HEIGHT");
				FI
				height = scannum(&p);
				IF	(*p && *p!='/')
				THEN	error("\7garbage follows /HEIGHT switch: \"%s\"",p);
				FI
				break;
			default:
				error("illegal switch \"%s\"\7\n",s);
				}
			;
		s=p-1;	/* fake so s++ points to next '/' */
		FI
	OD
END

int
scannum(ppc)		/* scan a MCR-standard number */
char	**ppc;		/* address of character pointer */
			/* returns pointing to 1st char after number */
			/* if no number: return 0 as value of function */
BEGIN
char	c;
register	char	*p;
int	r;
int	r8;
int	r10;
int	radix;

	p = *ppc;
	r8 = r10 = 0;
	radix = 10;		/* assume decimal radix */
	if	(*p=='#')
	THEN	p++;
		radix=8;
	FI
	WHILE	(isdigit(*p))
	DO	c = *p - '0';
		p++;
		r8 = r8*8 + c;
		r10 = r10*10 + c;
	OD
	IF	(*p=='.')
	THEN	r=r10;
		p++;
	ELSE	IF	(radix==8)
		THEN	r=r8;
		ELSE	r=r10;
		FI
	FI
	*ppc = p;
	return(r);
END

/* end: pagetype.c */
