/* sor.c - attempt a sort that WORKS (all the time). */

/*
 *	RESTRICTIONS
 *
 * Text files. (We can't handle EOS in middle of a record).
 * Link with Sorts.obj.
 * No stdin or stdout. You must name the files.
 */

/*
 * I have found STRANGE bugs in SORTC.C (Van Tassle version).
 * They mostly happen in large files with long runs.
 * I can: lose records, gain records, have a few runs unsorted.
 */

/* ufilter4.c - prototype filter program - line (actually record) oriented */
/*
 * Modular, fast, record filter skeleton.
 * Forces FD.CR on output file.
 * Gets file names from argv[1],[2]. Too hard to use stdin,stdout.
 * The record has NOTHING (like free '\n's) added to it.
 * Howlong = the record size in bytes.
 * Designed for R.VAR files.
 */

/*
 * note: not only does this main() use "un" in fopen(), but sorts.c
 * also uses "un" in fopen(), so we get roaring fast I/O.
 * SORTC should be educated to do this!
 */

#include <stdio.h>
#include <algol68.h>
#include <cx.h>
#include <nboff.h>
#include <fdoff.h>
char *	buffer;		/* where the buffer is				*/
int	bufmax;		/* maximum record size, needed for recinp()	*/
FILE	*inf;		/* input file					*/
FILE	*ouf;		/* output file					*/
FDB *	fdbp;		/* obsolete kludge				*/
int	howlong;	/* char length of this record			*/

#define suspect $$mchk();
#define suspect

extern int sort_l;	/* determine max sort record length		*/

main(argc,argv)
char **argv;
BEGIN
char *	recinp();	/* the record-getter: 0 means end-of-file	*/

	IF	((inf=fopen(argv[1],"urn"))==NULL)
	THEN	error("can't find %s\7",argv[1]);
	FI
	fdbp = inf -> io_fdb;
	IF	(!(buffer=malloc((bufmax=fdbp->f_fatt.f_rsiz)+1)))
			/* +1 for EOS at buffer end */
	THEN	error("max record size=%d.\7",bufmax);
	FI

	IF	((ouf=fopen(argv[2],"uwn"))==NULL)
	THEN	error("can't make %s\7",argv[2]);
	FI
	fdbp = ouf -> io_fdb;
	fdbp -> f_fatt . f_ratt |= fd_cr;	/* force fd.cr		*/

	sort_l = bufmax;

	WHILE	(recinp(buffer,bufmax,inf,&howlong))
	DO	buffer[howlong] = EOS;
		suspect
		sorta(buffer);
	OD
	suspect
	sorta(NULL);
	WHILE	(sorto(buffer))
	DO	recout(buffer,strlen(buffer),ouf);
	OD

	IF	(fclose(ouf))
	THEN	error("Can't close\7");
	FI
END

char * recinp (where,moby,sewer,lenp)	/* 0==end-file, else buf adr	*/
char *	where;				/* buffer			*/
int	moby;				/* buffer size			*/
FILE *	sewer;				/* input file			*/
int *	lenp;				/* return actual record size	*/
BEGIN
	*lenp = fget(where,moby,sewer);
	IF	(ferror(sewer))
	THEN	error("read failure $$ferr=%oo\7\n",$$ferr);
	FI
	return	(feof(sewer)?NULL:where);
END

recout(where,len,sewer)
char *	where;		/* buffer					*/
int	len;		/* record size					*/
FILE *	sewer;		/* output file					*/
BEGIN
	fput(where,len,sewer);
	IF	(ferror(sewer))
	THEN	error("write failed $$ferr=%oo len=%d.\7\n",$$ferr,len);
	FI
END
/* end: ufilter4.c */
