/* RMSDOC.H - documentation common to rms.c & rrms.c */

/*

block			struct ??? *
			address of a rms object, typically rab or fab

buf			char *
			address of buffer to hold FULL LENGTH record

datlen			unsigned
			number of bytes in data (non-key) part of
			single-indexed record:
			in a s-i record, assume key is to left of data.

key			char *
			address of buffer with FULL LENGTH key

keylen			char
			number of bytes in key # 0

keynum			int
			small number 0,1,...,7
			says which key (index) you use in a get

lans			int []
			receives info about record lengths
			[0] record length
			[1] # keys
			[2] length of key0
			[3] length of key1
			.
			.
			.

len0,len1,...		char
			length (bytes) of each key
			1st key is numbered zero

lun			int
			small integer rms uses as handle on files
			when talking to operating system.
			luns 1,2,3 are sacred to C run-time system
			try using luns 4,7,8,...
			this reserves luns 5,6 to ddt (wise precaution!)

match			int
			has a few values: typically RB$KGT or RB$KGE
			RB$KGT: match any record > given key
			RB$KGE: match any record <=given key

name			char *
			a filename: INCLUDE THE DEVICE eg sy:

pos0,pos1,...		unsigned
			position of key 0,1,... in buffer
			keys are numbered starting from 0
			position of key is byte number of leftmost byte
			leftmost byte of record is numbered zero

rab			struct rabsyn *
			used as a handle for an open file

reclen			unsigned
			total length (bytes) of record

rights			a O$FAC requested access mask: typically or-ed
			from FB$DEL,FB$GET,FB$PUT,FB$REA,FB$TRN,FB$UPD,FB$WRT
			internal use mainly

status			int
			if it doesn't have value SU$SUC 'success'
			then you goofed!

thing			?
			none of your business!

-------------------------------------------------------------------
Common:

long rmssrv;		name of RMS server task in rad50
			ignored for local RMS (RMS.OLB)
			used with remote RMS (RRMS.OLB)

int	rmssts		last O_STS & O_STV from an RMS operation.
int	rmsstv		use RMS macro programmer's ref to decode these.

-------------------------------------------------------------------

rmscs()
			called ONCE before any other subroutine.
			This sets up communication with a remote RMS
			server task if necessary. CS stands for 'choose
			server' (task name) .

rab = newi(lun,name,keylen,datlen)
			create file 'new indexed'
			return RMS status in rmssts,rmsstv

rab = newmi(lun,name,reclen,len0,pos0,len1,pos1,...)
			create file 'new multi-indexed'
			return RMS status in rmssts,rmsstv

rab = newmi_(lun,name,reclen,lenpos)
			as for newmi() but lenpos is address of len0,pos0,...
			return RMS status in rmssts,rmsstv

rab = oldi(lun,name)
			open old file (may be multi-indexed)
			return RMS status in rmssts,rmsstv

rab = oldri(lun,name)
			as for oldi() but READ ONLY access requested

rab = xoldi(lun,name,rights)
			open existing file (perhaps multi-indexed)
			return RMS status in rmssts, rmsstv

block = drop(rab)
			close opened file : lun is now available
			return RMS status in rmssts,rmsstv

status = puti(rab,buf)
			add record to file
			return RMS status in rmssts,rmsstv

status = geti(rab,key,buf)
			'get indexed'
			get record using primary key
			returns record with key#0 >= given key
			return RMS status in rmssts,rmsstv

status = getmi(rab,key,buf,keynum,match)
			'get multi-indexed'
			as for geti but uses key # keynum
			if match == RB$KGT then gets 1st record > key
			if match == RB$KGE then gets 1st record >=key
			return RMS status in rmssts,rmsstv

status = nxti(rab,key,buf)
			'get next-after indexed'
			as for geti but picks key#0 > key
			return RMS status in rmssts,rmsstv

status = deli(rab)
			'delete indexed'
			delete last record got by this rab
			return RMS status in rmssts,rmsstv

status = freeee(rab)
			unlock any record-locks on this rab
			(sorry about the name: do you have a better one ? )
			return RMS status in rmssts,rmsstv

status = updi(rab,buf)
			'update indexed'
			replace last got record of this rab with buf
			return RMS status in rmssts,rmsstv

gsafre(thing)
			internal routine
			do a mfree(thing) with possible checking
			dies if you gsafre(0)

xxxfre(block)
			internal routine
			gsafre() rms objects including their sub-objects

wotli(rab,lans)
			return information about a file's lengths
			get rab from oldi(), newmi() etc
			return RMS status in rmssts,rmsstv

*/

/* end: rmsdoc.h */
