/*
 * Stdio header file.	Version of 01-Jul-82
 *
 * Edit history
 * 01 13-Aug-79 MM	Defined IOV to match the RSX package
 * 02 18-Mar-80	MM	Redefined everything for the new library
 * 03 14-May-80 MM	Do not define things twice
 * 04 13-Jun-80 MM	Define fwild stuff
 * 05 01-Aug-80 MM	Flag changes (IOV Version 08)
 * 06 15-Sep-80 RBD	Add cell for UIC under RSX.
 * 07 22-Sep-80 MM	Added VF$WLD
 * 08 25-Sep-80 MM	Removed VF$BAD
 * 09 17-Feb-81 MM	Added VMS runoff hack flag
 * 10 08-Oct-81 MM	Nothing special
 * 11 10-Mar-82 MM	Added documentation header
 * 12 14-Apr-82 JLB	Add RSTS stuff
 * 13 13-May-82 MM	Moved $$luns[] definition
 * 14 24-Jul-82	MM	Really redone
 * 15 02-Nov-82 MM	io_fdb is now a char array
 * 16 06-Dec-82 MM	More RSTS specific stuff
 * 17 17-Sep-84 CGW	Include _base in vector definition
 */

#ifndef	IO_OPN
/*
 * Note: _... is identical to Unix usage, while io_... is for Decus C
 */

typedef struct IOV {
	int	_cnt;		/* Bytes left in buffer	*/
	char	*_ptr;		/* Free spot in buffer	*/
	char	*_base;		/* Start of buffer		 17 */	
	int	_flag;		/* Flag word 		*/
	int	io_wflag;	/* Wild card flags	*/
	char	*io_wild;	/* Wild card buffer	*/
	int	io_rbsz;	/* Record buffer size	*/
#ifdef	rsts
				/*
				 * RSTS native I/O
				 */
	int	io_rsflag;	/* RSTS specific flags	*/
	int	io_recm;	/* Record Modifier	*/
	int	io_wait;	/* Wait time		*/
	struct {		/* Block number		*/
	  unsigned int low;
	  unsigned int high;
	} io_rsbnbr;
#else
#ifdef	rt11
				/*
				 * RT11 specific
				 */
	int	io_lun;		/* RT11 unit number	*/
	int	io_bnbr;	/* Disk block number	*/
	int	io_size;	/* File size in blocks	*/
	char	*io_name;	/* File name pointer	*/
	char	io_dbuf[2];	/* Dummy record buffer	*/
#endif
#ifdef	rsx
				/*
				 * RSX specific
				 */
	char	*io_bbuf;	/* Block buffer start	*/
	int	io_uic;		/* File's UIC in binary	*/
	char	*io_dnam;	/* Directory name ptr.	*/
	char	io_fdb[0];	/* File data block	*/
#endif
#endif
} FILE;

#define	MAXLUN	15
extern	FILE	*$$luns[];	/* Lun table		*/

/*
 * Bits in ((FILE *)fd)->_flag:
 *	_NAME		Compatible with Unix usage
 *	IO_NAME		Decus C specific.
 */

#define	_IOREAD		0000001	/* Open for reading	*/
#define	_IOWRT		0000002	/* Open for writing	*/
#define	_IONBF		0000004	/* Unbuffered "u" mode	*/
#define	_IOMYBUF	0000010	/* io stuff got buffer	*/
#define	_IOEOF		0000020	/* Eof seen if set	*/
#define	_IOERR		0000040	/* Error seen if set	*/
#define	_IOSTRG		0000100	/* for sprintf, sscanf	*/
#define _IORW		0000200	/* Open for read/write	*/

/*
 * Bits in fd->_flag (all in high byte of that word)
 * These are needed for Dec-style i/o.
 */

#define	IO_BZY		0000400	/* Buffer busy (RT11)	*/
#define	IO_APN		0001000	/* Append mode open	*/
#define	IO_NOS		0002000	/* No newlines needed	*/
#define IO_NEWL		0004000 /* RSX TTY newline hack	*/
#define	IO_FIL		0010000	/* Disk file		*/
#define	IO_TTY		0020000	/* Console terminal	*/
#define	IO_REC		0040000	/* Record device	*/
#define	IO_OPN		0100000	/* Open file		*/

/*
 * The following bits are set in fd->io_wflag for wild-card
 * processing.  Note: IO_WLD must be in the low byte.
 */

#define IO_WLD	0000001		/* fwild: wildcard file	*/
#define IO_VM1	0000002		/* fwild: version ;-1	*/
#define IO_VER	0000004		/* fwild: ;0 or ;-1	*/
#define IO_WF1	0000010		/* fwild first flag	*/
#define	IO_NLH	0000020		/* fopen 'n' hack bit	*/

/*
 * Bits in fd->io_rsflag (RSTS native)
 */

#define	IO_ODT2	0100000		/* ODT mode (RSTS only)	*/

/*
 * Common definitions
 */

#define EOF	(-1)		/* End of file by getc	*/
#define NULL	(0)		/* Impossible pointer	*/
/*
 * Warning -- the following definitions are not transportable
 */
#define TRUE	1		/* if (TRUE)		*/
#define FALSE	0		/* if (!TRUE)		*/
#define EOS	0		/* End of string	*/
#ifdef	rsx
#define	IO_SUCCESS	1	/* Normal exit		*/
#define	IO_WARNING	0	/* Warning error	*/
#define	IO_ERROR	2	/* Error		*/
#define	IO_FATAL	4	/* Severe error		*/
#endif
#ifdef	rt11
#define	IO_SUCCESS	1	/* Normal exit		*/
#define	IO_WARNING	2	/* Warning error	*/
#define	IO_ERROR	4	/* Error		*/
#define	IO_FATAL	8	/* Severe error		*/
#endif
 
extern	FILE	*stdin;		/* Standard input file	*/
extern	FILE	*stdout;	/* Standard output file	*/
extern 	FILE	*stderr;	/* Standard error file	*/
extern	char	*fgets();	/* Defined by unix	*/
extern	int	$$ferr;		/* Error codes set here	*/
extern	int	$$exst;		/* Exit status set here	*/
#endif
