{ SHEAP Version 1.0 Include file. }

type
  SHeapStatusType = packed array [1..3] of integer;
  SuperPointerType =
    record
      Region : integer;
      Ptr : ^integer
    end;

[External (SHINIT)]
procedure SHeap_Initialize (var SHeapStatus : SHeapStatusType;
			    var NumOfAreas : integer);
  external;

[External (SHCREA)]
procedure Create_SuperHeap_Region(var SHeapStatus : SHeapStatusType;
				  var RegionNumber : integer;
				      Area : integer := 1);
  external;

[External (SHCONN)]
procedure Connect_To_Region(var SHeapStatus : SHeapStatusType;
				RegionNumber : integer;
				Area : integer := 1);
  external;

[External (SHDISC)]
procedure Disconnect_From_Region (var SHeapStatus : SHeapStatusType;
				      RegionNumber : integer;
				      Area : integer := 1);
  external;

[External (SHMAP)]
procedure Map_To_Region(var SHeapStatus : SHeapStatusType;
			    RegionNumber : integer;
			    Area : integer := 1);
  external;

[External (SHNEW)]
function SHeap_New (var SuperPointer : SuperPointerType;
			Size : integer;
			Area : integer := 1) : boolean;
  external;

[External (SHDISP)]
procedure SHeap_Dispose(var SHeapStatus : SHeapStatusType;
			var SuperPointer : [readonly] SuperPointerType;
			    Area : integer := 1);
  external;

[External (SHFREE)]
function FreeSpace(Area : integer := 1) : integer;
  external;

[External (SHCURR)]
function Current_Region(Area : integer := 1) : integer;
  external;

[External (SHLOAD)]
function Region_Loaded (var SuperPointer : [readonly] SuperPointerType;
			    Area : integer := 1) : boolean;
  external;

[External (SHLOCK)]
function Lock_Current_Region(Area : integer := 1) : boolean;
  external;

[External (SHUNLO)]
procedure Unlock_Region(Area : integer := 1);
  external;

[External (SHLCKD)]
function Region_Is_Locked(Area : integer := 1) : boolean;
  external;

[External (SHWAIT)]
procedure Wait_And_Lock(Area : integer := 1);
  external;

[External (SHCONV)]
procedure Convert_SuperPointer (var SuperPointer : SuperPointerType;
				    Area : integer := 1);
  external;

{ End of SHEAP.INC }
