
#include	"sysdef.h"

/*								*/
/*	Copyright Notice					*/
/*								*/
/*								*/
/*	C version Copyright (C) 1984 Change Software, Inc.	*/
/*	Copyright (C) 1978 1979 1980 1981 1982 1983 1984 by	*/
/*		      Change Software, Inc.			*/
/*								*/
/*								*/
/*	This software is furnished under a license and may	*/
/*	be  used  and  copied  only in accordance with the	*/
/*	terms of such license and with  the  inclusion  of	*/
/*	the  above copyright notice.  This software or any	*/
/*	other copies thereof may not be provided or other-	*/
/*	wise made available to any other person.  No title	*/
/*	to and ownership of the software is hereby  trans-	*/
/*	ferred.							*/
/*								*/
/*	The information in this  software  is  subject  to	*/
/*	change  without notice and should not be construed	*/
/*	as a commitment by the author.				*/
/*								*/
/*								*/


#define	cm0	0
#define	cm1	1
#define	cm2	2
#define	cm3	3
#define	cm4	4
#define	cm5	5
#define	cm6	6
#define	cm7	7
#define	cm8	8
#define	cm9	9
#define	cm10	10
#define	cm11	11
#define	cm12	12
#define	cm13	13
#define	cm14	14
#define	cm15	15
#define	cm16	16
#define	cm17	17
#define	cm18	18
#define	cm19	19
#define	cm20	20
#define	cm21	21
#define	cm22	22
#define	cm23	23
#define	cm24	24
#define	cm25	25
#define	cm26	26
#define	cm27	27
#define	cm28	28
#define	cm29	29
#define	cm30	30
#define	cm31	31
#define	cm32	32
#define	cm33	33
#define	cm34	34
#define	cm35	35
#define	cm36	36
#define	cm37	37
#define	cm38	38
#define	cm39	39
#define	cm40	40
#include	"scterm.h"
#define	then

/*	map function and/or keypad keys to internal codes		*/

struct	mapcmd	{
		char	cmdchar ;
		int	cmdmap ;
		} ;



/*	map gold and control keys				*/

static
struct mapcmd goldkeys[]={
			'm'	,cm1	,	/* set macro buffer	*/
			'g'	,cm2	,	/* get disk file	*/
			'f'	,cm3	,	/* exit			*/
			's'	,cm4	,	/* save file		*/
			'p'	,cm5	,	/* fill paragraph	*/
			'h'	,cm6	,	/* help			*/
			'w'	,cm7	,	/* write select range	*/
			'r'	,cm8	,	/* reverse		*/
			'q'	,cm9	,	/* que select range	*/
			'u'	,cm10	,	/* erase		*/
			'a'	,cm11	,	/* adjust left margin	*/
			'l'	,cm12	,	/* learn a macro	*/
			't'	,cm13	,	/* insert time stamp	*/
			'd'	,cm14	,	/* cut and delete	*/
			'x'	,cm15	,	/* get macro		*/
			'v'	,cm16	,	/* view markers		*/
			'n'	,cm17	,	/*			*/
			'['	,cm18	,	/* save pagemarker	*/
			']'	,cm19	,	/* pop  pagemarker	*/
			'$'	,cm20	,	/* execute system cmd	*/
			'c'	,cm21	,	/* change case		*/
			'o'	,cm22	,	/* octal dump		*/
			'z'	,cm23	,	/* hex dump		*/
			'e'	,cm24	,	/* execute macro	*/
			'@'	,cm25	,	/* call line editor	*/
			'#'	,cm26	,	/* spawn and insert log	*/
			'\\'	,cm27	,	/* scroll		*/
			'b'	,cm28	,	/* enter buffer number	*/
			'\0'	,cm0	} ;	/* end			*/




/*	map keypad and/or function keys				*/

static
struct mapcmd cvt100[]={ 'A' ,  cm1 	,	/* up arrow	*/
			 'B' ,  cm2 	,	/* down arrow	*/
			 'C' ,  cm3 	,	/* right arrow	*/
			 'D' ,  cm4 	,	/* left arrow	*/
			 'Q' ,  cm5 	,	/* pf2		*/
			 'R' ,  cm6 	,	/* pf3		*/
			 'S' ,  cm7 	,	/* pf4		*/
			 'P' ,  cm8 	,	/* pf1 (gold)	*/
			 'H' ,  cm9 	,	/* esc H (help)	*/
			 'h' ,  cm10	,	/* esc h (help)	*/
			 '\027',cm11	,	/* esc leadin	*/
			 'p' ,  cm12	,	/* keypad '0'	*/
			 'q' ,  cm13	,	/* keypad '1'	*/
			 'r' ,  cm14	,	/* keypad '2'	*/
			 's' ,  cm15	,	/* keypad '3'	*/
			 't' ,  cm16	,	/* keypad '4'	*/
			 'u' ,  cm17	,	/* keypad '5'	*/
			 'v' ,  cm18	,	/* keypad '6'	*/
			 'w' ,  cm19	,	/* keypad '7'	*/
			 'x' ,  cm20	,	/* keypad '8'	*/
			 'y' ,  cm21	,	/* keypad '9'	*/
			 'm' ,  cm22	,	/* keypad '-'	*/
			 'l' ,  cm23	,	/* keypad ','	*/
			 'n' ,  cm24	,	/* keypad '.'	*/
			 'M' ,  cm25	,	/* keypad enter	*/
			  1  ,  cm26	,	/* the find key for vt220 */
			  2  ,  cm27	,	/* the INSERT HERE	  */
			  3  ,  cm28	,	/* the remove key	  */
			  4  ,  cm29	,	/* the select key	  */
			  5  ,  cm30	,	/* the previous page	  */
			  6  ,  cm31	,	/* the next page key	  */
			  28 ,  cm32	,	/* the HELP key on the 220*/
			  29 ,	cm33	,	/* the DO key ,get line ed*/
			  24 ,  cm34	,	/* backspace in vt200 mode*/
			  31 ,  cm35	,	/* f17			  */
			  32 ,  cm36	,	/* f18			  */
			  33 ,  cm37	,	/* f19			  */
			  34 ,  cm38	,	/* f20			  */
			  21 ,  cm39	,	/* f10 (exit)		  */
			  26 ,  cm40	,	/* f14 (stats)		  */
			 '\0',  cm0		/* end of list	*/
			} ;

static
struct mapcmd cvt220[]={ 'A' ,  cm1 	,
			 'B' ,  cm2 	,
			 'C' ,  cm3 	,
			 'D' ,  cm4 	,
			 'Q' ,  cm5 	,
			 'R' ,  cm6 	,
			 'S' ,  cm7 	,
			 'P' ,  cm8 	,
			 'H' ,  cm9 	,
			 'h' ,  cm10	,
			 '\027',cm11	,
			 'p' ,  cm12	,
			 'q' ,  cm13	,
			 'r' ,  cm14	,
			 's' ,  cm15	,
			 't' ,  cm16	,
			 'u' ,  cm17	,
			 'v' ,  cm18	,
			 'w' ,  cm19	,
			 'x' ,  cm20	,
			 'y' ,  cm21	,
			 'm' ,  cm22	,
			 'l' ,  cm23	,
			 'n' ,  cm24	,
			 'M' ,  cm25	,
			  1  ,  cm26	,	/* the find key for vt220 */
			  2  ,  cm27	,	/* the INSERT HERE	  */
			  3  ,  cm28	,	/* the remove key	  */
			  4  ,  cm29	,	/* the select key	  */
			  5  ,  cm30	,	/* the previous page	  */
			  6  ,  cm31	,	/* the next page key	  */
			  28 ,  cm32	,	/* the HELP key on the 220*/
			  29 ,	cm33	,	/* the DO key ,get line ed*/
			  24 ,  cm34	,	/* backspace in vt200 mode*/
			  31 ,  cm35	,	/* f17			  */
			  32 ,  cm36	,	/* f18			  */
			  33 ,  cm37	,	/* f19			  */
			  34 ,  cm38	,	/* f20			  */
			  21 ,  cm39	,	/* f10 (exit)		  */
			  26 ,  cm40	,	/* f14 (stats)		  */
			 '\0',  cm0
			} ;

static
struct mapcmd cansi[]={
			 'A' ,  cm1 	,
			 'B' ,  cm2 	,
			 'C' ,  cm3 	,
			 'D' ,  cm4 	,
			 'Q' ,  cm5 	,
			 'R' ,  cm6 	,
			 'S' ,  cm7 	,
			 'P' ,  cm8 	,
			 'H' ,  cm9 	,
			 'h' ,  cm10	,
			 '\027',cm11	,
			 'p' ,  cm12	,
			 'q' ,  cm13	,
			 'r' ,  cm14	,
			 's' ,  cm15	,
			 't' ,  cm16	,
			 'u' ,  cm17	,
			 'v' ,  cm18	,
			 'w' ,  cm19	,
			 'x' ,  cm20	,
			 'y' ,  cm21	,
			 'T' ,  cm22	,
			 'U' ,  cm23	,
			 'n' ,  cm24	,
			 'M' ,  cm25	,
			 '\0',  cm0
			} ;


/*	get the function/keypad key and get the command executed	*/

fcnlookup(ch)
register char ch;

{
	register struct mapcmd *mp,*mpinit ;
	extern int termtype, goldcount ;

	switch (termtype) {
		case _vt100:
			mpinit = cvt100 ;
			break ;
		case _vt220:
			mpinit = cvt220 ;
			break ;
		case _ansi:
			mpinit = cansi ;
			break ;
		}

	for (mp=mpinit; mp->cmdmap != 0;mp++)
	    if (mp->cmdchar == ch) break ;
	return( mp->cmdmap ) ;
}


funcommand(ch)
char ch ;
{
	extern int goldcount ;
	register int gcount,cmdindex ;

	gcount = goldcount ;
	cmdindex = fcnlookup(ch) ;
	
	if (gcount == 0)
	 then
	  switch (cmdindex) {
		case cm0:  vtbell()	;break ; /* error		*/
		case cm1:  vtmvup()	;break ; /* move up 		*/
		case cm2:  vtmvdown()	;break ; /* move down		*/
		case cm3:  vter()	;break ; /* move right in line	*/
		case cm4:  vtel()	;break ; /* move left in line	*/
		case cm5:  vtnextpage()	;break ; /* display next page	*/
		case cm6:  vtfnext(1)	;break ; /* find next occurance	*/
		case cm7:  vtdeleteline();break; /* delete line or range*/
		case cm8:  vtgold()	;break ; /* shift keypad	*/
		case cm9:  vthelp()	;break ; /* enter help		*/
		case cm10: vtinit()	;break ; /* reinit terminal	*/
		case cm11: vthelp()	;break ; /* enter help		*/
		case cm12: vtbline()	;break ; /* start of next line	*/
		case cm13: vtnxtword()	;break ; /* next word		*/
		case cm14: vteoln()	;break ; /* end of current line	*/
		case cm15: vtmark()	;break ; /* get paste text	*/
		case cm16: vtlastpage()	;break ; /* last page of file	*/
		case cm17: vtfirstpage();break ; /* first page of file	*/
		case cm18: vtpaste()	;break ; /* insert cut text	*/
		case cm19: vtflast()	;break ; /* forward search	*/
		case cm20: vtswpch()	;break ; /* swp adjacent chars	*/
		case cm21: vtapp()	;break ; /* append paste buffer	*/
		case cm22: vtdelword()	;break ; /* kill next word 	*/
		case cm23: vtdelc()	;break ; /* delete char and merg*/
		case cm24: vtrepnext()	;break ; /* findnext and replace*/
		case cm25: vtdorep()	;break ; /* findnext and replace*/
		case cm26: vtfnext(1)	;break ; /* vt220, FIND key	*/
		case cm27: vtpaste()	;break ; /* vt220, INSERT HERE	*/
		case cm28: vtdeleteline();break; /* vt220, REMOVE key	*/
		case cm29: vtmark()	;break ; /* vt220, SELECT key	*/
		case cm30: vtprevpage()	;break ; /* vt220, PREV PAGE	*/
		case cm31: vtnextpage()	;break ; /* vt220, NEXT PAGE	*/
		case cm32: vthelp()	;break ; /* vt220, HELP		*/
		case cm33: vtcallted()	;break ; /* vt220, DO key	*/
		case cm34: vtbs()	;break ; /* vt220, BS		*/
		case cm35: vtswindow(0)	;break ; /* vt220, f17		*/
		case cm36: vtswindow(1)	;break ; /* vt220, f18		*/
		case cm37: vtswindow(2)	;break ; /* vt220, f19		*/
		case cm38: vtswindow(3)	;break ; /* vt220, f20		*/
		case cm39: vtstop()	;break ; /* vt220, f10 (exit)	*/
		case cm40: vtstats()	;break ; /* vt220, f14		*/
		}

	if (gcount == 1)
	 then
	  switch (cmdindex) {
		case cm0:  vtbell()	;break; /* error		*/
		case cm1:  vttoppage()	;break; /* top of page		*/
		case cm2:  vtbotpage()	;break; /* bottom of page	*/
		case cm3:  vtsent()	;break; /* next sentence	*/
		case cm4:  vtboln()	;break; /* previous character	*/
		case cm5:  vtprevpage()	;break; /* previous page	*/
		case cm6:  vtprfnext(1)	;break; /* find next,prompt	*/
		case cm7:  vtunline()	;break; /* undelete line	*/
		case cm8:  vtgold()	;break; /* shift keypad		*/
		case cm9:  vthelp()	;break; /* help			*/
		case cm10: vtinit()	;break; /* reinit terminal	*/
		case cm11: vthelp()	;break; /* help			*/
		case cm12: vtopenline()	;break; /* break current line	*/
		case cm13: vtlstword()	;break; /* previous word	*/
		case cm14: vtdeoln()	;break; /* delete to end of line*/
		case cm15: vtsetbuffer();break;	/* select paste buffer	*/
		case cm16: vtfill()	;break; /* fill line		*/
		case cm17: vtcenter()	;break; /* center line		*/
		case cm18: vtcutzap()	;break; /* clear paste buffer	*/
		case cm19: vtprflast();break; /* find next reverse	*/
		case cm20: vtswpline()	;break; /* swap lines		*/
		case cm21: vtspins()	;break; /* insert special	*/
		case cm22: vtunword()	;break; /* undelete word	*/
		case cm23: vtunchar()	;break; /* undelete character	*/
		case cm24: vtoverwrite();break; /* toggle insert	*/
		case cm25: vtsetpat()	;break; /* enter search pattern	*/
		case cm26: vtprfnext(1)	;break; /* findnext,prompt (220)*/
		case cm40: qiostats() 	;break;
		}

	if ( gcount == 2 )
	  then
	    switch( cmdindex ) {
		case cm1:  vtpopmark()	;break;
		case cm2:  vtpushmark()	;break;
		case cm25: vtsetrep()	;break;
		case cm6:
		case cm26: vtfnext(0) ;break;
		}
}


fungoldcommand(ch)
register char ch ;
{
	struct mapcmd *mp ;
	extern int termtype, goldcount ;
	register int cmdindex, gcount ;
	int status ;

	if ( (gcount = goldcount) == 0 ) then return(0) ;
	ch = tolower(ch);
	for (mp=goldkeys; mp->cmdmap != 0;mp++)
	    if (tolower(mp->cmdchar) == ch) break ;
	cmdindex = mp->cmdmap ;

	if ( gcount == 1 )
	  switch (cmdindex) {

		status = 1 ;
		case cm0: vtbell()	;break;	/* unknown gold command	*/
		case cm1: vtmacnum()	;break;	/* M, macro buffer #	*/
		case cm2: vtopfile()	;break;	/* G, get a disk file	*/
		case cm3: vtstop()	;break;	/* F, exit screen editor*/
		case cm4: vtfsave()	;break;	/* S, save current file	*/
		case cm5: vtparagraph(1);break;	/* P, fill a paragraph	*/
		case cm6: vthelp()	;break; /* H, put up help screen*/
		case cm7: vtfwrite()	;break;	/* W, write select range*/
		case cm8: vtlreverse()	;break;
		case cm9: vtfque()	;break;	/* Q, que select range	*/
		case cm10:vteraline()	;break;	/* U, control U		*/
		case cm11:vttabset()	;break;	/* A, set left margin	*/
		case cm12:vtlearn()	;break;	/* L, learn a macro	*/
		case cm13:vttime()	;break;	/* T, insert timestamp	*/
		case cm14:vtcutdel()	;break;	/* D, cut&delete select	*/
		case cm15:vtgetmacro()	;break;	/* X, read a macro	*/
		case cm16:vtmview()	;break;	/* V, set parameters	*/
		case cm17:vtsetnext()	;break;	/* N, obsolete		*/
		case cm18:vtnpara()	;break;	/* [, find next para	*/
		case cm19:vtepara()	;break;	/* ], end of paragraph	*/
		case cm20:vtsystem()	;break;	/* $, execute system cmd*/
		case cm21:vtccase()	;break;	/* C, change case	*/
		case cm22:vtdump(0)	;break;	/* O, octal dump	*/
		case cm23:vtdump(1)	;break;	/* Z, hex dump		*/
		case cm24:execmacro()	;break;	/* E, execute macro	*/
		case cm25:vtcallted()	;break; /* @, call line editor	*/
		case cm26:vtlogsys()	;break;	/* #, spawn and insert	*/
		case cm27:vtscroll()	;break;	/* \			*/
		case cm28:vtswindow(-1)	;break; /* b, set buffer number	*/
		default:  status = 0	;break; /* unknown		*/

		} ;

	if ( gcount == 2 )
	  switch (cmdindex) {
		case cm5: vtparagraph(0);break;	/* P, fill a paragraph	*/
		default:  status = 0	;break;
		} ;

	return( status ) ;
}



#if	VAXVMS

static vtcallted()
{
	register int len ;
	char s[64] ;

	scunloadline() ;
	ceol24() ;
	if ( (len=trimjunk(s,lgetbin(s,"Command ? "))) != 0 )
	  then	{
		sclear() ;
		s[len] = 0 ;
		teddocommand(s) ;
		ceol24() ;
		lgetbin(s,"Type a carriage return to continue") ;
		scloadline() ;
		ref_screen() ;
		}
	goback() ;
}

#else

static vtcallted()
{
	return(0) ;
}

#endif


static vtstats()
{
	ceol24() ;
	accstats() ;
	goback() ;
}

static vtgetmacro()
{
	readmacro() ;
}

static vtgold()
{
	extern int goldcount,goldk ;

	goldk = 1 ;
	goldcount++ ;
}

static vtinit()
{
	terinit() ;
}

static vthelp()
{
	schelp() ;
	ref_screen() ;
}

static vtbs()
{
	if ( atcrlf() )
	  then vtboln() ;
	  else vteoln() ;
}




static vtmenu()      { return(0) ; }
static vttabset()    { return(0) ; }
static vtset()       { return(0) ; }
static vtsetnext()   { return(0) ; }

