
#include	"sysdef.h"
#include	"edswdf.h"

#define	then
#define	QUOTE	047
#define	COMMA	054
#define	SPACE	040
#define	TAB	011
#define	SETTER		1
#define	SETSER		2
#define	SETWRAP		3
#define	SETNOWRAP	4
#define	SETCASE		5
#define	SETTAB		6
#define	SETENTITY	7
#define	SETWORD		8
#define	SETQUIET	9
#define	SETVERBOSE	10
#define	SETESCAPE	11
#define	SETSCREEN	12
#define	SET132		13
#define	SET80		14
#define	SETAST		15
#define	SETDELETE	16
#define	SETHEADER	17
#define	SETLINE		18
#define	SETINDENT	19

struct	map	{
		char *name ;
		char idx ;
		char minlen ;
		} ;

static
struct map setmap[] = 	{ "TERMINAL"	,SETTER	,	2,
			  "SEARCH"	,SETSER	,	2,
			  "CASE"	,SETCASE,	2,
			  "TAB"		,SETTAB	,	2,
			  "ENTITY"	,SETENTITY,	2,
			  "WORD"	,SETWORD,	2,
			  "QUIET"	,SETQUIET,	3,
			  "RETICENT"	,SETQUIET,	3,
			  "VERBOSE"	,SETVERBOSE,	3,
			  "CHATTY"	,SETVERBOSE,	4,
			  "WRAP"	,SETWRAP,	3,
			  "FILL"	,SETWRAP,	3,
			  "ESCAPE"	,SETESCAPE,	2,
			  "SCREEN"	,SETSCREEN,	3,
			  "80"		,SET80,		2,
			  "132"		,SET132,	2,
			  "AST"		,SETAST,	2,
			  "DELETE"	,SETDELETE,	2,
			  "LINE"	,SETLINE,	2,
			  "HEADER"	,SETHEADER,	2,
			  "INDENTATION"	,SETINDENT,	2,
			  ""		,0	,	0 } ;
#define	SET_ON		1
#define	SET_OFF		2

static struct map onoff[] =  {"ON"	,SET_ON		,2	,
			      "OFF"	,SET_OFF	,3	} ;



cset()
{
	extern char argfile[] ;
	return( dosetcmd(argfile) ) ;
}

dosetcmd(s)
char *s ;

{
	extern int escprint ;
	extern struct map *findmap() ;
	register struct map *mp ;
	register char *cp,*dp ;
	int len1 ;
	char stopic[64] ;

	cp = s ;
	if ( *cp == 0 )
	  then	{
		tederror("Usage: SET KEYWORD ARG") ;
		return(0) ;
		}
	dp = stopic ;
	len1 = 0 ;
	while ( isletter(*cp) || isdigit(*cp) ) {
		len1++ ;
		*dp++ = *cp++ ;
		}
	*dp = 0 ;
	if ( (mp=findmap(stopic,&setmap,"SET"))==0 )
	  then	return(0) ;
	  else	{
		while ( *cp == SPACE || *cp == TAB ) cp++ ;
		switch( mp->idx ) {
		  case SETTER:
			setdev(cp) ;
			break ;
		  case SETSER:
			setser(cp) ;
		 	break ;
		  case SETCASE:
			setcase(cp) ;
			break ;
		  case SETTAB:
			settab(cp) ;
			break ;
		  case SETWORD:
			setword(cp) ;
			break ;
		  case SETQUIET:
			setquiet(cp) ;
			break ;
		  case SETVERBOSE:
			setverbose(cp) ;
			break ;
		  case SETWRAP:
			setwrap(cp) ;
			break ;
		  case SETESCAPE:
			setonoff(cp,&escprint) ;
			break ;
		  case SET80:
			set80col() ;
			ref_screen() ;
			break ;
		  case SET132:
			set132col() ;
			ref_screen() ;
			break ;
		  case SETSCREEN:
			setsize(cp) ;
			break ;
		  case SETAST:
			setast(cp) ;
			break ;
		  case SETDELETE:
			setdelete(cp) ;
			break ;
		  case SETHEADER:
			setheader(cp) ;
			sctopline() ;
			break ;
		  case SETLINE:
			setline(cp) ;
			break ;
		  case SETINDENT:
			setindent(cp) ;
			break ;
		  default:
			tederror("Unknown SET command") ;
			break ;
			}

		}
}


	



static setonoff(s,flag)
register char *s ;
int *flag ;
{
	extern struct map *findmap() ;
	register struct map *mp ;

	if ( mp=findmap(s,&onoff,"") )
	  then	
		switch( mp->idx ) {
		  case SET_OFF:	*flag = 0 ;
				break ;
		  case SET_ON:	*flag = 1 ;
				break ;
			}
}				



			




struct map *findmap(s,cmdlist,name)
register char *s ;
struct map *cmdlist ;
char *name ;
{
	register struct map *mp ;
	register int f,len ;

	if ( *s == '/' ) then s++ ;
	mp = cmdlist ;
	len = strlen(s) ;
	f = 0 ;
	while (    mp->name[0] != 0 )
		if (   len >= mp->minlen &&
		     ( f=finstr(mp->name,strlen(mp->name),s,len) ) == 1 )
		  then break ;
		  else mp++ ;
	if ( f )
	  then	return( mp ) ;
	  else	{
		xprintf("\nInvalid %s option\n",name) ;
		return( 0 ) ;
		}
}




swicase()
{
	extern struct fswitch inswitch ;

	toggle(&inswitch.casexl,"Case translation ") ;
	return(1) ;
}

switab()
{
	extern struct fswitch inswitch ;

	toggle(&inswitch.tabxl,"Tab expansion ") ;
	return(1) ;
}

swixlate()
{
	extern struct fswitch inswitch ;

	if ( inswitch.tabxl != inswitch.casexl )
	  then inswitch.casexl = inswitch.tabxl ;
	switab() ;
	swicase() ;
	return(1) ;
}


static toggle(sw_val,s)
int *sw_val ;
char *s ;
{
	if ( *sw_val )
	  then	{
		*sw_val = 0 ;
		xprintf("%s disabled\n",s) ;
		}
	  else	{
		*sw_val = 1 ;
		xprintf("%s enabled\n",s) ;
		}
	return(1) ;
}




