

/*	EDIFL.C							*/
/*								*/
/*	Removed from TEMPIO.C to place into overlay for PDP-11	*/
/*	09-AUG-1985 10:03 BDN					*/

#include	"sysdef.h"

/*								*/
/*	Copyright Notice					*/
/*								*/
/*								*/
/*	C version Copyright (C) 1984 Change Software, Inc.	*/
/*	Copyright (C) 1978 1979 1980 1981 1982 1983 1984 by	*/
/*		      Change Software, Inc.			*/
/*								*/
/*								*/
/*	This software is furnished under a license and may	*/
/*	be  used  and  copied  only in accordance with the	*/
/*	terms of such license and with  the  inclusion  of	*/
/*	the  above copyright notice.  This software or any	*/
/*	other copies thereof may not be provided or other-	*/
/*	wise made available to any other person.  No title	*/
/*	to and ownership of the software is hereby  trans-	*/
/*	ferred.							*/
/*								*/
/*	The information in this  software  is  subject  to	*/
/*	change  without notice and should not be construed	*/
/*	as a commitment by the author.				*/
/*								*/
/*								*/

#include	"tempio.h"
#include	"scerrd.h"
#include	"edswdf.h"

#define	CR	015
#define	LF	012

#define	INIT_SIZE	500
#define	INCR_SIZE	1000

	extern struct textline	inline ;

	extern int indexsize[NWINDOWS] ;
	extern int w ;

	extern int win_low[] ;
	extern int win_high[] ;
	extern int win_curline[] ;
	extern struct tempindex	*win_workpt[] ;
	extern struct tempindex	*workpt ;
	extern struct textwindow *windpt ;
	extern struct textwindow window[] ;
	extern struct tempblock	tempbuffer[] ;
	extern struct stats	tempstat ;
	extern struct deltype	lastdeleted ;
	extern int tmpsiz ;
	extern int maxlen ;
	extern int tempopen ;
	extern int escprint ;
	extern int infisize ;
	extern int curbucket[]	 ;
	extern int lstbucket[]	 ;
	extern int firbucket[]	 ;	
	extern int maxbucket[]	 ;
	extern int linecount[]	 ;
	extern int blkoffset[]	 ;
	extern int win_maxline[] ;
	extern int *maxline      ;
	extern int curmode[];
	extern int kblun  ;
	extern int cmdlun ;
	extern int inlun  ;
	extern int outlun ;
	extern int worddelim[] ;
	extern int maxfilesize ;


/*	Define the mechanism for indexing into the window pointers	*/
/*	First, the fast way for virtual 32 bit systems like VMS.	*/
/*	See TEMPIO.C for details.					*/

#if	VAXVMS
#define	_gworkpt(offset) workpt+offset
#endif

#if	RSX
extern struct tempindex *mapwin() ;
#define	_gworkpt mapwin
#endif

/*
#if	RSX
#define	_gworkpt workpt+
#endif
*/


/*	Procedure Init_temp

	Init_Temp will initialize the workfile
*/

init_temp()
{
	extern int sts_one, sts_two ;
	register int *ip ;
	int i,status ;
	extern   struct tempindex *getvm() ;

	for (i=0; i < NWINDOWS; i++) {
		curbucket[i] = 0 ;
		maxbucket[i] = 0 ;
		blkoffset[i] = 0 ;
		win_low[i] = 0 ;
		win_high[i] = 0 ;
		win_curline[i] = 0 ;
		lstbucket[i] = 0 ;	/* last_bucket_in_workfile = 0	*/
		linecount[i] = 0 ;	/* lines_in_current_bucket = 0	*/
		curmode[i]   = st_ifl ;	/* work_mode = initialfileload	*/
		firbucket[i] = 1 ;	/* first_bucket_in_workfile = 1	*/
		win_maxline[i] = 0 ;
		if ( i != 0 && tempopen == 0 ) then {
			win_workpt[i] = getvm(50,i,&indexsize[i]) ;
			}
		}

	if ( tempopen == 0 ) then
		if ( (win_workpt[0] = getvm(INIT_SIZE,0,&indexsize[0])) == 0 )
	  	then	{
		  tederror("Failure to allocate virtual memory for index") ;
		  return(0) ;
			} ;
	workpt = win_workpt[0] ;
	windpt = &window[0] ;
	wptset() ;
	maxline = &win_maxline[0] ;
	w = 0 ;
	worddelim[0] = 0 ;
        maxfilesize = _FILESIZE ;
	lastdeleted.lastline.partial = 1 ;
	lastdeleted.lastline.len = 0 ;
	lastdeleted.lastword.len = 0 ;
	lastdeleted.lastc = 0 ;
	sts_one = 0 ;
	sts_two = 0 ;
	ip = &tempstat ;
	*ip++ = 0 ;			/* tempstat.writes = 0		*/
	*ip++ = 0 ;			/* tempstat.reads  = 0		*/
	*ip++ = 0 ;			/* tempstat.r_faults = 0	*/
	*ip++ = 0 ;			/* tempstat.w_faults = 0 	*/
	*ip++ = 0 ;			/* tempstat.hits = 0		*/
	maxlen = _maxlen ;
	if (pageinit()==0)		/* allocate buffer and setup	*/
	  then	{			/* control structures for the	*/
		tederror("pageinit failed on memory allocation") ;
		return(0) ;
		}
	if ( tempopen )			/* perhaps we need to open it	*/
	  then status = SYS_NORMAL ;	/* no, must be doing wildcards	*/
	  else status = cretmp() ;	/* create the workfile		*/
	tempopen++ ;			/* flag workfile being open	*/
	return(status) ;		/* returning with create status	*/
}






/*	Procedure IFL( channel )

	Read the input file and initialize and load the work file
*/

#define	ESC	033

ifl(lun)
int lun ;
{
	int cctyped ;
	extern   int vir_pagecount ;
	register int status ;
	register char ch ;
	register char *cp, *oldcp ;
	register int curlen,i ;
	long character_count ;
	char dbuff[20] ;
	
	w = 0 ;
	cctyped = 0 ;
	status = init_temp();
	if (status != SYS_NORMAL) return( status );
	if (infisize > vir_pagecount) then pageoff(w) ;
	character_count = 0 ;
	status = SYS_NORMAL ;
	if ( lun != kblun )
	  then
		while (status == SYS_NORMAL && ( cctyped=testcc() ) == 0 ) {
		  status = getline(lun,&inline.c[0],&inline.len);
		  if ( status == SYS_TOOLONG )
		    then {
			status = SYS_NORMAL ;
			xprintf("Record truncated at line %d\n",*maxline + 1) ;
			 }
		  if ( status != SYS_NORMAL ) then break ;
		  curlen = 0 ;
		  cp = inline.c ;
		  oldcp = cp ;
		  for (i=inline.len; i>0; i--) {
			if ( ( ch = *cp++ ) == ESC ) then escprint = 1 ;
			if (ch == LF)
			  then	{
				ins_line(oldcp,++curlen) ;
				character_count += curlen ;
				curlen = 0 ;
				oldcp = cp ;
				(*maxline)++ ;
				}
			  else	curlen++ ;
			}
		  if ( curlen )
		    then {
			 ins_line( oldcp,curlen ) ;
			 character_count += curlen ;
			 (*maxline)++ ;
			 }
		}
	  else status = ER_EOF ;
	if ( cctyped )
	  then	{
		xprintf("File load aborted on Control C interupt\n");
		return(0) ;
		} ;
	if ( status != ER_EOF ) then return( status );
	if ( *maxline == 0 )
	  then	{
		character_count += 2 ;
		(*maxline)++ ;
		ins_line("\015\012",2) ;
		}
	inline.len = 1 ;
	inline.c[0] = '@' ;
	(*maxline)++ ;
	ins_line( inline.c,1 ) ;
	putlast ( inline.c,1 ) ;
	if (sizeof(int) == 4)
	  then
	   xprintf("\n%d characters  %d lines\n",character_count,*maxline-1);
	  else	{
	   cvtdd(dbuff,&character_count) ;
	   xprintf("\n%s characters  %d lines\n",dbuff,*maxline-1) ;
		} ;
	maxbucket[w] = lstbucket[w] ;
	(_gworkpt(lstbucket[w]))->link = 0 ;
	linecount[w] = 0 ;
	windpt->toplin = 0 ;
	pageon(w) ;
	setcc() ;
	ifl_alternates() ;
	return( SYS_NORMAL ) ;
}



ifl_alternates()
{

	for (w = 1; w < NWINDOWS; w++ ) {
		workpt = win_workpt[w] ;
		maxline = &win_maxline[w] ;
		windpt = &window[w] ;
		wptset() ;
		curmode[w] = st_ifl ;
		(*maxline)++ ;
		ins_line("\015\012",2) ;
		(*maxline)++ ;
		ins_line("@",1) ;
		putlast("@",1) ;
		maxbucket[w] = lstbucket[w] ;
		(_gworkpt(lstbucket[w]))->link = 0 ;
		linecount[w] = 0 ;
		windpt->toplin = 0 ;
		}
	w = 0 ;
	workpt = win_workpt[0] ;
	maxline = &win_maxline[0] ;
	windpt = &window[0] ;
	wptset() ;
}

