
#include	"sysdef.h"

/*	scompile	compile a search pattern		*/

#if	VAXVMS
typedef unsigned char pattern ;
#else
typedef char pattern ;
#endif

#include	"scerrd.h"

#define	CTRLA	1
#define	CTRLB	2
#define	CTRLC	3
#define	CTRLD	4
#define	CTRLE	5
#define	CTRLF	6
#define	CTRLG	7
#define	CTRLH	8
#define	CTRLI	9
#define	CTRLJ	10
#define	CTRLK	11
#define	CTRLL	12
#define	CTRLM	13
#define	CTRLN	14
#define	CTRLO	15
#define	CTRLP	16
#define	CTRLQ	17
#define	CTRLR	18
#define	CTRLS	19
#define	CTRLT	20
#define	CTRLU	21
#define	CTRLV	22
#define	CTRLW	23
#define	CTRLX	24
#define	CTRLY	25
#define	CTRLZ	26

#define	then
#define	true		1
#define	false		0
#define	metamin		192
#define	any		192
#define	notalfa		193
#define	let		195
#define	alfa		196
#define	digit		197
#define	letdig		200
#define	white		201
#define	smalllet	202
#define	biglet		203

#define	largea		0101
#define	largez		0132
#define	smalla		0141
#define	smallz		0172
#define	tab		'\011'
#define	TAB		'\011'





static char otable[]	= { CTRLX, CTRLS, CTRLN } ;
static int  omap[]	= { 192,193,194 } ;
static char etable[]	= "xacdglrsvwXACDGLLRSW" ;
static int  emap[]	= { 192,195,196,197,198,199,200,201,202,203,
			    192,195,196,197,198,199,200,201,202,203 } ;


scompile(ins,inlen,outs)
pattern *ins,*outs ;
int inlen ;

{
	register pattern *cp ;
	register ch ;
	int i,curlength ;

	cp = ins ;				/* point to the input string  */
	curlength = 0 ;				/* returned string length zero*/


	while (inlen > 0) {

	   ch = *cp++ ;				/* get the next character     */
	   inlen-- ;
	   if ( ch == '^' && inlen > 0 )	/* convert ^letter to control */
	     then { 				/* any character prefixed with*/
		inlen-- ;			/* uparrow will get converted */
		ch = *cp++ & 037 ;		/* to what should be a control*/
		}				/* character.		      */
	   if ( ch == CTRLR && inlen > 0 )	/* use any character following*/
	     then {				/* control R as is unless the */
		inlen -- ;			/* control R is the only thing*/
		*outs++ = *cp++ ;		/* left, in which case use it */
		curlength++ ;			/* otherwise, map it if in the*/
		}				/* meta chars ^X, ^S and ^N   */
	     else {				/* otherwise, use it if not ^E*/

		for ( i=0; ch != otable[i] && otable[i] != '\0';i++);
		if (otable[i] != 0)
		  then	{
			*outs++ = omap[i] ;
			curlength++ ;
			}
		  else	{
			if ( ch != CTRLE )
			  then {
			     *outs++ = ch ;
			     curlength++ ;
			       }
			  else {
			     i = patnumber(cp,inlen) ;
			     if ( i < 0 ) then return(0);
			     if ( i > 0 )
				then {
				  *outs++ = i ;
				  curlength++ ;
				  while (*cp != '>' && inlen > 0)
					{ inlen-- ; cp++ ; }
				  cp++ ; inlen-- ;
				     }
				else {
				  if (inlen <= 0) then break ;
				  ch = *cp++ ;
				  inlen-- ;
				  for (i=0; ch!=etable[i] && etable[i]!=0;i++);
				  if (etable[i] != 0)
				    then {
					  *outs++ = emap[i] ;
					  curlength++ ;
					 }
				     }				/* end else  */
				}				/* end else  */
			}					/* end else  */
		}						/* end else  */

	   }							/* end while */

	return( curlength ) ;
}							/* end scompile	     */

	



static patnumber(cp,inlen)
register pattern *cp ;
int inlen ;

{
	pattern buffer[50] ;
	int  decflag,i,result ;
	register pattern *bp ;

	if ( inlen <= 0 ) then return(-1) ;
	inlen-- ;
	if ( *cp++ != '<' ) then return(0) ;
	i = 0 ;
	decflag = false ;
	bp = buffer ;

	while ( inlen > 0 && *cp != '>' ) {

		if ( *cp == '.' )
		  then decflag = true ;
		  else *bp++ = *cp ;
		cp++ ;
		inlen-- ;
		}
	if ( *cp != '>' ) then return(-1) ;
	*bp = '\0' ;
	i = 0 ;
	bp = buffer ;
	result = 0 ;
	while ( *bp != '\0' && ((decflag) ? isdigit(*bp):isoctal(*bp)) ) {
		if (decflag)
		 then result = result*10 + (*bp-'0') ;
		 else result = result*8  + (*bp-'0') ;
		 bp++ ;
		}
	if (*bp != '\0') then return(-1); else return(result) ;
}
		
		
	
	
