.ENABLE GLOBAL
.ENABLE QUIET
.ENABLE SUBSTITUTION
; TABBUILD.CMD
;
; Author: Dennis P. Costello
;	   National Research and Resource Facility for Submicron Structures
;	   G02 Knight Lab
;	   Cornell University
;	   (607) 255-2329
;
; Copyright (c) 1986. This command file may be reproduced without charge 
;	provided this copyright notice remains intact.
;
; This command file at the attendant procedure for its use are believed to be
; correct, however, neither the author, the Submicron Facility, nor Cornell
; University acknowledge any liability for any damages arising from its use.
; In particular, the user is strongly encouraged to read and understand the
; paper "Adding Devices to RSX without a Sysgen", published in the Spring 86
; DECUS Proceedings, before proceeding. A copy is included here as PAPER.RNO.
.;
.; Prefix file for calling SGNPER.CMD. Sets global symbols appropriately, opens
.; files that are expected to be open, etc., and then calls SGNPER.
.;
.; Assumes that the files SYSSAVED.CMD and SGNPARM.CMD are in the current 
.; directory, and that they are copies of the file produced by SYSGEN.
.;
.; Also assumes that SGNPER.CMD is in the current directory. This should be run 
.; in a scratch directory, to reduce the chance of corrupting any system files.
.;
.; Will append to RSXMC.MAC, so make a backup copy first.
.;
.; If you have the RL02 kit, $EXC should be defined as the disk on which EXCPRV
.; is mounted.
.;
.; For RSX-11M only, NOT RSX-11S, MICRO/RSX, P/OS, or RSX-11M+ 
.;
.;
.; Get name of device to be added
.;
	.DISABLE LOWERCASE
	.ASKS XX [2:2] Enter name of device to be added (e.g., DL, MS)
	.ASKN [1:9.:1] XXN Enter number of controllers of type 'XX'
.;
.; Read saved answer file
.;
	.SETF $SGN1
	.SETF $SGN2
	@SYSSAVED
	@SGNPARM
.;
.; Set other global variables
.;
	.SETN $SYGRP 1
	.SETN $UIC 11
	.SETN $GRP 0
	.IFT $MAP .SETN $GRP 4
	.TEST <UIC>
	.SETS $DFUIC <UIC>[2:<STRLEN>-1]
	.SETS $SGNUC <UIC>[2:<STRLEN>-1]
	.SETS $LST ""
	.IF $ALD NE "NL:" .SETS $LST "'$ALD'['$UIC',3'$GRP']"
	.SETS $EXC "SY:"
	.SETS $DRV $EXC
	.SETS $DIR "['$UIC',2'$GRP']"
	.SETS $PREFX "LB:['$SYGRP',1]EXEMC/ML,SY:['$UIC',10]RSXMC"
	.SETS $XEPRE "LB:['$SYGRP',1]EXEMC/ML,DEUNA/ML,SY:['$UIC',10]RSXMC"
	.SETS $UICMS "['$SYGRP',5'$GRP']"
	.SETF $ACFDF
	.SETF $ACL
	.IFT $DCL .OR .IF $NUC GT 0 .SETT $ACL
	.SETS $SYS "M"
	.SETF $FUD
	.IF $TTY EQ "C" .SETT $FUD
	.SETT $PERIP
	.SETS $SF1 ""
	.SETT $SAVE
	.SETT $SAVED
	.SETS $SAO "SYSSAVED.CMD"
	.SETF $QBUS
	.IF $TPR EQ "11/03" OR $TPR EQ "11/23" OR $TPR EQ "11/73" .SETT $QBUS
	.IF $TPR EQ "11/83" OR $TPR EQ "LSI-11/73" OR $TPR EQ "KXJ11" .SETT $QBUS
	.SETT $XPRES
	.SETF $PTW
.;
.; Change number of controllers in $DEV, $DV2, $DV3 to show new device
.;
	.SETS STRING "$DEV"
	.GOSUB ADDDEV
	.SETS STRING "$DV2"
	.GOSUB ADDDEV
	.SETS STRING "$DV3"
	.GOSUB ADDDEV
.;
.; Open the various files that SGNPER expects to write to
.;
	.OPENA #0 SYSSAVED.CMD
	.OPENA #1 RSXMC.MAC
	.OPEN  #2 'XX'TAB.MAC
	.OPEN  #3 'XX'DRVASM.CMD
.;
.; Write header records in SGNPER's output files
.;
.DATA #2	.TITLE	'XX'TAB
.ENABLE DATA #2
	.IDENT	/M4.2/
;
;		COPYRIGHT (c) 1983, 1985 BY
;	DIGITAL EQUIPMENT CORPORATION, MAYNARD
;	 MASSACHUSETTS.  ALL RIGHTS RESERVED.
; 
; THIS  SOFTWARE  IS FURNISHED UNDER A LICENSE AND MAY
; BE USED AND  COPIED  ONLY  IN  ACCORDANCE  WITH  THE
; TERMS  OF SUCH LICENSE AND WITH THE INCLUSION OF THE
; ABOVE COPYRIGHT NOTICE.  THIS SOFTWARE OR ANY  OTHER
; COPIES  THEREOF  MAY  NOT  BE  PROVIDED OR OTHERWISE
; MADE AVAILABLE TO ANY OTHER  PERSON.   NO  TITLE  TO
; AND OWNERSHIP OF THE SOFTWARE IS HEREBY TRANSFERRED.
; 
; THE  INFORMATION  IN  THIS  SOFTWARE  IS  SUBJECT TO
; CHANGE WITHOUT NOTICE AND SHOULD  NOT  BE  CONSTRUED
; AS  A  COMMITMENT  BY DIGITAL EQUIPMENT CORPORATION.
; 
; DIGITAL ASSUMES NO RESPONSIBILITY  FOR  THE  USE  OR
; RELIABILITY  OF  ITS  SOFTWARE  ON EQUIPMENT THAT IS
; NOT SUPPLIED BY DIGITAL.
;
;  
; VERSION M4.2	BASELEVEL 38  
;
; CREATED BY SYSGEN VERSION 3.00
;
; SYSTEM TABLES
;
; MACRO LIBRARY CALLS
;
	.MCALL	HWDDF$,SCBDF$,UCBDF$,CLKDF$
	HWDDF$			;DEFINE HARDWARE REGISTERS
	SCBDF$	,,SYSDEF	;DEFINE SCB OFFSETS
	UCBDF$	,,TTDEF		;DEFINE UCB OFFSETS
	CLKDF$			;DEFINE CLOCK QUEUE OFFSETS
;
; LOCAL ASSIGNMENTS
;
	UMD=0
	.IIF DF	D$$IAG,UMD=400	;DIAGNOSTIC FUNCTIONS BECOME LEGAL
	ERL=0
	.IIF DF E$$DVC,ERL=4
;
; DEVICE TABLES
;
.DISABLE DATA #2
.DATA #2 $'XX'DAT::
.;
.; Call SGNPER to setup the device tables
.;
	@SGNPER
	SET /UIC=['$DFUIC']
.;
.; Write trailer records in SGNPER's output files
.;
	.DATA #2 $'XX'END::
	.DATA #2 	.END
.;
.; Close the files written by SGNPER
.;
	.CLOSE #0
	.CLOSE #1
	.CLOSE #2
	.CLOSE #3
.;
.; All done!!!
.;
	.EXIT 0
.;
.; Change the number of controllers for device XX to XXN, if XX is in STRING
.;
.ADDDEV:
	.TEST 'STRING'
	.SETN POS 1

.LOOP:
	.IF XX EQ 'STRING'[POS:POS+1] .GOTO FOUND
	.SETN POS POS+4
	.IF POS GT <STRLEN> .RETURN
	.GOTO LOOP

.FOUND:
	.SETS XXNS "'XXN'"
	.SETS 'STRING' 'STRING'[1:POS+2]+XXNS+'STRING'[POS+4:<STRLEN>]
	.RETURN
