.ENABLE SUBSTITUTION
;
;	      C C L G E N . C M D
;
; This command file will create a tailored CCL for your environment
; depending on the answers to your questions.  CCL requires parent/offspring
; support, the SPAWN directive and EXIT WITH STATUS under M V3.2/M+ V1.0.
; For M V4.x/M+ V2.x, RPOI and alternate CLI support is assumed.
;
.SETF INSPIP
.IFNINS ...PIP .SETT INSPIP
.IFT INSPIP INS $PIP
.ASK ASM Assemble CCL
.SETS LIST ""
.SETS MAPFIL ""
.SETS DCLFIL ""
.SETS TBLFIL ""
.SETF MP
.SETF KMSTBL
.SETF DFLTBL
.SETF LST
.SETF PIP
.SETF CREATE
.SETF HELP
.SETT ALTCLI
.SETT RPOI
.SETF NEWPRS
.SETF LB0
.SETT WAIT
.SETN FILE1 0
.SETN FILE2 0
.SETN FILE3 0
.SETN FILE4 0
.IFF ASM .GOTO TKB
.ASK LST Produce an assembly listing file (not spooled)
;
; CCL may be built as a privileged or non-privileged task.  The advantage
;  of being privileged is that there is no restriction on command line length
;  that may be passed to the ultimate command processing task.  Also,
;  for unsupportd versions of M and M-plus, a privileged CCL will implement
;  a form of the "REQUEST-PASS-OFFSPRING-INFORMATION" (RPOI) directive
;  allowing CCL to exit and maintain parent-offspring task synchronization.
;  The disadvantage is that CCL will have to be re-built each time
;  a SYSGEN is performed.
;
.ASK PRIV Build CCL as a privileged task
;
; For RSX-11M V4.x and RSX-11M-PLUS V2.x, CCL may be used as an alternate CLI
;
.ASK ALTCLI Include alternate CLI support
;
.IFF ALTCLI .ASK RPOI Executive support for RPOI directive available
;
; WAIT-FOR-TASK action lines allow CCL to connect and wait for an offspring
; task to exit.  If CCL is solely used as an alternate CLI, the wait-for-task
; code is never executed and may be excluded from the task image.  As a
; catchall task, wait-for-task action lines will be ignored if this
; support is excluded.
;
.ASK WAIT Include WAIT-FOR-TASK support
;
; You may select 1 of 2 parameter parsing options as the default; one
;  that is virtually identical to the previous release of CCL (V8.0),
;  or the new extended parsing supported by this version of CCL (V9.1)
;
.ASK NEWPRS Default to the new (V9.1) parameter parsing 
;
; CCL may be configured to automatically issue a "HELP" command if the
;  original command line ends in a "?".  In the event that the "?" terminator
;  has other significance for your installation, this feature may be disabled.
;
.ASK HELP Should CCL issue a HELP command if the command line ends with "?" 
;
; CCL normally looks for the group and system wide CCL command
;  files on LB1: (globally assigned)
;
.ASK LB0 Do you wish CCL to look for these files on LB0:
;
; Internal command lookup for DCL-like commands can be supported by:
;     1) including the DCL.MAC module''s code section
;        and/or,
;     2) including an internal CCL command file (table)
;
.ASK DCL Do you wish to include DCL.MAC''s code in CCL (option 1)
.IFT DCL;
.IFT DCL; DCL code is subdivided into 2 subsections: 1) the PIP-like commands, and
.IFT DCL; 2) various other functions (SHQ, ATS, etc.). The latter commands are
.IFT DCL; being included by default.
.IFT DCL;
.IFT DCL .ASK PIP Include DCL code to support PIP-like commands
;
; Do you wish to include command lookup from
.ASK TBL an internal CCL table (option 2)
.IFT TBL ;
.IFT TBL ; Two options are provided for supporting command lookup from
.IFT TBL ;  an internal file/table:
.IFT TBL ;     1) User supplied table (TABLE.MAC)
.IFT TBL ;     2) Standard table (TABLE.KMS) supporting DCL PIP-like commands
.IFT TBL ;
.IFT TBL .ASK DFLTBL Are you supplying the internal table (option 1)
.SETF CREATE
.IFT DFLTBL .ASK CREATE Do you need to create the internal table
.IFT CREATE ;
.IFT CREATE ; To create an internal table we will chain to TABLEGEN.CMD.
.IFT CREATE ; When it exits, you will have a TABLE.MAC file.
.IFT CREATE ;
.IFT CREATE @TABLEGEN
;
.IFT TBL .IFF DFLTBL ; TABLE.KMS will be used for internal PIP-like commands
.IFT DFLTBL ; TABLE.MAC will be used for the internal CCL table
.IFT DFLTBL ;   You are responsible for creating this file!!
.IFT TBL ;
;
;*****
;
; You must now select the order that the CCL command files are going
;  to be opened.  Enter the # corresponding with the following files
;  in the order that they should be opened :
.IFT TBL ;	1 = internal file/table
;	2 = SY0:[ggg,mmm]USERCCL.CCL
.IFF LB0 ;	3 = LB1:[ggg,5]GRPCCL.CCL
.IFF LB0 ;	4 = LB1:[1,5]SYSCCL.CCL
.IFT LB0 ;	3 = LB0:[ggg,5]GRPCCL.CCL
.IFT LB0 ;	4 = LB0:[1,5]SYSCCL.CCL
;
.ASKN [0.:4.] FILE1 Enter # of file/table to open first
.ASKN [0.:4.] FILE2 Enter # of file/table to open second
.ASKN [0.:4.] FILE3 Enter # of file/table to open third
.ASKN [0.:4.] FILE4 Enter # of file/table to open fourth
;
.OPEN PRECCLASM.MAC
.ENABLE DATA
;
;	DEFINE CONDITIONAL ASSEMBLY VARIABLES
;
.DISABLE DATA
.IFT PRIV .DATA   $PRIV=0		; CCL is privileged
.IFF PRIV .DATA ; $PRIV=0		; CCL is non-privileged
.IFT ALTCLI .DATA   $ALCLI=0		; Include alternate CLI support
.IFF ALTCLI .DATA ; $ALCLI=0		; Exclude alternate CLI support
.IFF ALTCLI .IFT RPOI .DATA   R$$POI=0		;  but can use RPOI$ directive
.IFT WAIT .DATA   $WAIT=0		; Include wait-for-task support
.IFF WAIT .DATA ; $WAIT=0		; Exclude wait-for-task support
.IFT NEWPRS .DATA   DEFPRS=1		; Default to V9.0 parsing
.IFF NEWPRS .DATA   DEFPRS=0		; Default to V8.0 parsing
.IFT HELP .DATA   HELP=0		; Issue HELP commands for lines ending in "?"
.IFF HELP .DATA ; HELP=0		; Suppress HELP commands for lines ending in "?"
.IFT LB0 .DATA   $LB0=0		; Look on LB0: for SYSCCL.CCL
.IFF LB0 .DATA ; $LB0=0		; Look on LB1: for SYSCCL.CCL
.IFT DCL .DATA   $DCL=0		; Include internal DCL support
.IFT DCL .IFT PIP .DATA   $PIP=0		; Include PIP subsection of DCL cmds
.IFT DCL .IFF PIP .DATA ; $PIP=0		; Exclude PIP subsection of DCL cmds
.IFT DCL .IFF KMSTBL .DATA   $DCLX=0		; Include SHQ, ATS, etc cmds in DCL
.IFT DCL .IFT KMSTBL .DATA ; $DCLX=0		; Exclude SHQ, ATS, etc cmds
.IFF DCL .DATA ; $DCL=0		; Do not include internal DCL support
.IF FILE1 GT 0. .DATA   FILE1='FILE1'		; Select 1st file to open
.IF FILE2 GT 0. .DATA   FILE2='FILE2'		; Select 2nd file to open
.IF FILE3 GT 0. .DATA   FILE3='FILE3'		; Select 3rd file to open
.IF FILE4 GT 0. .DATA   FILE4='FILE4'		; Select 4th file to open
.CLOSE
.OPEN CCLASM.ASM
.IFT LST .SETS LIST ",CCL/-SP"
.DATA CCL'LIST'=PRECCLASM/PA:1,CCL
.IFT LST .SETS LIST ",DCL/-SP"
.DATA DCL'LIST'=PRECCLASM/PA:1,DCL
.IFT LST .SETS LIST ",SPAWN/-SP"
.IFF PRIV .DATA SPAWN'LIST'=SPAWN
.IFT PRIV .DATA SPAWN'LIST'=[1,1]EXEMC/ML,[11,10]RSXMC/PA:1,'<UIC>'PRECCLASM/PA:1,SPAWN
.IFT LST .SETS LIST ",FIXUP/-SP"
.DATA FIXUP'LIST'=PRECCLASM/PA:1,FIXUP
.IFT LST .SETS LIST ",LOOKUP/-SP"
.DATA LOOKUP'LIST'=LOOKUP
.IFT LST .SETS LIST ",PARSE/-SP"
.DATA PARSE'LIST'=PRECCLASM/PA:1,PARSE
.IFT LST .SETS LIST ",WAITCK/-SP"
.DATA WAITCK'LIST'=WAITCK
.IFT LST .SETS LIST ",TABLE/-SP"
.DATA NULTBL=NULTBL
.IFT TBL .IFT DFLTBL .DATA TABLE'LIST'=TABLE
.IFT TBL .IFF DFLTBL .DATA TABLE'LIST'=TABLE.KMS
.CLOSE
.SETF INS
.IFNINS ...MAC .SETT INS
.IFT INS INS $MAC
MAC @CCLASM.ASM
.IFT INS REM ...MAC
;PIP CCLASM.ASM;*/DE
.SETF INS
.IFNINS ...LBR .SETT INS
.IFT INS INS $LBR
LBR CCL/CR:50.:128.:64.=CCL,DCL,FIXUP,LOOKUP,PARSE,SPAWN,WAITCK,NULTBL
.IFT INS REM ...LBR
PIP CCL.OBJ;*/DE/NM,DCL.OBJ;*,FIXUP.OBJ;*,LOOKUP.OBJ;*
PIP PARSE.OBJ;*/DE/NM,SPAWN.OBJ;*,WAITCK.OBJ;*,NULTBL.OBJ;*
.TKB:
.ASK BLD Build CCL
.IFF BLD .GOTO ENDUP
.ASK MP Produce a taskbuild map (not spooled)
.IF <SYSTEM> EQ 1 .ASK FCSRES Build CCL linked with a FCS resident library
.IF <SYSTEM> EQ 6 .ASK FCSRES Build CCL linked to a supervisor mode FCS resident library
.IFNDF PRIV .ASK PRIV Build CCL as a privileged task
.IFNDF TBL .ASK TBL Do you wish CCL to include command lookup from an internal CCL table
.SETF CCLRES
.SETF INS
.IFNINS ...TKB .SETT INS
.IFT INS INS $TKB
.IFF TBL .GOTO TKB2
.IFT TBL .ASK CCLRES Build the internal CCL table as a resident library
.IFT TBL .IFF CCLRES .GOTO TKB2
;
;  Be sure to install CCLRES.TSK into a common partition prior to
;  installing CCL.TSK....
;
.OPEN CCLRESBLD.BLD
.ENABLE DATA
CCLRES/-HD/PI,CCLRES/-SP,CCLRES=TABLE
/
STACK=0
//
.DISABLE DATA
.CLOSE
TKB @CCLRESBLD.BLD
;PIP CCLRESBLD.BLD;*/DE/NM
.TKB2:
.IFT MP .SETS MAPFIL ",CCL/-SP"
.IFT TBL .IFF CCLRES .SETS TBLFIL "TABLE"
.SETS PRIVSW ""
.IFT PRIV .SETS PRIVSW "/PR:5"
.OPEN CCLBLD.BLD
.DATA CCL/CP'PRIVSW''MAPFIL'=CCL/LB:CCL,
.DATA 'TBLFIL',CCL/LB
.IFT PRIV .DATA LB:'<LIBUIC>'RSX11M.STB/SS,LB:[1,1]EXELIB/LB
.DATA /
.IF <SYSTEM> EQ 1 .IFT FCSRES .DATA LIBR=FCSRES:RO
.IF <SYSTEM> EQ 6 .IFT FCSRES .DATA SUPLIB=FCSFSL:SV
.IFT TBL .IFT CCLRES .DATA RESCOM=CCLRES/RO
.ENABLE DATA
EXTTSK=255		;RESERVE SPACE FOR "P" WORKSPACE
GBLDEF=CLIFIL:44514	;CLI''S CHANGE FILES FROM XXXCCL.CCL TO XXXCLI.CCL
TASK=...CA.
PRI=90
UNITS=2
ASG=TI:2,LB:1
STACK=64
//
.DISABLE DATA
.CLOSE
TKB @CCLBLD.BLD
.IFT INS REM ...TKB
;PIP CCLBLD.BLD;*/DE
PIP *.ASM/PU,*.OBJ,*.LST,*.BLD,*.TSK,*.MAP,*.OLB
.IFT INSPIP REM ...PIP
.ENDUP:; CCLGEN complete
