/* r e x . h -- rex package common definitions */

#define QUIET 0		/* login/logout modes */
#define VERBOSE 1

#define REX_HOST "lb:[5,54]rexhst"

#define RXHELLO 1
#define RXSPAWN	2
#define RXBYE	3
#define RXEMIT	4
#define RXTTYO	5
#define RXEXEC	6
#define RXQHELLO 7
#define RXQBYE 8

#define RXVERSN	2	/* version 2 of protocol */
#define REXOBJ 129	/* rex remote server object type */

#define SPWN_CMD 1	/* command codes: rex to rexhst */
#define DATA	2
#define BYE	3
#define EXEC_CMD 4
#define QBYE 5          /* quiet logout request */

#define QUIET 0  	/* login/logout modes */
#define VERBOSE 1

struct $RX_HELLO {	/* remote VT: login packet */
	char type;	/* type = RXHELLO or RXQHELLO */
	char vers;	/* version - in case protocol changes */
	char acnt[16];	/* login account name */
	char pswd[8];	/* password */
	};

struct $RX_SPAWN {	/* remote VT: spqwn packet */
	char type;	/* type = RXSPAWN */
	char vers;	/* version - in case protocol changes */
	char task[8];	/* task to spawn */
	char cmdlin[132];	/* command line */
	};

struct $RX_BYE {	/* remote VT: bye packet */
	char type;	/* type = RXBYE or RXQBYE */
	char vers;	/* version - in case protocol changes */
	};

struct $RX_EXSTAT {	/* remote exit status return packet */
	char type;	/* type = RXEMIT */
	char vers;	/* version - in case protocol changes */
        word ex_stat;	/* returned exit status */
	};

struct $RX_TTYO {	/* remote tty iosb return packet */
	char type;	/* type = RXTTYO */
	char vers;	/* version - in case protocol changes */
        int buflen;	/* length of buffer to type */
	int vfc;	/* vertical format char */
	};

#define MAXSRL 255	/* maximum SR buffer size in words */
#define PKTHDR 3	/* words to skip to packet data */

