
          
          
           [17m[1w
          [?27h[17;1m[22m
                                                       [17;1mAnalytiCalc[22m
                                                   [17;1mThe Analyst's Tool[22m
                                               [17;1mReference Manual and Guide[22m
           [17;1m[22m
          
[80;80 B          
          
          
          
           [17;1m[22m
          [17;1m                            ANALYTICALC_OVERVIEW [22m
                                                 AnalytiCalc (PortaCalc)
          
                AnalytiCalc  is  an  electronic spreadsheet program which was written in "portable" Fortran 66
           and runs on your PDP11 or VAX systems.  It has a variety of commands and  operates  on  a  "command
           verb"  syntax.   That  is,  everything  you  tell  it is a command.  Some commands enter numbers or
           formulae;  others manipulate them or change the display.  Online help is available (though limited)
           via the Help command (or the PF2 key on some systems).  
          
                AnalytiCalc has 5 major ways of addressing cells, over 75 functions (more depending on how you
           count them), 70 commands (with more variations), unlimited windowing  and  programmability  at  the
           cell and the sheet level, 17 digit precision, and a built in online calculator with extended preci-
           sion (20 or 99 digit)  numbers  available.   It  is  designed  to  handle  traditional  spreadsheet
           problems,  data  access  problems,  equation solving, engineering applications, and finance, and is
           designed to be easy to extend both by adding to the program itself and by  adding  commands  exter-
           nally.  
          
                Interfaces  exist to graphics outputs, to word processing integration with the spreadsheet (or
           AnalytiCalc may be used as a word processing integration tool as a kind of framework  document  in-
           tegrator),  to  data access from data files separate from the sheet, and to saved sheets permitting
           access to systems of spreadsheets.  Simple methods of moving to other  system  commands  make  this
           program a powerful command interface as well as a unique analytic tool.  Approximately 400 function
           key assignments are left for user specification.  AnalytiCalc is designed to be mobile to any  sys-
           tem  with  a cursor controllable terminal and a Fortran compiler able to handle Fortran 66 and byte
           addressing.  Currently, versions exist for PDP11, VAX, and 8086/8088.  
          
                Unlike nearly all commercial spreadsheet type products, AnalytiCalc delivers what it promises.
           If a cell can be addressed, it can be used, subject only to  limitations  on  the  amount  of  disk
           storage  you  allocate  for  backing  store.  You can use EVERY cell fully with enough disk backup.
           Contrast this with memory only systems which may address 500,000 or more cells,  but  which  permit
           only  a few percent of these to be filled before running out of room, even on large machines.  (For
           example, the popular 1-2-3 spreadsheet on IBM PCs is reported to hold at most around 12,000  simple
           formulas on a 544K machine, or around 39,000 9-digit numbers.  AnalytiCalc can hold 32,000 17-digit
           numbers, long formulas, or text strings in its cells, using virtual pages on VAX or disk store on a
           PDP11,  so  that on the PDP11 only a 64 K Byte address space is needed.  RSX configurations can use
           additional memory to speed the program up.  The 8088 version requires 256K bytes for a  full  func-
           tionality 18,000 cell sheet.) The only virtue of pretending your sheet is huge is that there's some
           runtime flexibility of shape to be gained.  AnalytiCalc can do this also.  The version with  a  DTR
           interface  on  VAX  and which is used on PDP11 allows use of up to 32000 columns and 32000 rows via
           aliasing to real cells.  The result is that you can have very long or wide  sheets,  provided  they
           don't  take  up  too many overall cells, to a degree NOBODY exceeds, even on large mainframes.  (Of
           course, it's easier to use cells with short names  like  G12  and  F7  than  with  long  ones  like
           AABA20142 or AAAR18435, but you can choose what you wish.) 
          
           [17;1m[22m

          AnalytiCalc (PortaCalc) Reference Manual                                                      Page 2
          
          
          
          [17;1m                              INTRODUCTION [22m
                                            Getting Started with AnalytiCalc
          
                When using AnalytiCalc, you will find its commands are NOT similar to commercial spreadsheets.
           This has happened because of the method for reading them in.  Do NOT expect to use  the  same  com-
           mands  you learned with Visicalc here.  Few if any of them are the same.  Do, however, expect to be
           able to perform the same functions, even if a bit differently.  You will probably find this a  more
           powerful program than you knew on the micros.  It just takes some learning.  
          
                Remember two things first:  You need an Enter command ("E ") to enter text or numbers into the
           sheet, and floating point numbers (most are floating point rather than integers) need a period  (.)
           in  them  to  get  AnalytiCalc  to  recognize  them as numbers rather than text.  If you forget the
           period, the numbers will be displayed, but only as labels, and the cell will have a  numeric  value
           of  zero.   Scrolling is done differently from most sheets also.  The document file AnalytiCalc.PHL
           details the philosophy of this.  The result is that you have scroll keys to move around  with,  but
           you  also  can  have  as  many windows onto the sheet on screen as you care to define.  There are 2
           major command modes now.  The default is described here but the command  "/;"  command  enters  the
           other and the "//" command goes back to the mode described in this manual.  
          
                The  second ("/;" mode) command format is more like other spreadsheets generally.  Numbers and
           formulas are automatically ENTERed when typed at the start of a line.  If you start a line with  ",
           it is entered as text (minus the ").  If you start a line with "/" (just the slash, not in quotes),
           the remainder of the line is taken as a command.  Commands are NOT recognized unless preceded by  /
           in  this mode.  Some of the auto keypad keys don't work well as defaulted in this mode.  To facili-
           tate writing usable command procedures, the /# command swaps the current mode with a saved mode.  A
           command  file  can use this to save and restore the user's command mode and use a known mode inter-
           nally.  
          
                For  further  convenience,  most otherwise-unknown characters can be pre programmed to do com-
           mands of your choice.  This is described in the rear of the  manual.   A  key  point  is  that  the
           ~ character in a title flags to continue reading sys$input on VAX until EOF.  The ~ will be replaced by
           space prior to display.  This is used to allow automated setups.  
          
                If  the  program's display is not as expected, use a V command to redraw the screen and/or a R
           command to recompute to ensure the display is really  incorrect.   Automatic  recomputation  occurs
           normally when data is entered, so most invalid conditions due to forward references in equations or
           lack of an extra recalculation after copying is done are corrected in the  normal  course  of  use.
           Certain  cases  do  not  redraw  screen  labels (since it is not always correct to do so), so the V
           (View) command is to be used to guarantee the screen's consistency.  New  users  will  seldom  need
           these measures.  
          
                The  AnalytiCalc  spreadsheet  asks  some  questions  when  you  run it, to set up its working
           storage.  AnalytiCalc contains a direct access file which it sets up and can reuse or reinitialize,
           containing the basic information for the spreadsheet's physical sheet.  
          
          
                                                     Initial Screen
          
                When  you  run  AnalytiCalc,  it  first  asks you whether to change the default floating point
           format.  This is initially set to the Fortran format F9.2 (9 characters wide,  2  decimal  places),
           but  if  you  reply Y, it lets you enter any format you like as the default format.  It will try to
           use it, so if you enter an  illegal  format,  AnalytiCalc  will  issue  error  messages  before  it
           generates  a  bad  workfile.   Note  that the default applies when the workfile is BUILT, not later

          AnalytiCalc (PortaCalc) Reference Manual                                                      Page 3
          
          
          
           (though the DF command will reset the format of any part of the file later).  AnalytiCalc then asks
           you  to enter up to 80 characters as the Title of the spreadsheet.  This is displayed at the top of
           the screen and is used as a label for the sheet when printed out.  (The space is made available for
           this rather than being wasted on a copyright statement on your screen.) 
          
                To  reply,  enter  any  title you like, up to 80 characters long, followed (as all AnalytiCalc
           commands) by a carriage return (labelled RETURN on the VT100).  This will appear across the top  of
           the  sheet  on screen and in print images of it.  You may include any desired leading spaces in the
           title.  It will be printed on screen printouts, so make it descriptive of the sheet you'll  be  us-
           ing.   Note  that  it must not start with two spaces.  If you enter a title with two initial spaces
           (or just type the RETURN key), no title will be entered or altered.  This title remains until an  S
           command is given (at which time you can change the work file also), though reading in a saved sheet
           also reads in the saved title.  
          
          
                AnalytiCalc  will ask you some questions about storage and how much of the sheet you intend to
           use on non-VAX versions at this point.  Try to be accurate and see the Appendix on Variant Versions
           below for further information.  
          
                                                   Calculation Screen
          
                The  remainder  of the manual is common to all AnalytiCalc versions, though older versions may
           not have all commands.  

                                                       DISPLAY 
          
                The  sheet  is  displayed  at the top part of the screen and a command cell in Row 23 is shown
           with the current position encoded.  This starts off looking like
          
           [17;1m    A  1>   ("Command-mostly" mode), or[22m
           [17;1m    A  1:   ("Enter-mostly" mode)[22m
          
          
          
           and  then AnalytiCalc awaits your commands.  Note that if the cell pointed to by the command (which
           is always a Physical sheet address) is occupied (i.e., has ever had any  numbers  or  text  entered
           into it), that cell is displayed in the display in reverse video when you are positioned there.  If
           the cell is totally empty, it is not displayed, however, in any reverse video.  A pattern of blanks
           is  displayed, however, wherever the cell is null.  This pattern is in reverse video.  On terminals
           such as VT52 which don't have reverse video, AnalytiCalc uses a ">" character at the start of  your
           current  cell to indicate the active cell where anything is in it.  This overwrites whatever was at
           that character position, though it reappears when the cursor is moved.  (If  you  have  a  terminal
           with  the  ability to handle more lines, edit whatever gets copied to VKLUGPRM.FTN and change LCMDR
           and LDSPR from 23 and 24 to whatever you want as the command line and formula display rows.) 

                                                       CONTROL 
          
                You  control  the  sheet  by entering a command followed by Return.  These commands are in the
           first few columns of the command line and are the first few characters (often the first 1 or 2) you
           type, and they are REQUIRED for every command.  AnalytiCalc does NOT assume any command names.  
          
                Commands  entered  to  AnalytiCalc MUST BE IN UPPER CASE.  Text entered can be of either case.
           However, for PDP11 and VAX, AnalytiCalc now translates cases unless the " character is seen on  the
           line (see below).  
          

          AnalytiCalc (PortaCalc) Reference Manual                                                      Page 4
          
                The commands available in AnalytiCalc are each described separately.  The following is a brief
           listing alphabetically of their names.
           [?27l[2w
            [17m+J filename                Start journaling to filename [22m
            [17m+N                         Close journal file [22m
            [17m<                          Rewind input file [22m
            [17m%prompt%cmd%key%           Issue prompt and do cmd depending on key [22m
            [17m$ or }                     Perform operating system command [22m
            [17m> or >>pattern             Search for formula containing or starting with pattern [22m
            [17m*                          Comment line [22m
            [17m-prompt                    Load arguments after prompt [22m
            [17m//                         Use "Command-Mostly" mode [22m
            [17m/;                         Use "Enter-Mostly" mode [22m
            [17m/#                         Swap current mode with save mode (cmd-mostly or ent-mostly) [22m
            [17m1,2,3, or 4                Move cursor Up, Down, Left, or Right [22m
            [17m@file.typ                  Read file.typ as input instead of console [22m
            [17mAA nn {R/C}                Add absolute nn rows or columns [22m
            [17mAR nn {R/C}                Add relocating nn rows or columns (nn may be neg) [22m
            [17mCA in-range out-range      Copy All (Absolute) [22m
            [17mCV in-range out-range      Copy Value [22m
            [17mCF in-range out-range      Copy Formula (and Format) [22m
            [17mCR in-range out-range      Copy Relocating (all) [22m
            [17mDB ncol,nrow               Display Bounds (no. cols,rows on screen) [22m
            [17mDF range [format]          Display Format of range to format [22m
            [17mDL range {R/C}n:m          Display Locate range as Row/Col to display col:row n:m [22m
            [17mDS{R/C}{A/D} n             Display Sort row/col, Asc/Desc row/col n [22m
            [17mDT range {F/I}             Display Type range as Float or Integer [22m
            [17mDW ncol,wid                Display Width of col "ncol" to "wid" chars [22m
            [17mE expression               Enter expression into cell [22m
            [17mE" expression              Enter expression as text, no case translation [22m
            [17mED 'oldstring'newstring'   EDit cell [22m
            [17mET expression              Enter expression as UPPER CASE text [22m
            [17mEV expression              Enter expression as computable formula [22m
            [17mF filename/nskip           File read from filename onto display [22m
            [17mG                          Get saved sheet.  Many variants.  [22m
            [17mHn                         HELP and show page n [22m
            [17mIR inrange outrange        In Place Relocate inrange as if moved to outrange [22m
            [17mK                          Go into interactive calculator (need *V 3).  *E goes back.  [22m
            [17mL cell                     Go to cell [22m
            [17mM{0/1/2/3/4/5}             Move - set move direction after enter [22m
            [17mMS or MH                   Macrocell Show or Hide - show or hide included files.  [22m
            [17mOA cell                    Origin Absolute cell - Map Screen with cell in upper left [22m
            [17mOAD cell                   Origin  Absolute  Displace  cell  -  Map Screen with cell in[22m
                                        [17mupper left leaving old windowing alone [22m
            [17mOR cell                    Origin Relative cell - map screen dwn/rght of cursor w/curs=cell [22m
            [17mORD cell                   Origin  Relative  Displace  cell - map screen down/right[22m
                                        [17mof cursor with cursor=cell leaving old windows [22m
            [17mOV +                       OVerride absolute refs, make relative [22m
            [17mOV -                       OVerride off - let abs refs be absolute [22m
            [17mP                          Put (save) spreadsheet.  Many variations.  [22m
            [17mR                          Recalculate sheet [22m
            [17mRB cell                    Set Relocate Boundary at cell [22m
            [17mRE                         Recalculate Entry - recalculate only cell entered.  [22m
            [17mRF                         Recalculate, Force recalc of constants [22m[?27h

          AnalytiCalc (PortaCalc) Reference Manual                                                      Page 5
          
          [?27l[2w
          
            [17mRI                         Recalculate  Incremental  - Recalculate only cell 
                                                entered and displayed cells.  [22m
            [17mRII                        Set Recalc Incremental flag but don't recalculate.  [22m
            [17mRM                         Recalculate Manual - no recalc until R cmd [22m
            [17mS                          Setup - Global mapping/width/title setups [22m
            [17mTE expression              TEst - Evaluate math expr. in cmd mode - many variants.  [22m
            [17mV                          View - Redraw screen [22m
            [17mVF                         View Formulas - Draw with Formulas instead of numbers [22m
            [17mVM                         View Manual - no screen repaint until a V cmd [22m
            [17mW                          Write display to file or printer.  [22m
            [17mX                          eXit from AnalytiCalc.  Asks for confirmation.  [22m
            [17mZE range               ZEro range of cells [22m
            [17mZA                         Zero  All of sheet.  Asks for confirmation.[22m
                                        [17mAlso used for reinitializing.  [22m
           [17m[22m
          [1w[?27h
                                              Detailed Individual Commands
          
          [?27l [17;1m        CURSOR MOTION (Commands to move around[22m
           [17;1m                       the sheet one cell at a time)[22m
           [17;1m[22m
           [17;1m        1               (Move up)[22m
           [17;1m        2               (Move down)[22m
           [17;1m        3               (Move left)[22m
           [17;1m        4               (Move right)[22m
           [17;1m[22m[?27h
           [17;1m[22m
          
                The  cursor motion keys move the cursor on the display in the direction indicated.  Note these
           keys are in the same order on the keyboard as the arrow keys of the VT100.  
          
                (The  reason  the  cursor  keys  are  not  used  directly  is  that on VT100 they are multiple
           characters and difficult for Fortran to parse.) 
          
                Note that the keys 1 to 4 are interpreted in the same way as the up, down, left, and right ar-
           row keys on the vt100.  they appear in the same order as the arrow keys on the vt100  on  the  key-
           board.  
          
                The  X  and  Y accumulators are set to the column number and the (row number + 1) respectively
           during commands.  This allows procedures to detect cursor position or motion where  useful.   These
           accumulators may be used within cells for anything;  resetting them does not move the cursor.  
          
                Certain AnalytiCalc versions interpret the PF1, PF3, and PF4 keys on VT100s as the commands 
           @KYP, @KYR, and @KYS commands, which will use 
           KYP.DAT,  KYR.DAT,  or  KYS.DAT  as  input  command files.  This may be used to locally tailor some
           AnalytiCalc commands using the keypad.  (If CMDMUN and TTYINI are altered, the  entire  aux  keypad
           may be interpreted in this way.) 
          
                If the cursor is pointing to the edge of a screen and a command to move is given, an effective
           OAD to a new location is given to produce a scrolling effect.  This happens for auto  motion  also.
           Thus,  one  should  be  somewhat careful with the cursor keys where complex screen setups have been
           made, as the redraw of the screen (over or up/down by a  screenful,  the  size  depending  on  your
           current DB parameters) will repaint a full screen.  The scrolling will leave 2 rows or columns from

          AnalytiCalc (PortaCalc) Reference Manual                                                      Page 6
          
          
          
           the previous display on screen (to help you keep your place) but will treat the  entire  screen  as
           one  window.   Since  the  display may be set to contain any number of windows, the command NS will
           turn off this scrolling effect, protecting the windows.  The command SC will  turn  scrolling  back
           on.   Because  the OAD form of the repaint is used, reversing the scrolling will remap the old win-
           dows however.  
          
          
           [17;1m      ADJUSTING PHYSICAL LOCATIONS[22m
           [17;1m      (Adding or Removing Rows or Columns)[22m
               [17;1mAA  number  R      Add  "number"  rows ahead of the current physical position, moving all cells[22m
                      [17;1mbelow the current cell down by "number" rows and  losing  the  physical  sheet's  bottom[22m
                      [17;1m"number"  rows'  contents,  NOT adjusting variable references where the variables are in[22m
                      [17;1mthe moved range and are not the position independent (P## or D## forms) type.  [22m
               [17;1mAA  number  C     Add "number" columns ahead of the current physical position, moving all cells[22m
                      [17;1mright of the current cell right by "number" columns and losing the physical sheet's bot-[22m
                      [17;1mtom  "number"  columns'  contents, NOT adjusting variable references where the variables[22m
                      [17;1mare in the moved range and are not the position independent (P## or D## forms) type.  [22m
               [17;1mAR  number  R      Add  "number"  rows ahead of the current physical position, moving all cells[22m
                      [17;1mbelow the current cell down by "number" rows and  losing  the  physical  sheet's  bottom[22m
                      [17;1m"number"  rows'  contents,  adjusting variable references where the variables are in the[22m
                      [17;1mmoved range and are not the position independent (P## or D## forms) type.  [22m
               [17;1mAR  number  C     Add "number" columns ahead of the current physical position, moving all cells[22m
                      [17;1mright of the current cell right by "number" columns and losing the physical sheet's bot-[22m
                      [17;1mtom "number" columns' contents, adjusting variable references where the variables are in[22m
                      [17;1mthe moved range and are not the position independent (P## or D## forms) type.  [22m
          
          
                These  commands  permit  the  operations known on other spread sheets as "insertion" or "dele-
           tion".  Deletion takes place where "number" is negative and the sense of the  motion  is  reversed.
           These  commands change the physical sheet's contents and permit wholesale modifications to variable
           names (other than P## or D## forms which are position independent already and are  left  alone  for
           simplicity  and  to preserve some of the flexibility of the D## forms which can be used for projec-
           tions of 3D sheets onto the display and math with ranges of these).  To save a  sheet  for  merging
           such selected values, both forms, or at least the numeric form, of the Put commands should be used. 
          
[3m                Note  that the previous contents of the rows or columns inserted is RETAINED, though it can be
           zeroed by the ZE command if desired.  It will have been copied also to the lower  or  further-right
           row/column also, but do not be alarmed;  the space is free to re-use.  You may however elect to use
           this feature as a shorthand for copy.  
[23m          
                The AR/AA operations take place on the physical sheet and do not affect the display sheet map-
           ping to the physical sheet.  
          
[3m                Because  of  the  confusing results that could arise, AA and AR do not work on extended cells.
           (Extended cells are right of column 80 on VAX, or of 50 on PDP11, or below row 400 on VAX or 200 on
           PDP11.) 
[23m          
          

          AnalytiCalc (PortaCalc) Reference Manual                                                      Page 7
          
          
          
          [?27l
           [17;1m     COPYING CELLS[22m
           [17;1m[22m
           [17;1m   CA V1:V2 V3:V4    Copy all cell attributes from V1:V2[22m
           [17;1m                      to V3:V4.[22m
           [17;1m   CV V1:V2 V3:V4    Copy numeric values only[22m
           [17;1m   CD V1:V2 V3:V4    Copy Display Formats only[22m
           [17;1m   CF V1:V2 V3:V4    Copy Formulas only (no relocation)[22m
           [17;1m   CR V1:V2 V3:V4    Copy all cell attributes as in CA[22m
           [17;1m               but relocate cell names to new location[22m
           [17;1m               from old one. Only relocate names right[22m
           [17;1m               of or below the cursor or on same row/col[22m
           [17;1m               with cursor (cells above or left of cursor[22m
           [17;1m               are NOT relocated).[22m
           [17;1m   IR V1:V2 V3:V4    Relocate formulas inplace, computing[22m
           [17;1m               displacements using distance "moved".[22m
          
          [?27h
          
           The COPY commands let you reproduce cells' contents  in  other  locations  on  your  sheet  without
           re-entering them.  The CA form is most useful, though the CD part can be  used  to  change  default
           formats and the others may be handy.  Note that formulas are NOT changed by the copy operation.  If
           they should function correctly in their new location relative to different cells, the cell  identi-
           fications  should  be position independent forms (P#n#m for forms relative to physical sheet, D#n#m
           for forms relative to display sheet) so no modification is necessary.  CA will  normally  save  all
           information about a cell in the new cell.  
          
                Unlike  the  other  C class commands, the CR command WILL relocate any variable names that are
           below or to the right of the cursor at the time the command is given.  Names above or left  of  the
           cursor  are not changed.  The row and column the cursor is in is included in the relocation region.
           Thus, to be sure names are relocated, use a command like L A1 first to position yourself at the top
           left part of the physical sheet.  
           Be SURE you do the reposition if you use the CR command!  
           Note however that if you need certain cells NOT to be relocated, the ability to place them above or
           left of the cursor when copying or replicating cells around and having them left alone can be  use-
           ful.   Normalization  factors,  for  instance, can be left alone (e.g., at the top of a column) and
           cells referring to them be copied without having them point to the "wrong" normalization cell.  
          
                When  you  specify one variable to the C class commands in the V1:V2 range location and give a
           range V3:V4, the command will copy the named V1 into all cells in the V3:V4 range.  
          
                The  IR  command  allows inplace relocation of formulas.  This operates from the cursor to the
           Relocate Boundary (see below).  The *U HERE function returns the current maximum column used in the
           W  accumulator  and the current maximum row used in the Y accumulator to permit the repeated use of
           IR from a command file to simplify moving sections of the sheet.  
          
          

          AnalytiCalc (PortaCalc) Reference Manual                                                      Page 8
          
          
          
          [?27l [17;1m      DISPLAY BOUNDARIES SETTING (Number rows/cols)[22m
           [17;1m[22m
           [17;1m    DB n,m    Set number of columns displayed on screen[22m
           [17;1m                to n, number of rows displayed to m.[22m
          [?27h
          
                The DB command sets display size.  It also effects the number of cells modified by the OA, OR,
           OAD, and and ORD commands, so setting the display small, doing an OA or OR, then setting it  large,
           leaves  the part omitted as it was before the OA or OR.  The displayed window also controls what is
           read in with the F command.  Note that for automated text retrieval, the VM command  (to  turn  off
           redisplay during commands) may be useful in connection with using DB commands, F commands, and then
           V commands to turn the display updating back on from command  files  invoked  either  by  auxiliary
           keypad  keys or from @file commands.  The default VAX maximum dimensions for display are 63 columns
           and 75 rows.  For PDP11, the default is 20 columns by 75 rows.  In addition, the VAX  version  sup-
           ports displays up to 512 characters wide;  the PDP11 version's limit is 132.  
          
           For an example of DB, if you want a display of 14 columns by 20 rows, the command 
                 DB 14,20 
           would be the way to achieve it.  
          
          
          [?27l [17;1m      DISPLAY FORMAT SETTING[22m
           [17;1m[22m
           [17;1m      DF V1:V2 [format]   Set Display Format AND[22m
           [17;1m                            set up whether to[22m
           [17;1m                            display formula or number[22m
          
          [?27h
          
                The  DF  command sets the display format for the variable range V1 to V2 inclusive to be what-
           ever is in the square brackets.  This is expected to be a valid Fortran FORMAT specifier  for  dis-
           play  of the number and may be up to 9 characters long.  If the format specifier entered is however
           just A or L in the first character,  the  program  will  indicate  the  text  is  to  be  displayed
           literally,  not as a number, so titles and such can be shown.  To display numbers in Fortran A or L
           forms, just use formats like 4A1 or similar;  as long as there is something ahead of the A or L  it
           goes  to  Fortran.   The program will try your format once before writing to disk to ensure against
           any crashes that will damage your file.  Otherwise, the format is up to you.  You can even  display
           in octal or hex if you wish!  
          
                The  DF  command  is used to switch a cell from display of numeric information to formula/text
           display or back on a cell by cell basis (the VF command globally switches  cells  from  numeric  to
           formula  and  back,  though  a cell set to display text with DF always displays text).  To change a
           cell to numeric, merely use the DF command to give it a numeric format  (the  default  is  normally
           F9.2  so the command to set, say, cell G3 to be numeric (possibly after entering a formula not con-
           taining +, -, ., (, or [ characters) would be:  
          
               DF G3 [F9.2] 
          
           for the standard Fortran F9.2 format (2 decimal places, 9 digits wide display).  In AnalytiCalc-VM,
           every cell may have an entirely unique format.  In AnalytiCalc-PC, however, only a finite number of
           unique  formats is possible (usually about 45) since storage is in memory.  The design limit is 255
           unique formats, but very few spreadsheets will need more than the 45  normally  provided.   Typical

          AnalytiCalc (PortaCalc) Reference Manual                                                      Page 9
          
          
          
           ones only have 2 or 3 unique formats.  The formats may be ANY Fortran formats desired.  
          
                The  DF  command will also set the type to Floating if the format begins with F or E, and will
           set the type to Integer if the format begins with I.  Beyond this (e.g., for octal or hex) you must
           use the DT command (below) to set the storage to floating (8 bytes) or integer (4 bytes).  
          
                The  DF command will attempt to avoid erroneous format inputs by trying the format out on your
           current location.  If errors occur, the DF command will be quietly ignored, and  the  program  will
           not  crash.   This  makes it difficult to switch to integer displays.  To switch a cell or range to
           integer, you must use the L command to move to a cell not shown on the screen, then use the DT com-
           mand  to  change  the  desired cells to integer type, then use the DF command to change the display
           format to an integer display format.  The cells will then work correctly as  integer  cells.   Note
           this checking is done by AnalytiCalc-Vm and AnalytiCalc-PC only.  

                                          WHAT_IS_DISPLAYED 
                    NOTE:  
                    There are 2 items in any cell which may be displayed.  One of these is the number  in  the
                    cell,  which takes 4 bytes if an integer, 8 if floating point, and which is displayed nor-
                    mally using a Fortran FORMAT statement type declaration.  The other is the  FORMULA  asso-
                    ciated with the cell, which may contain just text or labels.  This is selected by the A or
                    L formats.  
          
                         Thus, the declaration 
                    DF A1:A64 [8A1] 
                    would  display  the  NUMBERs  in column A as 8 characters (assuming this makes sense), and
                    would cause strange errors if the number did not make sense as characters.  
                    The declaration 
                    DF A1:A64 [A] 
                    would  display the FORMULA TEXT in column A on the screen.  This normally will always make
                    sense, and is the normal way to display labels.  

                                                    FORMAT 
          
                To  reset FORTRAN Formats, the Fw.d format is useful.  In that format, w means an integer giv-
           ing the width in characters of the output number, and d is the  number  of  decimal  places  to  be
           shown.   For example F9.2 has 9 places total, 2 to the right of a decimal point.  A valid number in
           this format might be (supposing its' exact value is 123456.782) 
                123456.78 
                The format F9.1 would give 
                123456.8 (note rounding) 
                The format F10.3 would give 
                123456.782 
          
                You  may  devise  whatever  formats  desired.   In addition, AnalytiCalc will only display the
           number of characters that fit in the column on screen, so display width can be set  to  remove  un-
           desired decimals.  

                                                   OTHER_FORMATS 
          
                The  default F9.2 format occupies 9 of the default 10 characters of column width.  Where addi-
           tional labels are needed, the 1Hc or 2Hcc formats may be used.  For example, to show  dollars,  one
           might  write  a  format  as  [1H$,F9.2] in the DF command.  If as an alternative one wanted to show
           thousands of dollars with one decimal place, a format like [2H$K,F9.1] would place  "$K"  ahead  of
           each number.  Thus, a value of 345.67 in the first format would look like 
           $ 345.67 
           and in the second format it would look like 
           $K 345.7 

          AnalytiCalc (PortaCalc) Reference Manual                                                     Page 10
          
          
          
           (since the spreadsheet only knows numbers, not their dimensions).  
          
                Where  it is desired to display large numbers, FORTRAN offers the E and G formats (the form of
           such a format is Ew.d or Gw.d where w is the width of the number as printed and d is the number  of
           decimal  points).  The E format displays the number as a fraction followed be E followed by a power
           of 10.  The G format chooses a floating point display or an E  format  depending  on  the  number's
           size.   Note  that  in E and G formats, there need to be 4 spaces in the decimal field just for the
           exponent.  
          
                The  format  you  display  in  may  be wider than the column;  the first "n" characters of the
           number are shown, where "n" is the width of the column.  Thus, if  you  use  a  format  like  F10.0
           (which  displays  10  digits  followed  by  a  period),  the period will not show in the default 10
           character column width.  
          
                Available format designators for floating numbers (the ones you'll use almost always) are:  
               Fw.d  -  Simple display with w characters of display (counting the decimal point) and d decimal
           places after the decimal;  
               Ew.d  -  Display  as  a fraction followed by Enn where nn is the exponent of 10 to multiply the
           fraction by.  The format kPEw.d causes k digits to be displayed to the left of the  decimal  place,
           so  that  a format of E10.5 might display the number 73.453 as ".73453E+02" and a format of 1PE10.4
           would display it as "7.3453E+01".  The w is the total number of characters in the display, and  the
           d  the number of decimals shown.  Note that the w must have 4 extra characters to handle the "E+nn"
           part of the number.  Very large or small numbers can be handled by this format where they would  be
           too wide in F format.  
               Gw.d - This format works like the Fw.d format provided the number is small enough to fit in the
           widths provided, and like the Ew.d format otherwise.  The display will include only  d  digits  (or
           k+d digits if using kPGw.d), so for cases where it works, the Fw.d format is more space efficient. 
               Several  "modifier"  formats  are  available.  nHxx allows characters xx in the output.  nX in-
           cludes n spaces.  TRc causes the next output to appear c spaces right of the current one, and  'xx'
           acts  like the nHxx in outputting characters xx.  The 'xx' or nHxx designators must be separated by
           comma from following format designators.  Also Dw.d is equivalent  to  Ew.d.   The  optional  forms
           Ew.dEe and Gw.dEe act like Ew.d and Gw.d except that only e digits of exponent are displayed.  
          
          
          [?27l [17;1m     DISPLAY LOCATE (Map physical sheet variables[22m
           [17;1m                     onto Display Sheet)[22m
          [?27h
             DL  V1:V2  Rn:m     point at display coordinates (n,m) (col,row) and, going left to right along a
                    Row, copy in variables V1 through V2 (actually, point those display sheet cells  at  vari-
                    ables V1 thru V2).  
             DL  V1:V2  Cn:m     point at display coordinates (n,m) (col,row) and, going top to bottom along a
                    Column, copy in variables V1 through V2 (actually, point  those  display  sheet  cells  at
                    variables V1 thru V2).  
          
                The DL command lets you associate any variables in the physical sheet with any location on the
           display sheet (the display sheet coordinates always count from 1 as the  topmost  row  or  leftmost
           column, through the maximum number there).  This flexible association means that in principle every
           cell on the display sheet can be a "window" in the sense of other  sheets,  though  that  would  be
           quite  hard  to  follow.   If  the  :V2  part  of the command is left off, only one display cell is
           changed.  
          
          

          AnalytiCalc (PortaCalc) Reference Manual                                                     Page 11
          
          
          
          [?27l [17;1m        SORTING DISPLAYS[22m
           [17;1m[22m
           [17;1m   DSRA#nn   Sort display on row/col nn (display coord)[22m
          
          [?27h
          
                The  DS  command sorts "normally" ordered display sheets.  It operates something like a sorted
           OA command, the sort key being the number in a column or row.  The command looks like this:  
           DS Command specifier 
           R or C - Row or Column specifier (i.e.  whether to sort a row or a col.) 
           A or D - Ascending or Descending order sort 
           nn - row or column number to sort on.  
          
                The  command letters must all appear together.  Thus a command to sort Column 4 on the display
           in Descending order would be:  
           DSCD 4 
           and a command to sort Row 3 in Ascending order is:  
           DSRA 3 
          
           The  sheet should be in "normal" order (as from an OA command) prior to the sort for use.  The area
           sorted is the part of the sheet displayed (set by the DB command, so it may  actually  exceed  what
           shows on the screen.  The VAX version of AnalytiCalc normally supports very large display sheets to
           permit printout of large displays which are not all visible on the screen;  the screen display dis-
           cards  all  the  un-displayable points, but the print routine, and the sorts, do not.) That is, the
           display sheet size may be given as larger than your screen will display, and the  sort  will  cover
           that area.  Note that ONLY display sheet locations are sorted.  A sort on the PHYSICAL sheet may be
           done via a cell or sheet program, but this primitive does not.  
          
          
          [?27l [17;1m      DISPLAY TYPE SETTING[22m
           [17;1m[22m
           [17;1m    DT V1:V2 F    Set V1 thru V2 to Floating data type[22m
           [17;1m    DT V1:V2 I    Set V1 thru V2 to Integer data type[22m
          
          [?27h
          
                The  DT  command  sets  Float/Integer  attributes  on physical cells.  Initial default is F (8
           bytes) but this can set it to I (4 byte integer).  Computation is done in  floating  point  always,
           but I type variables will be converted to integer when stored and may be displayed in valid Fortran
           formats.  This information is stored/restored by the P/G class commands, but not in workfiles as it
           is considered volatile.  
          
          

          AnalytiCalc (PortaCalc) Reference Manual                                                     Page 12
          
          
          
          [?27l [17;1m        DISPLAY WIDTH SETTING[22m
           [17;1m[22m
           [17;1m    DW N,M     Set column N on display to be M[22m
           [17;1m                  characters wide[22m
          
          [?27h
          
                DW  lets  you set any [1mcolumn width[22m.  They are independent of each other, and may be set in any
           order.  Maximum width supported is 132 columns with the present  version  of  UVT100;   it  may  be
           larger  on terminals where it makes sense, if UVT100 is altered.  Note that when many widths are to
           be varied, the VM mode is useful to prevent redrawing the screen between settings;  the V mode  can
           then  be  reset once the widths are as desired.  Setting column widths is expected to be frequently
           done via a command file (see the @ command below).  Because a display column may  show  cells  from
           many parts of the physical worksheet, width is a property of the display column here rather than of
           the cell in the work sheet.  However, the format for displaying each physical cell's  number  is  a
           property of the physical cell.  This separation can be used to aid in formatting a display.  
          
          
                                                          ENTER
          [?27l
           [17;1m        E expression     Enter expression, figure out[22m
           [17;1m                           text or value based on[22m
           [17;1m                           contents.[22m
           [17;1m        ET expression    Enter expression as text only[22m
           [17;1m        E" expression    Enter expression as text only[22m
           [17;1m        EV expression    Enter expression as Value[22m
          
          [?27h
          
                This  command  enters the given expression at your current cursor position, and may optionally
           move in some direction that has been set up by the M command (Move) after the entry is made.  
          
                The Expression may be text or one or more numbers, functions, or equations (separated by the \
           (backslash) character if more than one per cell) in fully parenthesized infix  notation.   The  ex-
           pressions entered resemble normal algebraic expressions, with the usual operator precedence.  There
           are 26 global accumulators named A through Z (plus a special one named %) available;  the result of
           a calculation is always left in the % accumulator as well as the cell.  Operators available include
           addition (+), subtraction (-), multiplication (*), division (/), and exponentiation (** or !), with
           normal  precedence.  Many functions are also available, described below, for other operations.  The
           operator evaluation order is functions, exponentiation, multiplication and division,  addition  and
           subtraction,  just  as  in  Fortran  and  most  programming  languages  (and  on most calculators).
           Parentheses may be used to group calculations to override these defaults.  
          
                The  text  entered  becomes  the  Formula  for  that cell, and AnalytiCalc takes a guess as to
           whether that text is just text or a number to compute.  If the text contains any of the  characters
           (,  +, -, ., or [, it is assumed to be a formula, and the cell is marked as containing a computable
           formula.  Otherwise it is just treated as a label and the formula itself is displayed.  If you find
           the  guess  is  not  to  your  liking,  the  DF  command  below  lets you alter the format and tell
           AnalytiCalc that the entry is / is not a numeric.  An additional special character is the '"' (dou-
           ble  quote)  character.   If  this character appears any- where in the entered formula, AnalytiCalc
           will take the formula as text, regardless of whatever else is in it.  You can also combine comments
           and formulas by using a separate statement and the *C construct 

          AnalytiCalc (PortaCalc) Reference Manual                                                     Page 13
          
          
          
           (e.g.  SUM[A3:A12]\SQRT(%)\*C SQUARE ROOT OF THE LENGTHS) 
           of  Calc.   Once  a  cell  is  set up as numeric or text, it remains as it was originally set until
           changed (using the DF command, described below).  The ET and E" forms of the  Enter  command  force
           the formula entered to be considered as text and not as computable, and the EV form forces it to be
           considered computable, regardless of the presence or absence of special characters.   Note  however
           that  numbers need decimal points for their values to be understood correctly.  If the decimals are
           omitted, the expressions may be considered integer.  These will be converted,  but  the  conversion
           has  some  limitations and is advised against.  Also, integer division truncates results to produce
           an integer result (so that 7/2 would evaluate to 3, while 7./2.  would evaluate to 3.5,  for  exam-
           ple).  Thus, to avoid surprises, use decimals.  
          
                Where  the  auxiliary  console support routines supplied for PDP11 or VAX are in use, any com-
           mands will be translated to upper case unless a " character appears anywhere in the command.  If  a
           "  character  is  found, only the first 2 characters are converted.  These special console routines
           also attempt to convert the PF2 key to H (Help) (as in EDT), and to convert the arrow keys of VT100
           or VT52 to the 1,2,3, or 4 commands to move the current cell.  
          
                On the PDP11 or VAX, AnalytiCalc will turn the auxiliary keypad feature of a VT100 on to allow
           use of the auxiliary keypad as a shorthand for many user-specifiable command sequences.  
          
                Most  keys  map to indirect files to make customizing AnalytiCalc easier.  These files are as-
           sumed in one's default directory with names KYa.CMD where a is P, R, or S for PF1,PF3, or  PF4,  or
           AKa.CMD  where a ranges from A through N (0 thru 9 are E thru N).  In addition, the program is able
           to read a keypad diagram into Help page 9 from a file KEYPAD.PIC which may be updated to correspond
           to  the  keypad functions chosen.  A version of this corresponding to the "standard" keypad is sup-
           plied.  
          
                Note the terminal is set into auxiliary keypad mode to enable these keys to function.  
            AUX KEYPAD MAPPING IS:
          [?27l   KEY   CHAR  AKx.CMD,x=
             0     p       E
             1     q       F
             2     r       G
             3     s       H
             4     t       I
             5     u       J
             6     v       K
             7     w       L
             8     x       M
             9     y       N
             ,     l       A
             -     m       B
             .     n       C
            ENTER  o       D
          [?27h 
            MAPPING FOR PF1 THRU PF4 IS:
            KEY    FILE
            PF1    KYP.CMD
            PF2    (none - Equivalent to H Command)
            PF3    KYR.CMD
            PF4    KYS.CMD
          

          AnalytiCalc (PortaCalc) Reference Manual                                                     Page 14
          
          
          
                Examine  the  KEYPAD.DOC  file  for the values of individual keys.  There is a build option to
           read keypad command files from logical device DK:  which may be in effect at your site;  the system
           manager should be able to tell you.  
          
                Because many prefer a "Gold key" style command processor, AnalytiCalc can be set up  for  gold
           key  functions.   A "gold level" is kept internally and is incremented whenever a command beginning
           with the character ^ (up arrow) is seen, and cleared upon executing any normal command or opening a
           new  command  file.  When the gold level is greater than zero, the command file names opened by the
           auxiliary keypad are modified by adding 1 extra letter, which is  computed  as  64  plus  the  gold
           level, which means that at gold level 1, an A is added, at gold level 2 a B is added, and so on.  A
           gold key top level (no added letter) command file may be built containing a  single  ^  line.   For
           multiple  levels of gold key access, second level files may have two ^ lines (one after the other),
           third level files may have 3, and so on.  Command files are opened read-only, so they may be shared
           and  any desired level of gold key-ing may be supported.  Supplied command files using gold key use
           the VT100 LEDs to indicate that the "gold" level is nonzero.  
          
                A  bit  of  added functionality has been added to allow some extra flexibility in command han-
           dling.  A line beginning in % is assumed to have several fields:  
          
           %FLD-1%FLD-2%FLD-3 
          
           in which FLD-1 if present is typed out to the screen first (used to set screen widths).  Then FLD-2
           is passed as the command.  If FLD-3 exists and starts with a ? or , then the terminal is  read  and
           the  result  is  added onto the end of FLD-2 before the command is passed back to the spread sheet.
           If the command begins with a space or control character or a , then it is  commented  out  and  the
           command  file  falls  past  the  %  line.   If however FLD-3 started with ? and the initial read-in
           character is not or a control character, the command file is rewound.  This feature is used in  the
           enter command file (AKD.CMD) to implement an "enter mode" somewhat akin to that of Visicalc, Super-
           calc, or others of that ilk by automatically inserting the "E " of the PortaCalc Enter command  un-
           til  a  is  seen.   If  FLD-3 should be present and start with a & character, the auxiliary file is
           closed there and console input done as in input.  
          
                Note  that a file KYSAUX.CMD is supplied which may be used instead of KYS.CMD.  If used, it is
           the ENTER MODE command and will turn off auxiliary keypad mode on the terminal.  This way, PF4  may
           be  used  to  get  into  enter  mode and the numeric keypad used to enter numbers.  Recall that the
           period (.) of numbers is normally needed for their proper recognition as numerics.  
          
                Additionally,  where the Gold levels are supported (with lines beginning with "^" incrementing
           the level), gold-PF2 will be the same as H9 (help 9), and gold-gold-PF2 will be the  same  as  H10,
           gold-gold-gold-PF2  will  be  as  H11  and so on.  This allows multiple screen picture displays and
           makes them more available.  More than 9 help screens are supported only  in  PortaCalc-PC,  but  in
           that  version, a Help system with up to 99 screens is supported.  These are externally defined by a
           help file there.  However, by adding Runoff instructions  to  suppress  headers  and  paging,  this
           manual  may  be turned into a standard RSX or VMS HELP entry and accessed online via the $HELP com-
           mand.  

                                                EXAMPLES 
          
                The expressions that are entered can be numbers or formulas relating numbers and other  cells.
           They  may also consist of several statements separated by a \ character which will all be evaluated
           at that cell, up to 110 characters.  Thus, valid commands might be 

          AnalytiCalc (PortaCalc) Reference Manual                                                     Page 15
          
          
          
          [?27l 
             E 55.234      Enters value 55.234 at current cell
             E B4+H2+D5    Cell will contain the sum of cells B4,H2,
                           and D5.
             E Totals      Cell contains literal text "Totals".
          [?27h

                                               FORMULAS 
          
                Formulas  may  be  used too.  These include 2 classes.  The first are the multi-argument func-
           tions, which either appear at the start of their statements or substatements (alone), or inside ex-
           pressions.   The  difference between the classes is that the multiargument functions must have cell
           names or ranges as their arguments, while the single argument functions can have arbitrary  expres-
           sions in their arguments.  Otherwise they may mix freely.  All functions listed below may appear in
           command files or cells, and arguments must be cells, not expressions or constants.  The  IF  state-
           ment,  while  it is treated as a function syntactically, may NOT appear inside general expressions,
           but must begin a cell equation or sub-equation (i.e., it may begin after a  in  a  cell  containing
           several  operations).   It cannot be used inside command files driving cells, but its functionality
           is supplied there by the "*J label" function, so no real limitation exists on capability.  
          
           The available multiple argument functions are:  
          [?27l [17;1m[22m
           [17;1m  SUM[variables]     Sum of all arguments[22m
           [17;1m  MAX[variables]     Max of arguments[22m
           [17;1m  MIN[variables]     Min of arguments[22m
           [17;1m  AVG[variables]     Average of arguments[22m
           [17;1m  AVE[variables]     Average of arguments excluding zero args[22m
           [17;1m  STD[variables]     Standard deviation squared[22m
           [17;1m  IF [V1.rel.V2] statement | else-statement[22m
           [17;1m  AND[variables]     Boolean AND of all variables in list[22m
           [17;1m  IOR[variables]     Boolean inclusive OR of variables[22m
           [17;1m  NOT[variable]      Boolean complement of variable[22m
           [17;1m  XOR[v1,v2]         Boolean exclusive OR of v1,v2[22m
           [17;1m  EQV[V1,V2]         Boolean "equivalence" of V1,V2[22m
           [17;1m                     (complement of exclusive OR, true if[22m
           [17;1m                     bits have the SAME value)[22m
           [17;1m  CNT[variables]     Number of nonzero variables in list[22m
           [17;1m  MOD[V1,V2]         Returns V1 modulo V2 (i.e., remainder[22m
           [17;1m                     of V1/V2 division.)[22m
           [17;1m  SGN[v1]            Returns 1.0 times sign of V1[22m
           [17;1m  LKP[var,variables] Lookup variable in "variables" range[22m
           [17;1m                     greater or equal to var, return its[22m
           [17;1m                     index (starting with 0) into variables[22m
           [17;1m                     range.[22m
           [17;1m  LKN[var,variables] Lookup variable in "variables" range[22m
           [17;1m                     less than or equal to var, return its[22m
           [17;1m                     index (starting with 0) into variables[22m
           [17;1m                     range.[22m
           [17;1m  LKE[var,variables] Lookup variable in "variables" range[22m
           [17;1m                     strictly equal to var, return its index[22m
           [17;1m                     (starting with 0) into range. Note all[22m
           [17;1m                     LKP, LKN, LKE return the last variable[22m
           [17;1m                     index if no satisfactory value found.[22m
           [17;1m  NPV[disc,vars]     Net Present Value of vars (equal time[22m
           [17;1m                     interval numbers), at discount rate[22m[?27h

          AnalytiCalc (PortaCalc) Reference Manual                                                     Page 16
          
          [?27l
          
           [17;1m                     disc where disc is a fraction[22m
           [17;1m                     (e.g., .12 for 12%)[22m
           [17;1m  IRR[PV,FV,returns] Internal Rate of Return. Will compute[22m
           [17;1m                     internal rate of return on up to 20[22m
           [17;1m                     periods, returning rate per period.[22m
           [17;1m                     The returns are expected to be at[22m
           [17;1m                     equal time intervals. PV and FV are[22m
           [17;1m                     initial and final values of investment[22m
           [17;1m                     and the result is computed via Newton[22m
           [17;1m                     approximation.[22m
           [17;1m   PMT[princ,inter,nper] Payment (mortgage payment per period)[22m
           [17;1m                     function. Will compute payment per period[22m
           [17;1m                     for principal amount "princ" with interest[22m
           [17;1m                     per period as "inter" and number of periods[22m
           [17;1m                     as "nper". All arguments must be cells.[22m
           [17;1m                     The formula is the standard ordinary annuity[22m
           [17;1m                     formula. Interest rate must be a fraction so[22m
           [17;1m                     that 14% would be 0.14, for example.[22m
           [17;1m   PVL[payment,inter,nper] Present Value formula. Computes present[22m
           [17;1m                     value of an annuity given "payment", the payment[22m
           [17;1m                     per period, interest rate per period (as a[22m
           [17;1m                     fraction, so 12% is 0.12) in "inter", and[22m
           [17;1m                     number of periods as "nper". All arguments[22m
           [17;1m                     must be in cells.[22m
           [17;1m   RND[DUM]          Generates a random number between 0. and[22m
           [17;1m                     1.0. An argument is needed but it is[22m
           [17;1m                     NOT touched by this function.
                         CHS[IDX,Range]    Choose cell from range based on value of cell
                                           IDX. If cell used as IDX is 1, first element
                                           of range is chosen and so on. Zero is returned
                                           for out of range cases.[22m
          [?27h
           In  all  but  the  case  of IF [...], arguments are variable names separated by commas, or variable
           ranges, or mixtures separated by columns.  All these functions require  cells  or  accumulators  as
           arguments;   literals  and single argument functions may NOT be used here.  (That is why it is easy
           to place multiple commands on a line;  the ACs or cells may be loaded in "separate" steps.) 
          
                Note  that  the function STD gives a "variance" which normally will be the square of the stan-
           dard deviation;  just use SQRT(STD[range]) to  get  the  ordinary  standard  deviation  (using  "n"
           statistics;   scale  to  use "n-1" statistics).  The AVG function computes an average as the sum of
           all cells in the range given divided by the number of cells.  Since label cells are  counted  (with
           value zero), this may not always be what is wanted.  Therefore, the function AVE[range] returns the
           average ignoring label cells completely (by ignoring cells with zero value).  
          
                The  Boolean variables are computed by taking the integer values of the variables and perform-
           ing the appropriate boolean masking operations on them.  The values are returned as  whatever  type
           (floating  or  integer) the cell is.  32 bit integers are used.  The CNT operation will (generally)
           omit cells that have not been initialized, since these have a value of 0.0 and are not changed  un-
           less  modified  explicitly.   It may be used to compute a more accurate average than AVG where many
           uninitialized cells add zero values in.  The quotient of the SUM divided by the CNT of a range will
           give an average of nonzero cells only.  This is duplicated by the AVE function for ease of use.  
          
                The  LKP function quickly locates a cell in a list where the value is in a desired range;  the
           *G function may be used to extract other cells close to the addressed  cell  (e.g.,  beside  it  or
           below it).  The LKN and LKE functions are exactly the same but search for lower or equal values in-
           stead of greater than values.  This makes varied search strategies easy to do.  These functions are
           most  useful  in user command files for selecting parts of the sheet according to criteria, as they
           allow very fast searches of large parts of the spreadsheet from  inside  command  files.   In  this

          AnalytiCalc (PortaCalc) Reference Manual                                                     Page 17
          
          
          
           application  the  LKP class functions would be accessed via the TEst command.  Since the ranges can
           be either rows or columns, no special "horizontal" or "vertical"  lookups  are  needed.   Note  the
           FIRST cell that matches the criterion of the search is returned.  
          
                The  NPV  function is the standard financial Net Present Value function, assuming the discount
           rate is the fractional interest percent per period for the amounts in the range given, and that the
           range of numbers represents equal time periods.  Remember to give a FRACTION rather than a Percent,
           so a 5% interest rate per period should be given as .05 for example.  
          
                The  IRR  function  will compute IRR given present value, future value, investments per period
           (for up to 20 periods), and assuming that the periods are equally spaced.  The IRR  value  returned
           is  per  period  and must be multiplied by periods per year to get a yearly rate.  This function is
           computed iteratively.  The PMT and FVL functions are payment and  present  value  formulas.   These
           functions  are  implemented  only  on  the  VAX version of AnalytiCalc-PC (due to space).  They are
           present only for convenience and follow the same rules about arguments having to  be  in  cells  as
           other functions of this type.  To compute them one uses the formula 
           Payment=Princ*(int/(1.-(1.+int)**-nper)) for payment, or 
           PV=payment*(1.-(1.+int)**-nper)/int for present value.  
          
                No  function  for the value of PI is presented.  Pi is approximately 3.14159265358979323846...
           and may be used in this way if needed.  It is suggested that the @PI.CMD command file  be  used  to
           enter  the  value PI anywhere desired, or that a cell contain it and be named as {PI so that if you
           MUST have the constant in your sheet, it will be in one place.  Since pi/180.  is more often  used,
           you may prefer to compute that instead and use it.  
          
                The  random  number  function  RND[]  is  included  to  facilitate  generating  "Monte  Carlo"
           spreadsheet calculations.  It is uniformly distributed between 0.0 and  1.0.   Other  distributions
           may  be  derived  from  it via standard techniques described in numerical methods texts;  the GAUSS
           function in the IBM SSP library can be used as an example of this.  In  Monte  Carlo  applications,
           some  accumulator  can be used as a counter to provide a count of calculation passes.  The built in
           IF [] function can be used for producing triangular distributions by selecting one  of  a  pair  of
           scalings of this random number also.  
          
                Functions  which perform selections on their input ranges (MIN, MAX, LKP, LKN, and LKE) return
           the column and row numbers of the cells found in accumulators P and Q respectively in  addition  to
           returning  the  function  values.   This  is true of AnalytiCalc-PC and AnalytiCalc-88, V18-07A and
           later.  It is useful for operating on argument lists where the arguments are not single ranges.  
          
                                                  VARIABLE_NAMES 
          
                A  valid  variable name might be H14 or N22 or A3, or the position independent forms P#n#m and
           D#n#m where n and m are offsets in Physical or Display sheets from the current column and  row.   A
           valid  range  is 2 variable names separated by colon (:).  Thus the range B2:B12 is valid and means
           B2 through B12 inclusive.  The range expression D#0#1:D#0#12 is also valid and means the  cells  on
           the  display  sheet in the same column but 1 to 12 rows down from the current cell inclusive.  (The
           displacements may be negative too, with - sign to indicate it, as D#-3#2 for  the  display  cell  3
           columns  left  and  2  rows down from the current position.) The P# and D# forms are valuable since
           they work wherever you move them.  Other variables may be relocated when moved  (renaming  them  to
           correspond  to  their  new  locations), but the P# and D# forms need never change and allow working
           with projections across the physical sheet in various ways.  There  are  a  few  restrictions  with
           these forms.  They usually need to be enclosed in parentheses (e.g.  (P#3#5) rather than P#3#5) in-
           side expressions and therefore also won't work in ranges of form v1:v2 inside multi argument  func-
           tions.   For  most purposes they do work interchangeably with other name schemes however.  For most
           purposes, the "normal" naming scheme is more  flexible.   Copying  with  relocation  works  in  it,

          AnalytiCalc (PortaCalc) Reference Manual                                                     Page 18
          
          
          
           provided  that  the  cursor  is above and left of cells to be renamed (see below).  The keypad copy
           command normally moves to A1 during a copy for this reason.  
          
                It  should  be noted that the D#col#row forms work correctly only in the "prime region" of the
           sheet (upper left part) because the speed penalty for handling them globally  would  be  excessive.
           The P#col#row forms work everywhere.  
          
                The  special construction P#%ab or D#%ab allows relative addressing relative to current physi-
           cal or display location using accumulators named a or b (where a or b may be any  accumulator  name
           from  A through Z but upper case is REQUIRED).  This computable relative addressing affords greater
           flexibility in command procedure construction.  
          
                If  a  formula contains the construction {VN (where VN is any cell name), the FORMULA for cell
           VN is inserted into the formula being evaluated at that point, when the cell value is  to  be  com-
           puted.   This  may  be  done several levels deep, but is stopped after 20 translations to avoid in-
           finite loops due to circular references.  Some care must be used here since  the  final  translated
           formula  must  fit  in 110 characters and will be truncated if it gets too long.  This construct is
           useful where formulas are to be tested.  It provides a handy  inline  macro  capability  permitting
           complex  formulas  to  be entered more easily.  This feature may be used with the P#%ab form of ad-
           dressing to provide runtime addressing of formulas anywhere in the matrix.  
          
                The  command  processor may use these inline macros in commands.  If a command line contains 2
           successive underscores (__) anywhere in its length, the underscores will be  stripped  out  of  the
           command  line  and  the command line will be scanned for {Vn forms.  If any are found, they will be
           substituted for prior to interpretation of the command.  This will occur AFTER any console text  is
           read  if  console  text  is required by one of the %%% forms of command line.  This permits formula
           cells to be used as a convenient place to store intermediate answers in models being driven by com-
           mand  files.  It is not particularly useful from the console, but works, and may be used to reenter
           a formula without moving it explicitly if there is a reason to do so.  
          
                If  a  command is given that AnalytiCalc cannot otherwise understand, and if it is the name of
           an accumulator, the formula associated with that accumulator is executed as a command as if instead
           of typing, let us say, Q, you had typed __{Q0 which will execute the formula of Q.  Accumulators B,
           J, N, Q, T, U, and Y can be assigned commands in this way, allowing limited quick  commands  to  be
           implemented.   Since  the accumulators are scratch storage, you must run a command file or have the
           file that starts AnalytiCalc set the commands desired up.  
          
                                               Naming Regions or Formulas
          
                In the VAX version, PortaCalc will allow you to define names (as many names as there are rows)
           to refer to the contents of certain cells' formulas.  The names may be up to 16 characters long and
           they may be defined with a command like:  
          
                TEst {namestring=V1 
          
           where  "namestring"  is  the  name being defined and V1 is the cell name whose contents replace the
           {namestring construct in later formulas.  If the construct "{namestring" (less the " marks) is seen
           in  a formula, it is treated exactly as if it had been a {V1 string.  For example one could place a
           sales total formula in cell C5 and issue a command:  
          
                TE {SALES=C5 
          
           and  later  one could have a formula like "0.06*{SALES" in another cell, which would no longer have
           to remember the definition of "sales".  There is no facility to dump definitions, but they  may  be

          AnalytiCalc (PortaCalc) Reference Manual                                                     Page 19
          
          
          
           included in formulas and saved with a sheet if desired, being executed when computed.  Save as text
           and use TE _{cell to get them evaluated to define the names.  
          
                Note  there  is  some  scratch  formula  storage as well as the scratch accumulator stores.  A
           phantom "row 0" exists which includes the accumulators, but all cells in row 0 may contain formulas
           and/or  values  (though  cell AA0 conflicts with accumulator % in value and should be used for text
           storage only).  This is handy for storing name definitions TEMPORARILY, as during command file exe-
           cution.  The storage in these cells is NOT saved but is purely available for scratch use while run-
           ning AnalytiCalc.  It does however save you from having to use the bottom or  right  edges  of  the
           sheet for scratch formulas if you are using the macro feature as a way of entering text.  
          
                A dump of definitions may be made onto a disk file by typing the command 
          
                TE {*= 
          
           which  will  ask for the output filename.  Type a return an extra time or two after the dump.  Note
           that the format of the output file is a set of TE commands which may be played back into  PortaCalc
           via the @ command to recreate the definitions.  
          
                Since  it is sometimes useful to have mixed formulas which allow certain cell references to be
           absolute and never relocated, with other references which are relocatable, cell names may be speci-
           fied absolute.  If the character "$" (dollar sign) is placed after the letter, the number, or both,
           parts of the variable name, the part of the variable name followed by the dollar sign is  absolute.
           Thus,  the  variable  AB30 is relocatable in both row and column.  Variable AB$30 is relocatable in
           row only (the 30 is not followed by $), and the AB column will not  be  changed  in  any  relocate.
           Variable AB30$ is relocatable in column, but the row 30 reference does not change.  Variable AB$30$
           is totally absolute.  Note that these absolute variables are harder to move around even  on  adding
           or  deleting rows, so they should be used with care.  This relocation protection can be temporarily
           inhibited with the OV + command and reinstated with the OV - command.   This  will  allow  copy  of
           cells  with relocation if it is needed, without laborious editing.  The program starts in OV - mode
           and will remain in OV + mode until OV - is set up again.  The commands may be  given  in  the  form
           OV-, OV -, OV+, or OV +.  
          
                                                VARIABLE_RANGES 
          
                Variable ranges must lie in a single row or column.  Erroneous specifications are rejected and
           ignored generally.  For versions of AnalytiCalc supporting matrix operations, matrix dimensions are
           however given by specifying the upper left and lower right corners of the matrices.  Thus the range
           A1:B2 is the 2 by 2 matrix containing cells A1, A2, B1, and B2.  For  operations  using  full  rec-
           tangular regions, support is offered via auxiliary keypad commands which allow filling of large re-
           gions or moving data into them.  This is done via command  files  automatically  invoked,  but  the
           methods  used are transparent to the user.  Other operations on rectangular regions not confined to
           a single row or column may easily be added in the same way.  The  internal  implementation  permits
           copying rows to columns and vice versa as well as rows to rows and columns to columns;  this is why
           regions must be one or the other.  It is expected that regions are specified starting at  top  left
           and ending at bottom right.  
          
                                               FUNCTION_ARGUMENTS 
          
                Note  that the square brackets ([]) are needed to delimit arguments in multiple argument func-
           tions.  The results are left in accumulator % and in the cell.  The IF form will  compare  2  vari-
           ables  and  execute either the statement or the else-statement (which must NOT be another IF).  The
           valid relations are:  

          AnalytiCalc (PortaCalc) Reference Manual                                                     Page 20
          
          [?27l
                 .EQ.    Equal
                 .NE.    Not Equal
                 .GT.    Greater than (V1 greater than V2)
                 .LT.    Less than (V1 less than V2)
                 .GE.    Greater than or Equal to (V1 >= V2)
                 .LE.    Less than or Equal to (V1 =< V2)[?27h
           and must appear in this form.  (Note that your formulas must generally be in upper case only;  text
           can be anything.) 
          
                                      UNARY_FUNCTIONS 
          
                The  second  class  of  formulas permit fully general arguments of expressions, cells, and the
           like (and are evaluated AFTER the multi argument functions  lexically).   These  are  more  conven-
           tional,  use parentheses, and include single argument functions like SQRT, ALOG, EXP, SIN, COS, and
           so on.  See the built in  interactive  calculator  mode  manual  section  below  for  more  detail.
           However,  they  may  use  variable  names  as anywhere, not just single letter accumulators.  Thus,
           SQRT(A5) is a valid number.  There is a function list in the documentation of Calc  mode  later  in
           this manual.  
          
                                              ACCUMULATORS 
          
                The  single letter accumulators of Calc (letters A through Z and %) are available globally and
           may take on all Calc data types (see the description of calc mode below) including multiple  preci-
           sion.   They are usable globally on the entire sheet and may serve as arguments to command files or
           return cells for results.  Inside command files, Calc can perform any of  its  usual  calculations.
           The  multi-argument functions listed above are not available there (though they can be simulated by
           enumerating cells), but everything else is.  The letter accumulators are available in all cases  in
           addition  to cells.  Of course, any unused cell may be used as an accumulator too, but cells in the
           spreadsheet are at most 8 bytes long and cannot hold multiple precision arguments.  
          
                To get, e.g., the square root of the sum of several variables (in a row or column;  ranges may
           only be in rows or columns together) one might have a formula line like:  
          
           SUM[A1:A20,B4,F2,C5:C20,J3:M3]\SQRT(%) 
          
           which  computes  the  sum  of the 2 cells and 3 ranges and leaves it in %, then computes the square
           root of that and leaves it in the cell.  The formulas to Calc may be complex but MUST NOT be longer
           than  78  characters.   Break  up longer ones so they can be fed to Calc in smaller chunks.  Notice
           that the expression given could have been written as SQRT(SUM[A1:A20,B4,F2,C5:C20,J3:M3])  but  was
           broken up for tutorial purposes.  
          
                                    AUX_COMMANDS 
          
                The commands of CALC should be examined carefully for usefulness.  You can enter programs into
           CALC which can be used as user-defined functions from the sheet if need be.  Also, there are a  few
           new  commands in CALC for the sheet.  See the documentation about the Calc mode (interactive calcu-
           lator) for full lists of functions.  
          
                One of these is the *G command.  Its syntax is 
          
           *G V1,V2 
          
           which  has  the  effect of evaluating variables V1 and V2 as column and row numbers on the physical
           sheet and returning the physical sheet variable addressed  by  those  variables.   The  ranges  are
           clamped  to  fit on the sheet.  This gives indirect addressing, permitting lookup tables to be made

          AnalytiCalc (PortaCalc) Reference Manual                                                     Page 21
          
          
          
           up by creating the index you want and then accessing the addressed table element.  Typically the *G
           command would be the last on a formula line, though it need not be.  Its value is returned in the %
           accumulator.  
          
                Another is the *W command, which simply takes the number in % and places it in the formula for
           the current cell on the spread sheet.  This may be used to "freeze" a value, replacing a formula by
           a constant for future use.  Note that the previous contents of the formula entry are lost.  Thus, a
           *W command in the sheet will normally cause itself to be overwritten after one use.  The number  is
           stored  in  a  format  D35.24 in the worksheet.  The *WF command stores the value using the current
           cell format.  It is a good idea to use a command like "E %=P##WF" rather than just E *WF to  ensure
           the % accumulator REALLY is the current cell.  
          
                To  implement user functions, if Calc sees an expression of the form "*@filename.ext", it will
           execute that file as a command at that cell.  Any filename may be used and  as  many  functions  as
           desired  can  be handled in this way (with obvious overhead), with nesting depth of up to 3 permit-
           ted.  Once Calc starts using logical unit 4, however, it conflicts with the P or G commands and may
           have problems.  
          
                Calc has also a command called *P which allows resetting of the physical coordinates while ex-
           ecuting a cell's formulas, [17;1mfor the duration of that cell's formula only[22m or while in K mode only.  
          
                The  syntax  of  the  *P command is either just *P (which causes Calc to prompt for column and
           row), or *P Variablename (which  moves  the  current  location  to  the  named  location),  or  *P@
           variable1,variable2  (which moves to the location which is defined by variable 1 and 2 as col.  and
           row).  
          
                Some other commands exist for the main benefit of AnalytiCalc in Calc.  
          
                The command *F LABEL 
           will  evaluate  the % variable.  If it is positive and nonzero, then the current input line will be
           rewound and the program will (silently) seek a line of the form *CLABEL.  This allows loops  to  be
           defined  with  %  as the counter.  This command acts on the unit used by the AnalytiCalc @ command,
           NOT the unit for the Calc *@ command, and is a way that the Calc formula conditionals  may  be  re-
           flected back into its command processing.  The TE expression command may be used first to set the %
           variable as needed to any arithmetic expression to control the loop.  
          
                The command *J LABEL 
           will  act  as  does *F LABEL but its search will be in the current file opened by a Calc *@ command
           (i.e., an *@file inside a cell on the sheet, or given from the  console  after  a  K  command  [see
           below] to enter bare interactive Calc).  
          
                The command *QF or *QW file ?searchkey? <cc> 
           will  open  file  and look for lines starting with searchkey as given (with _ as a wild character).
           Upon finding this, it will look for the <cc> and if it finds it, it will select  the  part  of  the
           line  in  the file between the 2 characters given (which may be alike) as they are first found, and
           will do one of 2 things.  If the command was *QF, then Calc will Float the value found  there  (at-
           tempting to use a large E format) and return it in %.  If the command was *QW, then Calc will Write
           the selected part of the record into the formula at the current  physical  position  on  the  sheet
           (which may be reset by an immediately preceding *P command).  The record may contain the search key
           anywhere.  It is up to the user to make sure the formulas copied make sense.  This  however  allows
           access  to  sequential  files  of data which can be created by an editor, word processor, etc., and
           which might hold keyed information that the spreadsheet should be able to manipulate.   As  a  user
           convenience,  there  may  be  a  second  key specified (also inside a pair of ?s).  If two keys are
           specified, Calc will search for and require that BOTH be somewhere in the  record  accepted.   Note

          AnalytiCalc (PortaCalc) Reference Manual                                                     Page 22
          
          
          
           too  that the files opened may not have any records longer than 128 characters per line.  There are
           2 variant forms, involving the 4th character (i.e., the next one after the F or W of *QF  or  *QW).
           These  may  permit sequential access to a data file.  The *QFK command is exactly like the *QF com-
           mand (ditto *QWK and *QW) BUT it will not close the data file after finding the desired cell unless
           it  reached  EOF.   This  permits  subsequent commands of the *QFN command (for "Next") to continue
           reading the file.  The *QFN command will continue reading the file (the file spec must be there but
           is  ignored) from the next record and will also not close the file.  (Ditto *QWN.) The *QFC command
           will act exactly as *QFN BUT will close the file when the request completes.  Thus, a file  may  be
           opened  with  a *QFK (or *QWK) command, subsequent data retrieved by *QFN commands, and finally the
           last data retrieved with a *QFC command.  Also, *QF commands will close the file prior  to  opening
           another.  
          
                Formulas  entered  may  have (this version only) the following constructs which will be edited
           into the formula as entered (so a command file can enter them):  
          
                    _@V1,V2  Means get the values stored in V1 and V2 and use them as column and row locations
                         pointing at some cell in the sheet.  Replace the construct  with  the  name  of  that
                         cell.  
                    _#V1  Means take the real number in cell V1 and unpack it as if it had been a packed value
                         from a formula with 8 characters packed;  then convert it back into ASCII  and  place
                         in  the  formula  in  place of this construct.  This construct is intended to be used
                         with the *U STRVL function to allow retrieval and edit  of  formulas.   The  *U XQTCM
                         function permits use of the EDit command within a cell for string manipulation.  Only
                         8 characters at a time may be represented (the  limit  imposed  by  cell  size),  but
                         repeated use allows handling any desired length.  An application would be setting the
                         cell used as V1 to a packed representation of either of two strings inside  an  IF []
                         and  then  EDiting  the string into the formula as desired where one of the 2 strings
                         should be made to appear.  This capability is crude but provides the bare bones func-
                         tionality.  Additional USRFCT calls to give simpler (but more verbose) string manipu-
                         lations are not too hard to add should the user need them.  
          
                                         FORMULA_LENGTH 
          
                Formulas  have 109 characters allotted to them for use inside the spread sheet.  It may happen
           these are not enough for use.  In other spreadsheets, the technique is to put the formulas in other
           cells  inside  the  sheet  and  possibly  use  screen  windows to avoid display of the intermediate
           results.  
          
                While  you can use that technique here too, you have an alternative.  It is to use an indirect
           file in that cell and inside the cell in the spreadsheet just have a command "*@FILE.TYP" where the
           file  is  named "FILE.TYP" (you pick the real name).  Inside this file may be whatever calculations
           you like.  
          
                So  long  as  the file is to operate in a fixed cell location in your spreadsheet, you may use
           variable names like A3, D1, etc.  inside the file.  Your command files may include any multiple ar-
           gument  functions  except  the  IF  function.   (The  *F  and  *J  functions can be used to provide
           equivalent functionality inside command files however.) The only restriction on  multiple  argument
           functions is that their arguments must be cells, not general expressions.  
          
                Once  you  add  or delete rows or columns, or copy a formula, though, the file may not work as
           expected if the cell calling it has moved.  Since the relocation done by AnalytiCalc only  operates
           on formulas stored directly in the spreadsheet, it cannot relocate variables in the indirect files.
           However, you can make the files "position independent" so they WILL work wherever they  are  called
           from.  (This has the side benefit that a single file can be called from many cells.) 

          AnalytiCalc (PortaCalc) Reference Manual                                                     Page 23
          
          
          
                The  way to make the files position independent is to use location-relative variable names in-
           stead of absolute ones.  That is, inside cell B4, the cell immediately above can be named  B3  (the
           ABSOLUTE  name),  or it can be relocatably named P#0#-1 (the relative name).  Likewise the cell one
           to the right would be named either C3 or P#1#0, and so on.  The cell two down and one left would be
           either  A5  or P#-1#2 (you can begin to see how it goes).  A file containing only location-relative
           variable names will work even if called from a different cell, since the references will be figured
           out when used.  These references are more difficult to write than the absolute ones, but since they
           work without renaming, they provide a level of flexibility needed where long formulas must be used.
           These  forms  should  be used wherever indirect files are used to hold cell formulas.  The computed
           cell name forms like P#%ab can be used also provided the  a  and  b  accumulators  are  initialized
           properly, or the command file does its own relocation using the X and Y accumulators set on entry. 
          
                                                     LINKING SHEETS
          
                To enhance AnalytiCalc, it is possible to have a cell refer to cells from another, saved sheet
           anywhere in the system.  The sheet must normally have been saved starting at the upper left  (i.e.,
           cell A1) as would be the convention for using with PCGRAF (see PCG.DOC).  With AnalytiCalc-PC, nor-
           mally symbolically saved sheets can be accessed for values also, unless they were saved with formu-
           lae  only (PPF command below).  Numeric values MUST have been included in the save, so sheets saved
           with the PPF command (which only saves formulas) cannot have values linked.  
          
                The command *XV filename V1 
           will eXtract the Value of cell V1 (V1 is any variable name, e.g.  C15, AA3, F9, B34, etc.) from the
           saved sheet saved in filename.  The filename is any legal host system file  specifier.   Note  that
           there may be as many files as desired here, but only one cell is returned.  
          
                If  it  is  desired  to  extract a formula from a saved sheet saved NON-NUMERICALLY (i.e., NOT
           saved with the PPN command), the command form is 
          
           *XF filename V1 
          
           and  this  will  cause the formula in "filename"'s cell V1 to overwrite the current physical sheet.
           To avoid this, one might write a formula like 
          
           *P V2 \*XF myfile.typ V1 
          
           which  would  cause  current  sheet  variable  V2  to  have  its'  formula  loaded from saved sheet
           "myfile.typ"'s variable V1.  
          
                Note  that  filename syntax can be anything desired so that fully qualified device, directory,
           and nodename syntax is permitted.  In a DECnet/VAX environment, any file anywhere on the net may be
           accessed  in  AnalytiCalc  anywhere AnalytiCalc needs a filename.  There is a limit in total length
           (usually to 80 characters) for the filename, but apart from that, the name is unconstrained.   This
           is true of ALL places AnalyiCalc accesses filenames.  
          
          [?27l [17;1m        EDIT FORMULAS[22m
           [17;1m[22m
           [17;1m ED 'string1'string2'  Replace string1 with string2[22m
           [17;1m                       in current cell formula. Either[22m
           [17;1m                       string may be null if desired.[22m
          [?27h
          

          AnalytiCalc (PortaCalc) Reference Manual                                                     Page 24
          
          
          
                The  ED command allows editing of formulas with some extra bells and whistles.  Basically, the
           new string replaces the old one, EXCEPT that it is possible to do some  limited  argument  replace-
           ment.  
          
                The  constructs &1 through &4 will be replaced by arguments 1 through 4 as last entered by the
           "-" command (see below).  These may be from 0 to 51 characters long each, and multiple & constructs
           may  appear in a substitution.  No & constructs may recurse, however.  A second ED command can have
           the effect of the recursion in some cases however.  
          
                The  construct  &5  will  evaluate  accumulator  Z and, if it is in a range where it may be so
           represented, take its integer part and convert it to a numeric string (up to 10 characters) in  the
           place of the &5.  
          
                The  construct &6 will replace the cell with the contents of the integer part of accumulator Z
           provided that that number is between 1 and 256.  Thus, any single non-null ASCII code  can  be  en-
           tered.   Accumulator  Z  is used to avoid conflicts with %, which is used too frequently to reserve
           for this purpose.  To set up Z interactively to a constant, the command "TE Z=nn." will  set  Z  to
           the value nn.  
          
                The EDited formula is re-entered into the cell after the edit.  
          
                If  the  initial string is null, the EDit command appends the replacement string onto the con-
           tents of the cell.  If the replacement string is null, the corresponding  contents  of  the  cell's
           formula  are  deleted.   Note  that  ALL matching strings in the formula are replaced, not just the
           first.  The strings may be delimited by any character that does not appear in either  the  original
           or  the  replacement  string,  so  the  quote  character  shown in the example is not special.  Any
           delimiter can be used provided it won't be confused.  
          
          
          [?27l [17;1m      FILE LOADING[22m
           [17;1m[22m
           [17;1m  F filename/nnnn      Read filename, skipping nnnn lines[22m
           [17;1m                    if the "/nnnn" is there, and load[22m
           [17;1m                    contents onto the currently displayed[22m
           [17;1m                    screen, broken into columns as the[22m
           [17;1m                    current screen is set up.[22m
          [?27h
          
                This  command  is  designed  to  make  it  easy  to  load  document  files into AnalytiCalc in
           quasi-image mode.  Once loaded, the characters are in formula cells and may  be  moved  around  the
           sheet.   The display format must be reset to get them to be treated as non-text;  this command will
           reset all loaded cells to text format display.  It repaints the screen upon loading.  This  feature
           makes it easy to capture data in AnalytiCalc from other unrelated programs.  
          
          

          AnalytiCalc (PortaCalc) Reference Manual                                                     Page 25
          
          
          
          [?27l [17;1m      RESTORING YOUR SPREADSHEET[22m
           [17;1m[22m
           [17;1m    GD          Reload sheet down/right onto display[22m
           [17;1m                coordinates.[22m
           [17;1m    GP          Reload sheet down/right onto physical[22m
           [17;1m                coordinates.[22m
           [17;1m    GxR         Reload saved sheet and relocate so that[22m
           [17;1m                the cursor is treated as having been[22m
           [17;1m                at A1 in the save operation. Permits[22m
           [17;1m                mergers of multiple formulas.[22m
           [17;1m    Gxx+        Add saved sheet (if default save) values[22m
           [17;1m                to current values; enters Recalc Manual mode.[22m
           [17;1m    Gxx-        Subtract saved sheet (if default save) values[22m
           [17;1m                from current values. Also enters Recalc Manual[22m
           [17;1m                mode.[22m
          
          [?27h
          
                The  GP/GD  commands are the inverse of the PP/PD commands and load those files to potentially
           new locations.  This is the simple way to merge sheets.  In these cases, you are  separately  asked
           for  filenames  and  limits on what part of the sheets to load/save.  Only cells that are marked in
           use are saved, so sparse sheets take less space than saving the direct access files.  Note that  on
           save  or restore the ranges to restore are asked for.  To restore the sheet starting at the cursor,
           specify the lowest row/column offset of 1 and the highest either 0 or a  very  large  number.   Any
           rectangular  region  can  be  restored  by giving the X and Y coordinates of the lowest and highest
           offsets from the upper left to restore, counting from 1.  .break REMEMBER:  THE LOW  OFFSET  SHOULD
           BE 1 OR LARGER, NOT 0.  
           In  AnalytiCalc/PC, the logic to write to cells involves checks of the built in symbol table to en-
           sure that cells are not previously there and needing to be replaced.  This slows the Get  operation
           considerably,  and  is normally bypassed.  However, where a saved sheet is being merged into an ex-
           isting sheet (rather than restoring into a previously empty region of the sheet),  the  full  logic
           may  be  needed  for correct operation.  To get it, enter the filename followed by "/M" (so that to
           read SAVESHEET.PCC in the full-update mode  you  reply  SAVESHEET.PCC/M  to  the  "Enter Filename>"
           prompt, rather than just SAVESHEET.PCC, as an example.) (M stands for Merge.) 
          
                Note  the  R modifier as the 3rd character of the command (i.e., GPR or GDR) makes AnalytiCalc
           relocate formulas read in so that the origin of the area read becomes the current cell, rather than
           A1 as it ordinarily would be.  This makes merging multiple sheets trivial.  
          
                The + or - modifiers in the 4th character of the command allow you to add or subtract multiple
           saved sheet values.  These require that the normal default save (which includes  both  numeric  and
           formula  data)  have  been  done  to save the sheets being added.  The values in the sheet have the
           saved values either added (if +) or subtracted (if -) from the current values.  The manual recalcu-
           lation flag is set to prevent any automatic recalculations also, since formulas are loaded from the
           last sheet loaded and overwrite other formulas in  the  same  cells.   (This  is  generally  not  a
           problem.)  To  manipulate  these values if there is a need to, the TEst command and the matrix math
           functions (which include multiply matrix by constant) allow  two  dimensional  areas  to  be  moved
           around  or  multiplied  by constants without turning on the sheet recalculation.  Thus, averaging 4
           sheets could be done by a GP command, three GPx+ commands, and then a TE using the *U  MMPYC  func-
           tion to multiply the whole area by 0.25.  (One could use TE A=0.25 to get a "cell" A0 to use in the
           MMPYC function if no 0.25 value existed to use already.) 
          
          

          AnalytiCalc (PortaCalc) Reference Manual                                                     Page 26
          
          
          
          [?27l [17;1m        HELP[22m
           [17;1m[22m
           [17;1m     Hn     Display a screen of help. (n from 0 thru 9)[22m
          [?27h
          
                The  H  command will display a screenful of help giving a summary of many AnalytiCalc commands
           and syntax options.  When you type a second return, it will redraw the screen.  
          
                In most flavors of AnalytiCalc, the PF2 key also means 'Help'.  
          
                There  are  multiple  help  pages.   They  are  selected by commands H0 through H9, the number
           defaulting to 0 and selecting which help screen will appear.  Where the "gold key"  style  commands
           are  supported,  Gold-PF2  is  equivalent  to  H9 (which displays the keypad picture normally), and
           higher "gold" levels display later help pages.  Later help  pages  only  exist  in  AnalytiCalc-PC,
           where  up  to 99 may be provided.  The intent is to make possible the construction of a more intel-
           ligent Help system as desired, using the keypad as the primary command input medium.  
          
          
          [?27l
           [17;1m     DROPPING INTO INTERACTIVE CALCULATOR[22m
           [17;1m[22m
           [17;1m      K       Drop into interactive Calculator[22m
          
          [?27h
          
                The  K  command  gets  you into Calc, described below, and lets you do computations.  When you
           give the interactive Calc program the *E command to exit, you return to the spreadsheet.  This  may
           be  useful  where you want to do auxiliary computations not in the spread sheet or try out formulas
           that you may want to debug interactively before entering them  onto  the  sheet.   This  calculator
           knows  decimal,  hex, and octal radices and can be used to debug indirect command files written for
           use within spreadsheet cells;  the *V 3 command can be given and then the *@file can  be  given  in
           Calc  mode,  providing  a  trace playback of the actions of a command file to see what it is doing.
           See HELP INT_CALC for further information about Calc mode.  
          
          

          AnalytiCalc (PortaCalc) Reference Manual                                                     Page 27
          
          
          
          [?27l
           [17;1m      LOCATE CURSOR (GOTO somewhere on the sheet)[22m
          
           [17;1m   L variable-name    Position cursor at variable-name[22m
          
          [?27h
          
                The  L command moves the current position to the variable named on the Physical sheet (and the
           display sheet if the variable is on the display).  Examples might be 
          
               L B3    Move to cell B3 
               L D6    Move to cell D6 
          
          
           [17;1m           MOTION DIRECTION (Set Default[22m
           [17;1m           Direction to move after an Enter)[22m
           [17;1m[22m
           [17;1m         THIS COMMAND SETS DIRECTIONS FOR AUTOMATIC[22m
           [17;1m               MOTION AFTER ENTER ONLY.[22m
           [17;1m         SEE BELOW FOR HOW TO MOVE THE CURSOR AT[22m
           [17;1m              OTHER TIMES.[22m
           [17;1m[22m
           [17;1m           M0           (Swap previous, current direction)[22m
           [17;1m           M1           (Move up)[22m
           [17;1m           M2           (Move down)[22m
           [17;1m           M3           (Move left)[22m
           [17;1m           M4           (Move right)[22m
           [17;1m           M5           (No auto motion)[22m
          
          
          
                The  M  command  causes automatic cursor motion after an E command in the direction indicated.
           This only occurs after an E command.  The default condition is not to move at all after an  E  com-
           mand,  and this may be reestablished by a command of form M5 (actually Mc, where c is any character
           other than 1 to 4.) At each command, the old direction is saved and may be recalled via the M0 com-
           mand.  
          
          

          AnalytiCalc (PortaCalc) Reference Manual                                                     Page 28
          
          
          
                                    FILE_INCLUSION [17;1m[22m
          [?27l [17;1m      MS   Macrocell Show (handles &% and &&% files)[22m
           [17;1m      MH   Macrocell Hide (no special & treatment)[22m
           [17;1m      &%file,nskip,nshow    overlay file on screen[22m
           [17;1m      &&%file,snskip,nshow  Include file for output[22m
          [?27h
          
                The  MS  and  MH  commands  turn on or off the handling as print time macros of the &% and &&%
           forms of filenames.  These permit you to use AnalytiCalc for report generation or outline  handling
           more  easily.   In MS mode, if a cell has an &%file form in it, that file is read when that cell is
           displayed.  The first "nskip" records are skipped in the file, and up to  "nshow-1"  lines  of  the
           file  are  displayed  on  null cells of the spreadsheet.  Up to 4 files may be open at a time here.
           The left margin of the file text is made to coincide with the location of the cell  containing  the
           reference.  You can use the $ (spawn) command to edit these files with your favorite editor or word
           processor on the system and they will automatically be updated on screen.  The &&% form is used  to
           include  (possibly  lengthy)  files in output.  The files are included in spreadsheet output at the
           point they are seen, indented by the amount of the indenting of the &&% command  form.   Therefore,
           you  can  use AnalytiCalc to organize a multilevel hierarchy of printout of reports.  If a &&% form
           is seen in one of the files being included, that file is opened and included.  This nesting may  go
           to  a  depth  of 4 levels.  This permits a real "frame editing" using AnalytiCalc and your favorite
           editor or word processor (WITHOUT requiring you to learn yet another editor.) 
          
          
          [?27l [17;1m        ORIGIN RESET  (Windows onto physical sheet)[22m
           [17;1m[22m
           [17;1m    OA variable   Reset origin of display to variable[22m
           [17;1m    OR variable   Reset display down and right to start[22m
           [17;1m                      with variable[22m
           [17;1m    OAD variable  Reset origin of display leaving [22m
           [17;1m                      mapping Displacements intact[22m
           [17;1m    ORD variable  Reset origin down and right of cursor[22m
           [17;1m                      leaving mapping Displacements[22m
           [17;1m                      intact.[22m
          
          [?27h
          
                The  OA  and  OR  commands let you do quick scrolls around the physical sheet by resetting the
           upper left corner of the display sheet to point at any variable on the physical one  and  make  the
           rest  follow suit (OA), or will reset the display sheet starting at your current cursor location to
           point at the physical sheet variable and make all parts of the displayed sheet down and right  from
           your current location correspond likewise.  
          
                Thus, if you start with a normal initial display and execute the commands 
          
               L C1 
               OR H1 
          
           you  wind  up with columns A and B still on screen, but now the remaining columns are H, I, J, K, L
           instead of C, D, E, F, and G.  This happened because cell H1, down and right were pointed to by the
           display  sheet  starting where you were, which was cell C1, initially the 3rd column and first row.
           Had the command been OA H1, the column labels would be H-N rather than the initial A-G.  
          

          AnalytiCalc (PortaCalc) Reference Manual                                                     Page 29
          
          
          
                If  the  character D is appended to the commands (so they are ORD or OAD instead of OA or OR),
           the mappings are adjusted by adding the displacement from the current origin cell (upper left  cell
           on  screen  in  OAD  or cursor cell in ORD) to the new cell (the one in the command) to whatever is
           currently there.  The effect is to move an entire display-full of mapped windows to a new location,
           leaving  all relative mappings intact.  (Some pathological cases can occur where one moves parts of
           the windows into nonexistent areas.  Use an OR or OA command to correct these.) 
          
                To  see  the  difference, consider a virgin sheet.  If you first move the cursor to C1 and use
           the command "OR AA1" the screen will now show columns A, B, AA, AB, AC, and so on.  The  rows  will
           be  (still)  their  initial  1 to 20.  Now if you move to cell A10 and use the command OR A100, the
           lower half of the screen now contains columns A, B, C, D, E, and so on and rows 100, 101, 102,  and
           so on.  If you want to reset the mapping so that there are four regions on screen, you need to move
           to C100 and use an OR AA100 command to get the four regions desired (A1:B9, A100:B110, AA1:AE9, and
           AA100:AE110).   This is somewhat counter intuitive.  Therefore, if you use the command ORD A100 in-
           stead of the OR A100 above, the previous mapping of columns is retained, and you don't need to move
           to  the  middle  part  of  the  screen  to  reset  mappings  inside  as often.  This makes for much
           easier-to-understand windowing.  
          
          
          [?27l [17;1m        SAVING YOUR SPREADSHEET[22m
           [17;1m[22m
           [17;1m    PD        Put out current Display sheet (Formulas)[22m
           [17;1m    PPA       Put out current Physical sheet (Formulas and Nos.)[22m
           [17;1m    PDN       Put out current Display sheet (Numbers)[22m
           [17;1m    PPN       Put out current Physical sheet (Numbers)[22m
           [17;1m    PPF       Put our current Physical Sheet (Formulas only)[22m
           [17;1m    PxxM      Put out display to physical map as well as[22m
           [17;1m               worksheet information. Saves displayed mapping[22m
           [17;1m               only.[22m
           [17;1m    PxxMA     Put out display to physical map. Saves entire[22m
           [17;1m               mapping, whether within DB command bounds or[22m
           [17;1m               not.[22m
           [17;1m    S         Setup Global Items[22m
           [17;1m              (In workfile versions, Saves workfile and[22m
           [17;1m              allows you to use a new one.)[22m
          [?27h
          
                In  current  versions  of  AnalytiCalc, the S command will lead to questions being asked about
           whether to update the display mapping.  If you reply Y, you will be able to reset the default  dis-
           play column width to whatever you like between 1 and 120 characters and to say whether to reset the
           display sheet to point to the upper left of the physical spreadsheet.  In any case you will be able
           to  reset the default format and the spreadsheet title.  In AnalytiCalc-VM and AnalytiCalc-PC, this
           is all the S command does.  In the older AnalytiCalcs, global column width  is  not  resettable  in
           this way.  
          
                The  S command also allows you to reset the mapping used for cells out of the normal "physical
           sheet" range.  When you move to the right of the "prime area" storage (on VAX, generally this means
           columns  past  80 over and rows lower than 400), cells continue to be shown, but cells to the right
           of the right border of the "prime area" (i.e., the real storage available) are remapped to the left
           of  the  real  area  but down some number of rows.  Cells below the "prime area" are remapped to an
           area starting at the top of the "prime area" again, but right several columns.  You can select  how
           many  rows down or columns right successive groups of columns or rows are moved to here.  This must
           ONLY be done if there are NO active cells in  an  extended  region;   otherwise  you  mess  up  the

          AnalytiCalc (PortaCalc) Reference Manual                                                     Page 30
          
          
          
           mapping.   Also the mapping must be reset when using a sheet that was saved with a nonstandard map-
           ping for the computations to work normally.  The default values are 1/10 of the width  and  length,
           and  will  normally be adequate.  If you reply that you do NOT want to reset the extended area map-
           ping, the questions will not be asked that set it.  A negative number reply  sets  up  the  default
           mapping.   If you must alter the extended map while using extended cells, save the sheet, alter the
           map, and rerun AnalytiCalc and reload the saved sheet.  
          
                When  asked for a new title, a carriage return (or anything starting with 2 spaces) will leave
           the old title alone.  
          
                In  workfile  versions (i.e., old ones) the S command just returns to the start of Calc to let
           you select a new work file.  You may reselect the old one if you wish;  this lets  you  change  the
           title only.  Otherwise you can use the direct access file as primary saved info on a sheet.  The PP
           and PD commands (with the GP/GD commands described below) are intended to be the primary  means  of
           saving/restoring sheets, and allow more flexibility in saving, restoring, or mixing sheets than the
           S command.  Thus, the S command is intended as a highly temporary form of saving data,  and  should
           NOT be used as an archival means of storing a spread sheet.  
          
                The  PD  and  PP commands write Display or Physical sheet cells that are active to a specially
           formatted sequential ASCII text file, always starting from the current position of the  cursor  and
           saving  right  and  down.   Some questions will be asked so you may enter a maximum displacement to
           save (so not all of a large sheet need be saved) in columns and rows.  On reload  (the  GP/GD  com-
           mands),  these  questions  are also asked, and minimum displacements are asked also to allow you to
           enter basically any region of the saved sheets into the current sheet starting at the current loca-
           tion  and  moving down and right.  This gives a large scale move capability and a sheet merge capa-
           bility.  
          
                The PPN and PDN commands save numbers instead of formats to permit loading of isolated numeric
           values from other sheets by using the GD or GP commands (below).  They record only numbers and  not
           formulas,  but  this  allows  any  cell's numeric value from other sheets to be loaded into another
           sheet without loading all formulas and repeating calculations.   Also,  the  PPN/PDN  commands  are
           needed to use the PCGRAF program to graph parts of a sheet if this form of output is desired.  
          
                The  PP/PD  commands  are suitable for archival storage of spread sheet data, or for its tran-
           sportation to differently compiled versions of AnalytiCalc.  
          
                The "extended area" mapping available on the PortaCalc-PC version of the program allows one to
           use the storage on the sheet as a very wide but shallow, or long but narrow, sheet.   Real  storage
           is  not altered, but extended addresses are given aliases on the real sheet.  The wide-storage case
           can look something like this:  

          AnalytiCalc (PortaCalc) Reference Manual                                                     Page 31
          [?27l
          
          
           
               AAAAAAAABBBBBBBBCCCCCCCC........
               BBBBBBBB
               CCCCCCCC
               ........
           
          [?27h
           where  the  AAAAAAAA  section may represent the first 80 columns and 20 rows, the BBBBBBBB section,
           the second 80 columns and the CCCCCCCC section the third 80 columns across.  The  BBBBBBBB  section
           will  appear  to  be  just columns 81-160 in rows 1 to 20 as it is used.  However, it actually uses
           storage in columns 1 to 80 and rows 21-40 (if we have the row increment set to  20).   The  section
           shown  as  CCCCCCCC  is similar but would be mapped to rows 41-60, and so on.  Rows below the sheet
           are treated in a similar way.  That is, rows 401-800 in columns A through L might actually use rows
           1-400  in  columns  M through X in the physical storage.  If you use addresses in the middle of the
           range, they will be mapped somewhere on the physical storage, but it's harder to follow the  remap-
           ping unless only very wide or very long sheets are being used, the other dimension being correspon-
           dingly short.  
          
                It is fairly simple to increase the storage possible in the real sheet, but this has been left
           undone because an attempt to make a spreadsheet that really  will  try  to  calculate  hundreds  of
           thousands  of  cells  will  page fault itself to death and harm system performance unduly.  Several
           commercially sold VAX or PDP11 spreadsheets have this problem already,  and  AnalytiCalc  will  not
           join  them.   The  program's working set is always reasonable now.  If the amount of storage is too
           small, you probably need a different kind of tool, and should investigate writing a program  to  do
           the  calculations  you  need in a compiled language, rather than trying to pound it through a giant
           interpreter like this one.  You should also see if the ability to handle several equations per cell
           and  do  matrix math can help.  Computing the sum of the products of two columns can be represented
           as the product of one matrix with the transpose of another, for example.  This calculation  is  far
           faster  than  wasting  another  column for the individual products and then summing them somewhere.
           The system performance and the time you save may be your own.  
          
          
          
           [17;1m           RECALCULATE[22m
           [17;1m       R    Recalculate all of the sheet.[22m
           [17;1m       RE   Recalculate Entries as made but nothing else until[22m
           [17;1m              R command given.[22m
           [17;1m       RI   Recalculate Incremental - Calculate displayed cells only.[22m
           [17;1m       RM   Recalculate manually only until R command given[22m
           [17;1m       RAF  Recalculate sheet, without constant recalculation (same as R)[22m
           [17;1m       RF   Recalculate, Force constant recalculation.[22m
           [17;1m       RR   Recalculate, Force, but stay in RE or RI mode if in[22m
           [17;1m              it already.[22m
          
          
                The  R  command  forces  a recalculation of the sheet.  This will evaluate all formulas on the
           sheet and update the display to show the new numbers.  Normally, recalculation is done  after  each
           number is entered to update the new cell, but the R command forces total recalculation in case any-
           thing was missed.  Use the raf command for most recalculations to avoid the extra time used  by  R.
           The standard keypad's Recalculate key generates the RAF command automatically for ease of use.  
          

          AnalytiCalc (PortaCalc) Reference Manual                                                     Page 32
          
          
          
                Since these calculations can be time-consuming, you can suppress them while doing input by en-
           tering the RM command (Recalculate Manually) which suppresses recalculation until an R  command  is
           entered.  This command's format is just 
          
           RM 
          
          
                To  speed normal recalculation, AnalytiCalc only computes constants once.  In PCC-VM only, the
           normal R command will force them to be recomputed also.  This may be suppressed (for speed) by  the
           command  RAF.   (Actually  the second character may be anything except M.) In all other AnalytiCalc
           dialects the R command does not recompute constants but the  RF  command  does  force  them  to  be
           re-evaluated also.  
          
                For  further  speedups,  AnalytiCalc can be put into RE or RI mode to recompute only the cells
           just entered after each entry, or to compute cells on the display only.  It starts in RI  (Recalcu-
           late Incremental) mode until an R command is given.  After an R or RF command is given, AnalytiCalc
           goes into a mode where it will compute ALL cells that have anything in them at each sheet  recompu-
           tation.   Another RI or RE command will return to the previous mode.  The RR command does a RF (Re-
           calculate, Force constant recomputation) but stays in Incremental or Entry mode.   Whenever  a  new
           sheet is loaded, a single R is done automatically regardless of the current mode.  
          
                In  R,  RE,  and  RF  modes,  AnalytiCalc computes all cells in across, then down mode (like a
           television raster scan).  This corresponds to storage order to give best performance in  a  virtual
           memory  system.  In RI mode, AnalytiCalc computes by going across, then down, the DISPLAY cells, so
           physical access can be in non-optimal order.  However, the speedup is generally well  worth  while.
           Therefore,  RI  mode is the default.  Note that when a sheet is loaded a full recalculation is per-
           formed initially even in RI mode, however.  Also, RE mode is effective only in the "prime area"  of
           the sheet (upper left part) for speed reasons.  
          
                Notice that these Recalculate commands both perform recalculations and set modes of recalcula-
           tion.  If the third character of the command is I (e.g., RII  in  Recalc  Incremental,  or  RXI  in
           normal recalc mode), only the modes will be set.  An extra recalculation will not occur as a result
           of an RxI command (where x is any letter).  This feature can be used where it has been necessary to
           recompute  the  entire  sheet, possibly via an R command, and it is desired to return to the normal
           Recalculate Incremental mode.  The RI command will recompute the display, causing  a  short  delay.
           The  RII command, on the other hand, will simply reset the mode to Incremental and complete at once
           so that subsequent recalculations will be affected.  
          
                The RE mode applies only in the prime (i.e., upper left) part of the sheet.  In extended areas
           (normally, those outside the range A1:CA400), it fails and R mode or RI mode should be used.   This
           is done because supporting this mode globally would impose a large speed penalty.  If a large sheet
           is used and your display is entirely in the prime part of the sheet, you can re-enter  RE  mode  by
           giving the RE command any time your display points entirely inside the prime (upper left) region of
           the sheet.  
          
          

          AnalytiCalc (PortaCalc) Reference Manual                                                     Page 33
          
          
          
          [?27l [17;1m     RELOCATE BOUNDARY[22m
           [17;1m[22m
           [17;1m        RB*     Set maximum row and col for relocation[22m
           [17;1m                to end of sheet[22m
           [17;1m        RB Var  Set maximum row and col to be relocated[22m
           [17;1m                to coords of Var (cell name)[22m
          [?27h
          
                The  RB  command affords a way to specify a lower right corner to the area relocated by any of
           the copy and relocate operations.  This allows the AR operation to relocate only a  finite  maximum
           number  of rows or columns, or permits cells moved beyond the boundary specified to be unrelocated.
           The upper left corner of the relocation area is defined by the cursor position, so this permits any
           rectangular  area  to be moved without relocation while the rest is relocated.  Combination of this
           feature with the AR and CR commands permits moving rows or columns (or parts of them)  via  command
           files.   For  example,  a rectangle could be moved away from the origin further by using the cursor
           and the RB command to delimit the area to move, then using a command file to cycle through a set of
           CR commands to copy all cells down the desired amount.  The AA command could then be used to delete
           the undesired top cells and the area to be moved now moved into its new address,  all  other  cells
           having  been  relocated.   The  functionality  of  moving  cells  is  however much better served on
           AnalytiCalc by the OA, OR, and DL commands to reset the display  mapping  (possibly  while  logging
           keystrokes  so the mapping can be easily reproduced) to effect the desired move.  For simply refor-
           matting the screen, DL affords control at the level of any regions desired.  A command file  should
           be  devised for moving cells but only used when really needed badly, if such actions are needed for
           other reasons.  There will be very little need for them under most  circumstances  however.   Where
           cells  must move closer to the origin, an AR command at the origin can be used to provide temporary
           space in which to move the cells;  at the end, they will be moved back  further.   The  IR  command
           (Inplace  Relocate)  can be used to avoid major moving around the sheet.  The *U HERE function will
           return the current max column in accumulator W and the current max row in accumulator Y to  facili-
           tate this.  
          
          
          [?27l [17;1m      TEST EVALUATE[22m
           [17;1m[22m
           [17;1m     TE expression    Evaluate expression, save in %[22m
           [17;1m[22m
          [?27h
          
                The  TEst  command allows command level calculations, for use in controlling loops.  It evalu-
           ates the expression (up to 79 characters long) and stores in the % accumulator.  Useful for *J type
           commands  to  control branching in AnalytiCalc.  Any expression may be handled in a TE command, and
           forms of the sort Z=expression are allowed.  NOTE however that it is frequently desirable from com-
           mand  files  to  add a C to the end of the formula since sometimes junk from preceding lines is not
           zeroed.  The C causes it to be treated as a comment and ignored.  
          
                The  TEst  command will calculate formulas even in restricted recalculation modes (RM mode, RE
           mode, or RI mode) since it ALWAYS evaluates the expression regardless of mode.   The  construct  to
           evaluate a cell with a command like 
          
                TE V1=__{V1 
          
           (which  sets a cell value to the computed value of its formula) is explicitly legal and can be used
           where it is desired to perform irregular partial recomputations while in RM mode.  

          AnalytiCalc (PortaCalc) Reference Manual                                                     Page 34
          
          
          
          
          
          [?27l [17;1m        VIEWSCREEN UPDATE[22m
           [17;1m[22m
           [17;1m     V           Redraw screen with normal formats[22m
           [17;1m     VF          Redraw screen showing all formulas[22m
           [17;1m     VM          Don't redraw screen until a V or VF is[22m
           [17;1m                         given.[22m
          
          [?27h
          
                The  V  and VF commands redraw the display screen showing numerics as numerics in the selected
           format (V) or displaying whatever part of the formulas fits on screen in the column (VF).  This  is
           used  wherever  the  picture on the screen is damaged, e.g., by operating system broadcasts.  VM is
           used to inhibit redraw while numerous changes may be made, to save time.  A V or VF command will re
           enable display updates.  
          
          
          [?27l [17;1m        WRITING SCREEN TO HARDCOPY OR FILES[22m
           [17;1m[22m
           [17;1m        W     Write screen to file[22m
          [?27h
          
                The  W  command  lets  you  write a hard copy of the screen as it exists on display to a file.
           AnalytiCalc will prompt you for the file name;  the device specifier should be included.  
          
                Note that if the filename you enter (or the last character after the device or file specifier)
           is a "/" character, AnalytiCalc will omit the column and row labels in the output file or  printout
           so  that  you  need  not  edit  them  out  afterwards.  They will always be displayed on the screen
           however.  
          
                To output to the lineprinter on PDP11, the file specifiers to give are either "LP:" or "LP:/",
           then.  The device name normally should be given on PDP11.  On other systems (e.g., VAX), the device
           will default to disk unless otherwise specified.  The output file in any case has no strange escape
           sequences and may be edited with any normal system editor.  On VAX, use LPA0:  for printer or NLA0:
           for  junking anyxoutput you really don't want.  If the character "%" appears in the file specifier,
           the title  will  not  be  displayed  on  printout.   This  is  designed  to  help  those  producing
           paste-together printouts from several sheet areas.  
          
                The  width  and  length of the file output may be considerably larger than a VTxxx screen.  In
           fact, print widths are supported on VAX to 512 characters (normally up to 63 columns) and pages may
           be  up  to 75 rows long.  Just set the size with the DB command to set numbers of columns and rows,
           and use DW commands to set the  widths  desired  of  displayed  columns.   While  only  80  or  132
           characters  width  and  20 rows length fit on a VTxxx screen, the size you set will be used for the
           printable file.  It's up to you to figure out how to display a wide file if your  lineprinter  only
           has  132  columns of course.  Other display page editing commands like OR or OA will work up to the
           bounds set by DB even if these exceed a physical screen's capacity.  
          
          

          AnalytiCalc (PortaCalc) Reference Manual                                                     Page 35
          
          
          
          [?27l
           [17;1m        EXIT[22m
           [17;1m[22m
           [17;1m  X           Exit to operating system.[22m
          [?27h
          
          
                The  X  command  exits from AnalytiCalc to the operating system.  In general, this is the ONLY
           way (short of an abort command to the operating system) to get out of AnalytiCalc, and is the  ONLY
           WAY  TO LEAVE GRACEFULLY.  You should use the PP or PD command to save your sheet prior to X if you
           want to save your sheet;  otherwise it will be lost.  Be at least that cautious;  the program  will
           NOT  keep track of whether you've saved the sheet or not (this may be the umpteenth time you've run
           it since creating that scratch file).  
          
                The files created by PP/PD commands save the sheet, but only entries that were in use.  The XD
           and  X commands are identical in the VM and PC versions of AnalytiCalc since there is never a work-
           file created that can be saved or deleted.   The  scratch  files  for  formulas  and  variables  in
           AnalytiCalc-PC are created as temporaries and automatically deleted on exit.  The XD command exists
           in older versions of AnalytiCalc and deletes the random access  workfile  they  use  for  formulas,
           which is saved by the S (Save) command in those old versions.  
          
          
          [?27l [17;1m        ZERO VARIABLES[22m
           [17;1m[22m
           [17;1m   ZA           Zero whole sheet[22m
           [17;1m   ZE V1:V2     Zero variables in a row or column[22m
           [17;1m                in range from cell V1 to cell V2[22m
           [17;1m                (V1,V2 = names of cells)[22m
          [?27h
          
          
                The  ZEro commands clear out a sheet.  The ZA command will also ask if you mean it and needs a
           reply of Yes to actually clobber the whole sheet and return it to pristine purity.  
          
                The  ZA  command  occasionally  takes  a noticeable time to clear the workfile out;  do not be
           alarmed at this.  It will ask afterwards for a new title, new display format default  for  floating
           point, etc.  
          
                If  you  give the ZA command, AnalytiCalc will ask you to confirm that you indeed want to zero
           the entire sheet.  A reply of Y will proceed to execute the command;  any other  reply  will  abort
           the clearing operation.  
          
          

          AnalytiCalc (PortaCalc) Reference Manual                                                     Page 36
          
          
          
          [?27l [17;1m     EXECUTING COMMAND FILES[22m
           [17;1m[22m
           [17;1m   @filespec    Read filespec and execute commands[22m
           [17;1m                as though typed in.[22m
          [?27h
           The  @  command  lets you treat a file as though it were your console input (returns on endfile) to
           let you execute saved sets of commands to set up your sheets.  Note that if you issue the K command
           (below),  those  inputs  come  from  a  separate file on logical unit 1.  As a special VAX feature,
           PortaCalc-VM will accept a reply beginning with @ in the title question of the first  page  of  the
           sheet  as indicating a command and begin using that command directly until it reaches EOF.  This is
           done to permit auto-startup commands for particular users to be defined.  
          
          
          [?27l [17;1m        JOURNALING[22m
           [17;1m[22m
           [17;1m  +J filename   Opens filename as a journal file,[22m
           [17;1m                recording commands to that file.[22m
           [17;1m                (Note: auxiliary inputs are not so[22m
           [17;1m                recorded, where asked for as separate[22m
           [17;1m                questions.)[22m
           [17;1m  +N            Closes any open journal file[22m
          [?27h
          
          
                The  journaling  commands  allow typed commands to be saved into a file later usable as an in-
           direct command input to AnalytiCalc to allow recreation of screen  formats,  data,  formulas,  etc.
           Extra  questions  (e.g.   those used for filename and areas to save or restore in P or G class com-
           mands) are NOT saved by the journal.  They will be read by @ commands however  and  may  be  edited
           into  a  journal  file with any editor.  If this is desired inside a AnalytiCalc session, the Spawn
           command (below) is recommended after the +N command is used to close the file.  The VM and RM  com-
           mands  are recommended inside @ files (with R and V commands at the ends) to suspend display updat-
           ing and recalculation until all commands in the journal file are done.  The Journal command is  the
           way  to get AnalytiCalc to remember your keystrokes when making up any command so that you can tell
           what you're doing.  Later if you don't need to watch the screen update, use the  VM  command  (View
           Manual) to turn display update off during the command files' operation, and the V (View) command to
           turn it back on at the end.  
          
          

          AnalytiCalc (PortaCalc) Reference Manual                                                     Page 37
          
          
          
                                  SPAWN EXEC COMMANDS
          [?27l [17;1m       $ command-line     Spawn command line to the OS[22m
           [17;1m                            (minus the $ sign). May[22m
           [17;1m                            need extra CR to free[22m
           [17;1m                            console.[22m
           [17;1m       } command-line    Spawn command line (minus the })[22m
           [17;1m                            and await a return on console[22m
           [17;1m                            before return to sheet.[22m
          [?27h
          
                The  $  command  permits the VAX/VMS version of AnalytiCalc to spawn DCL commands to VMS.  The
           command is whatever follows the $ and results in that command being spawned  to  VMS.   (Users  may
           find  an  extra  CR (Return key) is needed to allow terminal output).  The command is executed in a
           VMS subprocess, and upon completion, the screen is redrawn.  This permits use of other  VMS  utili-
           ties  during a session with AnalytiCalc.  This also is implemented for AnalytiCalc-PC for the PDP11
           using the RSX Spawn command.  The variant using the } character rather than the  $  character  will
           print  the  message  ENTER  RETURN  TO REDRAW SPREADSHEET> at the bottom of the screen and will not
           repaint the screen until the return key is pressed.  This allows you to examine the screen as  long
           as needed before erasing and redrawing the sheet.  
          
          
          [?27l [17;1m    SEARCH for formula substring[22m
           [17;1m[22m
           [17;1m    >STRING      Find cell whose formula contains STRING[22m
           [17;1m    >>STRING     Find cell whose formula starts with[22m
           [17;1m                    STRING[22m
          [?27h
          
          
                The  >  command  (greater than sign) causes a search to be made from the current position down
           and right to the relocate boundary for a formula containing the string after the >.  The cell found
           (the first one) will become the current cell.  The origin is not moved, but the command OA P## will
           cause the cell found to become the upper left cell on the screen if desired.  This is a handy  tool
           for  locating sections of a large sheet.  The comparison is between the entered string and the for-
           mula, but terminates with the shorter.  Therefore, aliasing occasionally occurs.   Just  skip  past
           the  offending  cell  and  redo to continue to search.  The >>STRING form anchors the search at the
           start of the string so this will not occur, though very short formulas whose beginnings  match  the
           search string will match.  
          
          

          AnalytiCalc (PortaCalc) Reference Manual                                                     Page 38
          
          
          
          [?27l [17;1m        LOOPING COMMAND FILES[22m
           [17;1m[22m
           [17;1m     <        Rewind the current AnalytiCalc input file[22m
          [?27h
          
          
                This  command will allow a command file to restart itself from the beginning.  It does so only
           if the % variable is positive (permitting some control over it).  
          
                In the PortaCalc-PC version for VAX, an < found in a cell equation causes the cell equation to
           be re-evaluated from the start of the formula, PROVIDED that the "<" is seen at the start of one of
           the  cell's  equations,  AND  that  the  %  accumulator  is greater than 0.0 at that time.  This is
           provided to allow use in conjunction with *WF, *P, and *U XQTCM so that multi-equation formulas can
           loop,  doing  jobs  like  selecting rows from regions, entering sequences of numbers, and the like.
           This provides a compact and fast looping structure that does not depend on rewinding  files  exter-
           nally.  The looping is limited to at most 100 passes to prevent infinite loops.  
          
          
          [?27l [17;1m        COMMENTS[22m
           [17;1m[22m
           [17;1m        * any text[22m
          [?27h
          
                Any  line  beginning with * is treated by AnalytiCalc as a comment (except when in the *F mode
           when it is sought).  This allows you to comment your indirect AnalytiCalc command files.  It should
           be  mentioned  again  that  in  the  "Enter-Mostly"  mode of operation, inputs beginning with the *
           character are treated as comments.  Where it is desired to enter an equation that begins with * (as
           in  function-commands  like  *U  DBTRMFRM  ...), use the command string "/EV formula" to ensure the
           input is interpreted as an equation.  In "Command-Mostly" mode this is not a problem.  
          
          
                   READING ARGUMENTS OFF CONSOLE
           
                   - Prompt
          
                The  "-"  command  will print the prompt text on the screen and await entry of a line of text.
           This text is stored as up to 4 arguments for possible later use in EDit commands.  Spaces  separate
           input  arguments,  and no argument may be longer than 51 characters.  This facility is intended for
           use with indirect command files (@ files) which may want to be able to prompt for parts of formulas
           and  then  edit  them  into the command formulas for use, or to prompt for parts of later-used Calc
           commands.  Note that Calc never sees any formulas that are given the A format, so they can be  pre-
           pared in this way, to be used when they are given a numeric format.  
                A suitable - command might be 
          
           -Enter net pay> 
                which would produce the printout (in row 23 of the screen) 
           Enter net pay> 
                and to which one might reply with a number to be entered onto a "template" worksheet.  
          

          AnalytiCalc (PortaCalc) Reference Manual                                                     Page 39
          
          
          
                NOTE:   This is a somewhat obsolete construct;  in general the %%% construct is easier to use.
           It is recommended to use it instead since no subsequent EDit commands  need  be  used  to  get  the
           values into formulas again.  
          
          
          
                                        APPLICATION NOTES 
          
          
                In  entering  numbers,  use  a decimal (.) to get them to go in correctly.  The parser doesn't
           seem to understand they are numeric otherwise (even integers).  
          
                Note that the default format for numeric output is F9.2 and that it may be changed if desired.
           If you set up the format of a cell, that marks the cell valid and the  format  is  not  altered  by
           input  defaults, nor the numeric/text interpretation of the cell.  To put in a lot of labels, then,
           set up format A using DF and then enter the labels.  
          
                If  the  sheet's calculations contain forward references (down or right), you may need to give
           the R (Recalculate) command a few times to get proper values.  If the values on the  sheet  do  not
           stabilize,  you  probably  have  a circular reference in your formulas and should examine the cells
           that do not stabilize for the circularity.  
          
                If you enter numbers with exponentials, use +/- in front of the E so that AnalytiCalc can tell
           that the "E4" type strings in numbers like "1.3E4" are really exponents, not cell names.  That is, 
                Don't enter 
                   1.35E4 
                Enter 
                   1.35E+4 
           to avoid confusion when cells are relocated.  You may use lowercase E also (1.35e4) to avoid confu-
           sion in some versions.  Because the cell relocation logic is somewhat stupid, filenames  that  look
           like cell names should be avoided too.  That is, a sheet that contains a formula like 
           @D5.FRM 
           might, upon getting moved from D5 to F3, be changed to 
           @F3.FRM 
           and if this is not what is desired, it could cause confusion.  
          
                When  using  relative cell names (the P#col#row forms) in formulas, you will often need to en-
           close them in parentheses to ensure correct evaluation.  Thus, use a formula like 
           (P#4#2)+3.4 
          
           rather than simply "P#4#2+3.4".  
          
                Inside multi argument functions an extra space should be used sometimes ahead of a range using
           P## or D## forms.   Thus,  "SUM[P#3#0:P#7#0]"  will  sometimes  fail  to  evaluate  correctly,  but
           "SUM[ P#3#0:P#7#0]"  will  work as expected.  These considerations apply to all naming types begin-
           ning in P# or D# as well.  They arise from details of the parsing of these name forms.  
          
                AnalytiCalc  normally  will  keep track of the lowest and furthest right cells in use and only
           ever try to recompute cells that have active values there.  This may occasionally be invalid  where
           command  files  modify cell values and formulas in ways that are not caught (if there are any such;
           none have been encountered but they may exist).  If problems are suspected,  the  command  RS  (for
           ReSet)  will  cause  recalculation  to go to the limits of the sheet.  There is no command to bring

          AnalytiCalc (PortaCalc) Reference Manual                                                     Page 40
          
          
          
           back the old default since RS sets the maximum cell to be the last row and last column;   save  and
           rerun if this is a problem.  Do not use this command in normal operation.  
          
                                      THE CALC OPTION (K) and Functions Available:
          
                This  describes  the CALC option (K) of AnalytiCalc which is also the mathematical engine used
           for expression evaluation except for multi-argument functions and IF statements.  

                                               OVERVIEW 
          
                CALC  is a calculator designed to evaluate arithmetic expressions.  In its basic form, expres-
           sion evaluation is similar to that used by ANSI FORTRAN with calculations  performed  on  INTEGER*4
           and  REAL*8  constants.   Variables  may  also  be  invoked  but  are  limited to single alphabetic
           characters.  It is assumed that the reader is familiar with FORTRAN data types, constants,  expres-
           sion  syntax,  operator  precedence,  and the syntax for assigning values to variables.  Additional
           features include octal, hexadecimal, and multiple precision arithmetic capabilities.  Commonly used
           commands and expressions can be placed in a file and executed when convenient.  
          
                                                ENTERING 
          
                To enter Calc, use the K command of AnalytiCalc.  Calc will then prompt as follows:  
          
                  CALC> 
          
           Try typing 
          
                  123+456 
          
           followed by a carriage return.  CALC will evaluate the expression and output the answer 
                  579 
          
           It then prompts for further input.  Try other expressions such as 
          [?27l     12.0 - 99.               (answer=-87.00000000000000)
               -(-32767+(6-2)**8-(512/(409-401)))   (answer=-32705)
               3*5/7                                     (answer=2)
               3*(5/7)                                   (answer=0)
          [?27h
                Mixed mode is legal, for example 
          
                  1977/50.  is evaluated as 39.54000000000000 
          
           Reals may be expressed using D or E format.  For example 
          
                  1.2E10*2.D0**3-1.D-8 is evaluated as 
          
                  0.95999999999999992D+11 

                                            ACCUMULATORS 
          
                Variables  may  also  be  used to retain values for later use.  Variables may be the letters A
           through Z, or any AnalytiCalc physical sheet cell name.  As in FORTRAN, variable A through H and  O
           thru  Z  default to type real, I thru N to type integer.  To set I to a value use the usual FORTRAN
           syntax, for example:  
          

          AnalytiCalc (PortaCalc) Reference Manual                                                     Page 41
          
          
          
                  I=2**10-1 
          
           Try  typing the single character 'I'.  CALC will respond with its value.  We can now use I in vari-
           ous expressions such as 
          
                  J=I-I/3*3 
          
                % is a special variable that retains the value of the last expression evaluated.  For example,
           to successively add up the numbers 1, 2, 3, 4, 5, and 6 we could enter 
           
                 1
                 %+2
                 %+3
                 %+4
                 %+5
                 %+6
          
                Note  that  you  can  examine  the  value  of  the  variables by typing the appropriate single
           character followed by a carriage return.  Such an examination does not change the value of %.  
          
                                         EXITING 
          
                To exit from CALC, type 
          
                  *E (or *EXIT) 
               or *S (or *STOP) 
          
           This will return you to AnalytiCalc.  (To exit AnalytiCalc, use the X command.) 

                                                   -SPECIAL FUNCTIONS-
          
                CALC  recognizes a variety of special functions.  For example, to calculate the square root of
           2, we can type 
          
                  SQRT(2.) 
          
           CALC responds with the value 1.41421356237310 
          
                Each function may have an expression for its argument.  For example, 
          
                A=2.0*SQRT(ALOG(9.)+3.) 
          
           sets A to 4.55948443459838 
          
                The following special functions are available:  
          
          [?27l
           [17;1m FUNCT NAME   ARG TYPE    FUNCT VALUE   DESCRIPTION[22m
           [17;1m -------------------------------------------------------[22m
           [17;1m ABS          REAL        REAL         absolute value[22m
           [17;1m DABS         REAL        REAL         absolute value[22m
           [17;1m IABS         INTEGER     INTEGER      absolute value[22m
           [17;1m IFIX         REAL        INTEGER      REAL to INT conv.[22m
           [17;1m AINT         REAL        REAL         REAL truncation[22m[?27h

          AnalytiCalc (PortaCalc) Reference Manual                                                     Page 42
          [?27l
          
          
           [17;1m INT          REAL        INTEGER      REAL to INT conv.[22m
           [17;1m IDINT        REAL        INTEGER      REAL to INT conv.[22m
           [17;1m EXP          REAL        REAL         e**X[22m
           [17;1m DEXP         REAL        REAL         e**X[22m
           [17;1m ALOG         REAL        REAL         natural logarithm[22m
           [17;1m DLOG         REAL        REAL         natural logarithm[22m
           [17;1m ALOG10       REAL        REAL         logarithm base 10[22m
           [17;1m DLOG10       REAL        REAL         logarithm base 10[22m
           [17;1m SQRT         REAL        REAL         square root[22m
           [17;1m DSQRT        REAL        REAL         square root[22m
           [17;1m SIN          REAL        REAL         trigonometric sine[22m
           [17;1m DSIN         REAL        REAL         trigonometric sine[22m
           [17;1m COS          REAL        REAL         trig. cosine[22m
           [17;1m DCOS         REAL        REAL         trig. cosine[22m
           [17;1m TANH         REAL        REAL         hyperbolic tangent[22m
           [17;1m DTANH        REAL        REAL         hyperbolic tangent[22m
           [17;1m ATAN         REAL        REAL         arc tangent[22m
           [17;1m DATAN        REAL        REAL         arc tangent[22m
          [?27h
          
                                           -WORKING IN OCTAL AND HEXADECIMAL-
          
                You may change the base used to specify constants by using the *B command.  Legal forms are 
          [?27l
                command              action
                -------              ------
                  *B             displays current default base
                  *B 8           changes default base to octal
                  *B 10          changes default base to 10
                  *B 16          changes default base to 16
          [?27h
                Suppose we have changed the default base to octal.  Then adding 
          
                  7 + 1 
          
           we obtain the result 
          
                  00000000010 (BASE 8) 
          
           If the default base is hexadecimal, we can enter 
          
                  9 + 1 
          
           which is evaluated as 
          
                  0000000A (BASE 16) 
          
           Suppose we have assigned 
                  A=1 
           then 
                  1+A 
           gives 
                  2.000000000000000 

          AnalytiCalc (PortaCalc) Reference Manual                                                     Page 43
          
          
          
          
           even when the default base is 16.  If we wish to add the hexadecimal digit 'A' to 1, enter 
          
                  1+0A 
          
           We now obtain the desired 
          
                  0000000B (BASE 16) 
          
                This leading 0 is only necessary when the first hexadecimal digit is greater than 9.  
          
                If  constants  are  entered with digits that are not legal for the base being used, the entire
           number is converted using a more appropriate base.  For example, if we have set the default base to
           octal and type 
                  1+9 
          
                the  9 is not an octal number so it is converted to base 10.  If a base 16 number is involved,
           the result will be in base 16.  
          
                You may temporarily change the base for a single integer constant by preceeding it with 
          
                  ^8 for octal 
                  ^10 for base 10 
                  ^16 for base 16 
          
           For example, if the default base is 10, 
                  100+^840 
           gives 
                  132 
          
           a base 10 integer.  
          
                  I=100+^1610 
          
           gives 
                  116 
          
           also a base 10 integer.  
          
                Note  that the '^' can only be used to specify the base of constants and that expressions such
           as ^16I are illegal.  
          
                To declare variables to be integers of a specific base, we can use the commands 
          [?27l    *INTEGER        (base 10)
              *OCTAL          (base 8)
              *HEX            (base 16)
           for example, 
              *INTEGER A     declares variable A to be a
                             base 10 integer.
              *HEX B,Z,F     declares variables B, Z, and
                             F to be base 16 integers.
              *DECIMAL       lists all the variables that
                             have been declared to be
                             of type DECIMAL.[?27h

          AnalytiCalc (PortaCalc) Reference Manual                                                     Page 44
          
          
          
          
          
                To  summarize, there are three distinct ways of making base declarations when using CALC.  The
           first is to use the *B command to designate the base default value.  This is used to determine  the
           base  for  constants  when they occur in expressions.  It does not in any way influence the type of
           any variables found in an expression.  The only way to change the type of  a  variable  is  with  a
           specific CALC command such as 
                  *INTEGER A,B 
          
                Note  that  the *INTEGER command can be used to set types for AnalytiCalc cells.  However, ex-
           ercise care in doing so that your display formats match the new type.  
           Suppose for example that the default base is 10 and we enter 
                  *OCTAL A 
                  A=100 
          
           then CALC responds with 
                  00000000144 (BASE 8) 
          
                Finally,  the last way to change a base is to use the explicit base specifiers for a constant,
           for example 
          
                ^10 123 
                ^8 777 
                ^16 AB 

                                                  -MULTIPLE PRECISION-
          
                Normally  integer arithmetic (base 8, 10, and 16) is done internally with INTEGER*4 variables.
           To allow for larger numbers, CALC has multiple precision capabilities that allow numbers up  to  99
           digits  (20  in AnalytiCalc-PC) to be manipulated.  Constants are converted to a multiple precision
           data type when the number of digits specified exceeds a certain value.  This value depends upon the
           specified base.  Leading zeroes are included in this count and can be used to force constants to be
           of type multiple precision.  
          
               base     max. number of digits before conversion
               ----     ---------------------------------------
                 8               10
                10                9
                16                7
          
                Suppose we type (with the default base of 10) the number 
                  1234567890 
           then CALC echoes with 
                  1,234,567,890 
                  (BASE 10) 
          
           The commas indicate that % now has type multiple precision base 10.  Similarly, typing 
                  1234ABCD 
          
           results in 
          
                  1234,ABCD 
                  (BASE 16) 
          

          AnalytiCalc (PortaCalc) Reference Manual                                                     Page 45
          
          
          
           Notice  that  base  16 multiple precision numbers are separated by commas every 4 digits, octal and
           base 10 numbers every 3 digits.  
          
                You may perform the usual operations of addition, subtraction, multipli- cation, division, and
           exponentiation.  As of version 1.0, exponentiation of a multiple precision number may only be to  a
           non-negative integral power.  To declare variables of type multiple precision, use 
          [?27l 
                    *M8        (multiple precision base 8)
                    *M10       (multiple precision base 10)
                    *M16       (multiple precision base 16)
          [?27h
           for example, 
                  *M8 A,B     declares A and B to be multiple precision 
                         octal variables.  
          
           Then typing 
                  A=32768 
          
           results in CALC responding with 
          
                  100,000 
                  (BASE 8) 
          
                The  accumulators  in  Calc  (variables  A-Z  and %) all may take on or use multiple precision
           values.  However, the spreadsheet cells may not;  they must fit in 8 bytes (double precision  real)
           or  4  bytes  if  integer.  Accumulators may however be used globally in a sheet for large numbers.
           Note however that certain accumulators have special purposes.  Accumulator Z is used in  some  sub-
           stitution  commands.   Accumulators  X  and  Y  get current cell locations at each command (column,
           row+1).  Accumulators T, U, and V are used to return year, month, and day in the *U IDATE function.
           Also  the  %  accumulator  is the value cell for all operations and should not be treated globally.
           Other accumulators may have meanings for user modifications of the program as well, though by  con-
           vention the early ones should be left alone.  
          
                                                  -ADDITIONAL COMMANDS-
          
                All  commands  to  CALC  (as  distinguished  from  expressions  to be evaluated) begin with an
           asterisk.  To obtain a list of all possible commands, type a question mark followed by  a  carriage
           return.  Most of the commands have already been described.  The following section gives an explana-
           tion of the remaining commands.  (Some additional ones are described in the AnalytiCalc manual.) 

          AnalytiCalc (PortaCalc) Reference Manual                                                     Page 46
          
          
          
               COMMAND            DESCRIPTION
               -------            -----------
            *@filename     Where filename is the name of a file of CALC commands.  CALC reads the file and ex-
                         ecutes the commands.  Up to 5 nested calls can be made.  Recursive calls are not  al-
                         lowed.   CALC  prompts  with CALC<n> before each command line is executed, where n is
                         the calling level.  You may optionally follow the file name with a blank followed  by
                         a  single variable name (a single alphabetic character or %).  CALC will then execute
                         the file until the value of that variable is zero or  negative.   The  test  of  this
                         variable  is  made  before  the file is executed and not during execution of commands
                         within the file.  If the variable's value is not positive when the  command  is  ini-
                         tially  encountered,  the  file will not be opened for execution.  See the section on
                         command file examples for ways to use this option.  
            *ASCII      Declares  a  list  of  variables  to  be  of  type  ASCII.  Useful when decoding ASCII
                         characters.  For example, if we set A to be of type ASCII, then typing  A=77  results
                         in  the  character  'M' being output.  The inverse operation is the single quote.  It
                         allows us to specify a single ASCII constant.  For example, if we type 
                         'M 
                         then  the  character  'M' is echoed and indicates that % holds that character and has
                         data type ASCII.  Suppose that the variable I has data type  INTEGER.   Then  we  can
                         output the base 10 code for the ASCII character 'M' by entering 
                         I='M 
                         which  results  in 77 being output.  Notice that you may not be able to enter certain
                         control characters that are intercepted by your operating system.   Characters  whose
                         value  is  less  than  32.   are output by printing the character '^' followed by the
                         equivalent ASCII character of that number plus 32.  For example, 
                         A=10 
                         results in 
                         ^* 
                         being  output since 42 is the ASCII code for the character '*'.  See Appendix A for a
                         table of the characters output by CALC to represent such non-printable characters.  
            *C      COMMENT  line.   The  characters that follow are ignored by CALC.  This is useful when do-
                         cumenting files containing CALC commands.  
            *N      NOVIEW.   Prevents  CALC  from outputting the value of the expressions evaluated.  This is
                         especially useful when executing  files  containing  CALC  commands  that  initialize
                         variables to special values.  Equivalent to *V 1 
            *V     VIEW.  Controls CALC's printing options:  
          
                           command    output class
                           --------   --------------
                            *V 0       error messages
                         
                            *V 1       error messages
                                       command lines read
                                         from files
                         
                            *V 2       error messages
                                       value of expressions
                                         evaluated
                         
                            *V 3       error messages
                                       command lines read
                                         from a file
                                       value of expressions
                                         evaluated

          AnalytiCalc (PortaCalc) Reference Manual                                                     Page 47
          
          
          
                            *V         same as *V 3
          
                         The default setting is *V 3.  Notice that other legal forms are *VIEW 1 and *V2.  You
                         may want to include a command *V 0 somewhere before using any command files to  avoid
                         diagnostic printouts if you use indirect cell files much.  
            *R     READ.  Allows a single line to be read from the terminal.  Useful in files of CALC commands
                         to allow additional commands to be entered (like *S to exit from that file) or simply
                         as a way to halt terminal output until the carriage return key is pressed.  
            *REAL     declares specified variables to be REAL*8.  When the value of such variables are output,
                         FORTRAN's D format is used.  
            *DECIMAL     Declares specified variables to be REAL*8.  When the value of such variables are out-
                         put, FORTRAN's F format is used.  Variables A-H and O-Z default to type DECIMAL.  
            *S     STOP.  Same as *E 
            *E      EXIT.   Terminates CALC session unless it is used within a file of CALC commands.  In this
                         case, CALC closes the file and continues with the next command.  
            *Z     ZERO.  Zeroes all variables except %.  Data types are not changed.  
            *G        *G  V1,V2 (where V1 and V2 are cell or accumulator names) will evaluate V1 and V2 as the
                         column and row numbers, on the physical sheet, of the desired  cell.   The  addressed
                         cell's  value is retrieved and used as the resulting number.  This is used for lookup
                         tables.  
            *W       Takes the value at the current cell and writes it out to the formula as a numeric (float-
                         ing) value.  The current cell may have been modified temporarily by the  *P  command.
                         This  will overwrite the formula at that cell.  The *WF command stores the cell simi-
                         larly, but uses the format of the current cell instead of the D32.25 format used  for
                         *W.  This makes it possible to make the cell contents match the display exactly.  Ex-
                         tra spaces introduced may be removed via the ED / // command.  It is a good  idea  to
                         use  a  command  like  "E %=P##WF" rather than just E *WF to ensure the % accumulator
                         REALLY is the current cell.  
            *P       The *P command resets the current cell coordinate from within a cell (until the next cell
                         is evaluated only).  It has several forms:  
                       *P - By itself, *P causes Calc to prompt for the new physical column and row number.  
                       *P  V1  -  This  moves the current location to the named cell where V1 is the cell name
                         (e.g.  A5, H2) 
                       *P@  V1,V2 - This uses V1 and V2 (cell names) as column and row numbers and changes the
                         current physical cell position to that defined by the contents of cells  V1  and  V2.
                         This gives complete addressing of the sheet from within any cell.  
            *F        *F Label - If the value in % is positive and nonzero this command rewinds the input file
                         for the AnalytiCalc @ command (not the Calc @ command) and  seeks  a  line  beginning
                         with  the  characters  *CLabel  (where "label" is what you put after the *F command).
                         This allows Calc commands inside a cell to direct outside command entry.  
            *J         *J  Label - This command behaves as the *F command but operates on the file used by the
                         Calc @ command rather than the AnalytiCalc one.  Thus,  conditions  in  Calc  program
                         files may be implemented.  
            *QF 
            *QW         The  *QF  (Float) or *QW (write) commands are used to examine sequential files created
                         outside AnalytiCalc and return values or formulas.  Their syntax is 
                     *QF filename ?key1? ?key2? <lm> 
                  or *QW filename ?key1? ?key2? <lm> 
                         where ?key2? is optional 
                         l  and  m  are  delimiter  characters  for start and end of the parts of the selected
                         records to extract (defaults to first part of the record) filename is just  the  file
                         specifier  in the host OS.  operation is that the file is searched from the beginning
                         for records containing key1 (and key2 if specified) and then the part of  the  record
                         between  character  l and character m (delimiter characters, which may be the same as

          AnalytiCalc (PortaCalc) Reference Manual                                                     Page 48
          
          
          
                         for example 2 commas) is extracted.  That part of the record is then  either  Floated
                         by converting to a floating point number using a wide Floating Point format specifier
                         (in *QF) or read in and made the current cell's formula between those delimiters  (in
                         the  case  of *QW).  Records may not be over 128 characters long.  This command would
                         be used to extract data from a database or word processing files.  
          
                              The  first  key  will begin at the start of the line for each file if it's first
                         character is the ` (accent grave) character.  Then the key  searched  for  is  sought
                         always at the start of the line, minus the ` character.  
          
                              The  delimiters  may contain 3 characters to specify positional fields.  In this
                         case, the first delimiter character is ` (again) and the second 2 are  encoded  start
                         location  and length fields.  They are just the binary values of these + 32 (starting
                         from 1) to turn them to printable ASCII.  
          
                              Variant  forms are *QFK, *QWK (which keep the file open after opening it so that
                         subsequent *QFN or *QWN or *QFC or *QWC  commands  can  read  sequentially  down  the
                         file),  or  the  mentioned  *QFN and *QWN commands, which read the file from the Next
                         record (leaving it open for more Next searches) and the *QFC or *QWC  variants  which
                         perform the *QFN type action but close the file on completion.  The file spec must be
                         present in *QFN, *QWN, *QFC, and *QWC commands, but is ignored there.  If the  search
                         fails,  the  %  accumulator is returned as -999999.  and on *QW type operations where
                         there is no failure, the % accumulator returns a value of 1.0  to  indicate  success.
                         In the *QF commands, the value returned is in the file searched.  These return values
                         occur regardless of the variant.  Note that the same logical unit (4) is used for all
                         *Q class operations, so a subsequent *QF or *QW will close the unit after a string of
                         *QN searches of indeterminate length.  A request that searches the null device  is  a
                         simple  way to ensure the unit is closed.  It is possible to leave it open and inter-
                         fere with some other operations, so the user is cautioned to pay  attention  to  this
                         aspect of program operation when designing a sheet that uses it.  
            *U  funct args      The *U command is a means to allow easy user addition to the AnalytiCalc func-
                         tion repertoire.  It passes the command line to the USRFCT subroutine which is set up
                         to recognize up to 5-letter function names (edit it to add what you need) and to pro-
                         cess the functions called.  The parsing is up to you.  Note that the  VARSCN  routine
                         may be called to convert variable names into coordinates in the XVBLS array.  
          
                              Functions supplied include:  
                    DATE  functions operating on dates:  IDATE, YRMOD, JDATE, JTOCH, and DATE which all return
                         or convert between Julian dates (day since a fixed date) and  year/month/day  binary,
                         and  ASCII dates.  The auxiliary functions WKDYS and WKDIN also give weekdays (Monday
                         through Friday) between two Julian dates, or the end Julian date given a  start  date
                         and a number of weekdays.  
                    MATRIX  functions  which  handle  matrix  math:   MTXEQ, MOVEV, MDET, MPROD, MADDV, MSUBV,
                         MMPYT, and MMPYC.  These handle all variants of  normal  matrix  algebra.   MMPYT  is
                         particularly  handy  for  producing the dot product of 2 rows or columns (sum of pro-
                         ducts of corresponding elements).  Note that matrices must reside in the  prime  area
                         in  the AnalytiCalc-PC version of PortaCalc/AnalytiCalc.  That limits them to columns
                         A through CA and rows 1 to 400 on VAX if built the  default  way.   (Not  all  matrix
                         routines are so limited, but MTXEQ is.) 
                    EQUATION  SOLUTION  via  the  VARY  function, which allows up to 8 accumulators to vary to
                         iteratively search for solutions to equations anywhere on the sheet.  
                    UTILITY  functions,  including STRVL, which converts formula text to numeric values, XQTCM
                         which executes commands from inside formulas, and HERE which returns current location
                         and some extra sheet status information.  Also, the FFTFW and FFTRV functions perform

          AnalytiCalc (PortaCalc) Reference Manual                                                     Page 49
          
          
          
                         forward and reverse FFT (Fast Fourier Transforms) on data,  and  the  LINEF  function
                         fits  a  straight line to a given data range, returning slope, intercept, and fit er-
                         ror.  
          
          
                         DETAILS:  
          
                              A  version  of USRFCT is supplied which can call the system to return the system
                         month, day, and year in accumulators T, U, and V respectively.  The % returns with  a
                         value  of yymmdd to permit easier sorting too.  However, any functions desired may be
                         added in this way and results extracted in whatever way is  convenient.   The  yymmdd
                         value returned is a Julian date based on 1/1/1980, in the % accumulator.  This is the
                         IDATE() function.  
          
                              There are 4 other date functions supported in AnalytiCalc.  These permit conver-
                         sion between ASCII dates displayed as YY/MM/DD and Julian dates, or back.  
          
                              The call 
          
                         *U YRMOD VY,VM,VD 
          
                         returns  the Julian date (in %) computed from the Year (in VY), the month (in VM) and
                         the day (in VD), where VY, VM, and VD are sheet cells.  These may be  the  result  of
                         date arithmetic.  
          
                              The call 
          
                         *U JDATE Var 
          
                         assumes the formula in cell Var (any spreadsheet cell name) contains a date string in
                         the format YY/MM/DD.  It reads this formula and converts the date to a  Julian  date,
                         returning it in the % accumulator.  
          
                              The call 
          
                         *U JTOCH Jul,Var 
          
                         assumes  that  variable Jul (any spreadsheet cell) contains a Julian date and changes
                         it into an ASCII string in the cell whose name is in the  Var  position  here.   This
                         wipes  out any previous formula in that cell, though it does not alter display format
                         or type information.  The T, U, and V accumulators return with the  month,  day,  and
                         year on return.  
          
                              The call 
          
                         *U DATE VY,VM,VD,Var 
          
                         uses VY, VM, and VD as year, month and day, and computes a Julian date from them.  It
                         then composes an ASCII string of form YY/MM/DD for that date and stores in  the  for-
                         mula for Var.  
          
                              The  use  of  Julian dates is made because the difference of two Julian dates is
                         precisely the number of days between the two dates.  These functions are designed  to
                         make date labels easier to do.  

          AnalytiCalc (PortaCalc) Reference Manual                                                     Page 50
          
          
          
                              The call 
          
                         *U WKDYS D1,D2 
          
                         computes  the  number  of  workdays between Julian dates D1 and D2 just as taking the
                         difference of two Julian dates gives differences between calendar dates in days.  
          
                              The call 
          
                         *U WKDIN D1,N1 
          
                         returns  a  Julian  date  that  is N1 work days after the date in D1, which must be a
                         start Julian date.  The WKDIN function is in a sense a  partial  "inverse"  of  WKDYS
                         since  it  allows  one  to  go from workday intervals back to Julian (i.e., calendar)
                         dates.  Only the VAX version of AnalytiCalc-PC supports WKDYS and WKDIN functions  at
                         this point for reasons of space.  
          
                              There  are  actually  4  supplied USRFCT routines.  The larger of these are also
                         able to solve matrix equations (this demonstrates  how  other  programs  may  be  in-
                         tegrated  with the package).  The function solves the matrix equation AX=B where A is
                         a square matrix and X and B are rectangular ones, A being n by n and X, B being n  by
                         m.  
          
                              The call formats for IDATE and MTXEQU are 
          
                         *U IDATE() 
          
                         *U MTXEQ(AA:AA,XX:XX,BB:BB) 
          
                         where  the  notation AA:AA means two cells at the upper left and lower right edges of
                         matrix A (e.g.  B2:C3 for the 2 X 2 matrix so defined), and the XX:XX and BB:BB nota-
                         tion  means the same for the X and B matrices.  This capability is used to solve sys-
                         tems of linear simultaneous equations and does so with extreme speed.   Note  however
                         that  errors can occur if the A matrix is singular.  The cell returns 0 if the matrix
                         was singular and does not solve the equation then;  1 is returned if the equation was
                         solved.  
          
                              Note that matrix A is modified by the call, so a reasonable precaution is to en-
                         sure that the matrix is reset by AnalytiCalc prior to each computation.  This may  be
                         done by:  
                     1.  Placing the MTXEQ call in a cell left and down from the A matrix and 
                     2.   Ensuring there are some alphas in each entry in matrix A.  This may be done by plac-
                         ing a C FRC RECALC into each cell.  This is a comment and will not affect the number.
                         However  because  it  contains  alphas,  AnalytiCalc will then re-compute each number
                         whenever the sheet is computed.  
          
                              or 
          
                              Using  the  MOVEV function to copy the real A matrix onto the working one before
                         the MTXEQU call every time.  (This is the efficient way to do  it,  as  recalculating
                         the constants every time wastes resources.) 
          
                              To  have the X matrix cells displayed without being modified, it is necessary to
                         have the cells' formulas contain a self-reference.  The easiest way to  achieve  this

          AnalytiCalc (PortaCalc) Reference Manual                                                     Page 51
          
          
          
                         is  to place the "formula" P 0 0 into each cell.  This effectively will cause display
                         of whatever number is there.  A similar technique may be used to  set  up  matrix  A,
                         where  the  real  matrix is elsewhere and formulas in A are just the P 0 0 type.  The
                         real matrix may contain formulas like "34.65d12=%" to set  up  the  desired  contents
                         here  AND to reset cell D12 (in the work area) to the entered value.  The B matrix is
                         not modified by the MTXEQ routine.  A simpler way to handle the problem is to use the
                         MOVEV  function (below) to copy the desired cells to a scratch A matrix from wherever
                         it was, so the scratch matrix may be destroyed without impact on display.  If this is
                         done, the source of the A matrix need not be specially bollixed up.  
          
                         *U MOVEV mtxa,mtxb 
          
                         where  mtxa  and  mtxb are matrix specifiers.  This command moves values from mtxa to
                         mtxb (useful prior to calling MTXEQ).  
          
                         *U MDET mtx 
          
                         This  function computes and returns the determinant of matrix mtx (specified as v1:v2
                         where v1 and v2 are upper left and lower right corners of the matrix).  
          
          
                         *U MPROD A,B,C 
          
                         This function will multiply matrix A by matrix B giving matrix C, provided that their
                         dimensions are compatible.  
          
                         *U MADDV A,B,C 
          
                         This  function  adds  matrix A to matrix B and stores in matrix C.  All matrices must
                         have the same dimensions.  It can be used for adding values  in  any  pairs  of  rec-
                         tangular regions much faster than a series of sum functions would permit.  
          
                         *U MSUBV A,B,C 
          
                         This  function  subtracts  matrix B from matrix A leaving the result in matrix C;  as
                         above, matrix dimensions must be the same.  It also is far faster in subtracting rec-
                         tangular regions than numerous separate equations would be.  
          
                         *U MMPYT A,B,C 
          
                         This  function multiplies matrix A-transpose by matrix B and stores the result in ma-
                         trix C;  dimensions must be compatible.  Also, as in MPROD, matrix C must not be  the
                         same  as  either  A or B.  In ordinary use, this can be handy for dot products.  That
                         is, suppose you have two column parts, G10:G50 and R20:R60 and you want to  form  the
                         sum  (G10*R20  + G11*R21 + G12*R22 + ...  + G50*R60) for later use.  In many systems,
                         you need to make another column of the G10*R20, etc.  terms and add it up.  Here, you
                         can use the MMPYT function as 
                         *U MMPYT G10:G50,R20:R60,G51:G51 
                         to form the sum and store it in cell G51.  (It can be stored anywhere;  G51 is chosen
                         just for illustration.) If you have a row and a column to multiply, you use the MPROD
                         function  instead  of  MMPYT  for this.  Since this is a built in function, it can be
                         orders of magnitude faster than the separate - column approach.  
          
                         *U MMPYC A,B,K 

          AnalytiCalc (PortaCalc) Reference Manual                                                     Page 52
          
          
          
          
                         This function multiplies every element of matrix A by constant K (a cell or accumula-
                         tor) and stores the result in matrix B.  This function is FAR faster than  separately
                         multiplying  many  cells.   If you want to scale a rectangular region of the sheet by
                         some constant, this function can be used to quickly do so, multiplying each  cell  in
                         the  region  by the constant in cell or accumulator K (K can be ANY cell or accumula-
                         tor).  Wherever you need to adjust data by some fraction,  this  function  should  be
                         used as the fastest way of doing it.  
          
          
                         *U VARY X,A,W,I,P;Q;R;S;T;U;V;W 
          
                         (Equation Solving by Iterative Search) 
          
                         This  function  allows AnalytiCalc to automatically search for solutions to equations
                         over up to 8 dimensions.  The operation is that the accumulators named in the  fields
                         shown as P;Q;R;S;T;U;V;W (one to 8 may be specified, only one is required) are varied
                         by a fraction W about their initial values (later scaled down by the gradient of  the
                         change  in X) to attempt to get accumulator or cell X to equal accumulator or cell A.
                         This is done for I iterations, where I is another accumulator.  Care should be  taken
                         that I is not initialized in every pass of the spreadsheet, but at most 20 iterations
                         will be done in any one pass as a safeguard in any case.  The accumulators given must
                         be  independent  variables;  set dependent ones or normalization conditions elsewhere
                         on the sheet for use with calculations.  Any function or set of functions can be  en-
                         tered and the program will step the accumulators to attempt to find a (local) minimum
                         of the value of (X-A) where X and A may be either accumulators or cells.   The  other
                         arguments  must  be accumulators (i.e., named A through Z, though prior automatic use
                         of X, Y, and Z may conflict if these are used).  This function will  allow  iterative
                         solutions  to be found for situations not soluble directly, with stops for inspection
                         every several iterations.  The TE command may be used conveniently to set the accumu-
                         lator designated as I here without need to modify a cell to do so.  
          
                              The  VARY  function is initialized by a negative or 0 value in the I accumulator
                         (the LOGICAL one, not I itself).  The equations controlling the variation may  appear
                         anywhere  in the sheet, and variation begins at the initial values set into the vary-
                         ing ACs (P-W in the illustration).  Both the logical X and A accumulators  may  vary,
                         as well.  
          
                              As  an  example,  let  us suppose we want to solve the equation A=SQRT(B) for B,
                         given A.  Humans would of course just square both sides, but in  an  iterative  solu-
                         tion, we would vary B until we found A.  The method used here performs the variations
                         intelligently so that we actually approach the  correct  value  asymptotically;   the
                         signal  we  have  a  solution  is that the variation stops.  To set this up, we might
                         enter the following equations in a  row  or  column  (or  anywhere  actually;   order
                         doesn't matter) in the sheet:  
          [?27l
                         I=-1.\A=55.\P=12.\*C Set up to initialize 
                                     with negative I, initial guess 
                                     12., and desired value 55.  
                         W=1.\*C Set "step scale" 
                         P+0.\*C Display P accumulator on screen 
                         B=SQRT(P)\*C Enter equation relating B, P 
                         *U VARY B,A,W,I,P 
          [?27h

          AnalytiCalc (PortaCalc) Reference Manual                                                     Page 53
          
          
          
                         Now we go back to the first equation, since the desired value in A (55.) has been set
                         and the initial guess for SQRT(55.) has been entered (12.) and we  may  now  set  the
                         number of iterations desired to drive the calculations to solve the equation 
                         B=A (which amounts to B=55.) 
                         (which  is what the VARY function does), by varying P to control B.  The idea here is
                         that we can control P, but B is an ARBITRARY function of P (and possibly other  AC's)
                         and  we  will vary the independent AC's like P to find what THEY need to be to arrive
                         at the desired dependent "goal" values.  Here  we  are  solving  B=A,  or  B=55.,  or
                         SQRT(P)=55.  and finding P in this way.  
          
                              In the first equation we now enter 
          
                         I=10.\*C Enter some number of iterations 
                                   to search for between displays.  
          
                         and  for  every display, we will see how P varies since we are displaying P in one of
                         the cells.  It will converge on the square root of 55.  (which is 7.416)  after  some
                         iterations.  We may just use the TE command instead to set the I accumulator to avoid
                         some of the complexity of messing with cells on the sheet.  
          
                              Note that we could have more than just accumulator P varying and could have much
                         more complex functions.  Also, both A and B could be functions of any or all of these
                         accumulators.   Matrix  computations  may  be  used, or any other functions available
                         through the spreadsheet, and the equations may be entered anywhere on the sheet.   In
                         this  way,  some  quite  powerful  sorts of solutions to equations may be found.  The
                         philosophy of this is that if you know enough algebra to set up the equations  for  a
                         problem  (the  hard  part),  you  can  set  them up so the spreadsheet can solve them
                         directly yourself, if there is a simple way to do so.  If there isn't, and if you can
                         express  the  desired result as an equation, the AnalytiCalc program can do iterative
                         searching to try and solve the problem for you, varying up to 8  accumulators  to  do
                         so.  If you really want to search for a situation in which several cells are close to
                         several others, just make up an additional cell that is the "summed distance" between
                         the desired targets.  For example, if you want to arrive at a solution where cell B20
                         should approach B30, D25 should approach D35, and cell X15 should approach cell  AQ5,
                         make  2  new cells.  One should be zero, and the other will have a formula that looks
                         like 
          
                         (B20-B30)*(B20-B30)+(D25-D35)*(D25*D35)+(X15-AQ5)*(X15-AQ5) 
          
                         or  a  simple  variation,  perhaps using **2 instead of multiplying as was done here.
                         This will produce the desired results, PROVIDED that the cells depend somehow on  the
                         accumulator values you are varying.  
                     There are 2 more functions for the USRFCT.F40 sources which permit access to formulae and
                         allow more flexible command procedures.  These functions exist only in a  variant  of
                         AnalytiCalc-VM, not in the versions of AnalytiCalc using work files.  This is because
                         support in the XQTCMD module was needed for the XQTCM functions.  
          
                              The  function  *U XQTCM command  will  execute  the  command  (terminated by the
                         end-of-line), with any command except X or K permitted, from inside a cell.  This al-
                         lows  command  files  driven from cells to control moving data, etc.  It is suggested
                         that cells containing these references in command files have the last command in  the
                         file  set the cell format to [A] so that the command execution will be once only, un-
                         less repeated commands are desired.  This function may not  be  present  on  overlaid
                         versions of PortaCalc.  

          AnalytiCalc (PortaCalc) Reference Manual                                                     Page 54
          
          
          
                              The function "*U STRVL V1,start;len" will return a value that is made from up to
                         8 characters in the FORMULA of cell V1 (where V1  is  any  cell  name),  starting  at
                         character  "start"  and  for  "len"  characters.   The  value is computed such that a
                         numeric sort on these values is equivalent to an alpha sort  on  the  formulas;   the
                         characters  are  multiplied  from  the left by 128 and the next ASCII value is added.
                         This function may be combined with the DS commands to sort on text, or with the XQTCM
                         functionality to drive a slower but more thorough sort on values.  
          
                              The  function  "*U HERE"  will  return  the current location on the matrix.  The
                         normal result is a hash-coded address of the physical cell pointed to, in the  %  ac-
                         cumulator,  and  the  column  and  row in accumulators T and U respectively.  The row
                         number is up by 1 (as the X,Y accumulators are at start of cell  evaluation)  to  ac-
                         count  for accumulator storage.  Also, the flags for manual display update and manual
                         recalculate are returned in accumulator V.  The 4 bit being set means manual view  is
                         set  on,  and the 2 bit means manual recalculate is on.  The W and Y accumulators re-
                         turn the current maximum column and row used also.  These are  designed  to  make  it
                         easy to use the IR command (Inplace Relocate) to go over only cells in use.  
          
                              The  function *U FFTFW and the function *U FFTRV perform Fast Fourier Transforms
                         in the forward and reverse (inverse) directions on the  given  range  of  data.   The
                         largest power of 2 of data points less than or equal to the given range is used and a
                         one-dimensional real FFT is performed.  This is useful for digital  filters  and  the
                         like.   The  input values are replaced by their FFT so it is best to work with values
                         copied from the real inputs (use the *U MOVEV function  to  move  the  values  before
                         use).  
          
                              The  function  *U  LINEF Vy:Vy,Vx:Vx (with the Vx range optional) fits a line to
                         the input range.  It will use the Vx range as the X coordinate if  supplied  or  will
                         compute a range if none is supplied using the cell coordinates.  It computes the line
                         equation Y=mX+B and returns the slope m in accumulator U and the intercept B  in  ac-
                         cumulator  T.  The value returned in accumulator % from the function is the Y fit er-
                         ror of the line fit.  The W accumulator returns the correlation coeff. of X vs Y.
            *XV filename V1 
            *XF filename V1        The *X class commands are for sheet linkages.  
                         *XF loads a Formula from another saved spreadsheet, while *XV loads a Value (normally
                         from a NUMERICALLY saved sheet).  They look in the given file for the named  variable
                         in the saved sheet and place the formula or value in the current position of the cur-
                         rent sheet.  Note the *P commands may be used to reset the position if it is  desired
                         not to overwrite the current formula in the case of the *XF command;  the *XV command
                         assumes the sheet was saved numerically and does not modify the formula.   Note  that
                         each *X class command gets 1 number or formula.  
          
          
                                                  -ADDITIONAL FEATURES-
          
                CALC  is similar to FORTRAN with respect to operator precedence.  Blanks may occur anywhere on
           a command line without effect except after a single quote mark  used  to  specify  a  single  ASCII
           character constant.  CALC extends the ANSI FORTRAN syntax by allowing the following:  
          
          
                 1.  multiple assignments on one line, for example 
          
                    I=J=K=812 
                 2.  Unary + and unary - are allowed, for example 

          AnalytiCalc (PortaCalc) Reference Manual                                                     Page 55
          
          
          
                    2*-3 
                    +2+-7 
                    -2**4 
                    are  all legal.  The last expression evaluates to 16 because the unary - has a higher pre-
                    cedence than exponentiation.  
                 3.  exponentiation may be indicated by using !  as well as ** 
          
                If  any of the declarations are entered (such as *INTEGER or *M8) and no argument to this com-
           mand is given, then CALC will print out the variables that have been assigned that data type.  Note
           that  a  variable  can be assigned to different data types using such commands and still not be as-
           signed a value.  If you attempt to output the value of such  a  variable,  an  error  message  will
           result.  
          
          
                                                       USAGE NOTES
             1.  When you iterate on a file by a call such as 
                      *@REPEAT X 
              then note that 
               A)  X must have been set to a positive value when the command is executed or else the file will
                    not be executed.  
               B)  If  the  file of commands does not change the value of the variable X you will enter an in-
                    finite loop.  You can explicitly set X to a non-positive value, use the *Z command to zero
                    it (if it is not %), or include a 
                    *R 
                    command to give you a chance to reset the variable and get out of the loop.  
               C)  *E  and  *S  will allow you to exit from the command file REPEAT but will not of themselves
                    prevent repetitions.  
               D)  Entering  constants  echo  on the terminal (assuming *V is properly set) and can change the
                    value and type of the variable %.  This is important to remember when using %  to  control
                    the iteration of a file.  
             2.   In  practice, multiple precision arithmetic may be limited to less than 99 digits because of
                    your terminal's inability to print that many characters.  
             3.   No  implicit conversion is made to multiple precision when operations with reals or integers
                    cause an overflow.  This was done in version 1.0 in case the multiple  precision  routines
                    have to be removed when creating a small task image for some operating system.  
             6.  In FORTRAN, 
                    -A**2 is the same as -(A**2) 
               with CALC, 
                    -A**2 is the same as (-A)**2 (just like SNOBOL!) 
             5.   If R and A are positive reals and I is a positive integer, some compilers like RSX-11M's F4P
                    won't allow (at run time) evaluation of 
                    (-I)**R 
                    (-A)**R 
             6.  Under RSX-11M F4P you will find 
                    2**.5 to have value 1 
               while 
                    2.**.5 has value 1.41421356237310 
             7.  10E10 is a hexadecimal constant (integer) while 10.E10 is a real.  

          AnalytiCalc (PortaCalc) Reference Manual                                                     Page 56
          
          
          
                                                       APPENDIX A
          [?27l
            ASCII  CALC   ASCII  CALC   ASCII  CALC   ASCII  CALC
            CODE   PRINTS CODES  PRINTS CODE   PRINTS CODE   PRINTS
            ----   ------ -----  ------ ----   ------ ----   ------
           
              0    ^      32            64     @      96     _`
              1    ^!     33     !      65     A      97     a
              2    ^"     34     "      66     B      98     b
              3    ^#     35     #      67     C      99     c
              4    ^$     36     $      68     D      100    d
              5    ^%     37     %      69     E      101    e
              6    ^&     38     &      70     F      102    f
              7    ^'     39     '      71     G      103    g
              8    ^(     40     (      72     H      104    h
              9    ^)     41     )      73     I      105    i
             10    ^*     42     *      74     J      106    j
             11    ^+     43     +      75     K      107    k
             12    ^,     44     ,      76     L      108    l
             13    ^-     45     -      77     M      109    m
             14    ^.     46     .      78     N      110    n
             15    ^/     47     /      79     O      111    o
             16    ^0     48     0      80     P      112    p
             17    ^1     49     1      81     Q      113    q
             18    ^2     50     2      82     R      114    r
             19    ^3     51     3      83     S      115    s
             20    ^4     52     4      84     T      116    t
             21    ^5     53     5      85     U      117    u
             22    ^6     54     6      86     V      118    v
             23    ^7     55     7      87     W      119    w
             24    ^8     56     8      88     X      120    x
             25    ^9     57     9      89     Y      121    y
             26    ^:     58     :      90     Z      122    Z
             27    ^;     59     ;      91     [      123    {
             28    ^<     60     <      92     \      124    \
             29    ^=     61     =      93     ]      125    }
             30    ^>     62     >      94     ^      126    ^
             31    ^?     63     ?      95     _      127
          
          [?27h
          
                                     Interactive Calc in the AnalytiCalc environment
          
                Calc  runs  as  part of AnalytiCalc to do much of the math.  The K command drops into straight
           Calc and it works as described here.  There are many additions however.  
          
                One  immediate  difference  is  that you need to issue the *V 3 command upon entry to the Calc
           mode to have it print anything.  It defaults to the *V 0  mode  in  AnalytiCalc  (to  speed  it  up
           slightly).  
          
                Calc  can  access all the variables on the sheet (names A1 and up), which may be up to 8 bytes
           long.  However, while it can examine or set any of these, the spreadsheet recomputes them from  its
           disk  based  formula  file  when  re-entered  by the *E command.  To modify this file, the "current
           position" in the physical display sheet may be set by answering the prompts  after  giving  the  *P

          AnalytiCalc (PortaCalc) Reference Manual                                                     Page 57
          
          
          
           command.   Then  the  current  display value (contents of the "%" variable) may be entered into the
           disk file by executing the *W command.  Numerous other manipulations are possible, and  by  setting
           the  view  level  to 3 (*V 3) it is possible to debug a command file that drives a spreadsheet cell
           from interactive mode (by tracing through its' operation to see what it is doing).  All interactive
           Calc  commands  work  also  from indirect files.  The physical location is clamped to legal values.
           Note too that any unused cells of the sheet may be used as scratch accumulators.  However, they may
           not  assume  any types of multiple precision numbers, as they are all 8 bytes long.  In the case of
           AnalytiCalc-PC, the multiple precision numbers are at most 20 digits long (to save space).  The in-
           ternal  expression  stack  is 40 tokens deep, so very complex expressions may have to be split into
           pieces to work.  Error messages will be shown if this happens;  they are placed on the top line  of
           the screen.  
          
                It  should  be  noted  that  until any cell is flagged as having something in it (either by an
           Enter command or implicit enter, or by giving it a format with the DF command,  or  by  loading  or
           copying  something  into it), it does not really exist in AnalytiCalc-PC and always reads as having
           value 0.0 and formula P 0 0.  It must be set up from the spreadsheet environment before it  can  be
           used.   The accumulators all pre-exist and do not need this initialization however.  This is a dif-
           ference of AnalytiCalc-PC from older versions, in which the  storage  was  always  present  whether
           needed  or  not.  The current versions allocate storage only as needed, and CALC routines generally
           do not call these allocators.  
          
          
          
          
          2 GRAPHICS 
                                                        PCC GRAF
          
                                   GRAPHICS INTERFACE AND OUTPUT FROM PCC SPREADSHEET
                                                GLENN EVERHART, 23-JUL-84
          
          
          
                                                      Introduction
          
                The AnalytiCalc system uses a separate program to provide its graphics output, permitting easy
           tailoring to different graphics devices.  The routine supplied uses a character graphics subroutine
           (GHASP) to produce histograms and scatter plots from any rows or columns of a saved sheet which has
           been saved via the PPX or PDX or PPN or PDN commands.  The output is  printed  normally.   However,
           users  with other devices may easily modify this program to insert their own favorite graphics out-
           put device output into the program.  There are several options to govern plotting, and one plot per
           command is produced.  Once a saved sheet is generated, many plots can be made from it without reen-
           tering the sheet.  
          
                An  advantage of this approach is that the address space consumed by the graphical routines is
           not taken from the spreadsheet;  since the sheet permits reentry keeping the random access file  it
           uses,  graphics  may  be  handled  with  a fair degree of transparency by command files, or even by
           spawned commands.  
          
                In  the  8088  versions  of  AnalytiCalc, some extra graphics output routines are supplied for
           other higher resolution graphs.  Also, by using the DTR-32 interface to  AnalytiCalc-PC  and  using
           DTR graphics, much more powerful on-screen graphs can be handled on a ReGis terminal.  This package
           is however universal and adapted to data analysis.  It is intended for analysis, NOT as a generator
           of fancy presentation graphics.  Accordingly, it makes few assumptions about the display so it will
           work on almost any display available, even on hardcopy devices.  

          AnalytiCalc (PortaCalc) Reference Manual                                                     Page 58
          
          
          
                Getting Started:  
          
                Run  AnalytiCalc  (PCC is sometimes used to call it, from the other name PortaCalc) and create
           your spread sheet to your liking.  When it is set, use the following commands:  
          
               L A1    go to cell A1 (top left of sheet
               PPX     Put out physical sheet. (PPN may be used if desired.)
           
           When  AnalytiCalc  asks  for a filename, give one which describes your file well (with a file type)
           followed by return.  Example:  Myfile.pcc 
          
                When AnalytiCalc asks you for maximum displacements, enter 0 in both cases (equivalent to tel-
           ling it to save everything).  
          
                When done, you may use the X command to exit PCC (AnalytiCalc).  
           Now run PCG (on PDP11, type PCG;  on VAX, MCR PCGRAF).  
           When  PCG  first starts, it asks for an output dataset.  This may be any file or device on the sys-
           tem.  If TT:  or TI:  is used as output (the terminal), the graph will be scaled to fit on a termi-
           nal  screen.   Otherwise it will be sized to fit a sheet of (normally 132 column) printer paper and
           will have some extra statistical information about the plot.  (The program  assumes  if  the  first
           character  of  the output name is T and the 3rd character is a ":", it's a terminal and acts accor-
           dingly.) When PCG runs, it will ask for a command line.  A typical command to give a scaled plot of
           column H from row 1 to row 30 would be 
          
           Enter plot command>NN myfile.pcc H1:H30 [S] 
          
          
                Note  that the rows and columns are referred to exactly s on the sheet itself.  The initial NN
           could be LL or LN or PP or other letters, but L in column 1 takes the logarithm of the  numbers  in
           the  first  (in the example the only) range of numbers selected, and L in column 2 takes the log of
           the numbers in the second range.  A P is used instead of an N where  the  values  displayed  should
           start from 0.  rather than from the lowest value in the region selected.  
          
                Should  the  range  to be plotted include only POSITIVE numbers, make the first 2 letters P's.
           This will ensure the scale starts at 0 rather than at the minimum  positive  value  selected.   The
           command line would then look like:  
          
           Enter plot command>PP myfile.pcc H1:H30 [S] 
          
          
                Scatter  plots  plot  entries  in  the first range against corresponding entries in the second
           range selected.  One dimensional plots are up to 100 bins wide and scatter plots are up to 50  bins
           by  50 bins.  Height of histograms is Scaled to fit a page if the [S] form is used and will Vary to
           whatever is needed if the [V] character is used.  Widths of plots are less than 100 (or 50) if  the
           number  of  entries  plotted  are  less than those dimensions;  if the number of entries plotted is
           greater, it will be scaled to the 50 or 100 bin maxima (which derive from paper size  mainly).   If
           the  option  [H]  is chosen, the plot will be Hacked off at one page, but scaled as if the [V] Vary
           option were specified.  
          
          

          AnalytiCalc (PortaCalc) Reference Manual                                                     Page 59
          
          
          
                SYNTAX AND USAGE:  
          
                This  program  is  designed to allow an interactive user to enter a single command line to the
           program which it will parse (using the special version of VARSCN in GVARSCN) and allow graphic out-
           put  from  AnalytiCalc  saved  spread sheets.  The assumption made is that the sheet has been saved
           with the PPN or PDN command.  The filename must appear in the command line  and  variables  in  the
           file  (named  as  though  the cursor had been in cell A1 when the PPN / PDN was done) may be histo-
           grammed or scatterplotted against each other.  
          
           The  GHASP  routine  (a  FORTRAN plot package for ordinary printers) will be used for this version.
           Other routines may be readily used as replacements for specific graphics output devices.  There  is
           a  document  supplied  PCSAVFMT.TXT  which  will give the format used to save AnalytiCalc/PortaCalc
           files to simplify reading them in.  The popular VisiCalc (tm) DIF format was NOT used in this  pro-
           gram  because  it  cannot  encode  the variety of display formats available.  The format chosen was
           rather a straight ASCII format permitting almost any language  to  read  the  saved  files  with  a
           minimum of grief, and which permits editing saved sheets with a normal text editor.  
          
           Input syntax:  
           PP or NN or LL filename.ext V1:V2 [c] V3:V4 +switches 
           where 
          
                an L in columns 1 or 2 takes log of 1st or 2nd range numbers (base 10), a P indicates Positive
           numbers (so 0 is included in the range to be plotted and the  plot  starts  at  0.   and  increases
           rather than starting at the minimum observed value for an initialized cell in the saved sheet), and
           N means Normal, i.e., neither of the above;  the minimum and maximum coordinates are taken  as  min
           and max values in the set of values to be plotted, 
          
                filename.ext appears at the start of the command line after a space and with a space following
           it and is a valid RSX or VMS file specification (the same as was given to AnalytiCalc in the PP  or
           PD command that saved the sheet normally).  
          
                V1:V2 and V3:V4 are ranges.  V3:V4 is optional and its presence implies a scatter plot.  These
           ranges must be either a row or a column or part of them.  If only range V1:V2 is present, a  histo-
           gram  will  be  done using the Scale option of GHASP to fit the plot onto a page.  The plot will be
           set up for 100 bins horizontal, 50 vertical, or the number of entries to be plotted,  whichever  is
           less.  
          
                If  the  V3:V4  range  exists,  the character Q in the [c] position (the [] are required) will
           result in a "density" plot in which the program will attempt to print darker in filled bins.   This
           is  crude  and the default is to use a 2 digit number.  Again, plot size will be scaled to 50 by 50
           bins.  For histograms, the character S implies Scale the plot  to  fit  one  sheet  of  paper,  the
           character  H implies Hack the plot off at one sheet, and the character V implies Vary height, using
           as many sheets of paper as needed to plot the data.  The character S should be  used  for  "normal"
           scatter  plots  (in  which  number of entries in a scatter plot "bin" is represented as a number or
           character).  
          
                NOTE:  (V1B):  
           No  switches  are  currently implemented.  Command format errors are well diagnosed, but parsing is
           fairly inflexible.  Multiple ranges are not presently implemented,  though  it  would  be  a  minor
           change to do so.  It is expected that the source for PCGRAF will always be available.  
          
                To  use  PCGRAF  from  inside  AnalytiCalc,  use the $ command to pass the command line to the
           system;  this will allow graphics to be done without leaving the AnalytiCalc environment.  This can
           be  done  from  an indirect file driving AnalytiCalc also, without special intervention.  Note that

          AnalytiCalc (PortaCalc) Reference Manual                                                     Page 60
          
          
          
           AnalytiCalc-VM for VAX or AnalytiCalc-PC for VAX or PDP11 have the $ spawning capability.  Creation
           of  a  few  command  files  to allow passing desired parameters to PCGRAF is simple but left to the
           reader;  the program reads unit 5 and writes command prompts to 4 and the graph to Fortran unit 6. 

          AnalytiCalc (PortaCalc) Reference Manual                                                     Page 61
          
          
          
                                                       APPENDIX B
                                                 ANALYTICALC SHEET USAGE
          
                The  AnalytiCalc  spreadsheet provides a large, but finite, number of rows and columns to com-
           pute with.  
          
                In  the  8088 version, there is a "prime" computing area of 60 columns and 300 rows, or 18,000
           cells, which may be filled at any one time.  
          
                Because  some applications need different shaped storage, AnalytiCalc has been extended to al-
           low this storage to be used as if it were shaped in almost any way desired.  
          
                Assuming your "physical sheet" is compiled to support 80 columns and 400 rows (standard on VAX
           versions), the method used is that when you specify a column greater than 80, a second strip of the
           sheet  is  used as an alias for columns 81-160, a third strip for 181-260, and so on.  The depth of
           this strip is set in the S command;  initially the strips are 40 rows down each.   Similarly,  when
           you  use rows 401-800, a second vertical strip of the sheet (initially 8 columns across) is used as
           if it were the first 8 (initially) columns in rows 401-800.  Other strips further  right  are  used
           further down.  

          AnalytiCalc (PortaCalc) Reference Manual                                                     Page 62
          
          
          
           This can be shown pictorially like this:  
          [?27l 
                           C o l u m n   N u m b e r
                   0              00            11             2
                   0              88            66             4
                   1              01            01             0
                   AAAAAAAAAAAAAAAABBBBBBBBBBBBBBCCCCCCCCCCCCCCC
                   BBBBBBBBBBBBBBBB
                   CCCCCCCCCCCCCCCC
          [?27h 
          
                Note  that  the  cells  labelled  AAAAAAAAAAAa  are  in  the "prime" area.  The cells labelled
           BBBBBBBBBBB are in the extended area and appear to all uses as though they were really  part  of  a
           wide  but  shallow  sheet.   Likewise the cells labelled CCCCCCCCCCC.  They also are shown in their
           aliased locations in the "prime area" however, to show how the organization is done.  
          
                In the S command you will be asked if you want to reset the extended area mapping.  If you re-
           ply Y, you can enter the number of ROWS to add when moving over to  an  extended  COLUMN  group  as
           shown  in the picture, or the number of COLUMNS to add when going to an extended ROW group as shown
           in the picture below:  
          [?27l    Row no.
           
              001       ABC
                        ABC
                        ABC
              400       ABC
              401       B
                        B
                        B
              800       B
              801       C
                        C
                        C
             1200       C
           
          [?27h
                You  will note that the extended region here goes to make the spreadsheet appear long but nar-
           row.  
          
                The  redefinitions  allow  you  to  specify  how "thick" the A, B, or C regions are here;  the
           length depends on how far out you need to go.  Thus, if you need a 3000 row sheet, you might  allow
           only  the  default 6 columns width.  If you don't intend to use EVERY cell in your range you can of
           course use still longer or wider sheets.  This redefinition is done recursively so that you can use
           ANY  region  in this way, not just the top or the left edges.  But the cell redefinition still maps
           storage in this way to the "prime area".  The insert or delete row or column commands only work  in
           the  "prime  area" since they can cause considerable confusion in an extended sheet.  The copy com-
           mands are not so constrained however, and can be used as desired.  
          
                This  sort  of  area  redefinition  is  different from other spreadsheet programs only in that
           aliases are provided to storage;  overall storage use works similarly in many packages.  
          
                Consider 1-2-3 and Symphony (both tm) for a moment.  These programs allocate a rectangular ar-
           ray of 4 bytes per active cell, plus a scratch area containing all cell contents for cells that are
           non  empty.  Thus, if one has 200K of memory above the (hefty) requirements for those programs, one

          AnalytiCalc (PortaCalc) Reference Manual                                                     Page 63
          
          
          
           can have 50K of totally empty cells.  If cells contain one value (6 bytes) each, the  total  avail-
           able  storage  allows only 20K cells with only values in them.  If cells have 10 character formulas
           in each (plus a value), only 10K cells can be held in this much memory.  (In actual  practice,  far
           fewer than 10,000 formulas can be entered.) 
          
                In  1-2-3,  a  sheet with 10,000 cells storage can be organized in 2000 rows by 5 columns, 250
           columns by 40 rows, 100 columns by 100 rows, or any other way in which (rows used) * (columns used)
           is  less  than 10,000.  While you can display a screen showing cell IA2000, however, you CANNOT use
           it.  In fact, the area you can use is bounded by a hyperbola whose exact position depends  on  your
           memory  size  and the needs of the product for memory for itself (typically 256K or 320K for these,
           at a minimum).  Since some "lower" memory is used in even the newest releases  of  these  products,
           this problem still exists with lesser impact even with memory expander cards.  
          
                With AnalytiCalc, you also have a fixed maximum storage available, but it can be used anywhere
           in your address space and can be remapped to a physical sheet any way you like.  When  an  extended
           address  is  found, its column number and row number are remapped in turn until both fit within the
           prime area.  This makes the remapping somewhat hard to follow, but at least  a  cell  that  is  ad-
           dressed  can conceivably ALWAYS be used.  Where the need is for a wide but shallow sheet, or a high
           but narrow one, the remapping provides the same flexibility of shape as in other products, but  you
           can  control its action to achieve the results YOU need.  You will not suddenly be told you are out
           of memory, but can plan your usage.  Dimensions like 32000 by 1  or  1  by  32000  can  be  readily
           handled in extreme cases.  The only caution is that the mapping MUST NOT be altered if any extended
           address cells are in use.  Save the sheet, alter the map, and reload it to vary the mapping.  NOTE:
           ONLY  set up the map while the sheet has nothing in it in an extended area.  Save your sheet, alter
           the map, and then reload if you have an active extended  area  (i.e.,  any  cell  with  row  number
           greater  than 400 or column number greater than 80.) You have great flexibility here, but can still
           only access the storage available.  The total amount of such storage  is  quite  large,  since  all
           32,000 cells can have up to 100 characters in them at once, plus an 8 byte value and multiple equa-
           tions per cell.  This is far more storage than 1-2-3 (tm) or Symphony (tm) can  handle  on  even  a
           640K  PC or AT, and is comparable to the most they can permit even with extended memory boards.  It
           is in fact as much storage as can be used without excessive page thrashing on a VAX, making it  one
           of the most efficient packages you can use.  
          
                In  addition,  you  can  link  sheets  efficiently in AnalytiCalc, so your computations can be
           "bite-sized" pieces linked with use of GPX+ commands or *X cells or both.  The ability  to  do  au-
           tomatic  links  in AnalytiCalc is the thing that 1-2-3 lacks which has made its users interested in
           giant spreadsheets in the first place.  A giant summary sheet is a stopgap solution to  summarizing
           many  activities,  since  physical memory will always run out with a large enough summary.  A sheet
           that finds its inputs on disk will succeed in summarizing far larger  systems  of  sheets,  as  its
           storage is limited only by disk capacity, not memory.  
          
                                                 New Features - V19.01A
          
                A  modified command structure is supported now.  If you type the command /;  then the commands
           to AnalytiCalc are modified as follows:  
          
          
                1.  Any  command beginning with a digit (except single digits standing alone) is treated as an
                    EV followed by the text.  
          
                2.  Any command beginning with / has the / stripped off and the rest is treated as a command. 
          
                3.  Any  command beginning with " is treated as an E" command (enter text) with the " stripped
                    out.  

          AnalytiCalc (PortaCalc) Reference Manual                                                     Page 64
          
          
          
                4.  Anything  not  starting with a digit, a " character, or a / is treated as an Enter command
                    and is prefixed with "EN " and used.  
          
          
                The  old  (default)  command  mode is restored with the command "//" so that /;  and // switch
           between the two.  These commands may be given in ACINIT.PRM, other command files, or from the  con-
           sole.   They  introduce  incompatibilities  in  that  in  the  new  version commands like "DF range
           [format]" must be entered as "/DF range [format]" (for example) to work.  
          
                To  facilitate  writing  command files that work in both modes the command / switches the mode
           with a save cell.  A sequence of commands:  
          
            /#             (save current command mode in save cell)
            //             (enter old command mode)
           ...
            (do all of command file)
           /#              (restore saved user command mode)
          
           will  allow  a command file to operate and be written to run predictably in either user environment
           choice.  
          
                Please  NOTE  that special characters in the first character are interpreted as commands in /;
           mode.  The * character is handled as a comment.  To enter formulas with functions starting with  *,
           use the COMMAND form, e.g.  /EV *U IDATE.  This always works and disambiguates syntax.  
          
                When the system is in /;  mode, the cell prompt at the 23rd line of the screen ends with :  so
           that it appears like 
          
           AB 21:  
          
                When the system is in // mode (initial default) the prompt ends with the > character so it ap-
           pears like 
          
           AB 21> 
          
           This should aid in distinguishing modes during use.  
                                                  New Features of V19.2
          
                In  V19.2,  AnalytiCalc  adds the OAD and ORD commands.  These are like the OA and OR commands
           except they leave the relative mappings of the screen alone.   Thus,  if  you  already  split  your
           screen into 3 parts and use the command "OAD cell" to reset the mapping, the resultant screen still
           has 3 regions at the same relative positions as before.  If you use the ORD command, then only  the
           part of the screen right and down from the cursor is affected, but any screen partitioning is main-
           tained.  If these commands leave some areas pointing to nonexistent areas, use a command OR  or  OA
           to reset the areas desired to something real again.  V19.2 added the change from > to :  at the end
           of the prompt depending on // or /;  modes also.  

          AnalytiCalc (PortaCalc) Reference Manual                                                     Page 65
          
          
          
                The difference between OA, OAD, OR, and ORD may be illustrated in the following figures, which
           represent the screen mapping after a command sequence 
          
              OA A1
              L C1
              OR AA1
              L A11
              OR A100
          
           which produces a screen mapping like this:  (note only part of the map is reproduced...) 
          [?27l
                    A       B       AA       AB      AC
              1>   A1      B1      AA1      AB1     AC1
              2>   A2      B2      AA2      AB2     AC2
              3>   .       .       .        .       .
              4>   .       .       .        .       .
              5>   .       .       .        .       .
              6>
              7>
              8>
              9>
             10>  A10     B10    AA10      AB10     AC10
            100> A100    B100    C100      D100     E100
            101> A101    B101    C101      D101     E101
            102>
            103>
            104>        and so forth. Note that columns
            105>           AA, AB, and AC are now mapped
            106>           for only 10 rows. Thus we have
            107>           3 screen regions, not 4.
          [?27h 

          AnalytiCalc (PortaCalc) Reference Manual                                                     Page 66
          
          
          
           While after a sequence like:  
          
              OA A1
              L C1
              OR AA1
              L A11
              ORD A100                 (Different)
          
           the resulting screen mapping looks more like this:  
          [?27l
                    A       B       AA       AB      AC
              1>   A1      B1      AA1      AB1     AC1
              2>   A2      B2      AA2      AB2     AC2
              3>   .       .       .        .       .
              4>   .       .       .        .       .
              5>   .       .       .        .       .
              6>
              7>
              8>
              9>
             10>  A10     B10    AA10      AB10     AC10
            100> A100    B100   AA100     AB100    AC100
            101> A101    B101   AA101     AB101    AC101
            102>
            103>
            104>        and so forth. Note that columns
            105>           AA, AB, and AC now extend to
            106>           the full screen. This gives
            107>           4 screen regions.
           
          [?27h
          
                These figures illustrate the usefulness of the OAD and ORD commands.  

          AnalytiCalc (PortaCalc) Reference Manual                                                     Page 67
          
          
          
                                                       Appendix C
                                             Variant Versions of AnalytiCalc
          
                                                    Variant Versions
          
                There  are several variants of AnalytiCalc.  Some PDP11 versions, and some VAX versions, use a
           random access file to hold formulae.  These will ask whether there is a work file (the  random  ac-
           cess   file)   and   of  its  characteristics.   The  VAX  version  using  memory  instead  (called
           AnalytiCalc-VM) uses a memory array for formulas and does not ask about  workfiles,  since  it  has
           none.   (It also requires a confirm on exit to ensure you saved the sheet with a PP class command.)
           Finally, the PC versions of AnalytiCalc use memory arrays backed by temporary disk files for values
           and formulas.  These do not ask about work files, but ask how many K (bytes) to reserve on disk for
           the value file and the formula file.  Generally there should be somewhat more  formula  space  than
           value  space  if  many long formulae are used;  otherwise pick roughly equal values.  These scratch
           files are deleted on exit from AnalytiCalc-PC, but the sheet will NOT run out of room provided suf-
           ficient file space is allocated.  If it runs out due to lack of room, a message on screen will tell
           which file is out.   Save  the  sheet  and  restart  then  with  a  bigger  file.   Be  aware  that
           AnalytiCalc-PC  is  slower loading and running than AnalytiCalc-VM, but more comparable to PDP11 or
           workfile versions.  The best debugged and most capable versions are  AnalytiCalc-VM  for  Vax,  and
           AnalytiCalc-PC for PDP11 (including DEC PRO 300 series).  AnalytiCalc-PC also has a VAX build file,
           and that version is the only one which supports huge cell addresses and Datatrieve interfacing.  It
           is now the recommended VAX implementation, though AnalytiCalc-VM still works.  
          
                The  Datatrieve  (DTR)  interface  is described in DTRIF.DOC and adds not only a full bidirec-
           tional link to DTR for all DTR functionality, but adds optionally a "Super-AnalytiCalc"  capability
           which permits you to define an input and an output area of the spreadsheet and use AnalytiCalc as a
           smart data filter.  The input and output areas can be handled either as sequential or as random ac-
           cess  (128  byte  record)  files  and are constructed so the sequential mode is useful for mailbox,
           pipe, or communications line processing as well as simple files.  Also the FILFMTOUT range  command
           allows  you  to "freeze" a two dimensional area as values and write to an output file if one is de-
           fined.  The input and output areas can be any (possibly overlapping) two dimensional areas  of  the
           sheet.  Control can be from within the sheet template or from interactive commands.  The random ac-
           cess input is structured so that it can also be used (by opening the file for read only) to provide
           protected  cells which have un-modifiable formulae as well as to act as a communications mechanism.
           The Datatrieve access mechanism provides additional communications channels and  is  structured  to
           allow  FMS  and  graphics  commands to be includable, and controllable from within AnalytiCalc pro-
           cedures if desired, as well as normal interactive DTR commands.  
          
                The  sequential interface is designed to make it simple to "connect" AnalytiCalc to any appli-
           cation by running the application in a separate process with input and output set as mailboxes,  to
           which the sheet output and input areas can be logically assigned.  This can be done completely from
           within AnalytiCalc if desired (with a few pieces done via the "$dcl-command" feature).   It  should
           also be mentioned that as an aid to parsing text coming from generic applications using the sequen-
           tial interface to mailboxes, the DTR interface package implements formula string compare, substring
           search,  and  formula string length functions.  These can supplement the other string functions and
           greatly facilitate parsing text coming from a generic application.  
          
                AnalytiCalc-PC  for  VAX also supports output files up to 512 characters wide, save/restore of
           complete attributes of a sheet (including mappings and column widths if desired),  and  some  other
           novel  features,  and will be the only version able to support the upcoming extended DBMS interface
           which will allow some cell address ranges to automatically access a DBMS file  or  files  with  ex-
           tended DBMS operations permitted.  It is now the recommended implementation across the board.  
          

          AnalytiCalc (PortaCalc) Reference Manual                                                     Page 68
          
          
          
                AnalytiCalc-88  (for Rainbow and IBM PC) functions similarly to the PDP11 and DEC PRO versions
           but has fewer overlays (some variants have  none),  and  thus  has  no  limitations.   If  you  use
           AnalytiCalc-PC, the storage needed per cell in the workfile is 10 bytes per cell, and for formulas,
           12 bytes of formula go into every 16 bytes of workfile (the remainder is for accounting  overhead).
           Thus,  for  a  32,000  cell sheet, 320K bytes is the maximum useful value file size, and 512K bytes
           would permit a 12 character formula for each cell, while 4600K bytes  would  give  every  cell  108
           characters and is the maximum useful size.  Since a symbol table algorithm is used, sizes may be as
           small as desired.  If the size chosen is less than the memory allocation built in (1K is guaranteed
           to  be),  no  files will be opened and cells will be stored in memory only.  Note that if value and
           formula file sizes are given negative, a slower but sometimes more efficient packing will  be  done
           of  the file.  The workfiles are opened in one's default device at the time of running the program.
           The "slow" algorithm picks a diskfile page to use by taking the cell number modulo  the  number  of
           pages in the file.  The "fast" one picks a diskfile page to use by taking the position in the total
           sheet (columns increasing fastest) and making the number of cells in a diskfile page vary as number
           in  the  sheet  divided by the size of the diskfile.  Thus, cells close to one another on the sheet
           are kept close on the disk file.  This can overflow a disk page if too many cells for  a  page  are
           used  close  to each other.  Therefore, the program will ask you how many rows and columns you pro-
           pose to use for purposes of disk clustering.  If the "fast" algorithm is used, the disk  page  will
           be  chosen  as  (cell address)*(number of disk pages total)/(size of the total sheet you said you'd
           use, clamped to the max physical size).  If you say you'll use a small area, cells  will  be  scat-
           tered  better.   If  you  use  beyond  the area you said, disk pages are chosen in modular fashion.
           Therefore, if you run out of room in a file, try either varying the size for allocation, or  adding
           space  to  the  files.   If  you give the exact size you're really using, the "fast" algorithm will
           equally divide disk pages among cells on the screen you're using for  rectangular  use.   The  size
           question  is  ignored  if the "slow" algorithm is used, since that algorithm equipartitions without
           needing to know the size used.  
          
          
                                                          NOTE
[3m          
                     If  you  run  AnalytiCalc-PC  on  a  VAX,  the  workfile issues may be ignored.
                     Demand-zero pages are used instead of disk files for  speed,  and  the  default
                     storage size should be ample.  
[23m          
          
           There are two effects of importance here.  First, if you don't allocate enough space, scratch files
           may overflow and you'll have to save the sheet and rerun with bigger files.  Second, if the scratch
           files are TOO big, the program will waste time switching pages in memory unnecessarily.  Therefore,
           when you tell AnalytiCalc how much space you intend to use, it prints out the sizes of files needed
           ASSUMING  that you will fill in EVERY cell in the range indicated, and that formulas are 12 or less
           characters long.  If you use less cells, both files may be shorter.  If formulas  are  longer,  the
           formula  file  needs to be made bigger.  The program won't actually go out to disk unless the files
           are bigger than its in memory buffers, so don't worry about that condition.   The  suggested  sizes
           are usually a good guess.  
          
                A  version  of  AnalytiCalc  now built standardly on PDP11 (on PRO 3XX the PCCPRON.COM file is
           used) has two in-memory pages instead of one.  The one memory-page system could be made  to  thrash
           fairly  easily  since copies from one area to another required continual reloads of the appropriate
           pages.  The two-page algorithm makes each page half as large but allows LRU paging to swap the old-
           est  page first so that copies from one area to another tend to have the page contents follow along
           the regions copied.  In large sheets the speedup can be enormous.  (The WRKFIL.FIV  and  WSHEET.F40
           files are used for this on PDP11.) 

          AnalytiCalc (PortaCalc) Reference Manual                                                     Page 69
          
          
                                         OLD VERSION
                REMEMBER:    If   you  are  using  a  "workfile"  version  of  AnalytiCalc,  it  is  [1mobsolete[22m.
           AnalytiCalc-Pc and AnalytiCalc-VM are the most current and most capable versions and should be  the
           ones used unless there is a compelling reason to use an older one.  IF you have a more current ver-
           sion of AnalytiCalc, skip to the "Calculation Screen" section.  
          
                Now back to the workfile (obsolete) version.  
          
                The  next  question  is  whether there is already a work file on disk to use or reuse.  If you
           have such a file, you can let AnalytiCalc just reuse it.  AnalytiCalc will create one if  none  ex-
           ists,  but  one already in existence can be used as a way to continue a computation somewhat faster
           than loading a saved sheet, or to continue after a crash.  Reply N if there is no file and one must
           be  made.  The reply Y will cause AnalytiCalc to read the old file and find out what format entries
           are valid over the whole sheet, so that an old sheet's workfile can be used to continue;   formulas
           and  format  information is still there.  To start quickly, you can type Q, which means AnalytiCalc
           does not read the whole file, but only the default display window part.  If you choose this option,
           all cells will start with 0 until the first R (Recalculate)command is given, when the values in the
           display window will reappear.  Other cells' values will not be set up however, so large sheets  may
           need  the  Y option if the old cells are to be used outside the immediate display area.  Ordinarily
           it's a good idea to use the Y or N options only, not the Q option.  However, when re-using a  small
           sheet  that all appears in the display window, or reusing a workfile that you intend to Zero All of
           (see the ZA command), the Q option is a good time saver.  Normally it is better  practice  to  exit
           AnalytiCalc  with  the XD option to delete the workfile (assuming you used the PP option to save it
           if you need it) rather than to leave multiple random access files around.   AnalytiCalc's  workfile
           has  space  for  all  cells possible in your sheet, while the save files only contain data on cells
           that are in use;  hence retention of workfiles represents a waste of disk space.  
          
                Note  that the Q option is likely NOT to work if you have used integer formats.  In that case,
           ALWAYS use the P and G commands to save and load sheets.  These  are  a  good  idea  anyway.   They
           permit  sheets  to be loaded across AnalytiCalc versions, and some variants permit graphing the en-
           tries.  A workfile is only usable as long as the physical sheet  AnalytiCalc  is  compiled  for  is
           identical to that which created the workfile.  
          
                The  last  question  of this setup phase is the filename.  A standard filename, either that of
           the old file, or the name to use for a new one, is required.  Limit it to the max supported by your
           system for names (on DEC, 9 character names max).  A full system file specifier may be entered (in-
           cluding directory, etc.) at this time, provided the specifier is a file that you may  legally  open
           for update (read AND write) access.  AnalytiCalc has no such thing as an INSPECT mode.  
          
                The  workfile  that is set up may be of considerable size and could be much larger than is ac-
           tually needed.  However, if you know that you will be using fewer rows of your sheet than the  max-
           imum, you can specify a smaller maximum and have the workfile made smaller on disk (this is true of
           the VAX version and the PDP11 XL version) by specifying a "/" character  after  the  filename.   If
           this is done, the program will ask for the number of rows to use.  This will be clamped to at least
           the number on the initial display, and at most the number for the maximum sized generated sheet.  
          
                If you try to use more rows than this during a session, the results are UNPREDICTABLE and will
           possibly be wrong or could crash the program (leaving the random file, so a restart  is  possible).
           However,  this  permits a "large" version of the program to be used even where one's disk quotas or
           space is smaller than the full-sized workfile.  The number of COLUMNS is NOT variable in this  way.
           Note  the  sheet file is organized in a fashion that has columns varying quickly, rows slowly.  The
           calculations are done going across columns, then down rows, so the file is accessed nearly  sequen-
           tially  during a recalculation (and the memory array is also).  This was done deliberately to avoid
           paging slowdowns or disk thrashing and is part of the reason why the order  is  not  variable.   By

          AnalytiCalc (PortaCalc) Reference Manual                                                     Page 70
          
          
          
           recalculating (or auto recalculation), the correct results are achieved anyway with one or two more
           recomputations even where order dependencies exist.  
          
                If  the  Q  option  is not given, AnalytiCalc displays the directory page (0) of its help file
           while initializing the file or reading it, then goes into the sheet proper.  

          AnalytiCalc (PortaCalc) Reference Manual                                                     Page 71
          
          
          
                                                       APPENDIX D
          
                                              AnalytiCalc Function Summary
          
          
                The available multiple argument functions are:  
          [?27l
           [17;1m  SUM[variables]     Sum of all arguments[22m
           [17;1m  MAX[variables]     Max of arguments[22m
           [17;1m  MIN[variables]     Min of arguments[22m
           [17;1m  AVG[variables]     Average of arguments[22m
           [17;1m  AVE[variables]     Average of arguments excluding zero args[22m
           [17;1m  STD[variables]     Standard deviation squared[22m
           [17;1m  AND[variables]     Boolean AND of all variables in list[22m
           [17;1m  IOR[variables]     Boolean inclusive OR of variables[22m
           [17;1m  NOT[variable]      Boolean complement of variable[22m
           [17;1m  XOR[v1,v2]         Boolean exclusive OR of v1,v2[22m
           [17;1m  EQV[V1,V2]         Boolean "equivalence" of V1,V2[22m
           [17;1m                     (complement of exclusive OR, true if[22m
           [17;1m                     bits have the SAME value)[22m
           [17;1m  CNT[variables]     Number of nonzero variables in list[22m
           [17;1m  MOD[V1,V2]         Returns V1 modulo V2 (i.e., remainder[22m
           [17;1m                     of V1/V2 division.)[22m
           [17;1m  SGN[v1]            Returns 1.0 times sign of V1[22m
           [17;1m  LKP[var,variables] Lookup variable in "variables" range[22m
           [17;1m                     greater or equal to var, return its[22m
           [17;1m                     index (starting with 0) into variables[22m
           [17;1m                     range.[22m
           [17;1m  LKN[var,variables] Lookup variable in "variables" range[22m
           [17;1m                     less than or equal to var, return its[22m
           [17;1m                     index (starting with 0) into variables[22m
           [17;1m                     range.[22m
           [17;1m  LKE[var,variables] Lookup variable in "variables" range[22m
           [17;1m                     strictly equal to var, return its index[22m
           [17;1m                     (starting with 0) into range. Note all[22m
           [17;1m                     LKP, LKN, LKE return the last variable[22m
           [17;1m                     index if no satisfactory value found.[22m
           [17;1m  NPV[disc,vars]     Net Present Value of vars (equal time[22m
           [17;1m                     interval numbers), at discount rate[22m
           [17;1m                     disc where disc is a fraction[22m
           [17;1m                     (e.g., .12 for 12%)[22m
           [17;1m  IRR[PV,FV,returns] Internal Rate of Return. Will compute[22m
           [17;1m                     internal rate of return on up to 20[22m
           [17;1m                     periods, returning rate per period.[22m
           [17;1m                     The returns are expected to be at[22m
           [17;1m                     equal time intervals. PV and FV are[22m
           [17;1m                     initial and final values of investment[22m
           [17;1m                     and the result is computed via Newton[22m
           [17;1m                     approximation.[22m
           [17;1m   PMT[princ,inter,nper] Payment (mortgage payment per period)[22m
           [17;1m                     function. Will compute payment per period[22m
           [17;1m                     for principal amount "princ" with interest[22m
           [17;1m                     per period as "inter" and number of periods[22m
           [17;1m                     as "nper". All arguments must be cells.[22m

          AnalytiCalc (PortaCalc) Reference Manual                                                     Page 72
          
          [?27l
          
           [17;1m                     The formula is the standard ordinary annuity[22m
           [17;1m                     formula. Interest rate must be a fraction so[22m
           [17;1m                     that 14% would be 0.14, for example.[22m
           [17;1m   PVL[payment,inter,nper] Present Value formula. Computes present[22m
           [17;1m                     value of an annuity given "payment", the payment[22m
           [17;1m                     per period, interest rate per period (as a[22m
           [17;1m                     fraction, so 12% is 0.12) in "inter", and[22m
           [17;1m                     number of periods as "nper". All arguments[22m
           [17;1m                     must be in cells.[22m
           [17;1m   RND[DUM]          Generates a random number between 0. and[22m
           [17;1m                     1.0. An argument is needed but it is[22m
           [17;1m                     NOT touched by this function.
                         CHS[IDX,Range]    Choose cell from range based on value of cell
                                           IDX. If cell used as IDX is 1, first element
                                           of range is chosen and so on. Zero is returned
                                           for out of range cases.[22m
           [17;1m[22m
           [17;1m   IF [V1.rel.V2] statement | else-statement[22m
           [17;1m    Compares two variables and executes either "statement" (if the[22m
           [17;1m     relation is true) or "else-statement" (if the relation is[22m
           [17;1m     false).[22m
           [17;1m    Valid relations (in the place of the .rel. above) are:[22m
           [17;1m      .EQ.    Equal[22m
           [17;1m      .NE.    Not Equal[22m
           [17;1m      .GT.    Greater than (V1 greater than V2)[22m
           [17;1m      .LT.    Less than (V1 less than V2)[22m
           [17;1m      .GE.    Greater than or Equal to (V1 >= V2)[22m
           [17;1m      .LE.    Less than or Equal to (V1 =< V2)[22m
           [17;1m[22m
          
                The following single argument functions are available:  
          
           [17;1m[22m
           [17;1m FUNCT NAME   ARG TYPE    FUNCT VALUE   DESCRIPTION[22m
           [17;1m -------------------------------------------------------[22m
           [17;1m ABS          REAL        REAL         absolute value[22m
           [17;1m DABS         REAL        REAL         absolute value[22m
           [17;1m IABS         INTEGER     INTEGER      absolute value[22m
           [17;1m IFIX         REAL        INTEGER      REAL to INT conv.[22m
           [17;1m AINT         REAL        REAL         REAL truncation[22m
           [17;1m INT          REAL        INTEGER      REAL to INT conv.[22m
           [17;1m IDINT        REAL        INTEGER      REAL to INT conv.[22m
           [17;1m EXP          REAL        REAL         e**X[22m
           [17;1m DEXP         REAL        REAL         e**X[22m
           [17;1m ALOG         REAL        REAL         natural logarithm[22m
           [17;1m DLOG         REAL        REAL         natural logarithm[22m
           [17;1m ALOG10       REAL        REAL         logarithm base 10[22m
           [17;1m DLOG10       REAL        REAL         logarithm base 10[22m
           [17;1m SQRT         REAL        REAL         square root[22m
           [17;1m DSQRT        REAL        REAL         square root[22m
           [17;1m SIN          REAL        REAL         trigonometric sine[22m
           [17;1m DSIN         REAL        REAL         trigonometric sine[22m
           [17;1m COS          REAL        REAL         trig. cosine[22m
           [17;1m DCOS         REAL        REAL         trig. cosine[22m
           [17;1m TANH         REAL        REAL         hyperbolic tangent[22m
           [17;1m DTANH        REAL        REAL         hyperbolic tangent[22m
           [17;1m ATAN         REAL        REAL         arc tangent[22m
           [17;1m DATAN        REAL        REAL         arc tangent[22m

          AnalytiCalc (PortaCalc) Reference Manual                                                     Page 73
          
          
          
[?27h          
          
          
          
                The following special constructs in a formula act as functions:  
                    _@V1,V2  Means get the values stored in V1 and V2 and use them as column and row locations
                         pointing at some cell in the sheet.  Replace the construct  with  the  name  of  that
                         cell.  
                    _#V1  Means take the real number in cell V1 and unpack it as if it had been a packed value
                         from a formula with 8 characters packed;  then convert it back into ASCII  and  place
                         in  the  formula  in  place of this construct.  This construct is intended to be used
                         with the *U STRVL function to allow retrieval and edit  of  formulas.   The  *U XQTCM
                         function permits use of the EDit command within a cell for string manipulation.  
          
                The following "equation commands" also act as functions with the effects described:  
            *@filename     Where filename is the name of a file of CALC commands.  CALC reads the file and ex-
                         ecutes the commands.  
            *ASCII     Declares a list of variables to be of type ASCII.  
            *C     COMMENT line.  
            *N     NOVIEW.  
            *V     VIEW.  Controls printing options in K mode 
            *R     READ.  Allows a single line to be read from the terminal.  
            *REAL     declares specified variables to be REAL*8.  
            *DECIMAL     Declares specified variables to be REAL*8.  
            *S     STOP.  Same as *E.  Goes back to spreadsheet.  
            *E     EXIT.  Gets out of K mode, back to spreadsheet mode.  
            *Z     ZERO.  Zeroes all accumulators.  
            *G        *G  V1,V2 (where V1 and V2 are cell or accumulator names) will evaluate V1 and V2 as the
                         column and row numbers, on the physical sheet, of the desired  cell.   The  addressed
                         cell's value is retrieved and used as the resulting number.  
            *W       Takes the value at the current cell and writes it out to the formula as a numeric (float-
                         ing) value.  The *WF command stores the cell similarly, but uses the  format  of  the
                         current cell instead of the D32.25 format used for *W.  
            *P       The *P command resets the current cell coordinate from within a cell (until the next cell
                         is evaluated only).  It has several forms:  
                       *P - By itself, *P causes Calc to prompt for the new physical column and row number.  
                       *P  V1  -  This  moves the current location to the named cell where V1 is the cell name
                         (e.g.  A5, H2) 
                       *P@  V1,V2 - This uses V1 and V2 (cell names) as column and row numbers and changes the
                         current physical cell position to that defined by the contents of cells  V1  and  V2.
                         This gives complete addressing of the sheet from within any cell.  
            *F        *F Label - If the value in % is positive and nonzero this command rewinds the input file
                         for the AnalytiCalc @ command and seeks a line beginning with the characters  *CLabel
                         (where "label" is what you put after the *F command).  
            *J         *J  Label - This command behaves as the *F command but operates on the file used by the
                         Calc *@ command rather than the AnalytiCalc one.  
            *QF 
            *QW         The  *QF  (Float) or *QW (write) commands are used to examine sequential files created
                         outside AnalytiCalc and return values or formulas.  Their syntax is 
                     *QF filename ?key1? ?key2? <lm> 
                  or *QW filename ?key1? ?key2? <lm> 
                         where ?key2? is optional 
                         l  and  m  are  delimiter  characters  for start and end of the parts of the selected
                         records to extract (defaults to first part of the record) filename is just  the  file

          AnalytiCalc (PortaCalc) Reference Manual                                                     Page 74
          
          
          
                         specifier  in  the  host  OS.  The *QF command gets a part of a record containing the
                         keys specified and turns it into a number ("floats" it).  The *QW command Writes that
                         part of the record to a formula.  The special characters in the <lm> part of the com-
                         mand are delimiters of the area to be picked out.  Variant forms allow such  choosing
                         to be by column number instead of key character if needed.  
          
            *U YRMOD VY,VM,VD 
          
                         returns  the Julian date (in %) computed from the Year (in VY), the month (in VM) and
                         the day (in VD), where VY, VM, and VD are sheet cells.  These may be  the  result  of
                         date arithmetic.  
          
            *U JDATE Var 
          
                         assumes the formula in cell Var (any spreadsheet cell name) contains a date string in
                         the format YY/MM/DD.  It reads this formula and converts the date to a  Julian  date,
                         returning it in the % accumulator.  
          
            *U JTOCH Jul,Var 
          
                         assumes  that  variable Jul (any spreadsheet cell) contains a Julian date and changes
                         it into an ASCII string in the cell whose name is in the Var position here.  
          
            *U DATE VY,VM,VD,Var 
          
                         uses VY, VM, and VD as year, month and day, and computes a Julian date from them.  It
                         then composes an ASCII string of form YY/MM/DD for that date and stores in  the  for-
                         mula for Var.  
          
            *U WKDYS D1,D2 
          
                         computes  the  number  of  workdays between Julian dates D1 and D2 just as taking the
                         difference of two Julian dates gives differences between calendar dates in days.  
          
            *U WKDIN D1,N1 
          
                         returns a Julian date that is N1 work days after the date in D1.  
          
            *U IDATE() 
          
                         returns the current date as a Julian day.  
          
            *U MTXEQ(AA:AA,XX:XX,BB:BB) 
          
                         solves  equation  AX=B  where  A, X, and B are matrices, and where the notation AA:AA
                         means two cells at the upper left and lower right edges of matrix A (e.g.  B2:C3  for
                         the 2 X 2 matrix so defined), and the XX:XX and BB:BB notation means the same for the
                         X and B matrices.  
          
            *U MOVEV mtxa,mtxb 
          
                         moves values from mtxa to mtxb (useful prior to calling MTXEQ).  
          
            *U MDET mtx 

          AnalytiCalc (PortaCalc) Reference Manual                                                     Page 75
          
          
          
          
                         This function computes and returns the determinant of matrix mtx.  
          
            *U MPROD A,B,C 
          
                         This function will multiply matrix A by matrix B giving matrix C, provided that their
                         dimensions are compatible.  
          
            *U MADDV A,B,C 
          
                         This  function  adds  matrix A to matrix B and stores in matrix C.  All matrices must
                         have the same dimensions.  
          
            *U MSUBV A,B,C 
          
                         This function subtracts matrix B from matrix A leaving the result in matrix C.  
          
            *U MMPYT A,B,C 
          
                         This  function multiplies matrix A-transpose by matrix B and stores the result in ma-
                         trix C;  dimensions must be compatible.  
          
            *U MMPYC A,B,K 
          
                         This function multiplies every element of matrix A by constant K.  
          
          
            *U VARY X,A,W,I,P;Q;R;S;T;U;V;W 
          
                         (Equation Solving by Iterative Search) 
          
                         This  function  allows AnalytiCalc to automatically search for solutions to equations
                         over up to 8 dimensions.  The operation is that the accumulators named in the  fields
                         shown as P;Q;R;S;T;U;V;W (one to 8 may be specified, only one is required) are varied
                         by a fraction W about their initial values (later scaled down by the gradient of  the
                         change  in X) to attempt to get accumulator or cell X to equal accumulator or cell A.
                         This is done for I iterations, where I is another accumulator.  
          
            *U XQTCM command will execute the command (terminated by the end-of-line), with any command except
                         X or K permitted, from inside a cell.  This allows command files driven from cells to
                         control moving data, etc.  
          
            *U STRVL V1,start;len 
          
                         will  return  a  value that is made from up to 8 characters in the FORMULA of cell V1
                         (where V1 is any cell name), starting at character "start" and for "len" characters. 
          
            *U HERE 
          
                         will return the current location on the matrix and the current maximum row and column
                         used.  Curr. col, row in T, U. Max col, row used in W, Y.
          
            *U  FFTFW and *U FFTRV perform Fast Fourier Transforms in the forward and reverse (inverse) direc-
                         tions on the given range of data.  

          AnalytiCalc (PortaCalc) Reference Manual                                                     Page 76
          
          
          
            *U LINEF Vy:Vy,Vx:Vx (with the Vx range optional) fits a line to the input range.  
                 Eqn: y=Ux+T. Err in %. Corr. Coeff. in W.
            *XV filename V1 
            *XF filename V1        The *X class commands are for sheet linkages.  
                         *XF loads a Formula from another saved spreadsheet, while *XV loads a Value.  
          
          
          
                The  following  *U  DBxxxxxx  functions also exist as commands of form FILxxxxxx with the same
           results.  
          
          
          
            *U DBOPINS range filename Open input sequential on filename for cells in range When the input file
                         is open and any operation causes a read of the cell, the FORMULA will be  taken  from
                         the  file  and  used.  If the file is opened with the OPINU option (for Update), then
                         when the FORMULA of the cell is written, it will also write to the file.   The  OPINU
                         option  applies  only  to random access files.  Initially both input and output reads
                         are disabled (ENAINP and ENAOUT enable them).  When a sequential file (or device such
                         as  a mailbox, pipe, or communications line) is used for input, it is advantageous to
                         read data into a range once, then disable input/output  again,  to  allow  it  to  be
                         handled  between  these  commands.  The EDTINP and FMTOUT commands are designed to do
                         this to make it easier to use AnalytiCalc for a filter between sequential files.  
          
            *U DBOPINR range filename Open input random on filename for cells in range 
          
            *U  DBOPINU  range filename Open range for update on filename for read and write as random access.
                         skip 1 
            *U DBCLSINP Close input 
          
            *U DBCLSOUT Close output 
          
            *U DBOPOUTS range filename Open output sequential from range cells to filename 
          
            *U DBOPOUTR range filename Open output random from range on filename 
          
            *U DBENAINP Enable input file readin (initially disabled) 
          
            *U DBENAOUT Enable output write (initially disabled) 
          
            *U DBDISINP Disable input area readin 
          
            *U DBDISOUT Disable output write 
          
            *U DBEDTINP range Enables input and output and, for each cell in the given range, reads and writes
                         the cell, allowing the file read/writes to take effect.   Each  cell  is  flagged  as
                         valid  but  of  text  type;   the DF command must be used to reset any that should be
                         treated as computable.  Input and output are disabled on completion of the command.  
          
            *U DBFMTOUT range 
            *U  DBVALOUT  range Enables input and output and for each cell of the range takes the VALUE of the
                         cell, reads the cell, sets it of text type, and writes the  text  equivalent  of  its
                         value  to  the cell.  In the FMTOUT command the cell's display format is used for the
                         conversion.  In the VALOUT command a large builtin format is  used  to  preserve  all

          AnalytiCalc (PortaCalc) Reference Manual                                                     Page 77
          
          
          
                         significant digits.  Spaces are discarded prior to output.  Cells are left containing
                         textual data corresponding to their numeric values, stored in the formulae.   The  DF
                         command may be used to reset these cells to numeric types if desired.  Conversion er-
                         rors are ignored.  Input and output are disabled on completion of the command.  
          
            *U  DBCMPFRM  V1:V2[,V3:V4] Compares two formulas.  It returns, in the % accumulator, the index of
                         the formula in cell V2 in the formula in cell V1.  Lengths used  are  those  of  both
                         formulas  UNLESS the V3 and V4 cell arguments are seen.  In that case the value of V3
                         will be used as the length of the formula for V1 and the value of V4 will be used  as
                         the  length  of  cell  V2.  If either value in V3 or V4 is outside the range 1 to 109
                         both values in V3 and V4 will be ignored.  Also on output the W accumulator  will  be
                         set  to -1.  if V1 is lexically earlier than V2, 0.  if they are lexically equal, and
                         +1.  if V1 is lexically later than V2.  
          
            *U  DBLENFRM  V1:V2 returns the length of the formula for cell V1 in the % accumulator and in cell
                         V2 IF CELL V2 IS VALID.  Otherwise the cell specified in V2  is  ignored,  though  it
                         must be present in the command or function.  
          
            *U  DBTRMFRM  V1:V2,V3,V4 Reads the formula in V1 and uses V3 and V4 as start and end byte numbers
                         within it.  It returns to V2 the formula that is between the  start  and  end  bytes,
                         trimming  the  V1 formula into V2 by chopping out the undesired parts.  The find sub-
                         string function CMPFRM can be used to find delimiter bytes if absolute columnar  for-
                         matting is not desired.  As in all these functions, CMPFRM and LENFRM have the forms 

          AnalytiCalc (PortaCalc) Reference Manual                                                     Page 78
[?27h          
          
                                                       APPENDIX E
                                                AUTOMATIC INITIALIZATION
          
                AnalytiCalc  will  read  SYS$INPUT  during setup phases on VAX and then read SYS$COMMAND:  for
           spreadsheet commands ordinarily.  It can continue reading SYS$INPUT however, in the "//" mode  com-
           mand entry mode.  To get it to do so, just include a ~ character in your title somewhere.  It will be
           replaced by space before use, but flags to stay in SYS$INPUT so your command file can do  initiali-
           zations.  
          
                A prime use of these initializations is to set initial command mode (either a // or a /;  com-
           mand), and to set "accumulator formulas".  The formulas A0 through Z0 are scratch formulas, but  if
           special  characters  are  entered  as commands, they are transformed modulo 32 into valid codes.  A
           fudge factor is subtracted if the result is over Z.  The ASCII code is modified  so  that  the  "="
           character  gets  mapped into the T accumulator.  By entering the text "L" (without the quotes) into
           T0, the = key becomes equivalent to the L command (so =C5 as a command goes to cell C5).  This sort
           of thing can allow an installation to tailor some keys to have the same effects as on your favorite
           CP/M or MS-DOS spreadsheet (assuming you're not already using AnalytiCalc on PC;  it has a  similar
           feature and also now has dual modes.) 
          
                The  dual  modes (// command going to the "mostly command" one, /;  to the "mostly entry" one)
           allow you to enter numbers and text conveniently where that's mostly what you're doing, and to give
           commands  faster  (by avoiding the /) where you're mostly issuing commands.  The / command is there
           to let command procedures use a known environment and work in both cases.  This can be  convenient.
           On the PC version, if you're in /;  mode and type a command beginning with the / character, a short
           help message flashes onto the bottom line.  On VAX this isn't done.   However,  on  VAX  the  usual
           solution is to use the function keys for common commands, so letter commands won't be used often in
           situations like that.  Since each installation controls the keypad definitions (except that PF2  is
           hardwired as a HELP command), a built-in message seems inappropriate.  And the single-character I/O
           that would be needed to support it is hard on  the  system.   (Be  aware  that  Gold  PF2  is  also
           hardwired to be a keypad picture (H9).) 
          
                All  told,  you'll  be  able  to configure the command language of AnalytiCalc considerably by
           tailoring the .CMD files called by keypad keys and by setting up the A0 to  Z0  formulas  to  match
           desired  special keys or letters to functions of your choice.  (Letters not otherwise used can also
           be remapped.  Thus, for example, Y is not a command starter so if  the  Y0  accumulator  gets  some
           text,  that text will be inserted at the front of the command line and the command executed (if le-
           gal).  Several letters like B, Q, and Y exist that are free.  Other accumulators can  be  used  via
           special  characters  like  the  =  sign.  A bit of experimentation will allow you to find which are
           which.  
          
[3m                For communication to other programs, consider the DIFDB or DIFRW programs also.  These convert
           between saved AnalytiCalc files and DIF files, or DTR-usable data files, and DIFDB can be used  for
           some  exotic sheet combine and re-sort applications.  If the DIF format is inconvenient, the format
           of an AnalytiCalc saved sheet is described in another document in the AnalytiCalc kit.  
          
                I  hope  you  enjoy  AnalytiCalc.  If anyone makes a modification and/or improvement to it, or
           moves it to a new system, the author would appreciate a  machine  readable  copy.   Send  to  Glenn
           Everhart, 409 High St., Mt.  Holly, NJ 08060.  Thanks.  [23m

          [2w[?27l
          AnalytiCalc (PortaCalc) Reference Manual                           Page 79
          
          
                                            INDEX
          
           AA Command . . . . . . . . . . . . . . . . . . . . . . . . . . . . .    6
           Access to Saved Sheets . . . . . . . . . . . . . . . . . . . . . . .   54
           Accumulators . . . . . . . . . . . . . . . . . . . . . . . . . . . .   20
           AR Command . . . . . . . . . . . . . . . . . . . . . . . . . . . . .    6
           Arguments  . . . . . . . . . . . . . . . . . . . . . . . . . . . . .   20
           Auto Motion  . . . . . . . . . . . . . . . . . . . . . . . . . . . .   27
           AVE Function . . . . . . . . . . . . . . . . . . . . . . . .   15, 16, 71
           AVG function . . . . . . . . . . . . . . . . . . . . . . . .   15, 16, 71
          
           Boolean Functions  . . . . . . . . . . . . . . . . . . . . .   15, 16, 71
          
           C Command  . . . . . . . . . . . . . . . . . . . . . . . . . . . . .    7
           Calculation Order  . . . . . . . . . . . . . . . . . . . . . . . . .   39
           Case Conversion  . . . . . . . . . . . . . . . . . . . . . . . . . .   13
           Caveats on Relative Addressing . . . . . . . . . . . . . . . . . . .   39
           Cell Commands  . . . . . . . . . . . . . . . . . . . . . . . . . . .   21
           Cell Names . . . . . . . . . . . . . . . . . . . . . . . . . . .   22, 73
           Cell Precision . . . . . . . . . . . . . . . . . . . . . . . . . . .   56
           Column Width Set . . . . . . . . . . . . . . . . . . . . . . . . . .   12
           Command Arguments  . . . . . . . . . . . . . . . . . . . . . . . . .   24
           Command File Limitations . . . . . . . . . . . . . . . . . . . . . .   22
           Command Files  . . . . . . . . . . . . . . . . .   21, 22, 36, 38, 47, 73
           COMMAND MACROS . . . . . . . . . . . . . . . . . . . . . . . . . . .   18
           COMMANDS . . . . . . . . . . . . . . . . . . . . . . . . . . . . . .    3
           Comments . . . . . . . . . . . . . . . . . . . . . . . . . . . . . .   38
           Conditional Loops  . . . . . . . . . . . . . . . . . . . . . . . . .   21
           Conditional Motion . . . . . . . . . . . . . . . . . . . . . . .   47, 73
           Connecting generic programs  . . . . . . . . . . . . . . . . . . . .   67
           Console Arguments  . . . . . . . . . . . . . . . . . . . . . . . . .   38
           Control of Scrolling . . . . . . . . . . . . . . . . . . . . . . . .    6
           Copy . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . .    7
           Current Position . . . . . . . . . . . . . . . . . . . . . . . . . .    3
           Cursor Motion  . . . . . . . . . . . . . . . . . . . . . . . . . . .    5
          
           Data Base Access . . . . . . . . . . . . . . . . . . . . . .   21, 47, 73
           Datatrieve . . . . . . . . . . . . . . . . . . . . . . . . . . . . .   67
           DB Command . . . . . . . . . . . . . . . . . . . . . . . . . . . . .    8
           DF Command . . . . . . . . . . . . . . . . . . . . . . . . . . . . .    8
           Display  . . . . . . . . . . . . . . . . . . . . . . . . . . . . . .    3
           Display Format . . . . . . . . . . . . . . . . . . . . . . . . . . .    8
           Display Type . . . . . . . . . . . . . . . . . . . . . . . . . . . .   11
           Displayed Entity . . . . . . . . . . . . . . . . . . . . . . . . . .    9
           DL Command . . . . . . . . . . . . . . . . . . . . . . . . . . . . .   10
           DS Command . . . . . . . . . . . . . . . . . . . . . . . . . . . . .   11
           DT Command . . . . . . . . . . . . . . . . . . . . . . . . . . . . .   11
           DW Command . . . . . . . . . . . . . . . . . . . . . . . . . . . . .   12
          
           E Command  . . . . . . . . . . . . . . . . . . . . . . . . . . . . .   12
           EDIT . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . .   24
           EDIT, Special Constructs . . . . . . . . . . . . . . . . . . . . . .   24
           EMPTY CELLS  . . . . . . . . . . . . . . . . . . . . . . . . . . . .    3
           ENTER Command  . . . . . . . . . . . . . . . . . . . . . . . . . . .   12

          AnalytiCalc (PortaCalc) Reference Manual                             Page 80
          
          
          
           Equation Solving . . . . . . . . . . . . . . . . . . . . . . . .   52, 75
           Exit . . . . . . . . . . . . . . . . . . . . . . . . . . . . . .   35, 69
           Extract Saved Value  . . . . . . . . . . . . . . . . . . . . . . . .   23
          
           F Command  . . . . . . . . . . . . . . . . . . . . . . . . . . . . .   24
           File Loading . . . . . . . . . . . . . . . . . . . . . . . . . . . .   24
           File Merging . . . . . . . . . . . . . . . . . . . . . . . . . . . .   28
           FORMAT . . . . . . . . . . . . . . . . . . . . . . . . . . . .    2, 8, 9
           FORMAT Microtutorial . . . . . . . . . . . . . . . . . . . . . . . .    9
           Formula Indirection  . . . . . . . . . . . . . . . . . . . . . . . .   18
           Formula Length . . . . . . . . . . . . . . . . . . . . . . . . . . .   22
           FORMULA SEARCH . . . . . . . . . . . . . . . . . . . . . . . . . . .   37
           Formula to Text  . . . . . . . . . . . . . . . . . . . . . . . .    8, 12
           Formula Value Access . . . . . . . . . . . . . . . . . . . . . .   54, 75
           Formulas . . . . . . . . . . . . . . . . . . . . . . . . . .   12, 22, 73
           Frame Editing  . . . . . . . . . . . . . . . . . . . . . . . . . . .   28
           Freeze . . . . . . . . . . . . . . . . . . . . . . . . . . . . .   47, 73
           Function Arguments . . . . . . . . . . . . . . . . . . . . . . . . .   19
           Function Summary . . . . . . . . . . . . . . . . . . . . . . . . . .   71
           Functions  . . . . . . . . . . . . . . . . . . . . . . .   15, 20, 41, 72
           FVL (Future Value) function  . . . . . . . . . . . . . . . . . .   15, 71
           FVL Function . . . . . . . . . . . . . . . . . . . . . . . . . . . .   16
          
           G Command  . . . . . . . . . . . . . . . . . . . . . . . . . . . . .   25
           Goal Seeking . . . . . . . . . . . . . . . . . . . . . . . . . .   52, 75
           Gold Key . . . . . . . . . . . . . . . . . . . . . . . . . . . . . .   14
           GOTO (Locate) Command  . . . . . . . . . . . . . . . . . . . . . . .   27
           Graphics . . . . . . . . . . . . . . . . . . . . . . . . . . . .   30, 57
          
           Help . . . . . . . . . . . . . . . . . . . . . . . . . . . . . .   13, 26
           Hexadecimal  . . . . . . . . . . . . . . . . . . . . . . . . . .   42, 43
           Histograms . . . . . . . . . . . . . . . . . . . . . . . . . . . . .   58
          
           IF conditional . . . . . . . . . . . . . . . . . . . . . . .   15, 16, 71
           IF statement . . . . . . . . . . . . . . . . . . . . . . . . . . . .   19
           Indirect Addressing  . . . . . . . . . . . . . . . . . . . . . .   47, 73
           Indirect Cell References . . . . . . . . . . . . . . . . . . . . . .   20
           Indirect Command Execution . . . . . . . . . . . . . . . . . . . . .   53
           Input areas  . . . . . . . . . . . . . . . . . . . . . . . . . . . .   67
           Insert or Delete Rows or Columns . . . . . . . . . . . . . . . . . .    6
           Integers . . . . . . . . . . . . . . . . . . . . . . . . . . . . . .   11
           Interactive Calculator . . . . . . . . . . . . . . . . . . . . .   26, 40
           IRR function (Internal Rate of Return) . . . . . . . . . . .   15, 16, 71
          
           Journaling . . . . . . . . . . . . . . . . . . . . . . . . . . . . .   36
          
           Keypad Command Files . . . . . . . . . . . . . . . . . . . . . . . .   13
           Keypad Commands  . . . . . . . . . . . . . . . . . . . . . . . . . .   13
           Keystroke Capture  . . . . . . . . . . . . . . . . . . . . . . . . .   36
          
           L Command  . . . . . . . . . . . . . . . . . . . . . . . . . . . . .   27
           Linking Sheets . . . . . . . . . . . . . . . . . . . . . . . . . . .   23
           LKP, LKN, LKE Lookup Functions . . . . . . . . . . . . . . .   15, 16, 71
           Loading Saved Sheet  . . . . . . . . . . . . . . . . . . . . . . . .   25

          AnalytiCalc (PortaCalc) Reference Manual                            Page 81
          
          
          
           Locate current . . . . . . . . . . . . . . . . . . . . . . . . . . .   27
           Looping  . . . . . . . . . . . . . . . . . . . . . . . . . .   38, 47, 73
          
           M Command  . . . . . . . . . . . . . . . . . . . . . . . . . . . . .   27
           Macros . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . .   18
           Matrix Algebra . . . . . . . . . . . . . . . . . . . . . . . . .   48, 51
           MAX function . . . . . . . . . . . . . . . . . . . . . . . .   15, 16, 71
           MEMORY USE 
           MH Command . . . . . . . . . . . . . . . . . . . . . . . . . . . . .   28
           MIN function . . . . . . . . . . . . . . . . . . . . . . . .   15, 16, 71
           Mixed Relocatable Names  . . . . . . . . . . . . . . . . . . . . . .   19
           Mixed Relocation Override  . . . . . . . . . . . . . . . . . . . . .   19
           MOD Modulo function  . . . . . . . . . . . . . . . . . . . .   15, 16, 71
           Moving . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . .   27
           MS command . . . . . . . . . . . . . . . . . . . . . . . . . . . . .   28
           Multiple Equations . . . . . . . . . . . . . . . . . . . . . . .   14, 20
           Multiple Precision . . . . . . . . . . . . . . . . . . . . . . . . .   44
          
           Names  . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . .   18
           Notes  . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . .   39
           NPV (Net Present Value) Function . . . . . . . . . . . . . .   15, 16, 71
           NS command . . . . . . . . . . . . . . . . . . . . . . . . . . . . .    6
           Number Format  . . . . . . . . . . . . . . . . . . . . . . . . . . .   39
          
           OA Command . . . . . . . . . . . . . . . . . . . . . . . . . . . . .   28
           OAD and ORD vs.  OA and OR . . . . . . . . . . . . . . . . . . . . .   29
           OAD Command  . . . . . . . . . . . . . . . . . . . . . . . . . . . .   28
           Octal  . . . . . . . . . . . . . . . . . . . . . . . . . . . . .   42, 43
           OR Command . . . . . . . . . . . . . . . . . . . . . . . . . . . . .   28
           ORD Command  . . . . . . . . . . . . . . . . . . . . . . . . . . . .   28
           Origin Control Commands  . . . . . . . . . . . . . . . . . . . . . .   28
           Other Features . . . . . . . . . . . . . . . . . . . . . . . . . . .   54
           Other Functions  . . . . . . . . . . . . . . . . . . . . . .   20, 45, 48
           Output areas . . . . . . . . . . . . . . . . . . . . . . . . . . . .   67
          
           P Command 
           PARAMETER SUBSTITUTION . . . . . . . . . . . . . . . . . . . . . . .   18
           PMT Function . . . . . . . . . . . . . . . . . . . . . . . .   15, 16, 71
           Position Independent Cell Names  . . . . . . . . . . . . . . . . . .   23
           Position Independent Names . . . . . . . . . . . . . . . . . . . . .   17
           Printing Large Reports . . . . . . . . . . . . . . . . . . . . . . .   11
           protection . . . . . . . . . . . . . . . . . . . . . . . . . . . . .   67
          
           Random numbers . . . . . . . . . . . . . . . . . . . . . . . . .   16, 72
           Ranges . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . .   19
           RB COMMAND . . . . . . . . . . . . . . . . . . . . . . . . . . . . .   33
           RECALCULATE  . . . . . . . . . . . . . . . . . . . . . . . . . .    2, 31
           Recalculation  . . . . . . . . . . . . . . . . . . . . . . . . . . .   39
           Redraw Command . . . . . . . . . . . . . . . . . . . . . . . . . . .   34
           Relations  . . . . . . . . . . . . . . . . . . . . . . . . . . . . .   19
           RELOCATE BOUNDARY  . . . . . . . . . . . . . . . . . . . . . . . . .   33
           Relocation . . . . . . . . . . . . . . . . . . . . . . . . . . .    6, 22
           Replicating  . . . . . . . . . . . . . . . . . . . . . . . . . . . .    7
           RND function . . . . . . . . . . . . . . . . . . . . . . . . . .   16, 72

          AnalytiCalc (PortaCalc) Reference Manual                             Page 82
          
          
          
           Row 0 
          
           S Command  . . . . . . . . . . . . . . . . . . . . . . . . . . .    3, 62
           SAVE . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . .   35
           SC command . . . . . . . . . . . . . . . . . . . . . . . . . . . . .    6
           Scatter Plots  . . . . . . . . . . . . . . . . . . . . . . . . . . .   58
           SCRATCH FILES  . . . . . . . . . . . . . . . . . . . . . . . . . . .   67
           Scratch Storage 
           Scrolling  . . . . . . . . . . . . . . . . . . . . . . . . . . . . .    5
           Self Location  . . . . . . . . . . . . . . . . . . . . . . . . . . .   54
           Set Title  . . . . . . . . . . . . . . . . . . . . . . . . . . . . .    3
           Setting Number of Cols . . . . . . . . . . . . . . . . . . . . . . .    8
           Setting Number of Rows . . . . . . . . . . . . . . . . . . . . . . .    8
           Solving For Variables  . . . . . . . . . . . . . . . . . . . . .   52, 75
           Sorting  . . . . . . . . . . . . . . . . . . . . . . . . . .   11, 54, 75
           Sorting, by ASCII  . . . . . . . . . . . . . . . . . . . . . . .   54, 75
           Special Accumulators . . . . . . . . . . . . . . . . . . . . . . . .   41
           Special Cell Addressing  . . . . . . . . . . . . . . . . . . . . . .   18
           Special Considerations with P# and D# forms  . . . . . . . . . . . .   39
           STD (Std Deviation) function . . . . . . . . . . . . . . . .   15, 16, 71
           Subprocess Execution . . . . . . . . . . . . . . . . . . . . . . . .   37
           SUM function . . . . . . . . . . . . . . . . . . . . . . . .   15, 16, 71
           Symbolic Name Dump . . . . . . . . . . . . . . . . . . . . . . . . .   19
          
           TE Command . . . . . . . . . . . . . . . . . . . . . . . . . . . . .   33
           Temp.  Escape to Monitor . . . . . . . . . . . . . . . . . . . . . .   37
           Temporary Motion . . . . . . . . . . . . . . . . . . . . . . . . . .   21
           Temporary Move . . . . . . . . . . . . . . . . . . . . . . . . .   47, 73
           TEst Compute . . . . . . . . . . . . . . . . . . . . . . . . . . . .   33
           Text Entry . . . . . . . . . . . . . . . . . . . . . . . . . . . . .   12
           Text to Formula  . . . . . . . . . . . . . . . . . . . . . . . .    8, 12
           TITLE  . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . .    3
          
           Value Freeze . . . . . . . . . . . . . . . . . . . . . . . . . . . .   21
           Variable Names . . . . . . . . . . . . . . . . . . . . . . . . . . .   17
           VARY 
           VIEW . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . .    2
           View Command . . . . . . . . . . . . . . . . . . . . . . . . . . . .   34
           View Control . . . . . . . . . . . . . . . . . . . . . . . . . . . .   47
          
           W Command  . . . . . . . . . . . . . . . . . . . . . . . . . . . . .   34
           Windows  . . . . . . . . . . . . . . . . . . . . . . . . . . . .   10, 28
           Word Processing  . . . . . . . . . . . . . . . . . . . . . . . .   24, 28
           Writing Screen to File or Print  . . . . . . . . . . . . . . . . . .   34
          
           X Command  . . . . . . . . . . . . . . . . . . . . . . . . . . .   35, 69
           XV Command . . . . . . . . . . . . . . . . . . . . . . . . . . . . .   23
          
           ZAP Sheet Command  . . . . . . . . . . . . . . . . . . . . . . . . .   35
           ZEro Command . . . . . . . . . . . . . . . . . . . . . . . . . . . .   35

c
