**********************************************************************
C
	PROGRAM CURKED
C
C	PURPOSE:
C	   To transform a given CURVE macro (extension .MCC) to RT-11
C	   ASCII format where it can be edited with an ordinary editor,
C	   e.g. KED, EDIT, TECO, VTECO, etc.
C
C	USAGE:
C	   See file CURKED.DOC
C
C	INPUT DATA:
C	   A CURVE macro with the file name having the extension .MCC
C
C	OUTPUT DATA:
C	   - The same macro in RT-11 format in the file CURKED.TMP
C	   - The file CURKEC.COM with the form
C		RU CURKE1
C		!XXXXXX.MCC
C	     where XXXXXX.MCC is the name of the CURVE macro to be edited.
C
C	METHOD:
C	   A CURVE macro consists of 82 byte records, where the first 6
C	   characters contain the number of characters (I6 format) in
C	   the corresponding CURVE macro line excluding trailing blanks.
C	   The records have been filled to 82 ch length by adding
C	   blanks.
C
C	   The transformation to RT-11 format is made simply by removing
C	   trailing blanks and the preceding 6 character field.
C	
C	SUBROUTINES AND FUNCTION SUBPROGRAMS USED:
C	   ANS
C	   RADCO
C	   Various SYSLIB routines
C
C	DATE/AUTHOR:
C	   24-Sep-82	A. Virjo
C	   Central University Hospital of Tampere
C	   SF-33520 Tampere 52, Finland
C
C	MODIFIED G. GUELFI JUN-84
C
C
C***********************************************************************
C
	REAL*8  RFN			!Macro file name in Rad-50
	LOGICAL*1 MNAME(14)		!Macro name
	LOGICAL*1 YES,ERR		!Yes/no indicator
	LOGICAL*1 LBUF(84)		!Line buffers
C
C   Get the name of the CURVE macro to be edited
C
90	WRITE (7,100)
100	FORMAT (' CURVE macro to be edited',
	1' (without .MCC extension)? ',$)
C
	DO 85 I=1,14
85	MNAME(I)=' '
C
	READ (5,110)(MNAME(I),I=1,10)
110	FORMAT (10A1)
	DO 80 I=1,14
	IS=I
	IF (MNAME(I).EQ.' ') GOTO 81
80	CONTINUE
C
81	MNAME(IS)='.'
	MNAME(IS+1)='M'
	MNAME(IS+2)='C'
	MNAME(IS+3)='C'
C
C   Check the CURVE  macro name for correct syntax
C
	CALL RADCO(MNAME,RFN,ERR)
	IF (.NOT.ERR) GOTO 82
	CALL ITTOUR("007)	!Ring the bell
	GOTO 90
C
C   Write the name of the CURVE macro in question as a comment in the
C   command file CURKEC.COM for later use
C
 82	CALL ASSIGN (3,'SY0:CURKEC.COM')
	WRITE (3,120) (MNAME(I),I=1,14)
120	FORMAT(' RU HRT:CURKE1'/' !',14A1)
	CALL CLOSE(3)
C
C   Write the macro in RT11 format in 'CURKED.TMP'
C
	CALL ASSIGN (1,MNAME,14)		!Input file
	CALL ASSIGN(2,'SY0:CURKED.TMP',14,'NEW','CC')	!Output file
C
 20	READ(1,130,END=22,ERR=40) (LBUF(I),I=1,83)
 130	FORMAT(83A1)
C
C	MODIFIED G. GUELFI  JUN-84
C
C	PROBLEMS  OCCURRED WITH SCOPY AND TRIM IN V2.5
C
	LBUF(84) = 0
	CALL TRIM(LBUF)
	ICT = LEN(LBUF)
C	WRITE(7,136)ICT,(LBUF(I),I=7,ICT)
C136	FORMAT(//,'ICT + DATA ',I6,4(20O4,//),//)
	WRITE(2,131) (LBUF(I),I=7,ICT)
 131	FORMAT('+',82A1)	!Write without preceeding <LF>
	WRITE(2,132)		!Write a <LF> only
 132	FORMAT('$')
	GOTO 20
C
 22	CALL CLOSE(1)
	CALL CLOSE(2)
	CALL EXIT
C
C   Error branch, probably the given CURVE macro does not exist
C
40	CALL ITTOUR("007)		!Ring the bell
	WRITE (7,150)(MNAME(J),J=1,14)
150	FORMAT (/' *** CURVE macro ',14A,' does not exist.'
	@/'$     Do you want to create it (N)?	')
	CALL ANS(YES)
	IF (YES) GOTO 50
 45	CALL CLOSE(1)
	CALL CLOSE(2)
	GOTO 90
C
C   Create the missing macro by writing 2 <LF> characters
C   to the file CURKED.TMP
C
 50	CALL CLOSE(2)
	CALL ASSIGN(2,'SY0:CURKED.TMP',14,'NEW','CC')
	WRITE(2,160)
 160	FORMAT('$')
	GOTO 22
C
	END
