/*			LUN.H
 *
 *		Macro definitions for the LUN routines
 */

#include <stdio.h>
#include <cx.h>
#include <nboff.h>
#include <fdoff.h>
#include <qiottdrv.h>
#include <qiofun.h>
#include <ctype.h>

#define LUNEFN 10		/* EFN to use when doing QIO's */

extern int $$nlun;		/* number of lun's available */
extern int $$lune;		/* end of LUN table */



/*			QIOBUF
 * QUEUE an I/O request to a device. The buffer specified may be either
 * a normal 'C buffer or a LUN specification as opened with lunopn()
 * The CX library will need to be linked with the module in this is used
 * The DSW is returned.
 *
 */

#define qiobuf(f,b,e,i,a,d) (qio(f,getlun(b),e,i,a,d))


/*			QIOWBUF
 * QUEUE an I/O request to a device. Then wait for request to complete.
 * The buffer specified may be either a normal 'C buffer or a LUN specification
 * as opened with lunopn() The CX library will need to be linked with the module
 * in this is used.
 * The DSW is returned.
 *
 */
#define qiowbuf(f,b,e,i,a,d) (qiow(f,getlun(b),e,i,a,d))


/*			GETLUN
 * Find out which lun we're on, if buf<40 then the number must
 *  be a lun [no FILE would be down that low], otherwise the number
 *  would have to be a FILE *, or an error, in which case we can't
 *  tell anyway.
 *  This routine returns the LUN the file is associated with
 */
#define getlun(buf) (((unsigned)buf<40)?buf:((FDB *)(((FILE *)buf)->io_fdb))->f_lun)


/*			DEVCLS
 * This closes the device on the unit specified
 * The unit specification may be either a LUN specification or a buffer
 * specification.
 */
#define devcls(devptr)	((devptr<40)?luncls(devptr):fclose(devptr))


/*			AMAPIU
 * Returns an integer with each of its bytes being the first 2 characters
 * in the string (uppercased)
 * Typical usage is to map device names.
 */
#define amapiu(s) (_toupper(*s&255)+((_toupper(*(s+1)&255))<<8))


/*			AMAPI
 * Returns an integer with each of its bytes being the first 2 characters
 * in the string.
 * Typical usage is to map device names.
 */
#define amapi(s) ((*s&255)+((*(s+1)&255)<<8))


/*			ONESC
 * returns the one's compliment of a word.
 * usage: x=onesc(word)
 * This is used when an error is indicated by the high bit of a word, in
 * getting the absolute result.
 * all this macro does is TOGGLE the high bit of a word
 */
#define onesc(word) (word^0100000)


/*			ONEABS
 * returns the absolute value of a one's compliment word
 * usage: x=oneabs(word)
 * This is used when an error is indicated by the high bit of a word, in
 * getting the absolute result.
 * all this macro does is RESET the high bit of a word
 */
#define oneabs(word) (word&0100000)

