/*
 *			g e t 1 . c
 */

/*)LIBRARY
*/

#ifdef DOCUMENTATION

title	get1	Get a Sanitary Character Input
index		get a sanitary Character input

synopsis

	int
	get1(row,col)
	 int row;	/* row to get it at */
	 int col;	/* column to get it at */

description

	get1() awaits a sanitary character input, followed by '\r'
	do not return until something is seen before '\r'
	Returns the character typed before '\r', or the function
	key pressed.

bugs

author

	Machiavelli Systems

#endif

#include "vt100.h"
#include "symbols.h"



int	get1(row,col)
int	row;		/* where on screen to await input */
int	col;
{
	int	c;		/* the terminating character */
	char	buf[2];		/* the buffer that input is being put */

	/* clear out the buffer */
	zero(buf,2);

	/* loop arround until somthing sanitary is input */
	while	(TRUE) {

		/* get the character */
		c = getbuf(buf,1,row,col);

		/* if it is good, then exit */
		if (c<0 || c==ABORT || (c=='\r'&&*buf))
			break;

		/* otherwise beep & try again */
		zbeep();
	};

	/* if a return was used to exit, then return the buffer, otherwise return the function key or ABORT */
	return(c=='\r'?*buf:c);

}
