/*
 *			g e t q l i t . c
 */

/*)LIBRARY
*/

#ifdef DOCUMENTATION

title	getqli	Get Qouted Literal
index		get Quoted literal

synopsis

	int
	getqlit(ccp, dest)
	 char **ccp;	/* pointer to buffer pointer */
	 char *dest;	/* pointer to destination buffer */

description

	Getqlit relies on the data being in the following format:
		<Quoted-string><String><Quoted-string>......
	where there are no white chars in the unquoted string.
	The data is teminated by: 1) ENDSTRING
				  2) Any white character.
	Destination buffer will contain the quoted literals, (including
	quotes).
	 eg. "lit1""lit2""lit3"0\.

bugs

author

	Machiavelli Systems

#endif

#include "symbols.h"




getqlit(ccp, dest)
char **ccp;
char *dest;
{
	/* loop arround looking for the end of the string | a whitespace */
	while (!iswhite(**ccp) && **ccp!='\n' && **ccp!=ENDSTRING) {

		/* if we find a quote, then put one in the destination string */
		/* and place the quoted text into the destination. end the    */
		/* section of quoted text, with a quote 		      */
		if (**ccp = QUOTEMARK ) {
			*dest++ = QUOTEMARK;
			getqtext(ccp,dest);
			scrape(&dest);
			*dest++=QUOTEMARK;
		};

		/* move the pointer up, until we get the next peice of quoted text */
		while (**ccp != QUOTEMARK) {
			if (iswhite(**ccp)||**ccp == '\n' || **ccp == ENDSTRING )
				break;		/* quoted stuff */
			*dest++ = *(*ccp)++;
		};
	};

	/* must end the string with a null */
	*dest = ENDSTRING;
}

