/*
 *			g e t n u m . c
 */

/*)LIBRARY
*/

#ifdef DOCUMENTATION

title	getnum	Get a Number From Screen
index		Get a number from screen

synopsis

	int
	getnum(row,col,mess)
	 int row;	/* row to put message */
	 int col;	/* column to put message */
	 char *mess;	/* message to be displayed */

description

	getnum() positions the cursor a the specified position, displays
	a message, and accepts input. Input must be numeric, and editing
	is available. See edtbuf() for details on editing.
	The input is returned, or 0 for ESCAPE.

bugs

author

	Machiavelli Systems

#endif

#include "vt100.h"
#define ZGETNUM 7		/* length of users answer + 1 */



int	getnum(row,col,mess)
int	row;			/* row to put it */
int	col;			/* column to put it */
char	*mess;			/* message to put */
				/* return 0 if [ESC]ape else await <number>[RETURN] */
{

	int	retval;		/* what we return to the user */
	int	c;		/* what the user uses to end input */
	char	buf[ZGETNUM];	/* where to put the input */

	/* initialize the return value */
	retval = -1;

	/* loop arround until the user does somthing right */
	while	(retval<0)
	{

		/* position the cursor, and display the message */
		zsrowcol(row,col);		/* put the cursor */
		zsputs(mess);			/* put the message */

		/* clear out the input buffer */
		zero(buf,ZGETNUM);

		/* get the input into the buffer */
		c = getbuf(buf,ZGETNUM-1,row,col+strlen(mess));

		/* if we have ABORT, then retrun 0 */
		if (c==ABORT) {
			retval = 0;
		} else {

			/* if we have a good input, the return the input */
			if (c=='\r' && isdigit(*buf)) {
				retval = atoi(buf);

			/* otherwise beep & try again */
			} else {
				zbeep();
			};
		};
	};

	/* get out of here */
	return(retval);
}
