/*
 *			GETANGLE
 */

/*)LIBRARY
*/


#ifdef DOCUMENTATION

title	getangle	Finds angle between origin and (x,y) coordinates
index			Finds Angle Between Origin and (x,y) Coordinates

SYNOPSIS:

	double	getangle(xorigin, yorigin, x_pt, y_pt)
	 double	xorigin;
	 double yorigin;
	 double x_pt;
	 double y_pt;

DESCRIPTION:
                                                                                                        
	Determines the angle of the vector (xorigin,yorigin) given 
	a set of x and y coordinates.
	The angle returned is in radian measure.

BUGS:

AUTHOR:

	Machiavelli data systems

#endif



#define	PI	3.1415927
#define	PION2	PI / 2.0

double	getangle(xorigin, yorigin, x_pt, y_pt)
double	xorigin, yorigin, x_pt, y_pt;
{
	double	dx, dy, ret_val, angle();

	dx = x_pt - xorigin;					/* calc. the differences in the x's */
	dy = y_pt - yorigin;					/* calc. the differences in the y's */

	if (dx != 0.0)
		ret_val = angle(dx, dy);			/* not vertical */
	else {
		if (dy > 0.0)
			ret_val = PION2;			/* vertically upwards */
		else
			ret_val = 3.0 * PION2;			/* vertically downwards */
	};

	return(ret_val);
}
