/*
 *			f s i z e . c
 */

/*)LIBRARY
*/

#ifdef DOCUMENTATION

title	fsize	Get File Size in Bytes
index		get file Size in bytes

synopsis

	long
	fsize(ioptr)
	 FILE *ioptr;	/* file to be looked at */

description

	fsize() returns the file size, in bytes, of the specified file.

bugs

author

	Machiavelli Systems

#endif

#define _production

#include <stdio.h>
#include <cx.h>
#include <nboff.h>
#include <fdoff.h>

#define	FDBOFF	024		/* where the fdb really is in FILE struct */




long fsize(ioptr)		/* return file size in bytes */
char *ioptr;
{
	FDB *fdbp;	/* pointer to the file descriptor block */
	long efbk;	/* end file block */
	unsigned ffby;	/* first free byte in last block */

	/* point the users fbd at the correct place */
	fdbp = ioptr + FDBOFF;

	/* get the last block, and the first free byte in last block */
	efbk = fdbp->f_fatt.f_efbk;	/* 1-org eof block # */
	ffby = fdbp->f_fatt.f_ffby;	/* first free byte number 0-org */

#ifndef _production
	printf("fsize:ioptr=%oo fdbp=%oo\n",ioptr,fdbp);
	memdmp(ioptr,ioptr+0200);
	printf("fsize:ffby=%oo efbk=%loo\n",ffby,efbk);
#endif

	/* convert the data to bytes, and return */
	return(ffby + (efbk-1)*512);

}

