/*
 *			DISTANCE
 */

/*)LIBRARY
*/

#ifdef DOCUMENTATION

title	distance	find the distance between two points 
index			Find the Distance Between Two Points 

SYNOPSIS:
	
	double distance (x1, y1, x2, y2)
	 double x1;		/* X and Y coordinates 
	 double y1;		   of the first point  */
	 double x2;		/* X and Y coordinates
	 double y2;		   of the second point */

DESCRIPTION:

	This routine finds the distance between (x1, y1) and (x2, y2)
	given the coordinates as parameters in their respective order.

BUGS:

AUTHOR:

	Design aids data services

#endif




double	distance(x1, y1, x2, y2)
double	x1, y1, x2, y2;
{
	double	dis, dsqrt(), dx, dy;

	dx = x2 - x1;
	dy = y2 - y1;
	dis = dsqrt( (dy * dy) + (dx * dx) );

	return(dis);
}
