/* ebcdmp.c - convert each byte in file from ebcdic to ascii
   then dump the record in ebcdic(ascii actually) and hex */

/*
 * history
 *
 *	this used to be modelled on ufilter2.c, which uses stdin.
 *	but stdin proved to eliminate nulls in fget() . WHY??!!
 *	so I changed it to ufilter.c model, which honours record lengths.
 *
 *	released as 2ascii.c
 *
 *	bent to ebcdmp.c - dump program since RSX DMP has no /ebcdic switch
 */

#include <stdio.h>
#include <algol68.h>
#include <cx.h>
#include <ascii.h>

#define BUFSIZ 4096
char buffer[BUFSIZ];
FILE	*inf;
extern int $dsw;
extern int $$ferr;

char	* p;		/* tracks each char in record			*/
char	* nd;		/* marks end of record				*/
int	record;		/* 0-org record number of this record		*/
char	* dmpnd;	/* dump end : when to stop dumping 1 line	*/
char	* q;		/* track along bytes of a dump line		*/

main(argc,argv)
char **argv;
BEGIN
register int	howlong;	/* char length of this record */
	IF	((inf=fopen(argv[1],"ur"))==NULL)
	THEN	error("can't find %s\7\n",argv[1]);
	FI;
	WHILE	(!feof(inf))
	DO	howlong = fget(buffer,BUFSIZ,inf);
		IF	(ferror(inf))
		THEN	error("read failure $$ferr=%oo\7\n",$$ferr);
		FI;
		IF	(feof(inf))
		THEN	break;
		FI;
		nd = buffer + howlong;
		FOR	(p=buffer;	p<nd;	p+=16)
		DO	dmpnd = min(p+16,nd);
			ebcdmp();
			hexdmp();
		OD
		record++;
	OD;
END

hexdmp()
BEGIN
	start();
	FOR	(q=p;	q<dmpnd;	q++)
	DO	printf(" %02x ",*q&0xFF);
	OD
	stop();
END

ebcdmp()
BEGIN
int	c;

	start();
	FOR	(q=p;	q<dmpnd;	q++)
	DO	c = ascii[*q&0xFF];
		putchar(c&0x80?'\'':' ');
		c &= 0x7F;
		IF	(c==0x7F)
		THEN	printf("DL");
		ELSE	IF	(c<' ')
			THEN	putchar('^');
				c += 64;
			ELSE	putchar(' ');
			FI;
			putchar(c);
		FI
		putchar(' ');
	OD
	stop();
END

start()
BEGIN
	printf("%04x %04x",record,p-buffer);
END

stop()
BEGIN
	putchar('\n');
END

/* end: ebcdmp.c */
