/* meter.c - tell me when to feed my parking meter			*/
/* METER minutes message							*/
/* after 'minutes' minutes, will BROadcast 'message' to the terminal that
   ran METER								*/
/* I use BRO rather that QIOW$ IO_WBT with timeout because BRO is
   priviledged and tracks RSX, while my hack would just imitate BRO and
   possibly be out of date with the next RSX.				*/
/* ideas: make it understand absolute time as well as 'n' minutes from
   now									*/

#include <stdio.h>
#include <algol68.h>
#include <cx.h>
#include <qiofun.h>
#include <qioret.h>
#include <qiottd.h>
#include <spcio.h>

extern int $dsw;
#define LUN 4
#define EFN 4

char	message[300];	/* the message to broadcast			*/
int	minutes;	/* number of minutes to wait before BRO		*/

main(argc,argv)
int	argc;
char	**argv;
BEGIN
int		a;	/* counts arguments on command line		*/
	IF	(argc<2)
	THEN	fprintf(stderr,"usage METER nm mess\n");
		fprintf(stderr,"nm: number  of minutes to wait before BRO\n");
		fprintf(stderr,"mess: message to BRO to your terminal after waiting\n");
		fprintf(stderr,"This frob is to help you to remember to feed your parking meter\n");
		exit();
	FI;
	sprintf(message,"BRO TT%o: ",wotttn());
	strcat(message,"\7METER - ");
	FOR	(a=2;	a<argc;	a++)
	DO	strcat(message," ");
		strcat(message,argv[a]);
	OD;
	strcat(message,"\033");
	sscanf(argv[1],"%d",&minutes);
	mrkt(EFN,minutes,3,0);
	check("MRKT");
	wtse(EFN);
	check("WTSE");
	cspawn("mcr...",message,EFN);
	exit();
END

check(directive)
char * directive;
BEGIN
	IF	($dsw!=IS_SUC)
	THEN	error("\7%s $dsw=%oo",directive,$dsw);
	FI;
END

wotttn()	/* return the terminal number from a get lun qio */
{
 int	table[6];	/* the data */
 int	dsw;		/* directive status word */

 /* attach TI: so we can feel it */

 if	(alun(LUN,'TI',0)!=IS_SUC)	error("alun: $dsw=%oo\7\n",$dsw);

 /* get lun information */

 dsw = glun(LUN,table);
 if	(dsw<0)	printf("lun=%oo table=%oo dsw=%oo\n",LUN,table,dsw);
 return(table[1]&0xFF);
}

/* end: METER.c */
