#define debug
/* ff2lf.c - turns form-feeds into line-feeds */
#include <stdio.h>
#include <algol68.h>

#define BUFSIZ 4096
char buffer[BUFSIZ];

int	line_in_page;
int	lines_per_page;
int	c;

usage(gripe)
char	* gripe;
BEGIN
	fprintf(stderr,"\7%s\n",gripe);
	fprintf(stderr,"\n");
	fprintf(stderr,"Usage: FF2LF <in >out {lines/page}\n");
	fprintf(stderr,"Turns form-feeds into correct number of line-feeds.\n");
	fprintf(stderr,"Assumes 66 lines/page unless told otherwise.\n");
	exit(IO_WARNING);
END

main(argc,argv)
int	argc;
char **	argv;
BEGIN
	IF	(argc>2)
	THEN	usage("I expect at most ONE argument");
	FI
	IF	(argc==2)
	THEN	sscanf(argv[1],"%d",&lines_per_page);
		IF	(lines_per_page<=0)
		THEN	usage("Lines_per_page must exceed 0");
		FI
	ELSE	lines_per_page = 66;
	FI
	lines_per_page -= 1;	/* maths is 0-origin, english 1-origin */
	line_in_page = 0;
	WHILE	((c=getchar())!=EOF)
	DO
#ifdef debug
fprintf(stderr,"\t\tc=%oo\n",c);
#endif
		IF	(c=='\f')
		THEN	WHILE	(line_in_page<lines_per_page)
			DO	putchar('\n');
				line_in_page++;
#ifdef debug
fprintf(stderr,"LF\n");
#endif
			OD
			line_in_page = 0;
		ELSE	IF	(c=='\n')
			THEN	line_in_page++;
			FI
			putchar(c);
#ifdef debug
fprintf(stderr,"%oo\n",c);
#endif
		FI
	OD
END
/* end: ff2lf.c */
