/* clean.c - remove nasty characters like '\f' from a text file */

/*
 *	This is used to clean up eg PIP/TB output files which have
 *	embedded ^Ls, ^@s etc that we just want to go away.
 *	With PIP/TB you get a formfeed in the first line ONLY.
 *	One day Unix will be free, until then use clean.
 */

/* ufilter4.c - prototype filter program - line (actually record) oriented */
/*
 * Modular, fast, record filter skeleton.
 * Forces FD.CR on output file.
 * Gets file names from argv[1],[2]. Too hard to use stdin,stdout.
 * The record has NOTHING (like free '\n's) added to it.
 * Howlong = the record size in bytes.
 * Designed for R.VAR files.
 */

#include <stdio.h>
#include <algol68.h>
#include <cx.h>
#include <nboff.h>
#include <fdoff.h>
char *	buffer;		/* where the buffer is				*/
int	bufmax;		/* maximum record size, needed for recinp()	*/
FILE	*inf;		/* input file					*/
FILE	*ouf;		/* output file					*/
FDB *	fdbp;		/* obsolete kludge				*/
int	howlong;	/* char length of this input record		*/
char *	p;		/* scan input buffer				*/
char *	emit;		/* output buffer				*/
char *	q;		/* scan output buffer				*/
char *	n;		/* 'end' points just after end of input buffer	*/
char	c;		/*						*/

main(argc,argv)
char **argv;
BEGIN
char *	recinp();	/* the record-getter: 0 means end-of-file	*/

	IF	((inf=fopen(argv[1],"urn"))==NULL)
	THEN	error("can't find %s\7",argv[1]);
	FI
	fdbp = inf -> io_fdb;
	IF	(!(buffer=malloc(bufmax=fdbp->f_fatt.f_rsiz)))
	THEN	error("max record size=%d.\7",bufmax);
	FI
	IF	(!(emit=malloc(bufmax)))
	THEN	error("MAX record size=%d.\7",bufmax);
	FI

	IF	((ouf=fopen(argv[2],"uwn"))==NULL)
	THEN	error("can't make %s\7",argv[2]);
	FI
	fdbp = ouf -> io_fdb;
	fdbp -> f_fatt . f_ratt |= fd_cr;	/* force fd.cr		*/

	/*
	 * this is the simple logic:
	 */

	WHILE	(recinp(buffer,bufmax,inf,&howlong))
	DO	FOR	(p=buffer,q=emit,n=buffer+howlong; p<n; p++)
		DO	c = *p & 0xFF;
			IF	(c=='\n')
			THEN	recout(emit,q-emit,ouf);
				q = emit;
			ELSE	IF	( isprin(c) || c=='\t' )
				THEN	*q++ = c;
				FI
			FI
		OD
		recout(emit,q-emit,ouf);
	OD

	/*
	 * easy wasn't it?
	 */

	IF	(fclose(ouf))
	THEN	error("Can't close\7");
	FI
END

char * recinp (where,moby,sewer,lenp)	/* 0==end-file, else buf adr	*/
char *	where;				/* buffer			*/
int	moby;				/* buffer size			*/
FILE *	sewer;				/* input file			*/
int *	lenp;				/* return actual record size	*/
BEGIN
	*lenp = fget(where,moby,sewer);
	IF	(ferror(sewer))
	THEN	error("read failure $$ferr=%oo\7\n",$$ferr);
	FI
	return	(feof(sewer)?NULL:where);
END

recout(where,len,sewer)
char *	where;		/* buffer					*/
int	len;		/* record size					*/
FILE *	sewer;		/* output file					*/
BEGIN
	fput(where,len,sewer);
	IF	(ferror(sewer))
	THEN	error("write failed $$ferr=%oo len=%d.\7\n",$$ferr,len);
	FI
END
/* end: ufilter4.c */

/* end: clean.c */
