/*
 * print files with a margin (i.e. spaced across, hence the name)
 */
#include <stdio.h>
#define PRINTER "TT6:"

main (argc, argv)
int argc;
char **argv; {
	int i, margin, arg;
	FILE *file, *printer;
	char buffer [133], spaces [133];
	margin = 8;		/* default margin is 8 */
	if (argc < 2) {		/* no files or margin, so say how we work */
		printf ("Useage: %s {margin} {*printer} file(s)\n", *argv);
		printf ("\tWrites file(s) to printer (default TT6:) indented margin (default 8)\n");
		exit (0);
	}			/* get the printer, complain if we can't */
	if ((printer = fopen (PRINTER, "w")) == NULL) {
		fprintf (stderr, "?%s -- Can't open printer %s", *argv, PRINTER);
		exit (0);
	}
	arg = 1;		/* look at first argument */
	if (isdigit (*argv [arg])) { /* if numeric, use it as a margin */
		margin = atoi (argv [arg]);
		if (margin < 0 || margin >= sizeof (spaces)) {
			fprintf (stderr, "?%s -- margin not between 0 and %d\n",
				*argv, sizeof (spaces) - 1);
			exit (0); /* margin would cause crash */
		}
		++arg;
	}
	for (i = 0; i < margin; ++i) {
		spaces [i] = ' ';
	}
	spaces [margin] = EOS;
	while (arg < argc) {
		if (*argv [arg] == '*') {
			fclose (printer);
			if ((printer = fopen (&argv [arg] [1], "w")) == NULL) {
				fprintf (stderr, "?%s -- Can't open printer %s\n",
					*argv, &argv [arg] [1]);
				exit (0);
			}
		} else {
			if ((file = fopen (argv [arg], "r")) == NULL) {
				fprintf (stderr, "%%%s -- Can't open file %s\n",
					*argv, argv [arg]);
			} else {
				while (fgets (buffer, sizeof (buffer), file)) {
					fputs (spaces, printer);
					fputs (buffer, printer);
				}
				fclose (file);
			}
		}
		++arg;
	}
	fclose (printer);
}
