/* b2t.c: write a R.VAR file to tape */
/* format of input file is 1 record :: 1 tape block */
/* a 0-length input record causes a tape-mark to be written */
#include <stdio.h>
#include <cx.h>
#include <qiofun.h>
#define EFN 1
#define LUN 6
#define BUFSIZ 4096
char		b[BUFSIZ];
helpless()
{puts("usage: B2T inputfile MTn");
 puts("copies inputfile to MTn:");
 puts("inputfile is normally attributed R.VAR");
 puts("each record of inputfile maps to one tape record");
 puts("an empty input record writes as a tape mark");
 exit();
}
main(argc,argv)
char **argv;
{unsigned	u;
 int		ids;		/* directive status word */
 int		isb[2];		/* qio status block */
 int		i;
 FILE		*ioptr;
 unsigned	got;
 char		dnam[3];	/* magtape device name (ASCII) */
 int		dnum;		/* magtape unit number */
 int		dev;		/* word-aligned device name */
 int		dsw;		/* directive status word */
 if	(argc==0)
	{helpless();
	}
 ;
 if	(strlen(argv[2])!=3 || !isdigit(argv[2][2]))
	{puts("\7Second Argument must be EXACTLY ddn");
	 helpless();
	}
 ;
 copy(dnam,argv[2],2);
 dnum=argv[2][2]-'0';
 dev = toupper(dnam[1])<<8 | toupper(dnam[0]);
 dsw=alun(LUN,dev,dnum);
 if	(dsw!=IS_SUC)
	{error("\7Can't attach to %s dsw=%o",argv[2],dsw&0xFF);
	}
 ;
 if	((ioptr=fopen(argv[1],"ru"))==NULL)
	{error("Can't find file \"%s\"",argv[1]);
	}
 ;
/* if	(ioatt(LUN,EFN,isb,&ids)!=IS_SUC)
	{error("\7Can't attach magtape ids=%oo\n",ids);
	}
 ;
*/
 while	(!feof(ioptr))
	{got=fget(b,BUFSIZ,ioptr);
	 if	(ferror(ioptr))
		{error("Read error");
		}
	 ;
/*	 printf("got=%d.\n",got);
	 for	(u=0;	u<got;	u++)
		{printf("%02x  ",b[u]&0xFF);
		}
	 ;
	 putchar('\n');
*/
	 if	(got)
		{i=wmtrec(LUN,got,b,EFN,isb,&ids);
		 if	(ids!=IS_SUC || isb[0]!=IS_SUC)
			{error("\7Can't write record ids=%oo isb[0]=%oo",ids,isb[0]);
			}
		 ;
		}
	 else
		{i=weofm(LUN,EFN,isb,&ids);
		 if	(ids!=IS_SUC || isb[0]!=IS_SUC)
			{error("\7Can't write tape mark ids=%oo isb[0]=%oo",ids,isb[0]);
			}
		 ;
		}
	 ;
	}
}
int wmtrec(lun,bufsiz,buf,efn,isb,ids)	/* write a magtape record */
int	lun;		/* lun MT: lives on */
int	bufsiz;		/* buffer size for QIO */
char	*buf;		/* buffer to write data from */
int	efn;		/* event flag number to use */
int	isb[2];		/* i/o status block for qiow$ */
int	*ids;		/* directive status word returned */
{
 int	prl[6];		/* parameter block for qiow$ */
 int	noast;		/*			 */
 int	qiow();
 noast=0;
 prl[0]=buf;
 prl[1]=bufsiz;
 *ids=qiow(IO_WLB,lun,efn,isb,noast,prl);
 return (*ids);
}
int weofm(lun,efn,isb,ids)	/* write a magtape tape mark */
int	lun;		/* lun MT: lives on */
int	efn;		/* event flag number to use */
int	isb[2];		/* i/o status block for qiow$ */
int	*ids;		/* directive status word returned */
{
 int	prl[6];		/* parameter block for qiow$ */
 int	noast;		/*			 */
 int	qiow();
 noast=0;
 return ( *ids=qiow(IO_EOF,lun,efn,isb,noast,prl) );
}
int ioatt(lun,efn,isb,ids)
int	lun;
int	efn;		/* event flag number to use */
int	isb[2];		/* i/o status block for qiow$ */
int	*ids;		/* directive status word returned */
{
 int	prl[6];		/* parameter block for qiow$ */
 int	noast;		/*			 */
 int	qiow();
 noast=0;
 *ids=qiow(IO_ATT,lun,efn,isb,noast,prl);
 return (*ids);
}
