/* fsfui.c - Field Scan Forwards Until In */

#ifdef	DOCUMENTATION
title	fsfui()	Field Scan Forward Until In set
index	Scan
index	Set
index	Field
synopsis

	 char * inbuf;	/* input buffer */
	 int	inlen;	/* length of inbuf */
	 char *	outbuf;	/* output buffer */
	 int	outlen;	/* length of outbuf */
	 char set[] = { "chars to skip" };

	 fsfui(inbuf,inlen,outbuf,outlen,set);

description

	After Data General's "byte move until ..." instructions.
	Fsfui() will scan a pointer along a buffer until it encounters
	a character which is part of set[]. As for DG, if you want a '\0'
	as part of the set, include it as the FIRST character of the
	set, which must still end with a '\0'.

	As for FN???? FS???? routines, the strings may contain '\0's
	and have fixed lengths. This is not UNIX compliant, but very
	useful for binary data.

internal

	Uses icsp().

author

	Dean Elsner.
#endif

/*
 *		E D I T   H I S T O R Y
 *
 * ??-???-?? DLE	Create, on CP/M(Sic(k)) for Simat.
 * ??-???-?? DLE	Install on several little grey doorstops.
 * 10-Aug-85 DLE	Exhume for acts against the order of nature @ MLS.
 */

#include	<algol68.h>

fsfui(inbuf,inlen,outbuf,outlen,set)	/* field scan forward until in */
				/* skip leading characters from given set */
char		*inbuf;		/* address of input buffer */
int		inlen;		/* size of input buffer */
				/* output buffer is right subset of input
				   buffer found by skipping over chars in set */
char		**outbuf;	/* returns address of first char of subbuffer */
int		*outlen;	/* returns length of subbuffer (may be 0) */
char		*set;		/* set of characters that are skippable */
BEGIN
int		icsp();		/* return TRUE if char is in set */

				/* next () are for a C(sic) compiler */
	WHILE	(((inlen--)!=0) & !icsp(*inbuf++,set))
	DO
	OD
	*outlen = ++inlen;
	*outbuf = --inbuf;
END

/*
 *	Trap for fast players.
 *
 *	If you replace the & in the WHILE clause above with && then you
 *	will goof up in the case where inlen is decremented to zero,
 *	because you will not increment inbuf in sync with inlen for
 *	the last execution of the WHILE clause.
 *	This will cause much agony for the poor user of this subroutine!
 *
 *	(signed) a Chastened Programmer.
 */

/* end: fsfui.c */
