/* sec.c - test IO.SEC with RX02 */

/*
 * IO_SEC:	returns u.cw2 of UCB in 2nd isb word.
 *		bits of u.cw2 defined at top of [11,10]DYDRV.MAC
 *		Usually, 0 = single density, 4000(8.) = double density
 *		so 04000 is the "DENS" bit.
 *
 *	Normal return: dsw=1 isb=1,{0/04000}
 */

#include	<algol68.h>
#include	<stdio.h>
#include	<cx.h>
#include	<qiofun.h>
#include	<spcio.h>

#define ERROR -1
#define LUN 4
#define EFN 4

static	FILE	*iptr;		/* input file */
static	FILE	*optr;		/* output file */
static	int	prl[6];		/* QIO parameter block */
static	int	isb[2];		/* I/O status block */
static	int	dsw;		/* directive status word */
#define 	BINSIZ 1024	/* maximum binary record size */		/*pf04*/
static	char	binbuf[BINSIZ];	/* binary record from o/s */			/*pf04*/
static	unsigned binlen;	/* size of binary record in binbuf */		/*pf04*/
static	char *	binptr;		/* next char of binbuf to send to caller */	/*pf04*/
static char	name[45];	/* holds files-11 compatible file name */	/*pf05*/


main()
BEGIN
int	devnam;
int	devunt;

	devnam = 'DY';
	devunt = 0;
	dsw = alun(LUN,devnam,devunt);
	IF	(dsw!=IS_SUC)
	THEN	error("Can't attach device! dsw=%oo devnam=%oo devunt=%oo",dsw,devnam,devunt);
	FI
	dsw = qiow(IO_ATT,LUN,EFN,isb,0,prl);
	IF	(dsw!=IS_SUC||(isb[0]&0xFF)!=IS_SUC)
	THEN	error("dsw=%oo isb[0]=%oo isb[1]=%oo \7IO_ATT",dsw,isb[0],isb[1]);
	FI

	prl[0] = 0;	/* RX01 density: 3740 standard */
/*	dsw = qiow(IO_SMD,LUN,EFN,isb,0,prl);
	IF	(dsw!=IS_SUC||(isb[0]&0xFF)!=IS_SUC)
	THEN	error("dsw=%oo isb[0]=%oo isb[1]=%oo \7IO_SMD",dsw,isb[0],isb[1]);
	FI
*/
	dsw = qiow(IO_SEC,LUN,EFN,isb,0,prl);
	printf("dsw=%oo isb=%oo%oo\n",dsw,isb[0],isb[1]);
END
