/* RMS180.H	- include me for on-disk structs of RMS v1.8 onwards
 *
 * 15Apr85 DLE	create, using DECUS RMS internals paper by Phil
 *		Stevenson-Payne dated October 1980.
 *
 */

struct	rmsakd			/* RMS-11 Alternate Key Descriptor		*/
				/* not a DEC mnemonic or concept		*/
{				/*						*/
long		k_n_vb;		/* virtual block number of next key descriptor	*/
				/* 0 means there is no next descriptor block	*/
unsigned	k_nbyt;		/* byte position (this block) of next descriptor*/
				/* 0 means we must use a fresh block for next	*/
				/* descriptor, the (non-zero) vbn is k_nlvb	*/

			/* a zero k_nlvb with a zero k_nbyt means this is the	*/
			/* last key descriptor block				*/

char		k_ian;		/* index area number				*/
char		k_lan;		/* low level index area				*/
char		k_dan;		/* data area number				*/
char		k_lvl;		/* root index level				*/
char		k_ibks;		/* index bucket size				*/
char		k_dbks;		/* data bucket size				*/
long		k__vbn;		/* root bucket vbn				*/
				/* before initialising (izing for yanks) this	*/
				/* holds k_dan;k_ian;k_lan;0	(WHY??)		*/
char		k_flgs;		/* flags					*/
				/* see rms200.h for XB$DUP, XB$CHG, XB$NUL,	*/
				/* XB$INI					*/
char		k_dtp;		/* key data type				*/
				/* definitions exist in rms200.h for XB$STG,	*/
				/* XB$IN2, XB$BN2, XB$IN4, XB$BN4, XB$PAC	*/
char		k_nseg;		/* number of key segments			*/
char		k_null;		/* null key char				*/
char		k_kysz;		/* total key size				*/
char		k_key;		/* key of reference				*/
unsigned	k_minl;		/* minimum possible record length		*/
unsigned	k_ifil;		/* index bucket fill quantity (bytes)		*/
unsigned	k_dfil;		/* data bucket fill quantity (bytes)		*/
unsigned	k_pos[8];	/* key segment positions			*/
char		k_siz[8];	/* key segment sizes				*/
char		k_knm[32];	/* key name					*/
long		k__dvb;		/* 1st data bucket virtual block number		*/
int		k_unk1[7];	/* spare					*/
};

struct	rmspro			/* prologue block - 1st 512 bytes		*/
				/* actual prologue block will be 1 bucket long	*/
				/* doesn't exist for sequential files		*/
				/* relative file prologue is subset of indexed	*/
				/* file's prologue, which this describes	*/
{				/*						*/
struct	rmsakd	k_pkd;		/* Primary Key Descriptor			*/
				/* not a DEC mnemonic or concept		*/
char		k_avbn;		/* 1st area descriptor block start VBN		*/
				/* Area descriptors always follow Key descripts	*/
				/* and so the first must be 1<VBN<54		*/
char		k_amax;		/* 1 + number of areas				*/
int		k_unk2[6];	/* spare					*/
int		k_vern;		/* version number of this prologue		*/
int		k_unk3[196];	/* spare					*/
unsigned	k_cksm;		/* not a DEC symbol. files-11 checksum of this	*/
				/* block: viz low 16 bits of sum of previous	*/
				/* words					*/
};

struct	rmspr2			/* alternate key prologue block			*/
				/* not a DEC mnemonic or concept		*/
{				/*						*/
struct rmsakd	k_akp[5];	/* not a DEC menmonic or concept		*/
unsigned	k_acksm;	/* not a DEC symbol. files-11 checksum of this	*/
				/* block: viz low 16 bits of sum of previous	*/
				/* words					*/
};

struct	rmsard			/* on-disk area descriptor			*/
{				/*						*/
char		a_fill;		/* for 1st ARD in block, holds RMS standard	*/
				/* check char					*/
char		a_flg;		/* flags (no known use)				*/
char		a_aid;		/* area number					*/
char		a_bkz;		/* bucket size					*/
unsigned	a_vol;		/* relative volume number (not implemented)	*/
char		a_aln;		/* alignment options				*/
				/* RMS200.H has XB$RFI, XB$VBN, XB$LBN, XB$CYL	*/
char		a_aop;		/* allocation options				*/
				/* RMS200.H has XB$CTG, XB$HRD			*/
long		a_avl;		/* first available returned bucket		*/
long		a_cvb;		/* current extents's start VBN			*/
long		a_cnb;		/* blocks in current extent			*/
long		a_nus;		/* blocks used so far in current extent		*/
long		a_nvb;		/* next unused VBN in current extent		*/
long		a_nxt;		/* next extent start VBN			*/
long		a_xby;		/* number of blocks in next extent		*/
unsigned	a_deq;		/* default extend allocation			*/
unsigned	a_unk1;		/* unknown - think control flags here		*/
long		a_loc;		/* allocation starting point			*/
unsigned	a_rfi[3];	/* related file FID				*/
unsigned	a_unk2[6];	/* unknown - presumed spare			*/
unsigned	a_crc;		/* for last area descriptor in a block, holds	*/
				/* RMS standard check character	in high byte	*/
};


struct	rmsbkh			/* general bucket header			*/
				/* not a DEC mnemonic or concept		*/
{				/*						*/
char		b_chk;		/* check character				*/
				/* must equal last byte of bucket - else we	*/
				/* only wrote half a bucket hence we panic	*/
char		b_taa;		/* area number					*/
				/* are we in right solar system	?		*/
unsigned	b_adr;		/* low order bits of this block's VBN		*/
				/* are we on right planet?			*/
unsigned	b_nby;		/* next available byte in bucket 0-origin	*/
char		b_nid;		/* next record ID				*/
char		b_lid;		/* last ID in Range				*/
long		b_nbk;		/* next bucket (at this level) VBN		*/
				/* if it points to this bucket, there is no	*/
				/* next bucket at this level			*/
char		b_lev;		/* bucket level number				*/
				/* I DON'T UNDERSTAND THIS ONE - PLEASE HELP	*/	/* !!!!!!!! */
char		b_bcb;		/* bucket control bits				*/
				/* RMS200.H has BC$ROT, BC$LBK			*/
};


/*******************************************************************************\
*										*
*		WARNING: this structure is byte aligned !!			*
*										*
\*******************************************************************************/
struct	rmsibr			/* Index Bucket Record				*/
				/* not a DEC mnemonic				*/
				/* applies to data buckets, except a data entry	*/
				/* has whole record rather than key value	*/
{				/*						*/
char		b_ircb;		/* low 2 bits specify length of b_bptr		*/
				/* length is (value)+2 bytes			*/
				/* RMS200.H defines IC$KCP, IC$EMP, IC$NUL	*/
char		b_bptr[0];	/* bucket pointer (a VBN)			*/
/*			*/	/* a key value (At least ONE byte) follows here	*/
};

/*******************************************************************************\
*										*
*		WARNING: this structure is byte aligned !!			*
*										*
\*******************************************************************************/
struct	rmsrrv			/* record reference vector			*/
{				/*						*/
char		b_drcb;		/*						*/
};				/* don't understand this struct!		*/

/* end: rms180.h */
