NAMES.                
NAMES.
HEAP.MAC
ZTRIK.MAC
ZT01.MAC
ZT02.MAC
ZT03.MAC
ZT04.MAC
ZT05.MAC
ZT06.MAC
ZT07.MAC
ZT08.MAC
ZT09.MAC
ZT10.MAC
ZT11.MAC
ZT12.MAC
ZT13.MAC
ZT14.MAC
ZT15.MAC
ZT16.MAC
ZT17.MAC
****
HEAP.MAC              
	.TITLE	$HEAP - RUNTIME STACK/HEAP FOR MEM RES OVERLAYED TASKS
 
; THIS MODULE GENERATES A SPECIAL VERSION THE HEAP SECTION
; THAT IS REQUIRED FOR PROGRAMS USING MEMORY RESIDENT OVERLAYS.
; THE ONLY DIFFERENCE (ASSIDE FROM SIZE) BETWEEN THIS ONE AND
; THE ONE GENERATED BY THE COMPILER IS THAT THIS ONE HAS THE
; READ-ONLY (RO) ATTRIBUTE.
;
; WHEN MEMORY RESIDENT OVERLAYS ARE USED, THE HEAP SECTION MUST
; BE PLACED AT THE END OF THE ROOT SEGMENT BECAUSE OF THE WAY
; THE INITIALIZATION MODULE, P11INIT, PREPARES THE PASCAL STACK.
; HOWEVER, WHEN AUTOLOADING IS IN USE, PSECTS, $$MRKS AND $$RDSG
; ALSO GET LOADED INTO THE ROOT.  THESE PSECTS HAVE THE RO ATTRIBUTE
; AND CONSEQUENTLY GET PLACED AFTER ALL RW PSECTS. SO, IF THE HEAP
; SECTION (NAMED 999999) IS RW THEN IT WONT BE THE LAST ONE IN THE
; SEGMENT.  THIS WILL CAUSE P11INIT TO CLEAR SECTIONS $$MRKS, $$RDSG
; AND ANY OTHER RO SECTIONS.  THIS WILL CAUSE THE TASK TO EVENTUALLY
; CRASH.  THUS, THE REASON FOR GIVING RO ATTRIBUTE TO THE HEAP
; SECTION - TO MAKE SURE IT IS THE LAST ONE IN THE SEGMENT.
;
; NOTE: THERE IS NO PROBLEM WRITTING INTO A RO SECTION - AT LEAST
; IN RSX-11M UP TO VERSION 3.2.
;
; NOTE ALSO THAT THE PSECT NAME IS NOT 999999, AS IS THE COMPILER
; GENERATED PSECT.  WE HAVE TO CALL IT .99999 BECAUSE THE ASSEMBLER
; DOES'NT LIKE NAMES THAT START WITH NUMBERS!
 
 
	.PSECT	.99999	RO
 
$$HEAP::
	.BLKW	500.	; MINIMAL SIZE - SET ACTUAL SIZE AT BUILD TIME
 
	.END
****
ZTRIK.MAC             
	.TITLE	ZTRIK
	.IDENT	'810815'
 
;  THIS MODULE IS NEEDED TO RESOLVE CROSS-BRANCH CALLS BETWEEN
; SEGMENTS OF THE OVERLAY STRUCTURE.  IT MUST BE INCLUDED IN THE
; ROOT SEGMENT.
;
;  THERE IS AN ENTRY FOR EACH ROUTINE WHICH WILL BE CALLED FROM
; A SEGMENT WHICH IS NOT ON THE SAME OVERLAY PATH AS THE SEGMENT
; WHICH CONTAINS THE ROUTINE.  FOR ROUTINES WHICH ARE CALLED VIA
; A JSR PC, THE ENTRY IS JUST A JMP TO AN ALIAS ENTRY POINT OF
; THE ROUTINE.  THIS ALIAS ENTRY POINT (Z... SYMBOL) IS LOCATED
; IN A SMALL MODULE (ZT..) IN THE SEGMENT THAT CONTAINS THE
; ROUTINE.
;
;  WHEN A CALL IS MADE TO ONE OF THESE ROUTINES (EG. ASSIGN), IT
; FIRST RESOLVES TO THESE ENTRIES.  THE JMP TO THE ALIAS THEN
; INVOKES THE AUTOLOAD MECHANISM AND THE RECURSEG ROUTINE TAKES
; CARE OF RE-LOADING SEGMENTS ON RETURN.
 
ADDTOT::	JMP	ZADDTO
ASSIGN::	JMP	ZASIGN
BLOCK::		JMP	ZBLOCK
CALL::		JMP	ZCALL
CALLNO::	JMP	ZCALNO
CALLNS::	JMP	ZCALNS
CALLST::	JMP	ZCALST
CASEST::	JMP	ZCASES
COMPOU::	JMP	ZCOMPO
CONSTD::	JMP	ZCONST
COPYTR::	JMP	ZCOPYT
DELPRE::	JMP	ZDELPR
ERRMES::	JMP	ZERRME
EXPRES::	JMP	ZEXPRE
FORSTA::	JMP	ZFORST
GENBR::		JMP	ZGENBR
GENFJP::	JMP	ZGENFJ
GENUJP::	JMP	ZGENUJ
GENSUB::	JMP	ZGENSU
GLOBAL::	JMP	ZGLOBL
GOTOST::	JMP	ZGOTOS
HEAPMA::	JMP	ZHEAPM
HEAPRE::	JMP	ZHEAPR
INSERT::	JMP	ZINSER
IFSTAT::	JMP	ZIFSTA
LABELD::	JMP	ZLABEL
LARGES::	JMP	ZLARGE
LINENO::	JMP	ZLINEN
LDO::		JMP	ZLDO
LOAD::		JMP	ZLOAD
LOADAD::	JMP	ZLOADA
LOD::		JMP	ZLOD
LOOPST::	JMP	ZLOOPS
MOVEFR::	JMP	ZMOVFR
MULTIP::	JMP	ZMULTI
NEXTIN::	JMP	ZNEXTI
PROCED::	JMP	ZPROCE
PSECTD::	JMP	ZPSECT
PUTGSD::	JMP	ZPUTGS
PUTRLD::	JMP	ZPUTRL
REPEAT::	JMP	ZREPEA
RTTY::		JMP	ZRTTY
SAVEFD::	JMP	ZSAVEF
SMPLEE::	JMP	ZSMPLE
STATEM::	JMP	ZSTATE
TYP::		JMP	ZTYP
TYPEDE::	JMP	ZTYPED
UNSAVE::	JMP	ZUNSAV
WITHST::	JMP	ZWITHS
WHILES::	JMP	ZWHILE
WRITOB::	JMP	ZWRITB
WRITOF::	JMP	ZWRITF
.CLOSE::	JMP	ZCLOSE
.FINIT::	JMP	ZFINIT
.MARK::		JMP	ZMARK
.OPEN::		JMP	ZOPEN
.OPFID::	JMP	ZOPFID
.POINT::	JMP	ZPOINT
 
 
;  THE FOLLOWING ENTRIES ARE FOR PASCAL RUNTIME ROUTINES WHICH
; MUST BE HANDLED DIFFERENTLY BECAUSE THEY ARE CALLED VIA JSR R4
; INSTRUCTIONS.
;
;  THE DIFFERENCE HERE IS THAT WHEN THE CALLED ROUTINE RETURNS
; VIA RTS R4, CONTROL WILL NOT GO TO THE POINT IN ROUTINE RECURSEG
; WHERE IT NORMALLY GOES WHEN THE RETURN IS VIA RTS PC.
; INSTEAD THE RTS R4 TRIES TO RETURN CONTROL TO THE ORIGINAL CALL
; SITE, WHICH WILL MORE THAN LIKELY BE OVERLAID.  THE ONLY WAY TO
; REGAIN CONTROL FROM THE CALLED ROUTINE IS TO CALL IT FROM HERE
; WITH A JSR R4.
;
;  WHEN CONTROL RETURNS FROM THE CALLED ROUTINE, THE STACK MUST BE
; RE-ARRANGED TO ACCOMODATE THE RECURSEG ROUTINE AND THEN CONTROL
; IS TRANSFERED TO RECURSEG SO THAT IT CAN MANAGE SEGMENT RE-LOADING.
;
;  NOTE THAT THE METHOD USED HERE ASSUMES THAT NO PARAMETERS ARE
; BEING COMMUNICATED VIA R4.  THIS IS THE CASE FOR SOME, BUT NOT ALL,
; PASCAL RUNTIME ROUTINES.
 
$EXITP::	JSR	R4, ZEXITP
		BR	SEGRET
 
$RESET::	JSR	R4, ZRESET
		BR	SEGRET
 
$REWRI::	JSR	R4, ZREWRI
 
SEGRET:
	; AT THIS POINT WE HAVE:
	;
	;	2(SP) = ORIGINAL R4 VALUE
	;	 (SP) = RETURN ADDR AT ORIGINAL CALL SITE
	;	  R4  = ADDR JUST AFTER THE JSR @ENTRYP IN RECURSEG
	;
	; WE MUST RE-ARRANGE THIS TO:
	;
	;	(SP) = RETURN ADDR AT ORIGINAL CALL SITE
	;	 R4  = ORIGINAL R4
	;
	; AND WE MUST RETURN CONTROL TO JUST AFTER JSR @ENTRYP
 
	MOV	(SP), -(SP)	; EXCHANGE (SP) AND 2(SP)
	MOV	4(SP), 2(SP)
	MOV	(SP)+, 2(SP)
 
	RTS	R4		; FIXES STACK AND R4 AND DOES GOTO
 
	.END
****
ZT01.MAC              
	.TITLE	ZT01
 
ZASIGN::	JMP	ASSIGN
ZFORST::	JMP	FORSTA
 
	.END
****
ZT02.MAC              
	.TITLE	ZT02
 
ZBLOCK::	JMP	BLOCK
ZHEAPM::	JMP	HEAPMA
ZHEAPR::	JMP	HEAPRE
 
	.END
****
ZT03.MAC              
	.TITLE	ZT03
 
	.GLOBL	CALL
 
ZCALL::		JMP	CALL
ZSTATE::	JMP	STATEM
 
	.END
****
ZT04.MAC              
	.TITLE	ZT04
 
ZCALNO::	JMP	CALLNO
ZCALNS::	JMP	CALLNS
 
	.END
****
ZT05.MAC              
	.TITLE	ZT05
 
ZCALST::	JMP	CALLST
 
	.END
****
ZT06.MAC              
	.TITLE	ZT06
 
ZCASES::	JMP	CASEST
ZWITHS::	JMP	WITHST
 
	.END
****
ZT07.MAC              
	.TITLE	ZT07
 
ZCOMPO::	JMP	COMPOU
ZGOTOS::	JMP	GOTOST
ZIFSTA::	JMP	IFSTAT
ZLOOPS::	JMP	LOOPST
ZREPEA::	JMP	REPEAT
ZWHILE::	JMP	WHILES
 
	.END
****
ZT08.MAC              
	.TITLE	ZT08
 
ZCONST::	JMP	CONSTD
ZLABEL::	JMP	LABELD
ZPROCE::	JMP	PROCED
 
	.END
****
ZT09.MAC              
	.TITLE	ZT09
 
ZCOPYT::	JMP	COPYTR
 
	.END
****
ZT10.MAC              
	.TITLE	ZT10
 
ZADDTO::	JMP	ADDTOT
ZDELPR::	JMP	DELPRE
ZGENBR::	JMP	GENBR
ZGENFJ::	JMP	GENFJP
ZGENUJ::	JMP	GENUJP
ZGENSU::	JMP	GENSUB
ZLINEN::	JMP	LINENO
ZLDO::		JMP	LDO
ZLOAD::		JMP	LOAD
ZLOD::		JMP	LOD
ZMOVFR::	JMP	MOVEFR
 
	.END
****
ZT11.MAC              
	.TITLE	ZT11
 
ZERRME::	JMP	ERRMES
ZNEXTI::	JMP	NEXTIN
ZSAVEF::	JMP	SAVEFD
ZUNSAV::	JMP	UNSAVE
 
	.END
****
ZT12.MAC              
	.TITLE	ZT12
 
ZEXPRE::	JMP	EXPRES
ZLOADA::	JMP	LOADAD
ZMULTI::	JMP	MULTIP
ZWRITF::	JMP	WRITOF
 
	.END
****
ZT13.MAC              
	.TITLE	ZT13
 
ZGLOBL::	JMP	GLOBAL
ZINSER::	JMP	INSERT
ZPSECT::	JMP	PSECTD
ZPUTGS::	JMP	PUTGSD
ZPUTRL::	JMP	PUTRLD
ZWRITB::	JMP	WRITOB
 
	.END
****
ZT14.MAC              
	.TITLE	ZT14
 
ZLARGE::	JMP	LARGES
ZSMPLE::	JMP	SMPLEE
 
	.END
****
ZT15.MAC              
	.TITLE	ZT15
 
ZTYP::		JMP	TYP
ZTYPED::	JMP	TYPEDE
 
	.END
****
ZT16.MAC              
	.TITLE	ZT16
 
ZEXITP::	JMP	$EXITP
ZRESET::	JMP	$RESET
ZREWRI::	JMP	$REWRI
ZCLOSE::	JMP	.CLOSE
ZFINIT::	JMP	.FINIT
ZMARK::		JMP	.MARK
ZOPFID::	JMP	.OPFID
ZOPEN::		JMP	.OPEN
ZPOINT::	JMP	.POINT
 
	.END
****
ZT17.MAC              
	.TITLE	ZT17
 
ZRTTY::		JMP	RTTY
 
	.END
****
