-h- DIGRAM.C	Wed May 12 09:31:45 1982	_DRB0:DIGRAM.C;1
/*
 * Hyphenation digram tables. Taken directly from the public domain
 * Bell Labs hyphenation algorithm exemplified in the DECUS RUNOFF
 * program.
 *
 * Edits:
 *    01 13-May-81 RBD  Initial conversion to C
 */

char bxh[1][13] =
   {
   0060, 0000, 0040, 0000, 0040, 0000, 0000, 0040, 0000, 0000, 0040, 0000, 0040
   };

char hxx[26][13] =
   {
   0006, 0042, 0041, 0123, 0021, 0024, 0063, 0042, 0002, 0043, 0021, 0001, 0022,
   0140, 0000, 0200, 0003, 0260, 0006, 0000, 0160, 0007, 0000, 0140, 0000, 0320,
   0220, 0000, 0160, 0005, 0240, 0010, 0000, 0100, 0006, 0000, 0200, 0000, 0320,
   0240, 0000, 0120, 0003, 0140, 0000, 0000, 0240, 0010, 0000, 0220, 0000, 0160,
   0042, 0023, 0041, 0040, 0040, 0022, 0043, 0041, 0030, 0064, 0021, 0000, 0041,
   0100, 0000, 0140, 0000, 0220, 0006, 0000, 0140, 0003, 0000, 0200, 0000, 0000,
   0200, 0000, 0120, 0002, 0220, 0010, 0000, 0160, 0006, 0000, 0140, 0000, 0320,
   0020, 0000, 0020, 0000, 0020, 0000, 0000, 0020, 0000, 0000, 0020, 0000, 0000,
   0043, 0163, 0065, 0044, 0022, 0043, 0104, 0042, 0061, 0146, 0061, 0000, 0007,
   0100, 0000, 0140, 0000, 0040, 0000, 0000, 0100, 0000, 0000, 0120, 0000, 0000,
   0140, 0000, 0040, 0011, 0060, 0004, 0001, 0120, 0003, 0000, 0140, 0000, 0040,
   0200, 0000, 0100, 0000, 0140, 0000, 0000, 0140, 0000, 0000, 0140, 0000, 0240,
   0200, 0000, 0140, 0000, 0160, 0000, 0000, 0220, 0000, 0000, 0140, 0000, 0240,
   0200, 0000, 0140, 0000, 0160, 0000, 0000, 0220, 0000, 0000, 0060, 0000, 0240,
   0021, 0043, 0041, 0121, 0040, 0023, 0042, 0003, 0142, 0042, 0061, 0001, 0022,
   0120, 0000, 0140, 0010, 0140, 0010, 0000, 0140, 0002, 0000, 0120, 0000, 0120,
   0000, 0000, 0000, 0000, 0360, 0000, 0000, 0000, 0000, 0000, 0160, 0000, 0000,
   0100, 0000, 0040, 0005, 0120, 0000, 0000, 0100, 0000, 0000, 0060, 0000, 0140,
   0140, 0040, 0100, 0001, 0240, 0041, 0000, 0242, 0000, 0002, 0140, 0000, 0100,
   0240, 0000, 0120, 0002, 0200, 0000, 0000, 0320, 0007, 0000, 0240, 0000, 0340,
   0101, 0021, 0041, 0020, 0040, 0005, 0042, 0121, 0002, 0021, 0201, 0000, 0020,
   0160, 0000, 0100, 0000, 0140, 0000, 0000, 0160, 0006, 0000, 0220, 0000, 0140,
   0140, 0000, 0020, 0001, 0020, 0000, 0000, 0100, 0001, 0000, 0300, 0000, 0000,
   0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000,
   0106, 0041, 0040, 0147, 0040, 0000, 0063, 0041, 0001, 0102, 0160, 0002, 0002,
   0300, 0000, 0040, 0017, 0140, 0017, 0000, 0240, 0000, 0000, 0140, 0000, 0120
   };

char bxxh[26][13] =
   {
   0005, 0150, 0153, 0062, 0062, 0246, 0152, 0127, 0146, 0203, 0310, 0017, 0206,
   0100, 0000, 0120, 0000, 0140, 0000, 0000, 0100, 0000, 0000, 0120, 0000, 0060,
   0100, 0000, 0040, 0000, 0060, 0000, 0000, 0060, 0000, 0000, 0220, 0000, 0040,
   0100, 0000, 0120, 0000, 0200, 0000, 0000, 0100, 0000, 0000, 0140, 0000, 0060,
   0043, 0142, 0046, 0140, 0062, 0147, 0210, 0131, 0046, 0106, 0246, 0017, 0111,
   0060, 0000, 0020, 0000, 0060, 0000, 0000, 0040, 0000, 0000, 0100, 0000, 0000,
   0060, 0000, 0040, 0000, 0040, 0000, 0000, 0040, 0000, 0000, 0100, 0000, 0040,
   0100, 0000, 0100, 0000, 0100, 0000, 0000, 0040, 0000, 0000, 0100, 0000, 0140,
   0066, 0045, 0145, 0140, 0000, 0070, 0377, 0030, 0130, 0103, 0003, 0017, 0006,
   0040, 0000, 0040, 0000, 0020, 0000, 0000, 0040, 0000, 0000, 0100, 0000, 0000,
   0200, 0000, 0020, 0000, 0140, 0000, 0000, 0120, 0000, 0000, 0120, 0000, 0040,
   0120, 0000, 0040, 0000, 0060, 0000, 0000, 0060, 0000, 0000, 0160, 0000, 0040,
   0120, 0000, 0040, 0000, 0120, 0000, 0000, 0040, 0000, 0000, 0160, 0000, 0040,
   0120, 0000, 0020, 0000, 0140, 0000, 0000, 0120, 0000, 0000, 0140, 0000, 0040,
   0051, 0126, 0150, 0140, 0060, 0210, 0146, 0006, 0006, 0165, 0003, 0017, 0244,
   0120, 0000, 0040, 0000, 0160, 0000, 0000, 0140, 0000, 0000, 0060, 0000, 0140,
   0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000,
   0140, 0000, 0140, 0000, 0060, 0000, 0000, 0100, 0000, 0000, 0140, 0000, 0020,
   0120, 0000, 0020, 0000, 0060, 0000, 0000, 0060, 0000, 0000, 0060, 0000, 0040,
   0140, 0000, 0020, 0000, 0100, 0000, 0000, 0140, 0000, 0000, 0140, 0000, 0020,
   0070, 0125, 0051, 0162, 0120, 0105, 0126, 0104, 0006, 0044, 0000, 0017, 0052,
   0140, 0000, 0020, 0000, 0140, 0000, 0000, 0060, 0000, 0000, 0060, 0000, 0040,
   0020, 0000, 0000, 0000, 0020, 0000, 0000, 0000, 0000, 0000, 0000, 0000, 0060,
   0140, 0000, 0160, 0000, 0200, 0000, 0000, 0140, 0000, 0000, 0000, 0000, 0240,
   0065, 0042, 0060, 0200, 0000, 0210, 0222, 0146, 0006, 0204, 0220, 0012, 0003,
   0240, 0000, 0020, 0000, 0120, 0000, 0000, 0200, 0000, 0000, 0200, 0000, 0240
   };

char xhx[26][13] =
   {
   0032, 0146, 0042, 0107, 0076, 0102, 0042, 0146, 0202, 0050, 0006, 0000, 0051,
   0036, 0377, 0057, 0013, 0057, 0366, 0377, 0057, 0001, 0377, 0057, 0000, 0040,
   0037, 0377, 0020, 0000, 0100, 0022, 0377, 0057, 0362, 0116, 0100, 0000, 0017,
   0057, 0377, 0057, 0031, 0137, 0363, 0377, 0037, 0362, 0270, 0077, 0000, 0117,
   0074, 0142, 0012, 0236, 0076, 0125, 0063, 0165, 0341, 0046, 0047, 0000, 0024,
   0020, 0017, 0075, 0377, 0040, 0001, 0377, 0017, 0001, 0204, 0020, 0000, 0040,
   0057, 0017, 0057, 0340, 0140, 0362, 0314, 0117, 0003, 0302, 0100, 0000, 0057,
   0057, 0357, 0077, 0017, 0100, 0366, 0314, 0057, 0342, 0346, 0037, 0000, 0060,
   0252, 0145, 0072, 0157, 0377, 0165, 0063, 0066, 0164, 0050, 0363, 0000, 0362,
   0000, 0000, 0020, 0000, 0020, 0000, 0000, 0017, 0000, 0000, 0020, 0000, 0000,
   0117, 0017, 0237, 0377, 0200, 0354, 0125, 0110, 0004, 0257, 0000, 0000, 0300,
   0057, 0367, 0054, 0357, 0157, 0216, 0314, 0114, 0217, 0353, 0053, 0000, 0057,
   0077, 0213, 0077, 0077, 0177, 0317, 0377, 0114, 0377, 0352, 0077, 0000, 0076,
   0077, 0213, 0077, 0077, 0157, 0177, 0377, 0054, 0377, 0352, 0117, 0000, 0075,
   0125, 0230, 0065, 0216, 0057, 0066, 0063, 0047, 0345, 0126, 0011, 0000, 0033,
   0057, 0377, 0051, 0360, 0120, 0361, 0273, 0056, 0001, 0256, 0057, 0000, 0060,
   0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000,
   0076, 0310, 0056, 0310, 0137, 0174, 0273, 0055, 0335, 0266, 0033, 0000, 0155,
   0077, 0157, 0057, 0360, 0057, 0063, 0042, 0024, 0077, 0206, 0020, 0000, 0040,
   0057, 0037, 0077, 0360, 0100, 0365, 0377, 0037, 0362, 0176, 0050, 0000, 0026,
   0167, 0146, 0042, 0112, 0077, 0110, 0062, 0254, 0366, 0052, 0377, 0000, 0163,
   0060, 0000, 0040, 0000, 0120, 0000, 0377, 0060, 0012, 0000, 0037, 0000, 0257,
   0037, 0232, 0157, 0361, 0040, 0003, 0125, 0010, 0001, 0256, 0000, 0000, 0340,
   0377, 0377, 0377, 0377, 0377, 0377, 0377, 0377, 0377, 0377, 0377, 0017, 0277,
   0253, 0315, 0257, 0216, 0377, 0206, 0146, 0306, 0371, 0126, 0232, 0000, 0004,
   0057, 0012, 0100, 0360, 0160, 0360, 0000, 0040, 0000, 0017, 0157, 0000, 0176
   };

char xxh[26][13] =
   {
   0045, 0150, 0154, 0162, 0042, 0246, 0210, 0147, 0152, 0103, 0230, 0017, 0206,
   0100, 0000, 0040, 0000, 0140, 0000, 0000, 0100, 0000, 0021, 0120, 0017, 0060,
   0100, 0000, 0040, 0002, 0140, 0320, 0000, 0060, 0000, 0001, 0220, 0017, 0040,
   0100, 0001, 0120, 0001, 0241, 0000, 0000, 0100, 0000, 0020, 0140, 0017, 0060,
   0023, 0162, 0046, 0142, 0022, 0207, 0210, 0131, 0052, 0106, 0250, 0017, 0110,
   0060, 0000, 0042, 0000, 0160, 0000, 0000, 0040, 0000, 0212, 0100, 0017, 0000,
   0140, 0000, 0040, 0002, 0140, 0000, 0000, 0120, 0000, 0040, 0120, 0017, 0040,
   0100, 0000, 0100, 0000, 0140, 0001, 0021, 0140, 0000, 0046, 0100, 0017, 0140,
   0066, 0045, 0025, 0201, 0020, 0130, 0146, 0030, 0130, 0103, 0025, 0017, 0006,
   0100, 0000, 0040, 0000, 0020, 0000, 0000, 0040, 0000, 0000, 0200, 0017, 0000,
   0200, 0000, 0020, 0001, 0140, 0000, 0000, 0140, 0000, 0000, 0120, 0017, 0040,
   0120, 0026, 0042, 0020, 0140, 0161, 0042, 0143, 0000, 0022, 0162, 0017, 0040,
   0121, 0042, 0060, 0020, 0140, 0200, 0000, 0123, 0000, 0021, 0220, 0017, 0041,
   0121, 0042, 0060, 0120, 0140, 0200, 0000, 0123, 0000, 0021, 0160, 0017, 0041,
   0051, 0126, 0150, 0141, 0060, 0210, 0146, 0066, 0026, 0165, 0026, 0017, 0247,
   0120, 0000, 0040, 0003, 0160, 0000, 0000, 0140, 0000, 0021, 0100, 0017, 0140,
   0000, 0000, 0000, 0000, 0200, 0000, 0000, 0000, 0000, 0000, 0000, 0017, 0000,
   0141, 0023, 0122, 0040, 0160, 0143, 0042, 0142, 0000, 0047, 0143, 0017, 0020,
   0120, 0000, 0040, 0006, 0140, 0060, 0000, 0141, 0000, 0026, 0100, 0017, 0040,
   0140, 0000, 0020, 0007, 0100, 0000, 0000, 0140, 0000, 0001, 0140, 0017, 0020,
   0110, 0125, 0051, 0162, 0120, 0125, 0127, 0104, 0006, 0104, 0000, 0017, 0052,
   0140, 0000, 0040, 0000, 0160, 0000, 0000, 0140, 0000, 0000, 0060, 0017, 0000,
   0040, 0005, 0020, 0000, 0040, 0313, 0231, 0030, 0000, 0140, 0000, 0017, 0056,
   0140, 0000, 0160, 0000, 0200, 0000, 0000, 0140, 0000, 0000, 0000, 0017, 0240,
   0065, 0042, 0060, 0040, 0000, 0206, 0231, 0146, 0006, 0224, 0220, 0017, 0004,
   0240, 0000, 0020, 0000, 0140, 0000, 0000, 0220, 0000, 0000, 0200, 0017, 0141
   };
-h- HY.C	Wed May 12 09:31:45 1982	_DRB0:HY.C;8
/*
 * hy.c
 *
 * Mark words for hyphenation.
 * Output is one word per line.
 * May be used as a filter.
 *
 * Not too useful unless a decent exception list is added
 * to the hyphenation processing.
 *
 * Bob Denny
 * 28-Mar-82
 */

/*)BUILD	$(PROGRAM)	= hy
		$(FILES)	= { hy hyphen digram suffix }
		$(TKBOPTIONS)	= {
			STACK	= 256
			TASK	= ...HYP
			ACTFIL	= 3
			UNITS	= 3
		}
*/

#include <stdio.h>
#define	EOS	0

/*
 * Hyphenation marker character
 */
#define HYCH '-'

char *wdstart, *wdend;			/* Shared with hyphen()		*/
char *hyptr[16];			/* Hyphenation locations	*/

static char intext[133];		/* Input text line		*/
static char iwbuf[32];			/* Input word buffer		*/
static char owbuf[48];			/* Marked output word		*/

main()
{
	int		i;		/* Hyphen buffer index		*/
	register char	*tp;		/* Text pointer			*/
	register char	*wp;		/* Input word pointer		*/
	register char	*op;		/* Output word pointer		*/

	while((tp = gets(intext)) != NULL) {
	    while (*tp != EOS) {
		while (isspace(*tp))	/* Skip over whitespace		*/
		    tp++;		/* between words		*/
		if (*tp == EOS)
		    break;
		for (wp = iwbuf; (*wp++ = *tp) != EOS && !isspace(*tp); tp++)
			;
		*--wp = EOS;		/* Terminate word		*/
		if (wp == iwbuf)	/* Ignore null words		*/
		    continue;
	        hyphen(iwbuf);		/* Get hyphenation pointers	*/
		i = 0;			/* Start with 1st pointer	*/
		op = owbuf;		/* Initialize output pointer	*/
		wp = iwbuf;
		while ((*op++ = tolower(*wp)) != EOS) {
		    wp++;		/* (no side effect in tolower)	*/
		    if (hyptr[i] == wp) {
			/*
			 * Mark hyphenation point
			 */
			*op++ = HYCH;
			i++;		/* Next hyphenation pointer	*/
		    }
		}
		puts(owbuf);            /* Write the marked word	*/
	    }
	}
}
-h- HYPHEN.C	Wed May 12 09:31:45 1982	_DRB0:HYPHEN.C;1
/*
 * HYPHEN.C
 *
 * Hyphenation module. Adapted from the Bell Labs hyphenation algorithm.
 * Suffix and digram tables taken from several public domain sources,
 * including DECUS RUNOFF.
 *
 * Basically a toy until a decent exception list is added.
 *
 * Edits:
 *    01 13-May-81 RBD  Initial edit.
 */

#define NULL 0

/*
 * Custom C control construct: cycle/recycle/quit
 */

#define cycle while(1) {
#define recycle continue
#define quit break
#define endcycle }

/*
 * External statics and functions.
 */
extern char *wdstart, *wdend;          /* Pointers to 1st and last chars */
extern char *hyptr[];                  /* Table of ptrs to hyp pos's */
extern char tolower();                 /* Fold character to lower case */

/*
 * Internal statics.
 */
static char *hyend;                    /* Working scan pointer */
static char **hyp;                     /* Scan ptr for hyptr table */

/*
 * Digram tables, table of pointers to suffix tables.
 */
extern char bxh[26][13], bxxh[26][13], xxh[26][13], xhx[26][13], hxx[26][13];
extern char *suftab[];

#define THRESH 160                     /* Digram goodness threshold */

/*
 * Mark word for hyphenation.
 *
 * Inputs:
 *       wp = pointer to start of word to hyphenate.
 *
 * Outputs:
 *       returns 0
 *       wdstart --> first letter
 *       wdend   --> last letter
 *       hyend   --> letter before first hyphenation break
 *       hyptr[] --> locations where hyphenation is OK
 */
hyphen(wp)
char *wp;
   {
   register char *ch;
   register **h;
   register int i;
/*
 * Skip by leading punctuation
 */
   ch = wp;
/******** TEMP
   while(punct(*ch++))
      ;
*/
   ch++;    /* Fake it */
/*
*********/

/*
 * If word doesn't start with alpha, don't hyphenate.
 */
   if (!isalpha(*--ch))
      return;
/*
 * Mark the special places in the word.
 */
   wdstart = ch++;                     /* wdstart --> 1st alpha */
   while(isalpha(*ch++))
      ;
   hyend = wdend = --ch-1;             /* hyend --> last letter */

/******** TEMP **********
   while(punct(*ch++))  */               /* (skip trailing punctuation) */
   ch++; /* Fake it */
/*      ;
*************************/
/*
 * Don't hyphenate unless that was trailing punctuation, not
 * punctuation within a word. Assumes word ends in NULL. Also,
 * don't hyphenate if word is shorter than 5 characters.
 */
   if (*--ch)
      return;
   if ((wdend-wdstart-4) < 0)
      return;

   hyp = hyptr;                        /* hyp --> first cell in hyptr */
   *hyp = NULL;                        /* hyptr[0] <-- 0 */

   suffix();                           /* Mark suffix based hyp points */
   digram();                           /* Mark usable digrams in the word */
   *hyp++ = NULL;                      /* Terminate the list with a NULL */

   /*
    * Do a bubble sort on the hyphenation pointers in hyptr[]
    * so they point to spots in the word from left to right.
    */
   if (*hyptr)
      for(i = 1; i;)
         {
         i = 0;
         for(h = hyptr+1; *h != 0; h++)
            {
            if (*(h-1) > *h)
               {
               i++;
               ch = *h; *h = *(h-1); *(h-1) = ch;
               }
            }
         }
   }

/*
 * Suffix test and processing. Handles multiple suffices, such as
 * "ationalism".
 */
suffix()
   {
   register char *s, *s0, *w;
   char ch;
   /*
    * Do this from right to left, recognizing suffix forms which make
    * up a concatenated multi-suffix.
    */
   cycle
      /*
       * Make ch = lower case last character for this suffix try.
       */
      if (!isalpha(ch = *hyend))       /* Done if non-alpha */
         return(0);
      /*
       * Point s0 at suffix table for the last letter in this word.
       * If there is no suffix table, return failure.
       */
      if ((s0 = suftab[tolower(ch)-'a']) == NULL)
         return(0);
      /*
       * Test word for match to nodes in suffix table. Done if end of
       * table reached.
       */
      cycle
         if ((ch = *s0 & 017) == '\0') /* ch = # chars in this node */
            return(0);                 /* Done if none (end of table) */
         s = s0 + ch - 1;              /* s --> last char in node */
         w = hyend - 1;                /* w --> next to last char in word */

         while(((s > s0) && (w >= wdstart)) && ((*s & 0177) == tolower(*w)))
            {
            s--;
            w--;
            }

         if (s == s0)                  /* If the entire suffix matched ... */
            quit;                      /* ... quit the cycle. Found one. */
         s0 += ch;                     /* No match, go to next node */
      endcycle

      s = s0 + ch - 1;                 /* s --> last char in node */
      w = hyend;                       /* w --> last char in word */
      if (*s0 & 0200) goto mark;       /* If hyp flag set, mark hyp spot */
      /*
       * Mark the places where it can be hyphenated.
       */
      while(s > s0)
         {
         --w;
         if (*s-- & 0200)              /* If this is a legal hyp spot */
            {
mark:                                  /* Mark it as a hyphenation spot */
            hyend = w - 1;             /* hyend --> word b4 hyp spot */
            /*
             * If bit 6 set in first cell, it means
             * supress actual hyphenation.
             */
            if (*s0 & 0100)            /* If supress, keep moving left */
               continue;
            if (!chkvow(w))            /* Done if no vowels precede this */
               return(0);
            *hyp++ = w;                /* Fill in a hyphenation pointer */
            }
         }
/*
 * End of suffix node. If bit 5 set in first cell, supress multi
 * suffix processing, done. Otherwise, look further to the left
 * for more suffices and hyphenation points.
 */
      if (*s0 & 040)
         return(0);
   endcycle
   }

/*
 * Test if the supplied letter is a vowel.
 */
vowel(ch)
int ch;
   {
   switch(tolower(ch))
      {
      case 'a':
      case 'e':
      case 'i':
      case 'o':
      case 'u':
      case 'y':
         return(1);
      default:
         return(0);
      }
   }

/*
 * Check if any letters to the left of *w are vowels.
 */
chkvow(w)
char *w;
   {
   while(--w >= wdstart) if(vowel(*w)) return(w);
   return(0);
   }

/*
 * Digram processing. Magic here.
 */
digram()
   {
   register char *w;
   register int val;
   char *nhyend, *maxw;
   int maxval;

   cycle
      if (!(w=chkvow(hyend+1)))return;
      hyend = w;
      if (!(w=chkvow(hyend)))return;
      nhyend = w;
      maxval = 0;
      w--;
      while((++w < hyend) && (w < (wdend-1)))
         {
         val = 1;
         if (w == wdstart) val *= dilook('a',*w,bxh);
         else if(w == wdstart+1) val *= dilook(*(w-1),*w,bxxh);
         else val *= dilook(*(w-1),*w,xxh);
         val *= dilook(*w, *(w+1), xhx);
         val *= dilook(*(w+1), *(w+2), hxx);
         if (val > maxval)
            {
            maxval = val;
            maxw = w + 1;
            }
         }
      hyend = nhyend;
      if (maxval > THRESH)*hyp++ = maxw;
   endcycle
}

dilook(a,b,t)
char a, b;
char t[26][13];
   {
   register char i, j;

   i = t[tolower(a)-'a'][(j = tolower(b)-'a')/2];
   if (!(j & 01))i >>= 4;
   return(i & 017);
   }
-h- SUFFIX.C	Wed May 12 09:31:45 1982	_DRB0:SUFFIX.C;1
/*
 * Suffix table for hyphenation. Taken from the public domain Bell Labs
 * hyphenation algorithm.
 *
 * Edits:
 *    01 13-May-81 RBD  Initial edit
 */

static char sufa[] =
   {
   02,0200+'t',                                             /* -TA */
   02,0200+'s',                                             /* -SA */
   03,0200+'t','r',                                         /* -TRA */
   03,0200+'d','r',                                         /* -DRA */
   03,0200+'b','r',                                         /* -BRA */
   02,0200+'p',                                             /* -PA */
   02,0200+'n',                                             /* -NA */
   02,0200+'m',                                             /* -MA */
   03,0200+'p','l',                                         /* -PLA */
   02,0200+'l',                                             /* -LA */
   02,0200+'k',                                             /* -KA */
   03,0200+'t','h',                                         /* -THA */
   03,0200+'s','h',                                         /* -SHA */
   02,0200+'g',                                             /* -GA */
   02,0200+'d',                                             /* -DA */
   02,0200+'c',                                             /* -CA */
   02,0200+'b',                                             /* -BA */
   00
   };

static char sufc[] =
   {
   04,'e','t',0200+'i',                                     /* ET-IC */
   07,'a','l',0200+'i','s',0200+'t','i',                    /* AL-IS-TIC */
   04,'s',0200+'t','i',                                     /* S-TIC */
   04,'p',0200+'t','i',                                     /* P-TIC */
   05,0200+'l','y','t',0200+'i',                            /* -LYT-IC */
   04,'o','t',0200+'i',                                     /* OT-IC */
   05,'a','n',0200+'t','i',                                 /* AN-TIC */
   04,'n',0200+'t','i',                                     /* N-TIC */
   04,'c',0200+'t','i',                                     /* C-TIC */
   04,'a','t',0200+'i',                                     /* AT-IC */
   04,'h',0200+'n','i',                                     /* H-NIC */
   03,'n',0200+'i',                                         /* N-IC */
   03,'m',0200+'i',                                         /* M-IC */
   04,'l',0200+'l','i',                                     /* L-LIC */
   04,'b',0200+'l','i',                                     /* B-LIC */
   04,0200+'c','l','i',                                     /* -CLIC */
   03,'l',0200+'i',                                         /* L-IC */
   03,'h',0200+'i',                                         /* H-IC */
   03,'f',0200+'i',                                         /* F-IC */
   03,'d',0200+'i',                                         /* D-IC */
   03,0200+'b','i',                                         /* -BIC */
   03,'a',0200+'i',                                         /* A-IC */
   03,0200+'m','a',                                         /* -MAC */
   03,'i',0200+'a',                                         /* I-AC */
   00
   };

static char sufd[] =
   {
   04,0200+'w','o','r',                                     /* -WORD */
   04,0200+'l','o','r',                                     /* -LORD */
   04,0200+'f','o','r',                                     /* -FORD */
   04,0200+'y','a','r',                                     /* -YARD */
   04,0200+'w','a','r',                                     /* -WARD */
   05,0200+'g','u','a','r',                                 /* -GUARD */
   04,0200+'t','a','r',                                     /* -TARD */
   05,0200+'b','o','a','r',                                 /* -BOARD */
   04,0200+'n','a','r',                                     /* -NARD */
   05,0200+'l','i','a','r',                                 /* -LIARD */
   04,0200+'i','a','r',                                     /* -IARD */
   04,0200+'g','a','r',                                     /* -GARD */
   04,0200+'b','a','r',                                     /* -BARD */
   03,0200+'r','o',                                         /* -ROD */
   04,0200+'w','o','o',                                     /* -WOOD */
   04,0200+'h','o','o',                                     /* -HOOD */
   04,0200+'m','o','n',                                     /* -MOND */
   04,0200+'t','e','n',                                     /* -TEND */
   05,0200+'s','t','a','n',                                 /* -STAND */
   04,0200+'l','a','n',                                     /* -LAND */
   04,0200+'h','a','n',                                     /* -HAND */
   04,0200+'h','o','l',                                     /* -HOLD */
   04,0200+'f','o','l',                                     /* -FOLD */
   05,0200+'f','i','e','l',                                 /* -FIELD */
   03,0200+'v','i',                                         /* -VID */
   03,0200+'c','i',                                         /* -CID */
   04,0200+'s','a','i',                                     /* -SAID */
   04,0200+'m','a','i',                                     /* -MAID */
   04,'t',0200+'t','e',                                     /* T-TED */
   03,'t',0200+'e',                                         /* T-ED */
   04,0200+'d','r','e',                                     /* -DRED */
   04,0200+'c','r','e',                                     /* -CRED */
   04,0200+'b','r','e',                                     /* -BRED */
   05,'v',0200+'e','l','e',                                 /* V-ELED */
   0100+04,'a','l',0200+'e',                                /* AL/ED */
   0140+03,0200+'e','e',                                    /* /EED */
   040+05,'e','d',0200+'d','e',                             /* ED-DED */
   04,'d',0200+'d','e',                                     /* D-DED */
   040+04,'e','d',0200+'e',                                 /* ED-ED */
   03,'d',0200+'e',                                         /* D-ED */
   05,0200+'d','u','c','e',                                 /* -DUCED */
   0300+02,'e',                                             /* E/D */
   05,0200+'s','t','e','a',                                 /* -STEAD */
   04,0200+'h','e','a',                                     /* -HEAD */
   00
   };

static char sufe[] =
   {
   05,'a','r',0200+'i','z',                                 /* AR-IZE */
   05,'a','n',0200+'i','z',                                 /* AN-IZE */
   05,'a','l',0200+'i','z',                                 /* AL-IZE */
   06,0200+'a','r','d',0200+'i','z',                        /* -ARD-IZE */
   05,0200+'s','e','l','v',                                 /* -SELVE */
   05,0200+'k','n','i','v',                                 /* -KNIVE */
   05,0200+'l','i','e','v',                                 /* -LIEVE */
   0100+03,0200+'q','u',                                    /* /QUE */
   07,'o','n',0200+'t','i','n',0200+'u',                    /* ON-TIN-UE */
   03,0200+'n','u',                                         /* -NUE */
   03,0200+'d','u',                                         /* -DUE */
   0300+02,'u',                                             /* U/E */
   0300+05,'q','u','a','t',                                 /*  QUAT/E */
   04,'u',0200+'a','t',                                     /* U-ATE */
   05,0200+'s','t','a','t',                                 /* -STATE */
   04,0200+'t','a','t',                                     /* -TATE */
   06,0200+'t','o','r',0200+'a','t',                        /* -TOR-ATE */
   05,'e','n',0200+'a','t',                                 /* EN-ATE */
   04,0200+'m','a','t',                                     /* -MATE */
   05,0200+'h','o','u','s',                                 /* -HOUSE */
   05,0200+'c','l','o','s',                                 /* -CLOSE */
   04,'i',0200+'o','s',                                     /* I-OSE */
   04,0200+'w','i','s',                                     /* -WISE */
   05,'a','s',0200+'u','r',                                 /* AS-URE */
   040+04,0200+'s','u','r',                                 /* -SURE */
   06,0200+'f','i','g',0200+'u','r',                        /* -FIG-URE */
   040+03,0200+'t','r',                                     /* -TRE */
   05,0200+'s','t','o','r',                                 /* -STORE */
   04,0200+'f','o','r',                                     /* -FORE */
   05,0200+'w','h','e','r',                                 /* -WHERE */
   06,0200+'s','p','h','e','r',                             /* -SPHERE */
   03,0200+'d','r',                                         /* -DRE */
   03,0200+'c','r',                                         /* -CRE */
   03,0200+'b','r',                                         /* -BRE */
   05,0200+'s','c','o','p',                                 /* -SCOPE */
   04,'y',0200+'o','n',                                     /* Y-ONE */
   05,0200+'s','t','o','n',                                 /* -STONE */
   05,0200+'p','h','o','n',                                 /* -PHONE */
   04,0200+'g','o','n',                                     /* -GONE */
   04,'e',0200+'o','n',                                     /* E-ONE */
   040+04,0200+'e','n','n',                                 /* -ENNE */
   040+05,'a',0200+'r','i','n',                             /* A-RINE */
   05,0200+'c','l','i','n',                                 /* -CLINE */
   04,0200+'l','i','n',                                     /* -LINE */
   007,00200+'r','o','u',00200+'t','i','n',                 /*-ROU-TINE */
   04,0200+'s','o','m',                                     /* -SOME */
   04,0200+'c','o','m',                                     /* -COME */
   04,0200+'t','i','m',                                     /* -TIME */
   03,0200+'z','l',                                         /* -ZLE */
   03,0200+'t','l',                                         /* -TLE */
   03,0200+'s','l',                                         /* -SLE */
   03,0200+'p','l',                                         /* -PLE */
   05,0200+'v','i','l','l',                                 /* -VILLE */
   04,'c','k',0200+'l',                                     /* CK-LE */
   03,0200+'k','l',                                         /* -KLE */
   03,0200+'g','l',                                         /* -GLE */
   03,0200+'f','l',                                         /* -FLE */
   03,0200+'d','l',                                         /* -DLE */
   03,0200+'c','l',                                         /* -CLE */
   05,0200+'p','a',0200+'b','l',                            /* -PA-BLE */
   05,'f','a',0200+'b','l',                                 /* FA-BLE */
   05,0200+'c','a',0200+'b','l',                            /* -CA-BLE */
   06,0200+'s','t','a','b','l',                             /* -STABLE */
   04,0200+'a','b','l',                                     /* -ABLE */
   03,0200+'b','l',                                         /* -BLE */
   04,0200+'d','a','l',                                     /* -DALE */
   04,0200+'m','a','l',                                     /* -MALE */
   04,0200+'s','a','l',                                     /* -SALE */
   04,0200+'l','i','k',                                     /* -LIKE */
   0340+05,'g',0200+'u','a','g',                            /* -G/UAGE */
   05,0200+'r','i','a','g',                                 /* -RIAGE */
   05,'e','r',0200+'a','g',                                 /* ER-AGE */
   04,'m',0200+'a','g',                                     /* M-AGE */
   04,'k',0200+'a','g',                                     /* K-AGE */
   04,'d',0200+'a','g',                                     /* D-AGE */
   04,0200+'w','i','f',                                     /* -WIFE */
   05,0200+'k','n','i','f',                                 /* -KNYFE */
   03,0200+'s','e',                                         /* -SEE */
   04,0200+'f','r','e',                                     /* -FREE */
   0340+02,'e',                                             /* EE */
   04,0200+'w','i','d',                                     /* -WIDE */
   04,0200+'t','i','d',                                     /* -TIDE */
   04,0200+'s','i','d',                                     /* -SIDE */
   06,0200+'q','u','e','n','c',                             /* -QUENCE */
   07,0200+'f','l','u',0200+'e','n','c',                    /* -FLU-ENCE */
   040+06,'e','s',0200+'e','n','c',                         /* ES-ENCE */
   06,'e','r',0200+'e','n','c',                             /* ER-ENCE */
   05,'i',0200+'e','n','c',                                 /* I-ENCE */
   040+05,0200+'s','a','n','c',                             /* -SANCE */
   06,'e','r',0200+'a','n','c',                             /* ER-ANCE */
   06,'a','r',0200+'a','n','c',                             /* AR-ANCE */
   05,0200+'n','a','n','c',                                 /* -NANCE */
   07,0200+'b','a','l',0200+'a','n','c',                    /* -BAL-ANCE */
   05,'i',0200+'a','n','c',                                 /* I-ANCE */
   07,0200+'j','u','s',0200+'t','i','c',                    /* -JUS-TICE */
   05,0200+'s','t','i','c',                                 /* -STICE */
   05,0200+'p','i','e','c',                                 /* -PIECE */
   05,0200+'p','l','a','c',                                 /* -PLACE */
   0340+01,                                                 /* /E */
   00
   };

static char suff[] =
   {
   03,0200+'o','f',                                         /* -OFF */
   05,0200+'p','r','o','o',                                 /* -PROOF */
   04,0200+'s','e','l',                                     /* -SELF */
   03,0200+'r','i',                                         /* -RIF */
   040+04,0200+'l','i','e',                                 /* -LIEF */
   00
   };

static char sufg[] =
   {
   03,0200+'l','o',                                         /* -LOG */
   04,0200+'l','o','n',                                     /* -LONG */
   05,'t',0200+'t','i','n',                                 /* T-TING */
   06,0200+'s','t','r','i','n',                             /*  -STRING */
   05,'r',0200+'r','i','n',                                 /* R-RING */
   05,'p',0200+'p','i','n',                                 /* P-PING */
   05,'n',0200+'n','i','n',                                 /* N-NING */
   05,'m',0200+'m','i','n',                                 /* M-MING */
   05,'l',0200+'l','i','n',                                 /*  L-LING */
   05,0200+'z','l','i','n',                                 /* -ZLING */
   05,0200+'t','l','i','n',                                 /* -TLING */
   040+05,'s',0200+'l','i','n',                             /* S-LING */
   05,'r',0200+'l','i','n',                                 /* R-LING */
   05,0200+'p','l','i','n',                                 /* -PLING */
   06,'n',0200+'k','l','i','n',                             /* N-KLING */
   05,'k',0200+'l','i','n',                                 /* K-LING */
   05,0200+'g','l','i','n',                                 /* -GLING */
   05,0200+'f','l','i','n',                                 /* -FLING */
   05,0200+'d','l','i','n',                                 /* -DLING */
   05,0200+'c','l','i','n',                                 /* -CLING */
   05,0200+'b','l','i','n',                                 /* -BLING */
   06,'y',0200+'t','h','i','n',                             /* Y-THING */
   07,'e','e','t','h',0200+'i','n',                         /* EETH-ING */
   06,'e',0200+'t','h','i','n',                             /* E-THING */
   05,'g',0200+'g','i','n',                                 /* G-GING */
   05,'d',0200+'d','i','n',                                 /* D-DING */
   05,'b',0200+'b','i','n',                                 /* B-BING */
   03,0200+'i','n',                                         /* -ING */
   00
   };

static	char sufh[] =
   {
   05,0200+'m','o','u','t',                                 /* -MOUTH */
   05,0200+'w','o','r','t',                                 /* -WORTH */
   04,0200+'w','i','t',                                     /* -WITH */
   05,'t',0200+'t','i','s',                                 /* T-TISH */
   05,'e',0200+'t','i','s',                                 /* E-TISH */
   05,'p',0200+'p','i','s',                                 /* P-PISH */
   05,'r',0200+'n','i','s',                                 /* R-NISH */
   05,'n',0200+'n','i','s',                                 /* N-NISH */
   05,0200+'p','l','i','s',                                 /* -PLISH */
   05,0200+'g','u','i','s',                                 /*  -GUISH */
   05,0200+'g','l','i','s',                                 /*  -GLISH */
   05,'b',0200+'l','i','s',                                 /*  B-LISH */
   05,'g',0200+'g','i','s',                                 /* G-GISH */
   05,'d',0200+'d','i','s',                                 /* D-DISH */
   03,0200+'i','s',                                         /* -ISH */
   05,0200+'g','r','a','p',                                 /* -GRAPH */
   07,0200+'b','o','r',0200+'o','u','g',                    /* -BOR-OUGH */
   05,0200+'b','u','r','g',                                 /* -BURGH */
   04,0200+'v','i','c',                                     /* -VICH */
   03,0200+'n','a',                                         /* -NAH */
   03,0200+'l','a',                                         /* -LAH */
   04,0200+'m','i',0200+'a',                                /* -MI-AH */
   00
   };

static char sufi[] =
   {
   03,0200+'t','r',                                         /* -TRI */
   03,0200+'c','h',                                         /* -CHI */
   0200+03,'i','f',                                         /* IF-I */
   0200+03,'e','d',                                         /* ED-I */
   05,0200+'a','s','c','i',                                 /* -ASCII */
   04,0200+'s','e','m',                                     /* -SEMI */
   00
   };

static char sufk[] =
   {
   04,0200+'w','o','r',                                     /* -WORK */
   04,0200+'m','a','r',                                     /* -MARK */
   04,0200+'b','o','o',                                     /* -BOOK */
   04,0200+'w','a','l',                                     /* -WALK */
   05,0200+'c','r','a','c',                                 /* -CRACK */
   04,0200+'b','a','c',                                     /* -BACK */
   00
   };

static char sufl[] =
   {
   03,0200+'f','u',                                         /* -FUL */
   05,'s',0200+'w','e','l',                                 /* S-WELL */
   04,0200+'t','e','l',                                     /* -TELL */
   05,0200+'s','h','e','l',                                 /* -SHELL */
   05,0200+'s','t','a','l',                                 /* -STALL */
   04,0200+'s','t','a',                                     /* -STAL */
   04,0200+'b','a','l',                                     /* -BALL */
   04,0200+'c','a','l',                                     /* -CALL */
   03,'v',0200+'e',                                         /* V-EL */
   03,'u',0200+'e',                                         /* U-EL */
   03,'k',0200+'e',                                         /* K-EL */
   04,'t','h',0200+'e',                                     /* TH-EL */
   05,'t','c','h',0200+'e',                                 /* TCH-EL */
   03,'a',0200+'e',                                         /* A-EL */
   0140+04,0200+'q','u','a',                                /* /QUAL */
   040+03,'u',0200+'a',                                     /* U-AL */
   03,0200+'t','a',                                         /* -TAL */
   04,'u','r',0200+'a',                                     /* UR-AL */
   040+05,'g',0200+'o',0200+'n','a',                        /* G-O-NAL */
   04,'o','n',0200+'a',                                     /* ON-AL */
   03,0200+'n','a',                                         /* -NAL */
   04,0200+'t','i','a',                                     /* -TIAL */
   04,0200+'s','i','a',                                     /* -SIAL */
   040+05,0200+'t','r','i',0200+'a',                        /* -TRI-AL */
   04,'r','i',0200+'a',                                     /* RI-AL */
   04,0200+'n','i',0200+'a',                                /* -NI-AL */
   04,0200+'d','i',0200+'a',                                /* -DI-AL */
   04,0200+'c','i','a',                                     /* -CIAL */
   03,0200+'g','a',                                         /* -GAL */
   04,0200+'m','e','a',                                     /* -MEAL */
/* >>>	040+04,0200+'r','e',0200+'a', */                    /* (del) -RE-AL */
   040+04,0200+'r','e','a',                                 /* -REAL */
   06,'c',0200+'t','i',0200+'c','a',                        /* C-TI-CAL */
   05,0200+'s','i',0200+'c','a',                            /* -SI-CAL */
   04,0200+'i',0200+'c','a',                                /* -I-CAL */
   03,0200+'c','a',                                         /* -CAL */
   03,0200+'b','a',                                         /* -BAL */
   06,0200+'n','o',0200+'m','i',0200+'a',                   /* -NO-MI-AL */
   00
   };

static char sufm[] =
   {
   03,0200+'n','u',                                         /* -NUM */
   05,'o',0200+'r','i',0200+'u',                            /* O-RI-UM */
   040+03,'i',0200+'u',                                     /* I-UM */
   040+03,'e',0200+'u',                                     /* E-UM */
   05,'i','v',0200+'i','s',                                 /* IV-ISM */
   04,0200+'t','i','s',                                     /* -TISM */
   05,'i',0200+'m','i','s',                                 /* I-MISM */
   05,'a','l',0200+'i','s',                                 /* AL-ISM */
   040+04,'e',0200+'i','s',                                 /* E-ISM */
   040+04,'a',0200+'i','s',                                 /* A-ISM */
   04,0200+'r','o','o',                                     /* -ROOM */
   03,0200+'d','o',                                         /* -DOM */
   03,0200+'h','a',                                         /* -HAM */
   06,0200+'a',0200+'r','i','t','h',                        /* -A-RITHM */
   05,0200+'r','i','t','h',                                 /* -RITHM */
   00
   };

static char sufn[] =
   {
   04,0200+'t','o','w',                                     /* -TOWN */
   04,0200+'d','o','w',                                     /* -DOWN */
   04,0200+'t','u','r',                                     /* -TURN */
   05,0200+'s','p','o','o',                                 /* -SPOON */
   04,0200+'n','o','o',                                     /* -NOON */
   04,0200+'m','o','o',                                     /* -MOON */
   011,'a','l',0200+'i',0200+'z','a',0200+'t','i','o',      /* AL-I-ZA-TION */
   07,0200+'i',0200+'z','a',0200+'t','i','o',               /* -I-ZA-TION */
   07,'l',0200+'i',0200+'a',0200+'t','i','o',               /* L-I-A-TION */
   04,0200+'t','i','o',                                     /* -TION */
   040+05,'s',0200+'s','i','o',                             /* S-SION */
   04,0200+'s','i','o',                                     /* -SION */
   04,'n',0200+'i','o',                                     /* N-ION */
   04,0200+'g','i','o',                                     /* -GION */
   04,0200+'c','i','o',                                     /* -CION */
   03,0200+'c','o',                                         /* -CON */
   05,0200+'c','o','l','o',                                 /* -COLON */
   03,0200+'t','o',                                         /* -TON */
   04,'i','s',0200+'o',                                     /* IS-ON */
   03,0200+'s','o',                                         /* -SON */
   03,0200+'r','i',                                         /* -RIN */
   03,0200+'p','i',                                         /* -PIN */
   03,0200+'n','i',                                         /* -NIN */
   03,0200+'m','i',                                         /* -MIN */
   03,0200+'l','i',                                         /* -LIN */
   03,0200+'k','i',                                         /* -KIN */
   05,0200+'s','t','e','i',                                 /* -STEIN */
   04,0200+'t','a','i',                                     /* -TAIN */
   05,'g','h','t',0200+'e',                                 /* GHT-EN */
   05,0200+'w','o','m',0200+'e',                            /* -WOM-EN */
   03,0200+'m','e',                                         /* -MEN */
   04,'o',0200+'k','e',                                     /* O-KEN */
   03,'k',0200+'e',                                         /* K-EN */
   04,0200+'t','e','e',                                     /* -TEEN */
   04,0200+'s','e','e',                                     /* -SEEN */
   040+03,0200+'s','a',                                     /* -SAN */
   05,0200+'w','o','m',0200+'a',                            /* -WOM-AN */
   03,0200+'m','a',                                         /* -MAN */
   04,0200+'t','i','a',                                     /* -TIAN */
   04,0200+'s','i','a',                                     /* -SIAN */
   040+04,'e',0200+'i','a',                                 /* E-IAN */
   04,0200+'c','i','a',                                     /* -CIAN */
   0300+03,'i','a',                                         /* IA/N */
   05,0200+'c','l','e','a',                                 /* -CLEAN */
   04,0200+'m','e','a',                                     /* -MEAN */
   040+03,'e',0200+'a',                                     /* E-AN */
   00
   };

static char sufo[] =
   {
   05,0200+'m','a','c',0200+'r',                            /* -MAC-RO */
   00
   };

static char sufp[] =
   {
   05,0200+'g','r','o','u',                                 /* -GROUP */
   02,0200+'u',                                             /* -UP */
   04,0200+'s','h','i',                                     /* -SHIP */
   04,0200+'k','e','e',                                     /* -KEEP */
   00
   };

static char sufr[] =
   {
   04,0200+'z','a','r',                                     /* -ZARR */
   0300+02,'r',                                             /* R/R */
   03,0200+'t','o',                                         /* -TOR */
   040+03,0200+'s','o',                                     /* -SOR */
   040+04,0200+'r','i',0200+'o',                            /* -RI-OR */
   04,'i','z',0200+'e',                                     /* IZ-ER */
   05,0200+'c','o','v',0200+'e',                            /* -COV-ER */
/* >>>	04,'o',0200+'v','e', */                             /* (del) O-VER */
   04,0200+'o','v','e',                                     /* -OVER */
   04,0200+'e','v',0200+'e',                                /* -EV-ER */
   8,0200+'c','o','m',0200+'p','u','t',0200+'e',            /* -COM-PUT-ER */
   040+05,'u','s',0200+'t','e',                             /* US-TER */
   05,'o','s','t',0200+'e',                                 /* OST-ER */
   040+05,0200+'a','c',0200+'t','e',                        /* -AC-TER */
   06,0200+'w','r','i','t',0200+'e',                        /* -WRIT-ER */
   040+05,'i','s',0200+'t','e',                             /* IS-TER */
   040+05,'e','s',0200+'t','e',                             /* ES-TER */
   040+05,'a','s',0200+'t','e',                             /* AS-TER */
   04,0200+'s','t','e',                                     /* -STER */
   05,'a','r',0200+'t','e',                                 /* AR-TER */
   04,'r','t',0200+'e',                                     /* RT-ER */
   040+05,'m',0200+'e',0200+'t','e',                        /* M-E-TER */
   05,0200+'w','a',0200+'t','e',                            /* -WA-TER */
   03,'r',0200+'e',                                         /* R-ER */
   04,'o','p',0200+'e',                                     /* OP-ER */
   05,0200+'p','a',0200+'p','e',                            /* -PA-PER */
   04,'w','n',0200+'e',                                     /* WN-ER */
   040+04,'s',0200+'n','e',                                 /* S-NER */
   04,'o','n',0200+'e',                                     /* ON-ER */
   04,'r','m',0200+'e',                                     /* RM-ER */
   03,0200+'m','e',                                         /* -MER */
   04,'l','l',0200+'e',                                     /* LL-ER */
   05,'d',0200+'d','l','e',                                 /* D-DLER */
   04,0200+'b','l','e',                                     /* -BLER */
   03,'k',0200+'e',                                         /* K-ER */
   05,'n',0200+'t','h','e',                                 /* N-THER */
   06,0200+'f','a',0200+'t','h','e',                        /* -FA-THER */
   06,'e','i',0200+'t','h','e',                             /* EI-THER */
   04,'t','h',0200+'e',                                     /* TH-ER */
   04,'s','h',0200+'e',                                     /* SH-ER */
   04,0200+'p','h','e',                                     /* -PHER */
   04,'c','h',0200+'e',                                     /* CH-ER */
   04,'d','g',0200+'e',                                     /* DG-ER */
   04,'r','d',0200+'e',                                     /* RD-ER */
   06,'o','u','n','d',0200+'e',                             /* OUND-ER */
   04,'l','d',0200+'e',                                     /* LD-ER */
   04,'i','d',0200+'e',                                     /* ID-ER */
   05,0200+'d','u','c',0200+'e',                            /* -DUC-ER */
   04,'n','c',0200+'e',                                     /* NC-ER */
   0100+02,0200+'e',                                        /*  /ER */
   03,0200+'s','a',                                         /* -SAR */
   040+06,'a','c',0200+'u',0200+'l','a',                    /* AC-U-LAR */
   040+06,'e','c',0200+'u',0200+'l','a',                    /* EC-U-LAR */
   040+06,'i','c',0200+'u',0200+'l','a',                    /* IC-U-LAR */
   040+06,'e','g',0200+'u',0200+'l','a',                    /* EG-U-LAR */
   00
   };

static char sufs[] =
   {
   040+04,'u',0200+'o','u',                                 /* U-OUS */
   05,0200+'t','i','o','u',                                 /* -TIOUS */
   05,0200+'g','i','o','u',                                 /* -GIOUS */
   05,0200+'c','i','o','u',                                 /* -CIOUS */
   040+04,'i',0200+'o','u',                                 /* I-OUS */
   05,0200+'g','e','o','u',                                 /* -GEOUS */
   05,0200+'c','e','o','u',                                 /* -CEOUS */
   04,'e',0200+'o','u',                                     /* E-OUS */
   0140+02,0200+'u',                                        /* /US */
   04,0200+'n','e','s',                                     /* -NESS */
   04,0200+'l','e','s',                                     /* -LESS */
   0140+02,0200+'s',                                        /* /SS */
   040+05,'p',0200+'o',0200+'l','i',                        /* P-O-LIS */
   0140+02,0200+'i',                                        /* /IS */
   0100+03,0200+'x','e',                                    /* X/ES */
   0100+03,0200+'s','e',                                    /* S/ES */
   0100+04,'s','h',0200+'e',                                /* SH/ES */
   0100+04,'c','h',0200+'e',                                /* CH/ES */
   0300+01,                                                 /* /S */
   00
   };

static char suft[] =
   {
   06,'i','o','n',0200+'i','s',                             /* ION-IST */
   05,'i','n',0200+'i','s',                                 /* IN-IST */
   05,'a','l',0200+'i','s',                                 /* AL-IST */
   06,'l',0200+'o',0200+'g','i','s',                        /* L-O-GIST */
   05,'h','t',0200+'e','s',                                 /* HT-EST */
   04,'i',0200+'e','s',                                     /* I-EST */
   05,'g',0200+'g','e','s',                                 /* G-GEST */
   04,'g',0200+'e','s',                                     /* G-EST */
   05,'d',0200+'d','e','s',                                 /* D-DEST */
   04,'d',0200+'e','s',                                     /* D-EST */
   04,0200+'c','a','s',                                     /* -CAST */
   05,0200+'h','e','a','r',                                 /* -HEART */
   04,0200+'f','o','o',                                     /* -FOOT */
   03,'i',0200+'o',                                         /* I-OT */
   05,0200+'f','r','o','n',                                 /* -FRONT */
   05,0200+'p','r','i','n',                                 /* -PRINT */
   04,0200+'m','e','n',                                     /* -MENT */
   05,0200+'c','i','e','n',                                 /* -CIENT */
   04,'i',0200+'a','n',                                     /* I-ANT */
   06,0200+'w','r','i','g','h',                             /* -WRIGHT */
   06,0200+'b','r','i','g','h',                             /* -BRIGHT */
   06,0200+'f','l','i','g','h',                             /* -FLIGHT */
   06,0200+'w','e','i','g','h',                             /* -WEIGHT */
   05,0200+'s','h','i','f',                                 /* -SHIFT */
   05,0200+'c','r','a','f',                                 /* -CRAFT */
   040+04,'d','g',0200+'e',                                 /* DG-ET */
   04,0200+'g','o','a',                                     /* -GOAT */
   04,0200+'c','o','a',                                     /* -COAT */
   04,0200+'b','o','a',                                     /* -BOAT */
   04,0200+'w','h','a',                                     /* -WHAT */
   04,0200+'c','u','i',                                     /* -CUIT */
   00
   };

static char sufy[] =
   {
   040+04,'e','s',0200+'t',                                 /* ES-TY */
   040+05,'q','u','i',0200+'t',                             /* QUI-TY */
   04,0200+'t','i',0200+'t',                                /* -TI-TY */
   040+05,'o','s',0200+'i',0200+'t',                        /* OS-I-TY */
   04,0200+'s','i',0200+'t',                                /* -SI-TY */
   05,'i','n',0200+'i',0200+'t',                            /* IN-I-TY */
   04,'n','i',0200+'t',                                     /* NI-TY */
   040+010,'f','a',0200+'b','i','l',0200+'i',0200+'t',      /* FA-BIL-I-TY */
   010,0200+'c','a',0200+'b','i','l',0200+'i',0200+'t',     /* -CA-BIL-I-TY */
   010,0200+'p','a',0200+'b','i','l',0200+'i',0200+'t',     /* -PA-BIL-I-TY */
   06,0200+'b','i','l',0200+'i',0200+'t',                   /* -BIL-I-TY */
   03,'i',0200+'t',                                         /* I-TY */
   04,0200+'b','u','r',                                     /* -BUR-Y */
   04,0200+'t','o',0200+'r',                                /* -TO-RY */
   05,0200+'q','u','a','r',                                 /* -QUAR-Y */
   040+04,'u',0200+'a','r',                                 /* U-ARY */
   07,0200+'m','e','n',0200+'t','a',0200+'r',               /* -MEN-TA-RY */
   06,'i','o','n',0200+'a','r',                             /* ION-ARY */
   04,'i',0200+'a','r',                                     /* I-ARY */
   04,'n',0200+'o',0200+'m',                                /* N-O-MY */
   03,0200+'p','l',                                         /* -PLY */
   04,'g',0200+'g','l',                                     /* G-GLY */
   05,0200+'p','a',0200+'b','l',                            /* -PA-BLY */
   05,'f','a',0200+'b','l',                                 /* FA-BLY */
   05,0200+'c','a',0200+'b','l',                            /* -CA-BLY */
   04,0200+'a','b','l',                                     /* -ABLY */
   03,0200+'b','l',                                         /* -BLY */
   02,0200+'l',                                             /* -LY */
   03,0200+'s','k',                                         /* -SKY */
   040+06,'g',0200+'r','a',0200+'p','h',                    /* G-RA-PHY */
   04,'l',0200+'o',0200+'g',                                /* L-O-GY */
   02,0200+'f',                                             /* -FY */
   03,0200+'n','e',                                         /* -NEY */
   03,0200+'l','e',                                         /* -LEY */
   04,'c','k',0200+'e',                                     /* CK-EY */
   03,0200+'k','e',                                         /* -KEY */
   04,0200+'b','o','d',                                     /* -BODY */
   05,0200+'s','t','u','d',                                 /* -STUDY */
   0340+04,'e','e','d',                                     /* EEDY */
   02,0200+'b',                                             /* -BY */
   03,0200+'w','a',                                         /* -WAY */
   03,0200+'d','a',                                         /* -DAY */
   00
   };

char *suftab[] =
   {
   sufa, 0, sufc, sufd, sufe, suff, sufg, sufh, sufi, 0,
   sufk, sufl, sufm, sufn, sufo, sufp, 0, sufr, sufs, suft,
   0, 0, 0, 0, sufy, 0
   };
