	.TITLE	SUBJNM
	.IDENT	/V3.00/
	.NLIST	BEX
	.ENABL	LC

;***********************************************************************
;
;	SUBJNM.PAT
;
;	This patch file implements processing specific to the Cornell
;	University/Chemical Engineering Batch System (version 3) for
;	RSX-11M V4.0 or V4.1.
;
;	This patch is applied to object module SUBJNM.OBJ extracted from
;	the library file QMGCLI.OLB on the distribution disk.
;	Its function is to make a copy of the switch mask word after
;	the output side of a submit command (MCR) has been parsed. This
;	is so we can remember later (see CLISUB.PAT) whether or not the
;	job was meant to be on hold. The batch queue name is also saved
;	for checking scheduling limits.
;
;----------------------------------------------------------------------
;
;	Steve Thompson
;	School of Chemical Engineering
;	Cornell University
;	Ithaca NY 14853
;
;***********************************************************************

;
; Specify location of patch in module CLISUB. These locations are the
; same for RSX-11M V4.0 and V4.1.
;

	.PSECT	PURE$I
$$$=.
.=.+136
	CALL	COPQ		; Call new routine
	NOP
.=$$$+366
	CALL	COPMSK		; Call new routine
	NOP			;

;
; New stuff, all in P-section BAPCOD.
;

	.PSECT	BAPCOD,I

COPQ:	MOV	PACKET+Q.MQN,BATQ	; Save queue name
	MOV	PACKET+Q.MQN+2,BATQ+2	;
	BITB	#2,CSIBLK+1		;* Intercepted instruction
	RTS	PC			;

COPMSK:	MOV	CSIBLK+26,SWMASK	; Save switch mask
	BIT	#1000,CSIBLK+26		;* Intercepted instruction
	RTS	PC			; That's it

	.END
