.;
.;	************  BATGEN.CMD  ************
.;
.;	Command file to assemble and build Version 3 of the Batch System.
.;
.;	Steve Thompson
.;	School of Chemical Engineering
.;	Olin Hall
.;	Cornell University
.;	Ithaca NY 14853
.;	(607) 256 4616 - office
.;	(607) 256 3895 - computer room
.;
.;
.;			N O T E
.;
.;		This package will run only
.;		on RSX-11M V4.0 or V4.1.
.;
.;
.;	Revision History
.;	----------------
.;
.;	-none-
.;
.;
	.ENABLE SUBSTITUTION
	.ENABLE GLOBAL
	.ENABLE ESCAPE
	.ENABLE DECIMAL
	.SETS $IDENT "V3.00"	! Specify version of BATGEN.
	.SETS $PRPRI "40."	! Priority of Print Jobs (if QMG... used)
	.SETN $DFPRI 50.	! Default job submission priority
	.SETF $COMM		! Assume short comments
	.SETS $CLI <CLI>	! Save current CLI name
	.IF P1 EQ "GO" .GOTO 100 ! @BATGEN GO sets short comments and dives in.

;
;	<BATGEN '$IDENT'> '<DATE>' '<TIME>'
;
; Batch System Generation Procedure.
; Batch System Version 3, April 1983.
;

	.IF $CLI NE "MCR" MCR SET /MCR=TI: 
.START:

;
;	Long comments provide a description of all the options and
;	requirements in building Version 3 of the Batch System.
;	If you do not select long comments, many of the
;	questions can be answered with <ESC>, when the descriptive
;	text is displayed and the question is asked again.
;

	.ASK $COMM 1.  Do you want long comments
	.IFT <ESCAPE> .GOTO START
	.IFF $COMM .GOTO 100

;
;	You must be running on the exact version of the system that
;	is to be run with Batch, or at least LB:[1,54]RSX11M.STB
;	must be correct for the system on which Batch is to run.
;	BATGEN will install any tasks that are needed that are not
;	already installed (and will remove them when done).
;

.100:

.;
.; Questions relating to saved answer file.
.;

.200:
	.IFF $COMM .GOTO 202
.201:

;
;	BATGEN can create an answer file called BATANSWER.CMD during
;	its execution. This file can be used to drive a subsequent
;	BATGEN to rebuild the Batch System. This feature is
;	useful if a SYSGEN has been performed, since the Batch
;	system can be rebuilt without having to answer any of the
;	option questions. The answer files are assumed
;	to be stored under the current default UIC, on the device
;	currently assigned to SY:.
;

.202:

	.ASK $SAVE 2.  Save answers and create BATANSWER.CMD
	.IFT <ESCAPE> .GOTO 201

.203:

	.ASK $AUTO 3.  Use previous BATANSWER.CMD to drive this BATGEN
	.IFT <ESCAPE> .GOTO 203
	.IFT $AUTO .SETF $COMM
	.IFT $AUTO .DISABLE ESCAPE
	.IFF $AUTO .SETS WAKE ""
.; *** The next string contains a CTRL/G (Bell)
	.IFT $AUTO .SETS WAKE ""
	.IFF $COMM .GOTO 204
	.IFT $AUTO ;
	.IFT $AUTO ; *NOTE*	In automatic mode, BATGEN will cause the terminal
	.IFT $AUTO ;		bell to ring and will pause if any undefined
	.IFT $AUTO ;		answers are found. The <ESC> terminator to
	.IFT $AUTO ;		the questions asked is illegal in these cases.
	.IFT $AUTO ;
	.IFF $AUTO .GOTO 204

;
;	BATGEN will prompt you for any undefined answers that are
;	required during this run. The <ESC> terminator to these
;	questions, in order to request help, is not legal in this
;	mode.
;

.204:

.IFT $AUTO @BATANSWER.CMD

.;
.; Time and memory limit support.
.;

.300:
	.IFF $COMM .GOTO 302
.301:

;
;	Time Limits can be supported by this version of the Batch
;	System. The following options are available if time limit
;	support is selected:
;
;	1. If the accounting package is supported, time limits may
;	   be measured in terms of CPU time (Version 7 of the
;	   accounting package at revision level 843 or above is
;	   required).
;
;	2. If the accounting package is not supported, time limits
;	   operate in terms of elapsed time. This may or may not be
;	   acceptable to you.
;
;	If there is no time limit support included, there is no need
;	for accounting system support either.
;

.302:
	.IFT $AUTO .IFDF $B3TIM .GOTO 303
	.ASK $B3TIM 3.'WAKE'  Time Limit support
	.IFF $AUTO .IFT <ESCAPE> .GOTO 301
.303:
	.IFF $B3TIM .SETF $B3ACC
	.IFF $B3TIM .SETN $DFTIM 1.
	.IFF $B3TIM .SETN $MXTIM 1.
	.IFF $B3TIM .GOTO 305

	.IFT $AUTO .IFDF $DFTIM .GOTO 303A
	.ASKN [1.:1000.:30.] $DFTIM 3A.'WAKE' Default time limit (minutes)
	.IFF $AUTO .IFT <ESCAPE> .GOTO 301
.303A:
	.IFT $AUTO .IFDF $MXTIM .GOTO 303B
	.ASKN [$DFTIM:32736.:600.] $MXTIM 3B.'WAKE' Maximum time limit (minutes)
	.IFF $AUTO .IFT <ESCAPE> .GOTO 301
.303B:

.304:

	.IFT $AUTO .IFDF $B3ACC .GOTO 305
	.ASK $B3ACC 4.'WAKE'  Accounting System support
	.IFF $AUTO .IFT <ESCAPE> .GOTO 301

.305:

	.IFF $COMM .GOTO 307
.306:

;
;	The MEMORY parameter of the *JOB card is optional. If you
;	include support for this option, the INSTALL message
;	"partition too small" will appear if the job tries to
;	run a task that requires more memory than specified on
;	the *JOB card, and the task will not run.
;

.307:

	.IFT $AUTO .IFDF $B3MEM .GOTO 308
	.ASK $B3MEM 5.'WAKE'  Support for MEMORY keyword on *JOB
	.IFF $AUTO .IFT <ESCAPE> .GOTO 306
.308:
	.IFF $B3MEM .SETN $DFMEM 1.
	.IFF $B3MEM .SETN $MXMEM 1.
	.IFF $B3MEM .GOTO 308C

	.SETN DFMAX 64.
	.SETN DFDEF 32.
	.SETN MXMAX 128.
	.SETN MXDEF 128.

	.TESTPARTITION GEN
	.IF <EXSTRI> EQ ",,,NSP," .GOTO 308TP
	.PARSE <EXSTRI> ",,,," NAME BASE SIZE TYPE
	.DISABLE DECIMAL
	.SETN PARSIZ 'SIZE'
	.SETN PARSIZ PARSIZ/32.
	.ENABLE DECIMAL
	.SETD PARSIZ
	.SETN DFMAX PARSIZ/2
	.IF DFMAX < 32. .SETN DFDEF DFMAX
	.SETN MXMAX PARSIZ
	.SETN MXDEF 3*PARSIZ/4
	.SETD DFMAX
	.SETD DFDEF
	.SETD MXMAX
	.SETD MXDEF
.308TP:
	.IFT $AUTO .IFDF $DFMEM .GOTO 308A
	.ASKN [1:DFMAX:DFDEF] $DFMEM 5A.'WAKE' Default memory limit (KW)
	.IFF $AUTO .IFT <ESCAPE> .GOTO 306
.308A:
	.IFT $AUTO .IFDF $MXMEM .GOTO 308B
	.ASKN [$DFMEM:MXMAX:MXDEF] $MXMEM 5B.'WAKE' Maximum memory limit (KW)
	.IFF $AUTO .IFT <ESCAPE> .GOTO 306
.308B:

.308C:

	.IFF $COMM .GOTO 310
.309:

;
;	The PAGES parameter of the *JOB card is optional. If you
;	include support for this option, a job will be terminated
;	if it tries to output too many pages. For more information
;	on how to set the default and maximum output limits, see
;	the "Batch System Installation Guide", BATREF.DOC.
;

.310:

	.IFT $AUTO .IFDF $B3PAG .GOTO 311
	.ASK $B3PAG 6.'WAKE'  Output Limit support
	.IFF $AUTO .IFT <ESCAPE> .GOTO 309
.311:
	.IFF $B3PAG .SETN $DFPAG 1.
	.IFF $B3PAG .SETN $MXPAG 1.
	.IFF $B3PAG .GOTO 311C

	.IFT $AUTO .IFDF $DFPAG .GOTO 311A
	.ASKN [1.:255.:25.] $DFPAG 6A.'WAKE' Default Output Limit (pages)
	.IFF $AUTO .IFT <ESCAPE> .GOTO 309
.311A:
	.IFT $AUTO .IFDF $MXPAG .GOTO 311B
	.ASKN [$DFPAG:32736.:250.] $MXPAG 6B.'WAKE' Maximum Output Limit (pages)
	.IFF $AUTO .IFT <ESCAPE> .GOTO 309
.311B:
.311C:

.;
.; Determine support for Queueing Priority messages.
.;

	.IFF $B3TIM .AND .IFF $B3MEM .SETF $B3PQP
	.IFF $B3TIM .AND .IFF $B3MEM .GOTO 402
	.IFF $COMM .GOTO 401
.400:

;
;	The SUBMIT command can optionally inform you of what priority
;	was used to submit a job when the job has been accepted by the
;	Queue Manager. If you do not select this option, you can always
;	determine the priority using the SHOW QUEUE/BATCH/FULL command.
;

.401:
	.IFT $AUTO .IFDF $B3PQP .GOTO 402
	.ASK $B3PQP 7.'WAKE'  Print Queueing Priority at SUBMIT time
	.IFF $AUTO .IFT <ESCAPE> .GOTO 400
.402:
	.IFF $COMM .GOTO 404
.403:

;
;	The Batch Processor task(s) can optionally inform you that your
;	job is starting or ending if you are logged on at the time. The
;	message will appear at up to five terminals if you happen to be
;	logged on at this many. This feature operates by way sending
;	IO.WBT''s to the relevant terminals, the latter being determined
;	by a scan of the device tables.
;

.404:
	.IFT $AUTO .IFDF $B3MSG .GOTO 405
	.ASK $B3MSG 8.'WAKE'  Job Start/End messages
	.IFF $AUTO .IFT <ESCAPE> .GOTO 403
.405:

	.IFF $COMM .GOTO 407
.406:

;
;	The virtual terminal driver will always reject attempted writes
;	to logfiles from non-privileged tasks that are not running in
;	the relevant batch stream (a LUN may have been explicitly
;	assigned to a specific virtual terminal). However, the driver
;	can be configured so that privileged tasks are permitted to do
;	such writing. If you select support for this option, the output
;	can be handled in two ways:
;
;	1. The output can be written to the job''s logfile in the same
;	   fashion as if the job had done the output itself, or
;
;	2. The output can be forced to give a SYS-class message in the
;	   history file for the job. This is generally the most
;	   useful option, since it allows you to send messages to the
;	   job from a privileged task (eg BRO).
;

.407:
	.IFT $AUTO .IFDF $B3XIO .GOTO 408
	.ASK $B3XIO 9.'WAKE'  Allow external privileged writes
	.IFF $AUTO .IFT <ESCAPE> .GOTO 406
.408:
	.IFF $B3XIO .SETF $B3FSY
	.IFT $AUTO .IFDF $B3FSY .GOTO 409
	.ASK $B3FSY 10.'WAKE' Force such writes to SYS-class history messages
	.IFF $AUTO .IFT <ESCAPE> .GOTO 406
.409:

.;
.; Determine maximum number of virtual terminals.
.;

.500:
	.IFF $COMM .GOTO 502
.501:

;
;	You must now decide the maximum number of batch streams (virtual
;	terminals) to configure into the system. This number can be from
;	1 to 16 inclusive. The number of batch streams that are eligible
;	to run jobs can never be greater than this number, but can be less
;	by operator control.
;

.502:
	.IFT $AUTO .IFDF $NVT .GOTO 503
	.ASKN [1.:16.:6.] $NVT 11.'WAKE' Number of virtual terminals
	.IFF $AUTO .IFT <ESCAPE> .GOTO 501
.503:

	.IFF $SAVE .GOTO ESAV

.OPEN BATANSWER.CMD

;
; '<TIME>' '<DATE>' Construct answer file '<FILSPC>'
;

.ENABLE DATA
;
; Answer file constructed by BATGEN '$IDENT' on '<DATE>' at '<TIME>'
;
.ENABLE GLOBAL
.DISABLE DATA

            .DATA ;	********** SUMMARY OF SYSTEM PARAMETERS **********
            .DATA ;
.IFT $B3ACC .DATA ; Accounting System Support = YES
.IFF $B3ACC .DATA ; Accounting System Support = NO
.IFT $B3ACC .DATA .SETT $B3ACC
.IFF $B3ACC .DATA .SETF $B3ACC
.IFT $B3ACC .SETS CPUNIT "CPU"
.IFF $B3ACC .SETS CPUNIT "Elapsed"

            .DATA ;
.IFT $B3TIM .DATA ; Time Limit Support = YES
.IFT $B3TIM .DATA ;	Default Time Limit = '$DFTIM'. 'CPUNIT' minutes
.IFT $B3TIM .DATA ;	Maximum Time Limit = '$MXTIM'. 'CPUNIT' minutes
.IFF $B3TIM .DATA ; Time Limit Support = NO
.IFT $B3TIM .DATA .SETT $B3TIM
.IFT $B3TIM .DATA .SETN $DFTIM '$DFTIM'.
.IFT $B3TIM .DATA .SETN $MXTIM '$MXTIM'.
.IFF $B3TIM .DATA .SETF $B3TIM

            .DATA ;
.IFT $B3MEM .DATA ; Memory Limit Support = YES
.IFT $B3MEM .DATA ;	Default Memory Limit = '$DFMEM'. (KW)
.IFT $B3MEM .DATA ;	Maximum Memory Limit = '$MXMEM'. (KW)
.IFF $B3MEM .DATA ; Memory Limit Support = NO
.IFT $B3MEM .DATA .SETT $B3MEM
.IFT $B3MEM .DATA .SETN $DFMEM '$DFMEM'.
.IFT $B3MEM .DATA .SETN $MXMEM '$MXMEM'.
.IFF $B3MEM .DATA .SETF $B3MEM

            .DATA ;
.IFT $B3PAG .DATA ; Output Limit Support = YES
.IFT $B3PAG .DATA ;	Default Output Limit = '$DFPAG'. pages
.IFT $B3PAG .DATA ;	Maximum Output Limit = '$MXPAG'. pages
.IFF $B3PAG .DATA ; Output Limit Support = NO
.IFT $B3PAG .DATA .SETT $B3PAG
.IFT $B3PAG .DATA .SETN $DFPAG '$DFPAG'.
.IFT $B3PAG .DATA .SETN $MXPAG '$MXPAG'.
.IFF $B3PAG .DATA .SETF $B3PAG

            .DATA ;
.IFT $B3PQP .DATA ; Print Queue Priority at SUBMIT = YES
.IFF $B3PQP .DATA ; Print Queue Priority at SUBMIT = NO
.IFT $B3PQP .DATA .SETT $B3PQP
.IFF $B3PQP .DATA .SETF $B3PQP

            .DATA ;
.IFT $B3MSG .DATA ; Send Job Start/Finish messages = YES
.IFF $B3MSG .DATA ; Send Job Start/Finish messages = NO
.IFT $B3MSG .DATA .SETT $B3MSG
.IFF $B3MSG .DATA .SETF $B3MSG

            .DATA ;
.IFT $B3XIO .DATA ; Allow External Privileged I/O = YES
.IFF $B3XIO .DATA ; Allow External Privileged I/O = NO
.IFT $B3FSY .DATA ;	External, Messages forced to SYS-class
.IFF $B3FSY .DATA ;	External Messages written to logfile
.IFT $B3XIO .DATA .SETT $B3XIO
.IFF $B3XIO .DATA .SETF $B3XIO
.IFT $B3FSY .DATA .SETT $B3FSY
.IFF $B3FSY .DATA .SETF $B3FSY

            .DATA ;
            .DATA ; Number of Virtual Terminals = '$NVT'.
            .DATA .SETN $NVT '$NVT'.
            .DATA ;
            .DATA ;	********** END OF PARAMETER SUMMARY **********
            .DATA ;

.CLOSE

.ESAV:

.;
.; Set modes for proper substitution in GBLDEF lines.
.;

.SETO $DFTIM
.SETO $MXTIM
.SETO $DFMEM
.SETO $MXMEM
.SETO $DFPAG
.SETO $MXPAG
.SETO $DFPRI

.OPEN BV3PRE.MAC

;
; '<DATE>' '<TIME>' Create pre-assembly file '<FILSPC>'
;

.ENABLE DATA
	.IIF	NDF,BPROT, .NLIST
	.ENABL	LC
; This file created by BATGEN '$IDENT' on '<DATE>' at '<TIME>'

B3$BAT	=	300	; ** ALWAYS DEFINED **

.DISABLE DATA
.IFT $B3XIO .DATA B3$XIO	=	0	; Allow external privileged I/O
.IFT $B3FSY .DATA B3$FSY	=	0	; Force external privileged I/O to SYS messages
.IFT $B3ACC .DATA B3$ACC	=	0	; Accounting Support
.IFT $B3TIM .DATA B3$TIM	=	0	; Time limit support
.IFT $B3MEM .DATA B3$MEM	=	0	; Memory requirement support
.IFT $B3PAG .DATA B3$PAG	=	0	; Output limit support
.IFT $B3PQP .DATA B3$PQP	=	0	; SUBMIT prints queueing priority
.IFT $B3MSG .DATA B3$MSG	=	0	; Job Start/End messages to user
.ENABLE DATA
;
; Local equates required in many modules.
;

BELL	=	7		; Guess what this is
HT	=	11		; Horizontal tab
LF	=	12		; Linefeed
FF	=	14		; Formfeed
CR	=	15		; Carriage return
ESC	=	33		; Escape
SPA	=	40		; Space

;
; Message destination byte definitions.
; NB Definitions are assumed in driver source, and many other places.
;

MD$HST	=	200		; Write message to history file (set=yes)
MD$LOG	=	100		; Write message to logfile (set=yes)
MD$SYS	=	40		; Message is SYS class (if MD$HST set)

MD$SHF	=	MD$HST!MD$SYS	; Message is SYS+history file
MD$SHL	=	MD$HST!MD$LOG!MD$SYS ; Message is SYS+history file+logfile
MD$UHF	=	MD$HST		; Message is USR+history file
MD$UHL	=	MD$HST!MD$LOG	; Message is USR+history file+logfile

CC$SHF	=	<MD$SHF*400>	; Values to OR into carriage control word
CC$SHL	=	<MD$SHL*400>	;
CC$UHF	=	<MD$UHF*400>	;
CC$UHL	=	<MD$UHL*400>	;

;
; Macros.
;

.DISABLE DATA
.DISABLE SUBSTITUTION
.SETS L "'L'"
.SETS B "'B'"
.ENABLE SUBSTITUTION
.ENABLE DATA
	.MACRO	BV3DV$,L
	.EVEN
BATDEV:'L' .ASCII  /VT/
	.ENDM

	.MACRO	SOJDF$,L,B
	.ASECT
.=0
Q$JFUN:'L'	.BLKW	1	; Function code
Q$JUIC:'L'	.BLKW	1	; Binary job UIC
Q$JNAM:'L'	.BLKW	3	; Radix-50 jobname
Q$JATT:'L'	.BLKB	1	; Job attributes byte
Q$JUNT:'L'	.BLKB	1	; SY: device unit number
Q$JDEV:'L'	.BLKW	1	; SY: device name (ASCII)
Q$PRIN:'L'	.BLKW	2	; Print queue name
Q$JLEN='B'.			; Length used
QJ$SPL='B'10			; Logfile to be spooled
QJ$LOG='B'20			; Logfile to be generated
	.PSECT
	.MACRO	SOJDF$,X,Y
	.ENDM
	.ENDM

	.MACRO	SOFDF$,L,B
	.ASECT
.=0
Q$FFUN:'L'	.BLKW	1	; Function code
Q$FDEV:'L'	.BLKW	1	; ASCII device name
Q$FUNT:'L'	.BLKB	1	; Device unit
Q$FATT:'L'	.BLKB	1	; Attributes byte
Q$FUFD:'L'	.BLKW	1	; Binary UFD
Q$FNAM:'L'	.BLKW	3	; Radix-50 filename
Q$FTYP:'L'	.BLKW	1	; Radix-50 filetype
Q$FVER:'L'	.BLKW	1	; Binary version number
Q$FLEN='B'.			; Length used
QF$DEL='B'200			; Delete file at end of sub-job
	.PSECT
	.MACRO	SOFDF$,X,Y
	.ENDM
	.ENDM

	.IIF	NDF,BPROT, .LIST
.DISABLE DATA
.CLOSE

.OPEN VTTAB.MAC

;
; '<DATE>' '<TIME>' Build virtual terminal data base '<FILSPC>'
;

.SETN $NVT1 $NVT-1
.ENABLE DATA
	.TITLE VTTAB
	.IDENT	/V3.00/
	.NLIST	BEX
	.ENABL	LC
 
;********************************************************************
;
;	Data structures for Batch System driver.
;	For use by Batch System version 3 only.
;
;	This file built by BATGEN '$IDENT' at '<TIME>' on '<DATE>'
;
;	This file defines '$NVT'. UCBs
;
;	Each batch stream is on the same controller (there is only
;	one SCB). This is because the driver handles mutliple
;	operations in parallel, and uses $GSPKT to select the next
;	request to initiate. In this scheme, the SCB plays only
;	a minor role. See the source code for the driver for more
;	details.
;
; The unit control blocks (UCBs) for the batch streams are somewhat
; longer than those for normal terminals. The additional offsets
; involved are communicated to the rest of the Batch System via the
; symbol table created when this driver is built.
;
; Version:	V1	August 1979
; Version:	V2	January 1980
; Version:	V3	April 1983
;
;----------------------------------------------------------------------
;
;	Steve Thompson
;	School of Chemical Engineering
;	Olin Hall
;	Cornell University
;	Ithaca NY 14853
;	(607) 256 3895	(Computer Room)
;	(607) 256 4616	(Office)
;
;*********************************************************************
 
BUFSIZ	=	132.		; Initial buffer size (SET /BUF=VTN:)
				; (this is not really a meaningful parameter)
 
LD$VT=1				; Loadable driver if this symbol
				; is defined
 
	.PAGE
	.SBTTL	DEVICE CONTROL BLOCK
 
$VTDAT::			; Start of data base
 
;+
;
;	D E V I C E   C O N T R O L   B L O C K
;	=======================================
;
;	Note that the IO.ATT (Attach) and IO.DET (Detach) functions
;	are no-ops, because of the special nature of the driver.
;	The dispatch table ensures that the only operations that make
;	it through to the driver are IO.RLB and IO.WLB (IO.RVB and
;	IO.WVB are converted by $DRQIO to IO.RLB and IO.WLB respectively).
;
;-
 
$VTDCB:				; Label for DCB
	.WORD	0		; Link to next DCB (0=last)
	.WORD	.VT0		; Link to first UCB
	.ASCII	/VT/		; Batch stream device name
	.BYTE	0		; Lowest unit number
	.BYTE	'$NVT1'.		; Highest unit number
	.WORD	UCBLEN		; UCB length
 
	.IF	DF,LD$VT
	.WORD	0		; Pointer to driver dispatch table
	.IFF
	.WORD	$VTTBL
	.ENDC	; DF,LD$VT
 
	.WORD	160037		; Legal function mask codes 0-15
				; IO.ACE (access file for extend)
				; IO.ACW (access file for write)
				; IO.ACR (access file for read)
				; IO.ATT (attach device)
				; IO.DET (detach device)
				; IO.KIL (cancel I/O)
				; IO.WLB (write logical block)
				; IO.RLB (read logical block)
	.WORD	0		; Control function mask codes 0-15
	.WORD	160030		; No oped function mask codes 0-15
				; IO.ACE (access file for extend)
				; IO.ACW (access file for write)
				; IO.ACR (access file for read)
				; IO.ATT (attach device)
				; IO.DET (detach device)
	.WORD	0		; ACP function mask codes 0-15
	.WORD	7		; Legal function mask codes 16-31
				; IO.WVB (write virtual block)
				; IO.RVB (read virtual block)
				; IO.DAC (deaccess file)
	.WORD	0		; Control function mask codes 16-31
	.WORD	1		; No oped function mask codes 16-31
				; IO.DAC (deaccess file)
	.WORD	6		; ACP function mask codes 16-31
				; IO.RVB (read virtual block)
				; IO.WVB (write virtual block)
 
	.IF	DF,L$$DRV
	.WORD	0		; Loadable driver PCB address
	.ENDC	; DF,L$$DRV
	.PAGE
	.SBTTL	UNIT CONTROL BLOCKS
 
;+
;
;	U N I T   C O N T R O L   B L O C K S
;	=====================================
;
; Each UCB is configured to look exactly like a normal terminal UCB in
; case any /SET commands are used in a batch job. This is to prevent
; the system from being destroyed just because a batch stream looks
; like a terminal to the system. In addition, there are additional
; batch-specific offsets. These are placed at negative offsets from
; the normal terminal UCB.
;
; These additional offsets are as follows:
;
;	U.BTCB		TCB address of batch processor task. This is
;			non-zero only when a job is executing in the
;			relevant batch stream (a zero value does not
;			imply that the processor is dormant). 1 word.
;
;	U.BPKT		The address of the I/O packet for an outstanding
;			read by the batch processor, or zero if none.
;			If non-zero, the processor is waiting for a job
;			to do some output. 1 word.
;
;	U.BMEM		Maximum memory allowed to job in 32W blocks.
;			This is filled in by the batch processor task
;			whenever it encounters a *JOB card. 1 word.
;
;	U.BPRI		Maximum priority for execution of non-privileged
;			tasks in batch. This is filled in by the batch
;			processor whenever it encounters a *JOB card. 1 byte.
;
;	U.BSPR		Spare byte for expansion.
;
;	U.STCK		Virtual terminal stack listhead (2 words).
;
;-
 
.DISABLE DATA
.;
.; Create the UCBs.
.;

.SETO UNIT
.SETN UNIT 0.

.NXTUCB:

.IF UNIT > 0 .GOTO UNIT1

.ENABLE DATA
VTST=.				; Start of this UCB
BPTCB=.
	.WORD	0		; TCB address of batch processor (filled in
				; by the processor itself when active)
BPPKT=.
	.WORD	0		; I/O packet address (batch processor read)
BPMEM=.
	.WORD	0		; Maximum allowed memory
BPPRI=.
	.BYTE	0		; Maximum priority
BPSPR=.
	.BYTE	0		; Spare byte
BPSTCK=.
.STK'UNIT'::
	.WORD	0		; Stack listhead
	.WORD	.STK'UNIT'		;
.DISABLE DATA
.GOTO UNIT2

.UNIT1:

.ENABLE DATA
	.WORD	0		; Same (make sure it is!!)
	.WORD	0		;
	.WORD	0		;
	.BYTE	0		;
	.BYTE	0		;
.STK'UNIT'::
	.WORD	0		;
	.WORD	.STK'UNIT'			;
 
.DISABLE DATA

.UNIT2:

.ENABLE DATA
	.WORD	0		; CLI pointer (RSX-11M V4.0 and up)
	.WORD	0		; Logon UIC
	.WORD	0		; Owning terminal UCB address
.VT'UNIT'::
	.WORD	$VTDCB		; Backpointer to DCB
	.WORD	.VT'UNIT'		; Pointer to redirect unit UCB
	.BYTE	UC.KIL		; Control flags byte
	.BYTE	0		; Unit status byte
	.BYTE	'UNIT'.		; Physical unit number
	.BYTE	0		; 2nd status byte
	.WORD	DV.REC!DV.CCL!DV.TTY ; First characteristics word
 
	.IF	DF,M$$MUP
	.IFF
	.WORD	U2.PRV		; 2nd characteristics word
	.IFT
	.IF	GT,M$$MUP
	.WORD	U2.LOG		; Terminal starts off life logged off
	.IFF
	.WORD	U2.PRV
	.IFTF
M$$MUP=M$$MUP+1
	.ENDC	; GT,M$$MUP
	.ENDC	; DF,M$$MUP
 
	.WORD	0		; 3rd characteristics word
	.WORD	BUFSIZ		; 4th characteristics word
 
	.WORD	$VTSCB		; Pointer to status control block
 
	.WORD	0,0,0,0,0,0,0,0,0,100200,$BTMSK+1,0,0,0
 
	.IIF	DF,T$$ACR!T$$BTW!T$$CCA!T$$CCO!T$$ESC!T$$HLD, T1=0
	.IIF	DF,C$$CKP&T$$BUF, DFCKP=0
	.IF	DF,T1!T$$RPR!T$$SYN!T$$TRW!T$$UTB!T$$30P!DFCKP
	.WORD	0
	.ENDC	;
 
	.IF	DF,T$$CCA & A$$TRP
	.WORD	0
	.ENDC	; DF,T$$CCA & A$$TRP
 
	.IF	DF,T$$ESC
	.WORD	0
	.ENDC	; DF,T$$ESC
 
.DISABLE DATA
.IF UNIT = 0 .DATA VTND=.					; End of this UCB

.INC UNIT
.IF UNIT < $NVT .GOTO NXTUCB

.ENABLE DATA
UCBLEN=VTND-VTST			; Length of each UCB
 
;
; Define offsets globally for transfer to rest of system via the
; symbol table.
;
 
U.BTCB==BPTCB-.VT0			; UCB offset for TCB field
 
U.BPKT==BPPKT-.VT0			; UCB offset for I/O pkt. address
 
U.BMEM==BPMEM-.VT0			; UCB offset for memory limit
 
U.BPRI==BPPRI-.VT0			; UCB offset for maximum priority
 
U.BSPR==BPSPR-.VT0			; UCB offset, spare byte
 
U.STCK==BPSTCK-.VT0			; UCB offset for stack listhead
 
	.PAGE
	.SBTTL	STATUS CONTROL BLOCK
 
;+
;
;	S T A T U S   C O N T R O L  B L O C K S
;	========================================
;
;	There is one SCB for all UCBs.
;
;-
 
$VTSCB::			; Start of SCB
	.WORD	0		; I/O packet listhead
	.WORD	$VTSCB		;
	.BYTE	0,0		; No interrupts
	.BYTE	0,0		; No timeouts
	.BYTE	0		; Controller index
	.BYTE	0		; Controller status byte
	.WORD	0		; CSR address
	.WORD	0		; I/O packet address
	.WORD	0,0,0,0		; Fork block
 
	.IF	DF,L$$DRV & M$$MGE
 
	.WORD 0
 
	.ENDC	; DF,L$$DRV&M$$MGE
 
$VTEND::			; End of data base
 
	.END
.DISABLE DATA
	.CLOSE
	.ENABLE ESCAPE
	.IFF $COMM .GOTO EXEMC

;
;	There follow two questions concerning the location of two
;	Executive files. The rules for answering are as follows:
;
;	1. An answer of RETURN defaults to the device/UFD in the question.
;
;	2. An answer of ESCAPE defaults the the user''s current SY:/UIC.
;
;	3. An answer of ddnn:[ggg,mmm] uses the value entered.
;
;	Please enter both the device and UIC if format (3) is used.
;	The type of answer you give will depend on how you set up the
;	files EXEMC.MLB and RSXMC.MAC before running BATGEN.
;

.EXEMC:

	.ASKS LIBUIC Where is EXEMC.MLB if not LB:[1,1]
	.IFT <ESCAPE> .SETS LIBUIC "SY:"+<UIC>
	.IFF <ESCAPE> .IF LIBUIC EQ "" .SETS LIBUIC "LB:[1,1]"

	.ASKS RSXMC Where is RSXMC.MAC if not LB:[200,200]
	.IFT <ESCAPE> .SETS RSXMC "SY:"+<UIC>
	.IFF <ESCAPE> .IF RSXMC EQ "" .SETS RSXMC "LB:[200,200]"

	.SETS EXEFIL LIBUIC+"EXEMC/ML,"+RSXMC+"RSXMC/PA:1"

	.IFF $B3ACC .GOTO NOACC
	.ASKS ACCFIL Where is ACCPRE.MAC if not LB:[10,207]
	.IFT <ESCAPE> .SETS ACCFIL "SY:"+<UIC>
	.IFF <ESCAPE> .IF ACCFIL EQ "" .SETS ACCFIL "SY:[10,207]"
.NOACC:

.;
.; Install some tasks.
.;

	.SETT $PIP
	.IFNINS ...PIP .SETF $PIP
	.IFNINS ...PIP INS $PIP

	.SETT $MAC
	.IFNINS ...MAC .SETF $MAC
	.IFNINS ...MAC INS $MAC

	.SETT $LBR
	.IFNINS ...LBR .SETF $LBR
	.IFNINS ...LBR INS $LBR

	.IFF $COMM .GOTO GETQMG

;
; Certain patches have to be made to objects distributed on the RSX
; kit. These objects are in the file QMGCLI.OLB. We make a copy of
; this file and apply the patches to it (unless it has already been
; done). The original object modules extracted from this library
; will remain in SY:'<UIC>' with a file type of .ORG.
;

.GETQMG:

	.ASK DONYET Have you already done the library copy/extraction
	.IFT DONYET .GOTO ORGOK
	.ASKS QMGCLI Where is QMGCLI.OLB (ddnn:[g,m]) Default is LB:[1,24]
	.IF QMGCLI EQ "" .SETS QMGCLI "LB:[1,24]"
	PIP SY:/NV='QMGCLI'QMGCLI.OLB
	LBR CLISUB.ORG=QMGCLI.OLB/EX:CLISUB
	LBR SUBJNM.ORG=QMGCLI.OLB/EX:SUBJNM
	LBR WFIND.ORG=QMGCLI.OLB/EX:WFIND

.ORGOK:

;
;	'<DATE>' '<TIME>' Begin Assembly (Time for coffee break).
;

	.SETF SPOOL
	.SETF QMG
	.SETS LSTDEV ""
	.ASK LIST Do you want assembly listings
	.IFT LIST .ASKS LSTDEV Listing device (ddu:, default is SY:)
	.IFT LIST .ASK QMG Use Queue Manager to print listings
	.IFT LIST .IFF QMG .ASK SPOOL Spool listing files

	.SETS FTYP ".MAC"
	.SETS OTYP ".OBJ"

.;
.; Assemble the driver and database.
.;

	.SETS FILE "VTTAB"
	.GOSUB ASM

	.SETS FILE "VTDRV"
	.GOSUB ASM

.;
.; Assemble the Batch Processor Task.
.;

	.SETS FILE "BAPEOJ"
	.GOSUB ASM

	.SETS FILE "BAPEXT"
	.GOSUB ASM

	.SETS FILE "BAPFIL"
	.GOSUB ASM

	.SETS FILE "BAPINI"
	.GOSUB ASM

	.SETS FILE "BAPMSG"
	.GOSUB ASM

	.SETS FILE "BAPROT"
	.GOSUB ASM

	.SETS FILE "BAPSOJ"
	.GOSUB ASM

	.SETS FILE "BAPSTP"
	.GOSUB ASM

	LBR BAPLIB.OLB/CR=BAPROT,BAPSOJ,BAPEOJ,BAPFIL
	LBR BAPLIB.OLB/IN=BAPINI,BAPSTP,BAPEXT,BAPMSG
	PIP BAPROT.OBJ;*/DE,BAPSOJ.OBJ;*,BAPEOJ.OBJ;*,BAPFIL.OBJ;*
	PIP BAPINI.OBJ;*/DE,BAPSTP.OBJ;*,BAPEXT.OBJ;*,BAPMSG.OBJ;*

.;
.; Assemble patched components of MCR.
.;

	.SETS FILE "BATALLOV"
	.GOSUB ASM

	.SETS FILE "BATINSLB"
	.GOSUB ASM

	.SETS FILE "BATMCRDIS"
	.GOSUB ASM

.;
.; Assemble patch files for QMGCLI.
.;

	.SETS FTYP ".PAT"
	.SETS OTYP ".POB"

	.SETS FILE "CLISUB"
	.GOSUB ASM

	.SETS FILE "WFIND"
	.GOSUB ASM

	.SETS FILE "SUBJNM"
	.GOSUB ASM

	.SETS FTYP ".MAC"
	.SETS OTYP ".OBJ"

	.SETS FILE "SUBDAT"
	.GOSUB ASM

	.SETS FILE "QCHK"
	.GOSUB ASM

.;
.; Assemble miscellaneous components.
.;

	.SETS FILE "JOBMSG"
	.GOSUB ASM

.;
.; Now done with assembly.
.;

	.ASK DELASM Delete assembly (.ASM) files
	.IFT DELASM PIP *.ASM;*/DE

;
; Apply patches to modules extracted from QMGCLI.OLB
;

	.SETT $PAT
	.IFNINS ...PAT .SETF $PAT
	.IFNINS ...PAT INS $PAT
	PAT CLISUB.OBJ=CLISUB.ORG,CLISUB.POB
	PAT SUBJNM.OBJ=SUBJNM.ORG,SUBJNM.POB
	PAT WFIND.OBJ=WFIND.ORG,WFIND.POB
	.IFF $PAT REM PAT
	LBR QMGCLI/RP=CLISUB,SUBJNM,WFIND,QCHK,SUBDAT
	LBR QMGCLI/CO:97.=QMGCLI
	PIP QMGCLI.OLB/PU

;
; We are now ready to task build the package.
;

.;
.; Determine map file disposition.
.;

	.ASK MAP Do you want task builder maps
	.IFF MAP .SETF SPOOL
	.IFF MAP ASN NL:=MP:
	.IFF MAP .SETF QMG
	.IFT MAP .ASK SPOOL Spool map files
	.IFT MAP ASN SY:=MP:
	.IFT MAP .IFF SPOOL .SETF QMG

.;
.; Determine if FCSRES is present.
.;

	.SETF $FCSR
	.ASK $FCSR Do you have the PLAS FCS resident library built by SYSGEN
	.IFT $FCSR .SETS FCSCOM ";	Includes FCSRES"
	.IFF $FCSR .SETS FCSCOM ";	Does NOT include FCSRES"

.;
.; Install some tasks
.;

	.SETT $TKB
	.IFNINS ...TKB .SETF $TKB
	.IFNINS ...TKB INS $TKB

	.SETT $PRI
	.IFT QMG .IFNINS ...PRI .SETF $PRI
	.IFT QMG .IFNINS ...PRI INS $QMGCLI/TASK=...PRI

;
; '<DATE>' '<TIME>' Create task builder command files.
;

.;
.; Calculate $DXPRI constant for BAP scheduling algorithm.
.;

	.SETN $DXPRI $DFPRI/5
	.IFT $B3TIM .SETN $DXPRI $DXPRI*$DFTIM
	.IFT $B3MEM .SETN $DXPRI $DXPRI*$DFMEM
	.SETO $DXPRI

.;
.; Create BAPBLD.CMD
.;

.OPEN BAPBLD.CMD
; ...Creating '<FILSPC>'
.ENABLE DATA
;
;	Task Builder Command file for Batch Processor Task, BAP.TSK.
;	This file created by BATGEN '$IDENT' on '<DATE>' at '<TIME>'
'FCSCOM'
;
;	Batch System Version 3, April 1983.
;
;	Steve Thompson
;	School of Chemical Engineering
;	Cornell University
;	Ithaca NY 14853
;
;	NOTE: Building as non-checkpointable (/-CP) will not compensate
;	for not having Asynchronous Buffered I/O support in the system.
;	It will just serve to waste memory.
;
BAP/CP/-FP/PR/-SL/SE/-IP,MP:BAP/-SP/-WI=BAPBLD/MP
PAR=GEN			; Must have GEN on system (or specify size)
STACK=128		; BAP uses quite a lot of stack
UNITS=6			;
ASG=LB:1		; Log File
ASG=LB:2		; History File
ASG=LB:3		; Command File
ASG=VT0:4		; Batch Stream (assigned during initialization)
ASG=CO:5		; Console
ASG=CO:6		; User Messages, and miscellaneous other duties
PRI=55			; Not lower than this please
TASK=BAP0		; Installed as BAP0, BAP1, BAP2, etc
.DISABLE DATA
.IFT $FCSR .DATA LIBR=FCSRES:RO:7
.ENABLE DATA
;
; The following definitions give the default and maximum time limit,
; memory requirement, and page limits.
;
GBLDEF=$DFTIM:'$DFTIM'
GBLDEF=$MXTIM:'$MXTIM'
GBLDEF=$DFMEM:'$DFMEM'
GBLDEF=$MXMEM:'$MXMEM'
GBLDEF=$DFPAG:'$DFPAG'
GBLDEF=$MXPAG:'$MXPAG'
;
; The following definition gives the priority with which a job will
; be inserted into the batch queue if both time limit and memory
; requirement are equal to the defaults. Any 8-bit value is acceptable,
; but anything much less than 50 or greater than 150 will work
; against the value of the scheduling algorithm.
; The value is given in octal.
;
GBLDEF=$DFPRI:'$DFPRI'
;
; The following definition gives the constant in the algorithm used
; to calculate the maximum priority with which a non-privileged task
; in the batch stream may execute. The value of this constant should
; be approximately equal to the product of $DFPRI, $DFTIM and $DFMEM,
; divided by 5. Miss out any term in the product if the corresponding
; feature is not supported (if neither time or memory limit is supported,
; the value of $DXPRI is ignored and a priority of 5 is used). The
; operation of this feature requires an MCR patch.
;
GBLDEF=$DXPRI:'$DXPRI'
;
; The following global definition gives the number of lines per
; page in the log and history files. If you specify a value equal
; to or lower than 60, output such as compiler listings and task
; builder maps will probably be screwed up.
; The value is octal, and 76(8)=62(10) is recommended.
;
GBLDEF=$LINPP:76
;
; The following global patches give the default directory  in
; which the log files will be written. Unfortunately, the patches
; must be made in octal.
; The values set up below are the same as the assembly default,
; or LB0:[1,71].
; When changing these, note that the UFD string must have nine characters
; AND a trailing space, eg [001,071]<SPA>.
;
; Global patch on $DNAM is log file device name (2 ASCII characters).
; Global patch on $DEVU is log file device unit (binary).
; Global patch on $DUFD is log file UFD (10 ASCII characters).
;
GBLPAT=BAPROT:$DNAM:41114
GBLPAT=BAPROT:$DEVU:0
GBLPAT=BAPROT:$DUFD:030133:030460:030054:030467:020135
;
GBLREF=$FMTDV		; Put this module from MCR.OLB in the root
;
; End of task builder command file.
;
/
.DISABLE DATA
.CLOSE

.;
.; Create BAPBLD.ODL
.;

.OPEN BAPBLD.ODL
; ...Creating '<FILSPC>'
.ENABLE DATA
;
;	Overlay Description file for Batch Processor BAP.TSK.
;	This file created by BATGEN '$IDENT' on '<DATE>' at '<TIME>'
'FCSCOM'
;
;	Batch System Version 3, April 1983.
;
.DISABLE DATA
.IFT $FCSR .DATA	.ROOT	LOW-*(INI,SOJ,EOJ,FIL,EXT)
.IFF $FCSR .DATA	.ROOT	LOW-*(INI,SOJ,EOJ,FIL,EXT),FCSOVR
.ENABLE DATA
LOW:	.FCTR	BAPLIB/LB:BAPROT:BAPSTP-SYM-MCR-MULDIV-EXEC
INI:	.FCTR	BAPLIB/LB:BAPINI-EXEC
SOJ:	.FCTR	BAPLIB/LB:BAPSOJ:BAPMSG-EXEC
EOJ:	.FCTR	BAPLIB/LB:BAPEOJ:BAPMSG-EXEC
FIL:	.FCTR	BAPLIB/LB:BAPFIL-EXEC
EXT:	.FCTR	BAPLIB/LB:BAPEXT-EXEC

SYM:	.FCTR	LB:[1,24]QMG/LB:QMGSYM
MCR:	.FCTR	LB:[1,24]MCR/LB
MULDIV:	.FCTR	LB:[1,1]SYSLIB/LB:ARITH
EXEC:	.FCTR	LB:[1,1]EXELIB/LB-LB:[1,54]RSX11M.STB/SS-LB:[1,54]VTDRV.STB/SS
.DISABLE DATA
.IFT $FCSR .GOTO NOFCSB
.ENABLE DATA
FCSOVR:	.FCTR	FCSOVX-*(FCSOV1,FCSOV2,FCSOV3,FCSOV4,FCSOV5,FCSOV6)
	.NAME	FCSOVX
FCSOV1:	.FCTR	LB:[1,1]SYSLIB/LB:.CSI1:.CSI2
FCSOV2:	.FCTR	LB:[1,1]SYSLIB/LB:PARSE
FCSOV3:	.FCTR	LB:[1,1]SYSLIB/LB:OPEN:OPFNB:FINIT
FCSOV4:	.FCTR	LB:[1,1]SYSLIB/LB:CLOSE:DLFNB:$PRINT:GETDID:MRKDL
FCSOV5:	.FCTR	LB:[1,1]SYSLIB/LB:GETSQ:PUTSQ:PNTMRK
FCSOV6:	.FCTR	LB:[1,1]SYSLIB/LB:GET:PUT
.DISABLE DATA

.NOFCSB:
	.DATA	.END
.CLOSE

.;
.; Create QMGCLIBLD.CMD
.;

.OPEN QMGCLIBLD.CMD
; ...Creating '<FILSPC>'
.ENABLE DATA
;
;	Task Builder command file for QMGCLI.TSK.
;	This file created by BATGEN '$IDENT' on '<DATE>' at '<TIME>'
;	This version incorporates the patches necessary for inclusion
;	of Batch V3.
'FCSCOM'
;
QMGCLI/-FP/CP/MM,MP:QMGCLI/-SP/-WI=QMGCLIBLD/MP
TASK=...QUE		; Also ...PRI and ...SUB
STACK=128		;
UNITS=4			; More than DEC version!
ASG=TI:2		; Listing LUN
ASG=TI:3		; Error message LUN
ASG=SY:4		; For *JOB card processing
EXTSCT=$$FSR1:2040	; ditto
PRI=55
.DISABLE DATA
.IFT $FCSR .DATA LIBR=FCSRES:RO
.ENABLE DATA
;
GBLDEF=$DFPRI:'$DFPRI'
GBLDEF=$DFTIM:'$DFTIM'
GBLDEF=$MXTIM:'$MXTIM'
GBLDEF=$DFMEM:'$DFMEM'
GBLDEF=$MXMEM:'$MXMEM'
GBLDEF=$DFPAG:'$DFPAG'
GBLDEF=$MXPAG:'$MXPAG'
;
; This task must be installed three times. Once with the name ...QUE
; as specified here in the task build command file, once
; with the name ...PRI and once with the name ...SUB.
;
;
; You may also specify what the default job attributes will be for a job.
;
;	PRINT JOBS.....
;
;		VALUE		OPTION
;		4		print job should be held
;		10		print job flag pages
;		20		lower case printer required
;		100		print file flag pages
;		200		job is restartable
;
GBLDEF=$PRIDF:10
;
;	and BATCH JOBS.....
;
;		VALUE		OPTION
;		4		batch job should be held
;		10		log should be spooled
;		20		log should be generated
;		200		job is restartable
;
;
;	* * * * * *   I M P O R T A N T   * * * * * *
;
;	NOTE:	If you have applied the patches to WFIND and CLISUB and
;		are using SUBMIT to determine the scheduling priority,
;		the hold bit (004) MUST BE SET. If this is not the case,
;		the scheduling algorithm will not work properly.
;
;	* * * * * *   I M P O R T A N T   * * * * * *
;
GBLDEF=$SUBDF:34
;
;	This is the bit of magic that forces recognition of batch queues.
;
GBLPAT=QMGCLI:LSTOPT:176000
GBLPAT=QMGCLI:DEVOPT:144000
;
/
.DISABLE DATA
.CLOSE

.;
.; Create QMGCLIBLD.ODL
.;

.OPEN QMGCLIBLD.ODL
; ...Creating '<FILSPC>'
.ENABLE DATA
;
; Task Builder Overlay description file for QMGCLI.TSK.
; This file created by BATGEN '$IDENT' on '<DATE>' at '<TIME>'
; This file incorporates changes to the DEC version for support
; of V3 Batch.
'FCSCOM'
;
	.PSECT	ER$MSG,D,GBL
.DISABLE DATA
.IFT $FCSR .DATA	.ROOT	MAIN
.IFF $FCSR .DATA	.ROOT	MAIN,FCSTRE
.DATA MAIN:	.FCTR	R0-QMGCLI/LB:ERRMSG:SUBDAT-*(SEG1,SEG2,SEG3,SEG4,SEG5)
.DATA ;
.IFT $FCSR .DATA R0:	.FCTR	QMGCLI/LB:QMGCLI:SEND-R3
.IFF $FCSR .DATA R0:	.FCTR	QMGCLI/LB:QMGCLI:SEND-R2-R3
.IFF $FCSR .DATA R2:	.FCTR	LB:[1,1]SYSLIB/LB:CAT5:PPNASC
.ENABLE DATA
R3:	.FCTR	LB:[1,24]QMG/LB:QMGSYM
;
SEG1:	.FCTR	QMGCLI/LB:CLIERR-ER$MSG
;
	.NAME	SHOW
SEG2:	.FCTR	SHOW-*(S21,S22)
S21:	.FCTR	QMGCLI/LB:SHOWP
S22:	.FCTR	QMGCLI/LB:SHOWQ
;
SEG3:	.FCTR	QMGCLI/LB:CLIPRI:PRIWRN-*(S31,S33,S34)
S31:	.FCTR	QMGCLI/LB:PRIOPJ:PRIAFJ
S33:	.FCTR	QMGCLI/LB:PRIJNM:QUEAFT
S34:	.FCTR	QMGCLI/LB:WFIND:QCHK
;
SEG4:	.FCTR	QMGCLI/LB:CLIQUE-*(S42,S43)
S42:	.FCTR	QMGCLI/LB:LST:CSI3
S43:	.FCTR	QMGCLI/LB:QUE:CSI3-*(S431,S432,S433,S434)
S431:	.FCTR	QMGCLI/LB:QUE1:QUEAFT
S432:	.FCTR	QMGCLI/LB:QUE2
S433:	.FCTR	QMGCLI/LB:QUE3
S434:	.FCTR	QMGCLI/LB:QUE4
;
SEG5:	.FCTR	QMGCLI/LB:CLISUB:SUBWRN-*(S51,S53,S54)
S51:	.FCTR	QMGCLI/LB:SUBOPJ:SUBAFJ
S53:	.FCTR	QMGCLI/LB:SUBJNM:QUEAFT
S54:	.FCTR	QMGCLI/LB:WFIND:QCHK
;
.DISABLE DATA
.IFF $FCSR	.DATA	.NAME	FCS
.IFF $FCSR	.DATA FCSTRE:	.FCTR	FCS-*(F2,F3,F4)
.IFF $FCSR	.DATA F2:	.FCTR	LB:[1,1]SYSLIB/LB:PARSE
.IFF $FCSR	.DATA F3:	.FCTR	LB:[1,1]SYSLIB/LB:UDIREC
.IFF $FCSR	.DATA F4:	.FCTR	LB:[1,1]SYSLIB/LB:ASCPPN
.DATA	.END
.CLOSE

;
; '<DATE>' '<TIME>' Start of task building.
;

		TKB @VTDRVBLD.CMD
		.IFT SPOOL PIP VTDRV.MAP/SP
		.IFT QMG PRINT /-FL/PRIO:'$PRPRI'=VTDRV.MAP/DEL
.;
		TKB @BAPBLD.CMD
		.IFT SPOOL PIP BAP.MAP/SP
		.IFT QMG PRINT /-FL/PRIO:'$PRPRI'=BAP.MAP/DEL
.;
		TKB @QMGCLIBLD.CMD
		.IFT SPOOL PIP QMGCLI.MAP/SP
		.IFT QMG PRINT /-FL/PRIO:'$PRPRI'=QMGCLI.MAP/DEL

;
;	That''s it folks! Please refer to the documentation to determine
;	what to do next.
;
;	Good Luck!
;
;	Bye bye from BATGEN.
;

	.IFF $PIP REM PIP
	.IFF $MAC REM MAC
	.IFF $LBR REM LBR
	.IFF $TKB REM TKB
	.IFT QMG .IFF $PRI REM PRI

	.IF $CLI NE "MCR" SET /CLI=TI:'$CLI'
	.EXIT

.;
.; Subroutines
.;

.ASM:
	.SETS LSTNG ""
	.IFT LIST .SETS LSTNG ","+LSTDEV+FILE
	.IFT LIST .IFT SPOOL .SETS LSTNG LSTNG+"/SP"
	.IFT LIST .IFF SPOOL .SETS LSTNG LSTNG+"/-SP"
	.OPEN 'FILE'.ASM
	.DATA ; This file created by BATGEN '$IDENT' on '<DATE>' at '<TIME>'
	.DATA 'FILE''OTYP''LSTNG'='EXEFIL',-
	.DATA SY:'<UIC>'BV3PRE,-
.IFT $B3ACC .DATA 'ACCFIL'ACCPRE,-
	.DATA SY:'<UIC>''FILE''FTYP'
	.CLOSE
.ASMMAC:
	.TESTFILE 'FILE''FTYP'
	.IF <FILERR> NE 1 .GOTO ASMEXI

	MAC @'FILE'.ASM
	.IF <EXSTAT> NE 1 .GOTO ASMERR
	.IFT QMG PRINT /-FL/PRIO:'$PRPRI'='FILE'.LST/DEL
	.RETURN

.ASMEXI:

	.SETN FCSNUM 256.-<FILERR>

;
;	*WARNING*	There is a problem with file 'FILE''FTYP', FCS -'FCSNUM'.
;			I will pause to give you an opportunity to correct
;			the problem. When you have done this, restart me and
;			I will try the assembly again.
;

	.PAUSE
	.GOTO ASMMAC

.ASMERR:

;
;	*WARNING*	This assembly returned an exit status of '<EXSTAT>'.
;			I will pause to give you an opportunity to correct
;			the problem. When you have done this, restart me and
;			I will try the assembly again.
;

	.PAUSE
	.GOTO ASMMAC
