.;******************************************************************
.;
.;  Startup command file used in School of Chemical Engineering.
.;  Initialize exec, batch and accounting systems.
.;  Note that all lines starting .; will not be displayed when the
.;  startup file is executed.
.;
.;  Steve Thompson, 1979.
.;  School of Chemical Engineering
.;  Olin Hall
.;  Cornell University
.;  Ithaca NY 14853
.;
.;  Revision History
.;  ----------------
.;
.;  SMT707  7-Jul-81 Modifications to LOG... to simulate a
.;  		     logon when it is started no longer require
.;  		     the logoff/logon sequence in the startup
.;  		     file when initializing the accounting
.;  		     system. This patch removes this code.
.;
.;  SMT745 16-Sep-81 Addition of statistics accumulation feature
.;  		     of task UPD... This task is now entered into
.;  		     the clock queue to run on the first hour after
.;  		     boot and then every six minutes.
.;
.;  SMT746 18-Sep-81 Several small changes, mostly of a cosmetic
.;  		     nature. No changes to functionality.
.;
.;  SMT781  5-Nov-81 Run UPD... at the next multiple of 6 minutes
.;  		     past midnight rather than at the hour.
.;
.;  SMT805 16-Mar-82 Altered disk accounting interval from every
.;  		     7 hours to every 5 hours.
.;
.;  SMT810 25-Mar-82 Added the terminal watcher task WATCHR
.;
.;  SMT814 12-Apr-82 Added support for RSX-11M V4.0 and made some
.;  		     cosmetic changes (changed names of some
.;  		     symbols).
.;
.;  SMT820 21-Apr-82 Changed MACNT to BAL.
.;
.;  SMT825  7-Jun-82 Added start up of console logger. Removed
.;  		     "delete error log files" question for
.;  		     RSX-11M V4.0.
.;
.;  SMT826 30-Jun-82 Added the DISKUSE command.
.;
.;  SMT837 14-Sep-82 Correct DCL initialization. Modified startup
.;		     file format slightly.
.;
.;  SMT843 25-Apr-83 Tidy up and allow for Batch V2/V3 startup.
.;
.;  SMT851 22-Jul-83 Added RSX-11M V4.1 support
.;
.;******************************************************************
.ENABLE SUBSTITUTION
.ENABLE GLOBAL
.;******************************************************************
.;
.;  System should be set up with VMR so that logons are disabled
.;  in the saved system image. This is to prevent users logging
.;  on during accounting initialization. If this is not the case,
.;  a SET /NOLOGON command should appear here.
.;
.;******************************************************************
SET /NOLOGON
.;
.ASKS TIM Please enter time and date (HH:MM:SS DD-MMM-YY)
TIM 'TIM'
.;******************************************************************
.;
.;  Alter the ACS command as fits your installation.
.;
.;******************************************************************
ACS LB0:/BLKS=2500.
.;******************************************************************
.;
.;  The system should be saved so that the logon UIC of the
.;  terminal when it is booted corresponds to a privileged
.;  account which has an entry in the account file. Normally,
.;  the system UIC [1,54] is used here. If the logon UIC does not
.;  correspond to an account in the account file, BYE will
.;  complain when you try to log off, and accounting data for
.;  the session will not be charged.
.;
.;******************************************************************
.;
SET /UIC
.ASK NST Non-standard start
.IFF NST .SETT NORMAL
.IFT NST .SETF NORMAL
.50: .IFT NST .ASK NORMAL Start a normal production run
.IFF NORMAL .GOTO 100
.;******************************************************************
.;
.;  This section starts a normal accounting run. All tasks needed
.;  by the accounting package are installed from the device and
.;  UIC specified in the string symbol UIC. The system account
.;  1,54 is already logged on, and LOG... simulates the reception
.;  of a HELLO request, to square the fact that the initiating
.;  terminal is already logged on (before start of accounting).
.;  If any other terminals are logged on in the saved system
.;  image, LOG... will simulate HELLO requests for them also.
.;  The following symbols should be set according to the options
.;  requested at ACCGEN (set symbols to true or false; do not
.;  remove their definitions):
.;
.;  	$SALT			Auxiliary logging task (ALT...)
.;  	$SUSE			USE command
.;  	$SCPU (or $ENDS)	CPU /ON/OFF or /EN/DS functions
.;  	$STSF			TSF command support
.;  	$RSXV4			RSX-11M V4.0 or V4.1 (false=V3.2)
.;	$BATV3			Batch version 3 (false=Version 2)
.;
.;  Set the symbol $SDSK to true if you want disk accounting. The
.;  DISKUSE command is independent of this and is always
.;  available.
.;
.;  The symbol $WATCH should be set to true if you want to activate
.;  the terminal watcher task WATCHR (only if TSF support).
.;
.;******************************************************************
; *************** NORMAL ACCOUNTING PRODUCTION RUN ***************
.SETS UIC "LB0:[10,207]"
.;
.SETT $SALT		; ALT... is supported (SETT)
.SETT $SUSE		; USE is supported (SETT)
.SETT $SCPU		; CPU is supported (SETT)
.SETT $STSF		; TSF is supported (SETT)
.SETT $SDSK		; Disk accounting required (SETT)
.SETT $WATCH		; Terminal watcher required (SETT)
.SETT $RSXV4		; RSX-11M V4.0 (SETT; change to SETF for V3.2)
.SETT $BATV3		; Batch System Version 3 (SETT, SETF for Version 2)
.;
.IFF $RSXV4 .SETF $BATV3
.;
.;  Replace installed versions of HELLO and BYE with the correct
.;  ones since the installed copies may not be the right versions.
.;
.IFINS ...HEL REM ...HEL
.IFINS ...BYE REM ...BYE
INS 'UIC'HELV7
INS 'UIC'BYEV7
.;
.;  Activate the console logger task COT... (RSX-11M V4.0 only)
.;
.IFT $RSXV4 .IFF NST .SETT COT
.IFT $RSXV4 .IFT NST .ASK COT Start up console logger task
.IFT $RSXV4 .IFT COT SET /COLOG=ON
.;
.;  Activate the accounting system logging task. You may wish to
.;  change the default partition assignment (The partition specified
.;  at task-build time is GEN).
.;
.IFNINS LOG... INS 'UIC'LOG/PAR=LOGPAR/CKP=NO
RUN LOG... 1T
.;
.;  Activate the terminal watcher task WATCHR (before running
.;  ACNODE to save pool space in the accounting list). Its TI:
.;  will be CO:
.;
.IFT $STSF .IFT $WATCH .IFNINS WATCHR INS 'UIC'WATCHR
.IFT $STSF .IFT $WATCH RUN WATCHR 1S
.;
.;  See if any mail if waiting.
.;
.IFINS ...MAI MAIL ME
.;
.;  Start up the Queue Manager.
.;
.IFF NST .SETT QMG
.IFT NST .ASK QMG Start up the Queue Manager
.IFT QMG .TESTFILE LB:[1,2]QMGSTART.CMD
.IFT QMG .IF <FILERR> NE 1 .SETF QMG
.IFT QMG @LB:[1,2]QMGSTART
.;
.;  Initialize DCL (RSX-11M V4.0 or V4.1 only). Use a prompt of
.;  "$ " to make it look like VMS.
.;
.IFT $RSXV4 CLI /INIT=DCL/TASK=...DCL/LGO/DPR="<15><12>/$ /"
.;
.;  Insert intercepts in the exec and send some basic data to
.;  LOG... by running ACNODE (not installed).
.;
RUN 'UIC'ACNODE
.;
.;  Make sure that the necessary accounting tasks are installed.
.;
.IFT $SUSE .IFNINS ...USE INS 'UIC'USE
.IFF $SUSE .IFINS  ...USE REM ...USE
.IFT $SALT .IFNINS ALT... INS 'UIC'ALT
.IFF $SALT .IFINS  ALT... REM ALT...
.IFT $SUSE .IFNINS UPD... INS 'UIC'UPD
.IFF $SUSE .IFINS  UPD... REM UPD...
.IFT $STSF .IFNINS ...TSF INS 'UIC'TSF
.IFF $STSF .IFINS  ...TSF REM ...TSF
.IFNINS CPTASK INS 'UIC'CPTASK/TASK=CPTASK
.IFT $SCPU .IFNINS ...CPU INS 'UIC'CPU
.IFF $SCPU .IFINS  ...CPU REM ...CPU
.IFNINS ...CHG INS 'UIC'CHG
.IFNINS ...BAL INS 'UIC'BAL
.IFNINS ...RSU INS 'UIC'RSU
.IFNINS ...ACL INS 'UIC'ACL
.IFINS ACNODE REM ACNODE
.IFNINS ...DIS INS 'UIC'DISKUSE
.IFF $SUSE .GOTO UPDEND
.;
.;  Run UPD... on next 6 minute increment from midnight. You can change
.;  the interval if it is not too different, and is also a multiple of
.;  6 minutes or divides evenly into 6 minutes, eg. 1,2,3,12 minutes.
.;  However, note that if you have selected support for writing load
.;  statistics to a file, you will create very large files if you select
.;  a short update interval.
.;
.SETS TIME "'<TIME>'"
.SETS HRX TIME[1:2]
.SETS MNX TIME[4:5]
.SETN UPDINT 6.
.SETN HR 'HRX'.
.SETN MN 'MNX'.
.SETN MINS (60.*HR)+MN
.SETN MINS (MINS/UPDINT)+1
.SETN MINS UPDINT*MINS
.SETN HR1 MINS/60.
.SETN MN1 MINS-(60.*HR1)
RUN UPD... 'HR1':'MN1':00/RSI='UPDINT'M/UIC=[1,1]
.UPDEND:
.;
.;  Activate the disk accounting subsystem. The sysmbol DSKINT is set to
.;  the interval (magnitude plus unit) between runs of DSK...
.;
.SETS DSKINT "7H"
.IFT $SDSK .IFNINS DSK... INS 'UIC'DISK
.IFT $SDSK RUN DSK... 'DSKINT'/RSI='DSKINT'
.;
.;  Initialize the batch system. This code is used for batch system
.;  version 2 only, since version 3 is initialized by QMGSTART.CMD
.;  since it uses the Queue Manager.
.;
.IFT $BATV3 .GOTO ENDBAT
.IFF NST .SETT BATCH
.IFT NST .ASK BATCH Run the Batch System
.IFT BATCH .TESTFILE LB:[10,25]BATCHINIT.CMD
.IFT BATCH .IF <FILERR> NE 1 .SETF BATCH
.IFT BATCH @LB:[10,25]BATCHINIT
.ENDBAT:
.;
.;  Miscellaneous accounting startup procedures.
.;
.;	N O T E:	After patch SMT843, the default is NOT to reset
.;			disk accounting time during a standard start.
.;			Previous to SMT843, the time WAS reset.
.;
.IFF $SDSK .SETF RESLDA
.IFT $SDSK .IFT NST .ASK RESLDA Reset time of last Disk Accounting
.IFT $SDSK .IFF NST .SETF RESLDA
.IFT NST .ASK NEWPER Start a new accounting period
.IFF NST .SETF NEWPER
.IFT NEWPER .ASK DELARF Delete Accounting Records Files
.IFF NEWPER .SETF DELARF
.IFT NEWPER .SETT RESLDA
.;*********************************************************************
.;
.;  SYSTIM will now create a new version of the file LB:[0,0]DISK.TIM
.;  which is used by the disk accounting program to store the time
.;  that it last ran. The initial setting in this file is boot time,
.;  as determined here.
.;
.;**********************************************************************
.IFT $SDSK .IFT RESLDA RUN 'UIC'SYSTIM/TASK=DISK
.;******************************************************************
.;
.;  SYSTIM will now create a new version of the file LB:[0,0]BOOT.TIM
.;  which will contain the date and time of the start of the current
.;  accounting period. No tasks in the accounting system currently use
.;  this file (they did in Version 6) but it may be used in a future
.;  release or version so you are advised to leave it in.
.;
.;********************************************************************
.IFT NEWPER RUN 'UIC'SYSTIM/TASK=BOOT
.;*********************************************************************
.;
.;  The program RESET sets to zero the average disk block use (if
.;  block allocation is supported) and restores the Monthly Money
.;  Allocation (if supported). The accounting system data file is
.;  deleted if required, so that we start fresh for the new period.
.;
.;*********************************************************************
.IFT NEWPER RUN 'UIC'RESET
.IFT NEWPER .IFT DELARF PIP [0,0]ACCOUNTS.DAT;*/DE/NM/LD
.GOTO 200
.;******************************************************************
.;
.;  Initialize system for startup without accounting. The batch system
.;  will not be run either, since this is usually built to require
.;  accounting system support.
.;
.;*******************************************************************
.100: .ASK PRODUC Start a non-accounting run
.IFF PRODUC .GOTO 300
; *************** NON-ACCOUNTING PRODUCTION RUN ***************
.IFINS ...HEL REM ...HEL
.IFINS ...BYE REM ...BYE
INS $HEL
INS $BYE
.GOTO 200
.300:
; ********** AFTER THE PAUSE, I WILL RESTART AS ABOVE **********
.PAUSE
.GOTO 50
.200:
.;
.; Initialize the FILEDEF system.
.;
.TESTFILE LB:[254,327]FILINI.TSK
.IF <FILERR> EQ 1 RUN LB:[254,327]FILINI
.;
.IFT NST .ASK MORE Pause for any reason
.IFF NST .SETF MORE
.IFT MORE .PAUSE
.;
.;  Start Error Logger.
.;
.IFT NST .ASK ERRLOG Error Logging to remain inactive
.IFF NST .SETF ERRLOG
.IFNDF $RSXV4 .SETT $RSXV4
.IFF ERRLOG .IFF $RSXV4 RUN ERRLOG
.IFF ERRLOG .IFT $RSXV4 ELI /LOG
.IFF ERRLOG .IFT $RSXV4 ELI /NOLIM
.IFF ERRLOG .IFF $RSXV4 ;
.IFF ERRLOG .IFF $RSXV4 ;
.IFF ERRLOG .IFF $RSXV4 ;
.IFF ERRLOG .IFF $RSXV4 ;
.;
.;  Allow users to log on.
.;
SET /LOGON
;
.IFT NST .ASK BROAD Broadcast "SYSTEM AVAILABLE" message
.IFF NST .SETT BROAD
.IFT BROAD .XQT BRO ALL:****** SYSTEM IS NOW AVAILABLE FOR USE ******
.IFT NST .ASK LOG Log off this terminal
.IFF NST .SETF LOG
.IFT LOG .IFT $RSXV4 .DISABLE DISPLAY
.IFT LOG .XQT BYE
