/*
 *				s a v e s t . c
 */

/*)LIBRARY
*/

#ifdef	DOCUMENTATION

title	savestr	Make a Safe Copy of a String
index		Make a safe copy of a string

synopsis

	 char *
	 savestr(s)
	 char s[];

description

	savestr(s) returns a pointer to a newly-allocated block of memory
	containing a copy of s.  The memory is obtained from malloc() and
	should be freed with free() when you are done with it.

	savestr() returns NULL if it cannot obtain the memory it needs.

bugs

author

	Jerry Leichter

#endif

/*
 * )EDITLEVEL=04
 * Edit history
 * 0.0 19-May-81 JSL	Invention
 * 0.1 09-Dec-81 MM	Changed cpystr() to strcpy()
 */

#define NULL 0

extern char *malloc();

char *
savestr(s)
register char s[];
{	register char *new;
	if ((new=malloc(strlen(s)+1)) != NULL)
		strcpy(new,s);
	return(new);
}
