/*
 * HDRDF.H - Task header
 *
 * INCLUDE CX.H PRIOR TO INCLUDING THIS MODULE
 *
 * Include EXEDF.H for various symbolics
 *
 *          TASK HEADER STRUCTURE
 *
 *          |====================|
 *          |                    |
 *          |       FIXED        |
 *          |                    |
 *          |      PORTION       |
 *          |                    |
 *          |--------------------|
 *          |  Number of LUNs    |
 *          |--------------------|
 *          \                    \
 *          \        LUT         \
 *          |                    |
 *          |--------------------|
 *          | No. of window blox |
 *          |--------------------|
 *          \                    \
 *          \   Window Blocks    \
 *          |                    |
 *          |--------------------|
 *          |        PS          |
 *          |        PC          |
 *          |        R5          |
 *          |        R4          |
 *          |        R3          |
 *          |        R2          |
 *          |        R1          |
 *          |        R0          |
 *          |--------------------|
 *          |    Guard word      |
 *          |====================|
 *
 * Bob Denny
 * 19-Oct-82
 */

/*
 * Fixed portion
 */
struct header  {
            address  h_csp;            /* Current SP */
               word  h_hdln;           /* Header length, bytes */
               word  h_eflm[2];        /* Event flag mask words */
               word  h_cuic;           /* Current UIC */
               word  h_duic;           /* Protection UIC */
               word  h_ips;            /* Initial PSW */
            address  h_ipc;            /* Initial PC */
            address  h_isp;            /* Initial SP */
            address  h_odva;           /* --> Debug SST vector */
               word  h_odvl;           /* Debug SST vector length */
            address  h_tkva;           /* --> Task SST vector */
               word  h_tkvl;           /* Task SST vector length */
            address  h_pfva;           /* --> Power fail ACB */
            address  h_fpva;           /* --> FPP ACB */
            address  h_rcva;           /* --> Receive ACB */
               word  h_efsv;           /* Event flag address save address ?? */
            address  h_fpsa;           /* --> FP/EAE save area */
            address  h_wnd;            /* --> number of window blocks */
               word  h_dsw;            /* Task DSW */
            address  h_fcs;            /* --> FCS impure area */
            address  h_fort;           /* --> FORTRAN impure area */
            address  h_ovly;           /* --> overlay impure area */
            address  h_vext;           /* --> work area extension vector */
               byte  h_spri;           /* Priority diff. for swapping */
               byte  nml;              /* Network mailbox LUN */
            address  h_rrva;           /* --> Receive by reference ACB */
               byte  h_x25;            /* Reserved by X.25 */
               byte  h_xxx[5];         /* Reserved */
            address  h_gard;           /* --> header guard word */
               word  h_nlun;           /* No. of LUN's */
               word  h_lun[][];        /* Start of LUT */
               }

/*
 * Window block
 */
struct h_wind  {
               struct pcb *w_bpcb;     /* PCB address */
               address     w_blvr;     /* Low VA */
               address     w_bhvr;     /* High VA */
               address     w_batt;     /* --> attachment descriptor */
               word        w_bsiz;     /* Size of window, clicks */
               word        w_boff;     /* Physical memory offset, clicks */
               byte        w_bfpd;     /* 1st PDR address */
               byte        w_bnpd;     /* No. of PDR's to map */
               word        w_blpd;     /* Contents of last PDR */
               }
