#define	rsts	1
#include <stdio.h>
#include <rsts.h>

getchar()
{
    return(getc(stdin));
}

getc(fp)
FILE *fp;
{
    char c;

    if (fp->io_flag & IO_NOS) {
	return($getc(fp));
    }
    else {
	while ((c = $getc(fp)) != EOF) {
	    switch (c) {
		case '\0':
		    break;
		case '\r':
		    if ((c = $getc(fp)) == '\n') {
			return('\n');
		    }
		    else {
			ungetc(c, fp);
			return('\r');
		    }
		case '\032':
		    if (fp->io_flag & IO_TTY) {
			fp->io_flag |= IO_EOF;
			return(EOF);
		    }
		    return('\032');
		default:
		    return(c);
	    }
	}
	return(EOF);
    }
}

$getc(fp)
FILE *fp;
{
    return(--fp->io_bcnt >= 0 ? *fp->io_bptr++ & 0377 : $$get(fp));
}	

ungetc(c, fp)
char c;
FILE *fp;
{
    fp->io_bcnt++;
    *--fp->io_bptr = c;
}

$$get(fp)
FILE *fp;
{
    if (fp->io_flag2 & IO_ODT2) {
        clrxrb();
        xrb.xrlen  = 4;
        xrb.xrci   = fp->io_lun * 2;
        xrb.xrblkm = TTYHND;
        rstsys(_SPEC);
    }
    clrxrb();
    xrb.xrlen = fp->io_bsiz;
    xrb.xrloc = fp->io_bbuf;
    if (fp->io_flag & IO_FIL) {
	xrb.xrblk = fp->io_bnbr++;
    }
    else {
	xrb.xrmod = fp->io_recm;
    }
    if (fp->io_flag & IO_TTY) {
        xrb.xrtime = fp->io_wait;
    }
    xrb.xrci = fp->io_lun * 2;
    $$ferr = rstsys(_READ);
    fp->io_bptr = fp->io_bbuf;
    fp->io_bcnt = xrb.xrbc;
    if ($$ferr) {
	fp->io_flag |= IO_EOF;
	if ($$ferr != EOFERR) {
	    fp->io_flag |= IO_ERR;
	}
	else {
	    if (fp->io_flag & IO_TTY) {
		fp->io_flag &= ~IO_EOF;
		fp->io_bcnt--;
		return(*fp->io_bptr++ & 0377);
	    }
	}
	return(EOF);
    }
    fp->io_bcnt--;
    return(*fp->io_bptr++ & 0377);
}	    
