/*
 *			t i m e b . h
 */

#ifdef	DOCUMENTATION

title	timeb	Define timeb buffer structure for ftime()
index		Define timeb buffer structure for ftime()

synopsis

	#include <timeb.h>
	   ...
	extern long ftime();

description

	This header file defines the structure of the timeb buffer used by
	the standard library ftime() function.  It is defined
	as follows:
	.s.nf
	struct timeb {
	  long		time;
	  unsigned	milltim;
	  short		timezone;
	  short		dstflag;
	};        	
	.s.f
	The time value is identical to the value returned by the
	time() function.  Milltim is the number of milliseconds
	in the current second.  Timezone indicates the number
	of minutes past GMT in the current time zone (zero for
	Decus C) and dstflag is set if Daylight Savings Time
	is in effect.

#endif

/*
 * )EDITLEVEL=01
 * Edit history
 * 0.0 28-Feb-82 MM	Newly invented
 */

struct timeb {
	long		time;		/* Seconds since Jan 1 1970	*/
	unsigned	millitm;	/* Milliseconds since time	*/
	short		timezone;	/* Timezone (minutes after GMT)	*/
	short		dstflag;	/* TRUE if daylight savings	*/
};
