Things currently wrong with CAM

The author does not regard these problems as major, and is only being
"honest" in reporting them. If anyone shouts loud enough, these mis-features
stand a better chance of being fixed. If you fix one, let me know!

1) Handling of some lables.

	Lables that lie at the end of a data psect are not dealt with
	properly. Not a severe problem, but I must fix this.

2) Extension of psects

	Psects are defined in the GSD with a maximum length. TKB will
	always allocate enough space for the fully extended psect, even if
	the module does not contain code to fill it all. CAM will currently
	only output the code, and will not extend the psect.

	This problem could perhaps be solved by detecting the last reference
	to a psect and inserting a .blkb directive. During pass two, count
	the references to each psect in seg_ptr->p_count.

	eg.		T_LDEF:
				...
				seg_ptr->p_count++;
				...

		during pass three, 

			T_LDEF:
				plength();
				...

			T_EOM:
				p_length();
				...


		p_length()
		{
			if (!seg_ptr)	/* skip first ref */
				return;
			if (!(--seg_ptr->p_count)) {
				do blkb
			}
			return;
		}

3)	CAM currently checks that the target address of a branch lies
	within the bounds of the current psect. This should be ignored
	when operating in an absolute section as the length of such a
	section is always zero, which causes CAM to generate .words
	instead of branch instructions.

4)	CAM should assume that anything in a "D" type psect is data,
	and should go into binary mode. Currently CAM tries to convert
	such data into code, resulting in some obscure instructions.
