

/*************************************************************************

                      Copyright (c) 1984 by Nick de Smith

        This software is supplied for interest and non-profit making
        purposes  only.   Under  no  circumstance  shall it be lent,
        copied or otherwise used for profit.  All  rights  regarding
        the  use  and  ownership of this software shall at all times
        remain with the author, who does not guarantee the  accuracy
        or  reliabilty  of this software and who will not accept any
        liability for its use.

        This software may not be copied or distributed  without  the
        inclusion of the above copyright notice.

        January 31st 1984

*************************************************************************/


/*************************************************************************


	Program :	CAM

	Module	:	IP.C

	Author	:	Nick de Smith		November/December 1982

	Description :

			Input utilities for the object module dis-
			assembler. The routines herein are the primatives
			required for all I/O to the object module.

*************************************************************************/

#define	MODULE

#include	<stdio.h>

#include	"cam.h"


/*************************************************************************
*
*
*			b _ i n i t
*			-----------
*
*	Initialise the working input buffers
*
*************************************************************************/
global
b_init()
{
	b_current = &buff_1;
	b_other   = &buff_2;

	b_current->b_next  = b_other->b_next  = 0;
	b_current->b_left  = b_other->b_left  = 0;
	b_current->b_flags = b_other->b_flags = R_JUNK;
}

/*************************************************************************
*
*
*			b _ s w i t c h
*			---------------
*
*	Swap the two working buffers around.
*
*************************************************************************/
global
b_switch()
{
	register BUFFER_PTR b_temp;

	b_temp = b_current;
	b_current = b_other;
	b_other   = b_temp;
}


/*************************************************************************
*
*
*			r e a d _ r e c o r d
*			---------------------
*
*	read the next variable length record from the input file.
*
*************************************************************************/
global
read_record(b_ptr)
register BUFFER_PTR b_ptr;
{
	b_ptr->b_left = b_ptr->b_length = fget(b_ptr->b_text, MAX_RECLEN, ip);
	b_ptr->b_next = 0;
	b_ptr->b_flags= 0;
	if (feof(ip))
		bug("End of input file");
	rec_num += 1;
}

/*************************************************************************
*
*
*			n e x t _ b y t e
*			-----------------
*
*	Get the next byte from the specified buffer.
*
*************************************************************************/
global
next_byte(b_ptr)
register BUFFER_PTR b_ptr;
{
	b_ptr->b_left--;
	return(b_ptr->b_text[b_ptr->b_next++] & 0377);
}

/*************************************************************************
*
*
*			n e x t _ w o r d
*			-----------------
*
*	Get the next aligned word from the specified buffer.
*
*************************************************************************/
global
next_word(b_ptr)
register BUFFER_PTR b_ptr;
{
	b_ptr->b_next += (b_ptr->b_next & 1);	/* Align to next word	*/
	b_ptr->b_left = b_ptr->b_length - b_ptr->b_next;
	return(next_two_bytes(b_ptr));
}


/*************************************************************************
*
*
*			n e x t _ t w o _ b y t e s
*	 		---------------------------
*
*	Get the next two bytes from the specified buffer as
*	a non-aligned word.
*
*************************************************************************/
global
next_two_bytes(b_ptr)
register BUFFER_PTR b_ptr;
{
	int	temp;
	temp = next_byte(b_ptr);
	return(temp | (0400 * next_byte(b_ptr)));
}

/*************************************************************************
*
*
*			n a m e _ t e x t
*			-----------------
*
*	Get an un-aligned name from the current input record. Return a
*	pointer to the buffer used.
*
*************************************************************************/
global char *
name_text(b_ptr)
register BUFFER_PTR b_ptr;
{
	int	tbuff[2];
	tbuff[0] = next_two_bytes(b_ptr);
	tbuff[1] = next_two_bytes(b_ptr);
	return(radmin(tbuff));
}
