

/*************************************************************************

                      Copyright (c) 1984 by Nick de Smith

        This software is supplied for interest and non-profit making
        purposes  only.   Under  no  circumstance  shall it be lent,
        copied or otherwise used for profit.  All  rights  regarding
        the  use  and  ownership of this software shall at all times
        remain with the author, who does not guarantee the  accuracy
        or  reliabilty  of this software and who will not accept any
        liability for its use.

        This software may not be copied or distributed  without  the
        inclusion of the above copyright notice.

        January 31st 1984

*************************************************************************/


/*************************************************************************


	Program :	CAM

	Module	:	DEBUG.C

	Author	:	Nick de Smith		November/December 1982

	Description :
			Debug modules for CAM. The definition of "DEBUG"
			below may be removed to prevent excessive verbage
			during debug text printing.

*************************************************************************/

#define	DEBUG				/* Remove this for minimal text	*/

#define	MODULE

#include	<stdio.h>

#include	"cam.h"


/*************************************************************************
*
*
*				s _ d u m p
*				-----------
*
*	Dump the symbol table to the console.
*
*************************************************************************/
global
s_dump()
{
#ifdef	DEBUG
	register int i;
	register PSECT_PTR	p_ptr;
	register SYMBOL_PTR	s_ptr;
		 char		*radnam();

	fprintf(stderr, "\nSymbol table dump...\n");

	for (i = 0; i <= seg_max; i++) {

		p_ptr = &segtbl[i];
		fprintf(stderr, "\n%03o \"%s\" Flags: %03o, Length: %o\n",
			i, radnam(p_ptr->p_name), p_ptr->p_flags, p_ptr->p_mlength);
		if (!(s_ptr = p_ptr->p_symb))
			fprintf(stderr, "    ** No symbols\n");
		else
			while (s_ptr) {
				fprintf(stderr, "    \"%s\", offset %o, flags %o\n",
					radnam(s_ptr->s_name), s_ptr->s_offset, s_ptr->s_flags);
				s_ptr = s_ptr->s_next;
			}
	}
#endif
}


/*************************************************************************
*
*
*				d b g
*				-----
*
*	Maybe print a debug message.
*
*************************************************************************/
global
dbg(args)
{
	if (debug)
		fprintf(stderr, "%%CAM -D- p: %d, r: %d, %r",
			pass, rec_num, &args);
}

/*************************************************************************
*
*
*				w a r n
*				-------
*
*	Warn the luser that something has happened thats not fatal, but
*	which he/she/it might just like to know about.
*
*************************************************************************/
global
warn(args)
{
	fprintf(stderr, "%%CAM -W- during pass %d at record %d, %r",
		pass, rec_num, &args);
}

/*************************************************************************
*
*
*				b u g
*				-----
*
*	Report a bad error. This may be due to a number of causes such
*	as a truncated or corrupt object file. It is possible that the
*	cause of a bug check may be due to a CAM error, but as of Feb '83
*	I only know of the 'Load address mismatch' on RSTS/E reslib STB
*	files, and it is really very debatable if that is a bug, or just
*	something horrid in the way that TKB works.
*
*************************************************************************/
global
bug(args)
{
	error("?CAM -F- during pass %d at record %d, %r",
		pass, rec_num, &args);
}
