

/*************************************************************************

                      Copyright (c) 1984 by Nick de Smith

        This software is supplied for interest and non-profit making
        purposes  only.   Under  no  circumstance  shall it be lent,
        copied or otherwise used for profit.  All  rights  regarding
        the  use  and  ownership of this software shall at all times
        remain with the author, who does not guarantee the  accuracy
        or  reliabilty  of this software and who will not accept any
        liability for its use.

        This software may not be copied or distributed  without  the
        inclusion of the above copyright notice.

        January 31st 1984

*************************************************************************/


/*************************************************************************


	Program :	CAM

	Module	:	CAMTBL.H

	Author	:	Nick de Smith		November/December 1982

	Description :
			Table header file for CAM (object module
			disassembler).

*************************************************************************/

typedef	struct	tree {			/* Node of the TREE		*/

	int	 t_flags;		/* Flags for this node		*/
	char	*t_next;		/* Pointer to next/text		*/

} TREE, *TREE_PTR;

/*************************************************************************
*
*
*		d e f i n e     t r e e     f l a g s
*		-------------------------------------
*
*
*************************************************************************/

#define	T_TYPE		077		/* Entry type if end of node	*/

#define	T_NOPS		000		/* No operands			*/
#define	T_SSDD		001		/* SS,DD type (MOV etc)		*/
#define	T_RDD		002		/* R,DD reg, dest (JSR + XOR)	*/
#define	T_SSR		003		/* SS,R src, reg (MUL etc)	*/
#define	T_SS		004		/* SS src (JMP, CLR etc)	*/
#define	T_R		005		/* R reg (RTS, FADD etc)	*/
#define	T_ROO		006		/* R,OO reg, 6 bit off (SOB)	*/
#define	T_OO		007		/* OOO 8 bit off (branches)	*/
#define	T_NNNNNN	010		/* NNNNNN 16 bit data (.WORD)	*/
#define	T_NNN		011		/* NNN 8 bit data (EMT + TRAP)	*/
#define	T_NN		012		/* NN 6 bit data (MARK)		*/
#define	T_N		013		/* N 3 bit data (SPL)		*/
#define	T_AFSS		014		/* Fsrc, acc (MULF, MODF etc)	*/
#define	T_AFDD		015		/* Acc, Fdst (STF + STCFD)	*/
#define	T_ASS		016		/* Src, acc (LDCIF + LDEXP)	*/
#define	T_ADD		017		/* Acc, dst (STCFI + STEXP)	*/
#define	T_FSS		020		/* Fsrc (CLRF etc)		*/
/*		Special 'macro' instructions				*/
#define	M_JMPX		021		/* JMP for jmp/jmpx		*/
#define	M_RETURN	022		/* RTS for return/return rn	*/
#define	M_CALL		023		/* JSR for call/callx		*/
#define	M_PUSH		024		/* CLR -(SP) or MOV x,-(SP)	*/
#define	M_POP		025		/* TST (SP)+ or MOV (SP)+,x	*/
/*		High byte flags						*/
#define	T_WALK		000400		/* Walk the tree		*/
#define	T_END		001000		/* End of leaf			*/



#ifdef	CAMTBL

char	word[]	= ".word";		/* All unidentified opcodes	*/
char	emtext[]= "emt";		/* Common bit of text eliminated*/
char	push[]	= "push";		/* Another common bit of text	*/

#define	T_DATA		T_END | T_NNNNNN, word
#define	T_EMT		T_END | T_NNN	, emtext
#define	T_PUSH		T_END | M_PUSH	, push

#else

extern	char	word[];			/* All undefined opcodes	*/
extern	char	emtext[];		/* Text of 'emt'		*/

extern	TREE	x0[], x1[];		/* Root entry points of the tree*/

#endif

#ifdef	MAIN

extern	TREE	x104[], x10437[];	/* RSTS/RSX emt vectors		*/
extern	TREE	x106[];			/* Kernal mode opcodes		*/
extern	TREE	x00000[], x006[];	/* Kernal mode opcodes		*/
extern	TREE	x00[], x000[]	;	/* 'Macro' types		*/
extern	TREE	x005[], x0002[];	/*   ''     ''			*/

#endif
