

/*************************************************************************

                      Copyright (c) 1984 by Nick de Smith

        This software is supplied for interest and non-profit making
        purposes  only.   Under  no  circumstance  shall it be lent,
        copied or otherwise used for profit.  All  rights  regarding
        the  use  and  ownership of this software shall at all times
        remain with the author, who does not guarantee the  accuracy
        or  reliabilty  of this software and who will not accept any
        liability for its use.

        This software may not be copied or distributed  without  the
        inclusion of the above copyright notice.

        January 31st 1984

*************************************************************************/


/*************************************************************************


	Program :	CAM

	Module	:	CAMTBL.C

	Author	:	Nick de Smith		November/December 1982

	Description :

			This file contains the drive tables for CAM
			(object module disassembler)


*************************************************************************/

#define	CAMTBL

#include	"camtbl.h"


/*************************************************************************

	Trees - Part 1

	The following tree describes all possible words having the
	top bit (<15>) zero. In order to arrive at a particular leaf
	all the branches preceding the last digit in the lable must
	have been traversed. eg. to get to x075[] you must have gone
	via x0[] and x07[].

*************************************************************************/

TREE	x00027[] = {
	T_END | T_NOPS	, "sen"		,T_END | T_NOPS	, "secn"	,
	T_END | T_NOPS	, "sevn"	,T_END | T_NOPS	, "secvn"	,
	T_END | T_NOPS	, "sezn"	,T_END | T_NOPS	, "seczn"	,
	T_END | T_NOPS	, "sevzn"	,T_END | T_NOPS	, "scc"
};

TREE	x00026[] = {
	T_END | T_NOPS	, "nop"		,T_END | T_NOPS	, "sec"		,
	T_END | T_NOPS	, "sev"		,T_END | T_NOPS	, "secv"	,
	T_END | T_NOPS	, "sez"		,T_END | T_NOPS	, "secz"	,
	T_END | T_NOPS	, "sevz"	,T_END | T_NOPS	, "secvz"
};

TREE	x00025[] = {
	T_END | T_NOPS	, "cln"		,T_END | T_NOPS	, "clcn"	,
	T_END | T_NOPS	, "clvn"	,T_END | T_NOPS	, "clcvn"	,
	T_END | T_NOPS	, "clzn"	,T_END | T_NOPS	, "clczn"	,
	T_END | T_NOPS	, "clvzn"	,T_END | T_NOPS	, "ccc"
};

TREE	x00024[] = {
	T_END | T_NOPS	, "nop"		,T_END | T_NOPS	, "clc"		,
	T_END | T_NOPS	, "clv"		,T_END | T_NOPS	, "clcv"	,
	T_END | T_NOPS	, "clz"		,T_END | T_NOPS	, "clcz"	,
	T_END | T_NOPS	, "clvz"	,T_END | T_NOPS	, "clcvz"
};

TREE	x00000[] = {
	T_END | T_NOPS	, "halt"	,T_END | T_NOPS	, "wait"	,
	T_END | T_NOPS	, "rti"		,T_END | T_NOPS	, "bpt"		,
	T_END | T_NOPS	, "iot"		,T_END | T_NOPS	, "reset"	,
	T_END | T_NOPS	, "rtt"		,T_END | T_NOPS	, "mfpt"
};

TREE	x0750[] = {
	T_END | T_R	, "fadd"	,T_END | T_R	, "fsub"	,
	T_END | T_R	, "fmul"	,T_END | T_R	, "fdiv"	,
	T_DATA				,T_DATA				,
	T_DATA				,T_DATA
};

TREE	x0002[] = {
	T_END | M_RETURN, "return"	,T_DATA				,
	T_DATA				,T_END | T_N	, "spl"		,
	T_WALK		, x00024	,T_WALK		, x00025	,
	T_WALK		, x00026	,T_WALK		, x00027
};

TREE	x0000[] = {
	T_WALK		, x00000	,T_DATA				,
	T_DATA				,T_DATA				,
	T_DATA				,T_DATA				,
	T_DATA				,T_DATA
};

TREE	x075[] = {
	T_WALK		, x0750		,T_DATA				,
	T_DATA				,T_DATA				,
	T_DATA				,T_DATA				,
	T_DATA				,T_DATA
};

TREE	x012[] = {
	T_PUSH				,T_PUSH				,
	T_PUSH				,T_PUSH				,
	T_PUSH				,T_PUSH				,
	T_END | M_POP	, "pop"		,T_PUSH
};

TREE	x007[] = {
	T_END | T_SS	, "csm"		,T_DATA				,
	T_DATA				,T_DATA				,
	T_DATA				,T_DATA				,
	T_DATA				,T_DATA
};

TREE	x006[] = {
	T_END | T_SS	, "ror"		,T_END | T_SS	, "rol"		,
	T_END | T_SS	, "asr"		,T_END | T_SS	, "asl"		,
	T_END | T_NN	, "mark"	,T_END | T_SS	, "mfpi"	,
	T_END | T_SS	, "mtpi"	,T_END | T_SS	, "sxt"
};

TREE	x005[] = {
	T_END | M_PUSH	, "push"	,T_END | T_SS	, "com"		,
	T_END | T_SS	, "inc"		,T_END | T_SS	, "dec"		,
	T_END | T_SS	, "neg"		,T_END | T_SS	, "adc"		,
	T_END | T_SS	, "sbc"		,T_END | M_POP	, "pop"
};

TREE	x003[] = {
	T_END | T_OO	, "bgt"		,T_END | T_OO	, "bgt"		,
	T_END | T_OO	, "bgt"		,T_END | T_OO	, "bgt"		,
	T_END | T_OO	, "ble"		,T_END | T_OO	, "ble"		,
	T_END | T_OO	, "ble"		,T_END | T_OO	, "ble"
};

TREE	x002[] = {
	T_END | T_OO	, "bge"		,T_END | T_OO	, "bge"		,
	T_END | T_OO	, "bge"		,T_END | T_OO	, "bge"		,
	T_END | T_OO	, "blt"		,T_END | T_OO	, "blt"		,
	T_END | T_OO	, "blt"		,T_END | T_OO	, "blt"
};

TREE	x001[] = {
	T_END | T_OO	, "bne"		,T_END | T_OO	, "bne"		,
	T_END | T_OO	, "bne"		,T_END | T_OO	, "bne"		,
	T_END | T_OO	, "beq"		,T_END | T_OO	, "beq"		,
	T_END | T_OO	, "beq"		,T_END | T_OO	, "beq"
};

TREE	x000[] = {
	T_WALK		, x0000		,T_END | M_JMPX	, "jmp"		,
	T_WALK		, x0002		,T_END | T_SS	, "swab"	,
	T_END | T_OO	, "br"		,T_END | T_OO	, "br"		,
	T_END | T_OO	, "br"		,T_END | T_OO	, "br"
};

TREE	x07[] = {
	T_END | T_SSR	, "mul"		,T_END | T_SSR	, "div"		,
	T_END | T_SSR	, "ash"		,T_END | T_SSR	, "ashc"	,
	T_END | T_RDD	, "xor"		,T_WALK		, x075		,
	T_DATA				,T_END | T_ROO	, "sob"
};

TREE	x01[] = {
	T_PUSH				,T_PUSH				,
	T_WALK		, x012		,T_PUSH				,
	T_PUSH				,T_PUSH				,
	T_PUSH				,T_PUSH
};

TREE	x00[] = {
	T_WALK		, x000		,T_WALK		, x001		,
	T_WALK		, x002		,T_WALK		, x003		,
	T_END | M_CALL	, "call"	,T_WALK		, x005		,
	T_WALK		, x006		,T_WALK		, x007
};

TREE	x0[] = {
	T_WALK		, x00		,T_WALK		, x01		,
	T_END | T_SSDD	, "cmp"		,T_END | T_SSDD	, "bit"		,
	T_END | T_SSDD	, "bic"		,T_END | T_SSDD	, "bis"		,
	T_END | T_SSDD	, "add"		,T_WALK		, x07
};


/*************************************************************************

	Trees - Part 2

	The following tree describes all possible words having the
	top bit (<15>) non-zero. In order to arrive at a particular leaf,
	all the branches preceding the last digit in the lable must
	have been traversed. eg. to get to x175[] you must have
	gone via x1[] and x17[].

*************************************************************************/

TREE	x17001[] = {
	T_DATA				,T_END | T_NOPS	, "setd"	,
	T_END | T_NOPS	, "setl"	,T_DATA				,
	T_DATA				,T_DATA				,
	T_DATA				,T_DATA
};

TREE	x17000[] = {
	T_END | T_NOPS	, "cfcc"	,T_END | T_NOPS	, "setf"	,
	T_END | T_NOPS	, "seti"	,T_DATA				,
	T_DATA				,T_DATA				,
	T_DATA				,T_DATA
};

TREE	x10437[] = {
	T_EMT				,T_EMT				,
	T_EMT				,T_EMT				,
	T_EMT				,T_EMT				,
	T_EMT				,T_END | T_NOPS	, ".priv"
};

TREE	x10407[] = {
	T_END | T_NOPS	, ".chain"	,T_EMT				,
	T_END | T_NOPS	, ".plas"	,T_EMT				,
	T_END | T_NOPS	, ".rsx"	,T_EMT				,
	T_END | T_NOPS	, ".ulog"	,T_EMT
};

TREE	x10406[] = {
	T_END | T_NOPS	, ".mesag"	,T_EMT				,
	T_END | T_NOPS	, ".ccl"	,T_EMT				,
	T_END | T_NOPS	, ".fss"	,T_EMT				,
	T_END | T_NOPS	, ".uuo"	,T_EMT
};

TREE	x10405[] = {
	T_END | T_NOPS	, ".rts"	,T_EMT				,
	T_END | T_NOPS	, ".erlog"	,T_EMT				,
	T_END | T_NOPS	, ".logs"	,T_EMT				,
	T_END | T_NOPS	, ".clear"	,T_EMT
};

TREE	x10404[] = {
	T_END | T_NOPS	, ".stat"	,T_EMT				,
	T_END | T_NOPS	, ".run"	,T_EMT				,
	T_END | T_NOPS	, ".name"	,T_EMT				,
	T_END | T_NOPS	, ".exit"	,T_EMT
};

TREE	x10403[] = {
	T_END | T_NOPS	, ".time"	,T_EMT				,
	T_END | T_NOPS	, ".postn"	,T_EMT				,
	T_END | T_NOPS	, ".date"	,T_EMT				,
	T_END | T_NOPS	, ".set"	,T_EMT
};

TREE	x10402[] = {
	T_END | T_NOPS	, ".ttech"	,T_EMT				,
	T_END | T_NOPS	, ".ttnch"	,T_EMT				,
	T_END | T_NOPS	, ".ttddt"	,T_EMT				,
	T_END | T_NOPS	, ".ttrst"	,T_EMT
};

TREE	x10401[] = {
	T_END | T_NOPS	, ".sleep"	,T_EMT				,
	T_END | T_NOPS	, ".peek"	,T_EMT				,
	T_END | T_NOPS	, ".spec"	,T_EMT				,
	T_END | T_NOPS	, ".ttape"	,T_EMT
};

TREE	x10400[] = {
	T_END | T_NOPS	, "calfip"	,T_EMT				,
	T_END | T_NOPS	, ".read"	,T_EMT				,
	T_END | T_NOPS	, ".write"	,T_EMT				,
	T_END | T_NOPS	, ".core"	,T_EMT
};

TREE	x1700[] = {
	T_WALK		, x17000	,T_WALK		, x17001	,
	T_DATA				,T_DATA				,
	T_DATA				,T_DATA				,
	T_DATA				,T_DATA
};

TREE	x1043[] = {
	T_EMT				,T_EMT				,
	T_EMT				,T_EMT				,
	T_EMT				,T_EMT				,
	T_EMT				,T_WALK		, x10437
};

TREE	x1040[] = {
	T_WALK		, x10400	,T_WALK		, x10401	,
	T_WALK		, x10402	,T_WALK		, x10403	,
	T_WALK		, x10404	,T_WALK		, x10405	,
	T_WALK		, x10406	,T_WALK		, x10407
};

TREE	x177[] = {
	T_END | T_ASS	, "ldcif"	,T_END | T_ASS	, "ldcif"	,
	T_END | T_ASS	, "ldcif"	,T_END | T_ASS	, "ldcif"	,
	T_END | T_AFSS	, "ldcdf"	,T_END | T_AFSS	, "ldcdf"	,
	T_END | T_AFSS	, "ldcdf"	,T_END | T_AFSS	, "ldcdf"
};

TREE	x176[] = {
	T_END | T_AFDD	, "stcfd"	,T_END | T_AFDD	, "stcfd"	,
	T_END | T_AFDD	, "stcfd"	,T_END | T_AFDD	, "stcfd"	,
	T_END | T_ASS	, "ldexp"	,T_END | T_ASS	, "ldexp"	,
	T_END | T_ASS	, "ldexp"	,T_END | T_ASS	, "ldexp"
};

TREE	x175[] = {
	T_END | T_ADD	, "stexp"	,T_END | T_ADD	, "stexp"	,
	T_END | T_ADD	, "stexp"	,T_END | T_ADD	, "stexp"	,
	T_END | T_ADD	, "stcfi"	,T_END | T_ADD	, "stcfi"	,
	T_END | T_ADD	, "stcfi"	,T_END | T_ADD	, "stcfi"
};

TREE	x174[] = {
	T_END | T_AFDD	, "stf"		,T_END | T_AFDD	, "stf"		,
	T_END | T_AFDD	, "stf"		,T_END | T_AFDD	, "stf"		,
	T_END | T_AFSS	, "divf"	,T_END | T_AFSS	, "divf"	,
	T_END | T_AFSS	, "divf"	,T_END | T_AFSS	, "divf"
};

TREE	x173[] = {
	T_END | T_AFSS	, "subf"	,T_END | T_AFSS	, "subf"	,
	T_END | T_AFSS	, "subf"	,T_END | T_AFSS	, "subf"	,
	T_END | T_AFSS	, "cmpf"	,T_END | T_AFSS	, "cmpf"	,
	T_END | T_AFSS	, "cmpf"	,T_END | T_AFSS	, "cmpf"
};

TREE	x172[] = {
	T_END | T_AFSS	, "addf"	,T_END | T_AFSS	, "addf"	,
	T_END | T_AFSS	, "addf"	,T_END | T_AFSS	, "addf"	,
	T_END | T_AFSS	, "ldf"		,T_END | T_AFSS	, "ldf"		,
	T_END | T_AFSS	, "ldf"		,T_END | T_AFSS	, "ldf"
};

TREE	x171[] = {
	T_END | T_AFSS	, "mulf"	,T_END | T_AFSS	, "mulf"	,
	T_END | T_AFSS	, "mulf"	,T_END | T_AFSS	, "mulf"	,
	T_END | T_AFSS	, "modf"	,T_END | T_AFSS	, "modf"	,
	T_END | T_AFSS	, "modf"	,T_END | T_AFSS	, "modf"
};

TREE	x170[] = {
	T_WALK		, x1700		,T_END | T_SS	, "ldfps"	,
	T_END | T_SS	, "stfps"	,T_END | T_SS	, "stst"	,
	T_END | T_FSS	, "clrf"	,T_END | T_FSS	, "tstf"	,
	T_END | T_FSS	, "absf"	,T_END | T_FSS	, "negf"
};

TREE	x106[] = {
	T_END | T_SS	, "rorb"	,T_END | T_SS	, "rolb"	,
	T_END | T_SS	, "asrb"	,T_END | T_SS	, "aslb"	,
	T_END | T_SS	, "mtps"	,T_END | T_SS	, "mfpd"	,
	T_END | T_SS	, "mtpd"	,T_END | T_SS	, "mfps"
};

TREE	x105[] = {
	T_END | T_SS	, "clrb"	,T_END | T_SS	, "comb"	,
	T_END | T_SS	, "incb"	,T_END | T_SS	, "decb"	,
	T_END | T_SS	, "negb"	,T_END | T_SS	, "adcb"	,
	T_END | T_SS	, "sbcb"	,T_END | T_SS	, "tstb"
};

TREE	x104[] = {
	T_WALK		, x1040		,T_EMT				,
	T_EMT				,T_WALK		, x1043		,
	T_END | T_NNN	, "trap"	,T_END | T_NNN	, "trap"	,
	T_END | T_NNN	, "trap"	,T_END | T_NNN	, "trap"
};

TREE	x103[] = {
	T_END | T_OO	, "bcc"		,T_END | T_OO	, "bcc"		,
	T_END | T_OO	, "bcc"		,T_END | T_OO	, "bcc"		,
	T_END | T_OO	, "bcs"		,T_END | T_OO	, "bcs"		,
	T_END | T_OO	, "bcs"		,T_END | T_OO	, "bcs"
};

TREE	x102[] = {
	T_END | T_OO	, "bvc"		,T_END | T_OO	, "bvc"		,
	T_END | T_OO	, "bvc"		,T_END | T_OO	, "bvc"		,
	T_END | T_OO	, "bvs"		,T_END | T_OO	, "bvs"		,
	T_END | T_OO	, "bvs"		,T_END | T_OO	, "bvs"
};

TREE	x101[] = {
	T_END | T_OO	, "bhi"		,T_END | T_OO	, "bhi"		,
	T_END | T_OO	, "bhi"		,T_END | T_OO	, "bhi"		,
	T_END | T_OO	, "blos"	,T_END | T_OO	, "blos"	,
	T_END | T_OO	, "blos"	,T_END | T_OO	, "blos"
};

TREE	x100[] = {
	T_END | T_OO	, "bpl"		,T_END | T_OO	, "bpl"		,
	T_END | T_OO	, "bpl"		,T_END | T_OO	, "bpl"		,
	T_END | T_OO	, "bmi"		,T_END | T_OO	, "bmi"		,
	T_END | T_OO	, "bmi"		,T_END | T_OO	, "bmi"
};

TREE	x17[] = {
	T_WALK		, x170		,T_WALK		, x171		,
	T_WALK		, x172		,T_WALK		, x173		,
	T_WALK		, x174		,T_WALK		, x175		,
	T_WALK		, x176		,T_WALK		, x177
};

TREE	x10[] = {
	T_WALK		, x100		,T_WALK		, x101		,
	T_WALK		, x102		,T_WALK		, x103		,
	T_WALK		, x104		,T_WALK		, x105		,
	T_WALK		, x106		,T_DATA
};

TREE	x1[] = {
	T_WALK		, x10		,T_END | T_SSDD	, "movb"	,
	T_END | T_SSDD	, "cmpb"	,T_END | T_SSDD	, "bitb"	,
	T_END | T_SSDD	, "bicb"	,T_END | T_SSDD	, "bisb"	,
	T_END | T_SSDD	, "sub"		,T_WALK		, x17
};

