
#include	"sysdef.h"

#define then
#include	"scerrd.h"

/*+	MVUP()		move up one line (towards the top of screen)	*/
/*+	MVDOWN()	move down one line in display			*/
/*+	VTMVUP()	ept for command dispatcher, move up		*/
/*+	VTMVDOWN()	ept for command dispatcher, move down		*/
/*+	VTER()		move one right					*/
/*+	VTEL()		move one left					*/
/*+	VTSCROLL()	move down 10 lines/sec				*/
/*+	VTNEXTPAGE()	next page in file				*/
/*+	VTPREVPAGE()	previous page in the file			*/
/*+	VTFIRSTPAGE()	first part of the file				*/
/*+	VTLASTPAGE()	bottom of it all				*/
/*+	VTBOTPAGE()	bottom of the page				*/
/*+	VTTOPPAGE()	top of the current page				*/
/*+	VTNXTWORD()	move to next word				*/
/*+	VTLSTWORD()	move to previous word				*/
/*+	VTEOLN()	move to end of line				*/
/*+	VTBOLN()	move to start of line				*/
/*+	VTBLINE()	move to start of next line			*/
/*+	NEXTWORD()	find next word, no cursor positioning		*/
/*+	LASTWORD()	find last word, no cursor positioning		*/

extern int chposition, curposition, *curline ,page_size[], termtype ;
extern int read_only ;




/*	move up or down in display, scrolling the display as needed	*/


vtmvup()
{
	mvup();
	if ( read_only )
	  then creset() ;
}


vtmvdown()
{	mvdown();
	if ( read_only )
	  then	{
		creset() ;
		scmove() ;
		}
}


mvup()
{
	updown(1);
}

mvdown()
{
	updown(0) ;
}


vtscroll()
{
	extern int *curline, *maxline, prevchar, read_only ;
	extern int testcc(),typeahead() ;

	while (     read_only == 0 && *curline < *maxline
		 && typeahead()==0 && testcc() == 0 ) {
		vtmvdown() ;
		waittenth() ;
		}
}
	


static updown(dir)
int dir;
{
	register int oldcurline,oldloclow,temp ;
	int doprint ;
	extern int chposition,curposition,*curline,*loclow,*lochigh,*maxline ;
	extern int cut_st ;

	enabuffering() ;
	scunloadline() ;
	oldloclow  = *loclow ;
	oldcurline = *curline ;
	if ( dir == 0 )
	  then	{
		if ( ++(*curline) < *maxline )
		  then	{
			if ( *curline > *lochigh )
			  then	{
				sclinc() ;
				doprint = 1 ;
				}
			  else	doprint = 0 ;
			}
		  else	{
			*curline = oldcurline ;
			doprint = 0 ;
			}
		}
	  else	{
		if (--(*curline) < *loclow)  then scldec() ;
		if (  *curline < *loclow)  then *curline = *loclow ;
		doprint = ( *curline == *loclow && *loclow != oldloclow ) ;
		}
	ckmacro() ;
	if ( oldcurline != *curline )
	  then	{
		temp = curposition ;
		creset() ;
		if ( cut_st && dir == 0 )
		  then	{
			rvon() ;
			dumpworkbuffer() ;
			rvoff() ;
			}
		scloadline() ;
		if ( cut_st && dir > 0 && doprint == 0 )
		  then	{
			scmove() ;
			dumpworkbuffer() ;
			}
		chkselect() ;
		if ( doprint )
		  then	{
			if ( dir > 0 ) then lreverse(); else lnext() ;
			scmove() ;
			dumpworkbuffer() ;
			}
		rstcursor(temp) ;
		}
	  else	scloadline() ;
	scmove() ;
	disbuffering() ;
			
}			


static rstcursor(where)
register int where ;
{
	extern int curposition ;
	creset() ;
	while ( curposition < where && atcrlf() == 0 ) pinc() ;
	if (curposition > where) then pdec() ;
	return( chposition ) ;
}



/*	move left or right in current line				*/
/*	If at EOLN, then goto previous or next line			*/


vtel()
{
	extern int chposition,fastio ;

	chkselect() ;
	if ( atcrlf() == 0 ) then fastio = 1 ;
	if ( chposition == 0 )
	  then	{
		creset() ;
		mvup() ;
		findeoln() ;
		}
	  else	{
		pdec() ;
		}
	scmove() ;
	fastio = 0 ;
}


vter()
{
	extern int fastio ;

	if ( read_only == 0 )
	  then	{
		chkselect() ;
		fastio = 1 ;
		if ( atcrlf() == 0 )
		  then	pinc() ;
		  else	{
			fastio = 0 ;
			creset() ;
			mvdown() ;
			if ( read_only )
			  then creset() ;
			}
		scmove() ;
		fastio = 0 ;
		}
}




static fin()
{
	chkselect() ;
	scloadline() ;
	scmove() ;
	return(1) ;
}


static char delayc[] = { 0,0,0,0,0,0,0,0,0,0 } ;
static delay()
{
	putbin(delayc,10) ;
}


vtnextpage()
{
	extern int curposition,*loclow,termtype,page_size[],ttastarm ;
	extern int mactimes ;
	register int oldcurposition,oldloclow ;

	if ( mactimes <= 0 ) then ttastarm = 1 ;
	oldloclow = *loclow ;
	oldcurposition = curposition ;
	newpage(*loclow+page_size[termtype]) ;
	rstcursor( oldcurposition ) ;
	fin() ;
	if (oldloclow == *loclow) then vtbotpage() ;
	ttastarm = 0 ;
}


vtprevpage()
{
	extern int curposition,*loclow,termtype,page_size[],ttastarm ;
	extern int mactimes ;
	register int oldcurposition ;

	if ( mactimes <= 0 ) then ttastarm = 1 ;
	oldcurposition = curposition ;
	newpage(*loclow-page_size[termtype]);
	rstcursor( oldcurposition ) ;
	fin() ;
	ttastarm = 0 ;
}

vttoppage()
{
	topbot(1) ;
	return(1) ;
}


vtbotpage()
{
	topbot(0) ;
	return(1) ;
}


static topbot(dir)
int dir ;
{
	extern int curposition,*loclow,*lochigh ;
	register int temp ;

	scunloadline() ;
	temp = curposition ;
	creset() ;
	if (dir)
	  then *curline = *loclow ;
	  else *curline = *lochigh ;
	scloadline() ;
	if ( read_only == 0 ) then rstcursor(temp) ;
	chkselect() ;
	scmove () ;	
}




vtfirstpage()
{
	extern int curposition,*loclow,*lochigh ;

	scunloadline() ;
	creset() ;
	newpage(1) ;
	fin() ;
}


vtlastpage()
{
	extern int curposition,*loclow,*lochigh,*maxline ;
	register int temp ;

	scunloadline() ;
	creset() ;
	if ((temp = *maxline - page_size[termtype] - 1) < 1) then temp = 1 ;
	newpage(temp) ;
	fin() ;
}






vtnxtword()
{
	if ( atcrlf() ) 
	  then	vter() ;
	  else	{
		nextword() ;
		scmove() ;
		}
	return(1) ;
}
		

vtlstword()
{
	extern int chposition ;
	if ( chposition == 0 ) then vtel() ;
	lastword() ;
	scmove() ;
	return(1) ;
}


nextword()
{
	while ( atcrlf() == 0 && atworddelim() == 0 ) pinc() ;
	while ( atcrlf() == 0 && atworddelim() ) pinc() ;	
	return(1) ;
}


lastword()
{
	extern int chposition ;
	while ( chposition > 0 && atworddelim() == 0 ) pdec() ;
	while ( chposition > 0 && atworddelim() ) pdec() ;
	return(1) ;
}

vteoln()
{
	extern int linenext ;
	if ( linenext && atcrlf() )
	  then	vter() ;
	  else	{
		creset() ;
		findeoln() ;
		scmove() ;
		return(1) ;
		}
}
	

vtboln()
{
	creset() ;
	scmove() ;
	return(1) ;
}


vtbline()
{
	extern int chposition,doxla,worklength ;
	extern char workbuffer[] ;
	register char *cp ;
	register int i ;

	if ( doxla )
	  then	{
		cp = &workbuffer[chposition] ;
		for ( i=chposition; i<worklength; i++ ) *cp++ = tolower(*cp);
		txtmod() ;
		partdump() ;
		scmove() ;
		}
	creset() ;
	mvdown() ;
}



chkselect()
{
	extern int *curline,cut_st ;

	if ( cut_st > *curline )
	  then	{
		cut_st = 0 ;
		ledoff( l_select ) ;
		return(0) ;
		}
	  else	return(1) ;
}
