	.ENABLE SUBSTITUTION
	.ENABLE CONTROL-Z
	.ENABLE ESCAPE
	.DISABLE LOWERCASE
	.DISABLE QUIET
.;
.; File:	CALLBACK.CMD
.; Author:	Robin Miller
.; Date:	March 7, 1985
.;
.; Description:
.;
.;	This command file submits the callback batch job to have the
.; Hayes autodial modem call a phone number.
.;
.; Modification History:
.;
.; October 9, 1985 by Robin Miller.
.;   o	After getting the "CONNECT" message, program the Hays to return
.;	to command mode, disable echo and command codes, and then return
.;	back to the online state.  This will hopefully prevent problems
.;	with the Hayes calling you back after logging off the system.
.;   o	Add check for a user being privileged to run this command file.
.;
.; September 16, 1985 by Robin Miller.
.;	Do the setting of the terminal to /NOSLAVE as the last
.;	command to ensure the other SET commands complete.
.;
.; Inputs:
.;	P1	The phone number to dial.
.;	P2	The modem dialing speed.
.;	P3	The callback delay.
.;
.;-----------------------------------------------------------------
	.IFT <PRIVIL> .GOTO CHECK
;
;	You must be privileged in order to execute this command file
;	since the batch job it creates and submits performs privileged
;	MCR command lines.
;
	.EXIT
.;
.;	Find the physical terminal name for RM0:
.;
.;	Returns terminal string as "TTnn:.DAT" format.
.;
.CHECK:	.SETS CLI <CLI>				! Save the current CLI.
	.IF <CLI> <> "MCR" SET TERMINAL/MCR
	.TESTFILE TI0:
	.PARSE <FILSPC> "." TTY NULL
	.TESTFILE RM0:
	.PARSE <FILSPC> "." RMT NULL
	.IF TTY = RMT .GOTO INIT		! On the remote terminal.
.;
.;	Use the catchall CHECK command to ensure modem is available.
.;
	.ENABLE QUIET
	CHECK RM0:				! Check for availability.
	.DISABLE QUIET
	.IF <EXSTAT> = 1 .GOTO INIT		! If EQ, modem available.
;
;	The remote terminal is currently in use by another user.  If
;	you are submitting a batch job for execution at a later time,
;	then answer "Y"es to the next question to continue. Otherwise,
;	accept the default answer of "N"o to exit this procedure.
;
	.IFINS ...SHT SHT RM0:
	.IFNINS ...SHT DEV TT20:
;
	.ASK [<FALSE>] Z Do you wish to continue this procedure
	.IFT <EOF> .GOTO FINISH		! If true, user typed CTRL/Z.
	.IFF Z .GOTO FINISH		! If true, finish up now.
.;
.; Local definitions:
.;
.INIT:	.SETS PHODEF "RTM"		! The default phone number.
	.SETS SPEDEF "1200"		! The default baud rate.
	.SETS DLYDEF "30"		! The default callback delay.
	.SETN TRYDEF 3.			! The default retry count.
	.SETF $DLG			! Set for short dialogue.
.;
.;	Set up defaults incase parameters are passed.
.;
	.SETS PHONE "'P1'"		! Copy the phone number.
	.SETS SPEED "'P2'"		! Copy the dialing speed.
	.SETS DELAY "'P3'"		! Copy the callback delay.
	.IF P1 <> "" .GOTO DL10		! If NE, use short dialogue.
	.GOTO DLG
.DLGH:
;
;	Long dialogue results in a short explanation being displayed
;	before asking each question.  If you answer no, help is still
;	available on a per question basis by pressing the escape key.
;
.DLG:	.ASK $DLG Do you want long dialogue (<Escape> for explanation)
	.IFT <EOF> .GOTO FINISH		! If true, user typed CTRL/Z.
	.IFT <ESCAPE> .GOTO DLGH	! If true, give user some help.
.DL10:	.IF P1 <> "" .GOTO PH10		! If NE, number specified.
	.IFF $DLG .GOTO PHONEQ		! If false, skip long dialogue.
.PHONEH:
;
;	The next question requests the phone number to dial.  The Hayes
;	accepts punctuation characters such as "()-" or spaces.  The
;	total length of the phone number must not exceed 40 characters.
;	You can also specify a users' initials which gets translated to
;	the actual phone number.  The following initials are valid:
;
;		RTM	Robin Miller
;		DLSF	David Levan
;
.PHONEQ:.ASKS [::PHODEF] PHONE Enter the number to dial
	.IFT <EOF> .GOTO FINISH		! User typed CTRL/Z to exit.
	.IFT <ESCAPE> .GOTO PHONEH	! If true, give user some help.
.;
.;	Translate string to a phone number if we find a match.
.;
.PH10:	.IF PHONE <> "RTM" .GOTO PH20	! If NE, not this name.
	.SETS PHONE "9-432-8438"	! Set to phone Robin Miller.
	.GOTO PHEND			! Now ask for the speed.

.PH20:	.IF PHONE <> "DLSF" .GOTO PH30	! If NE, not this name.
	.SETS PHONE "6-613-726-1849"	! Set to phone Dave Levan.
	.GOTO PHEND			! Now ask for the speed.

.PH30:	.IF PHONE <> "JACK" .GOTO PH40	! If NE, not this name.
	.SETS PHONE "3000"		! Set to phone system JACK.
	.GOTO PHEND			! Now ask for the speed.
.;
.;	Add other user entrys at this point.
.;
.PH40:
.PHEND:	.IF P2 <> "" .GOTO SP10		! If NE, speed specified.
	.IFF $DLG .GOTO SPEEDQ		! If false, skip long dialogue.
.SPEEDH:
;
;	The next question requests the speed of the remote system you
;	are dialing.  This speed is used to set the Hayes auto-dialer
;	to the correct speed before dialing the phone numer. The Hayes
;	accepts speeds between 50-300 baud for low speed or 1200 baud
;	for high speed.
;
.SPEEDQ:.ASKS [::SPEDEF] SPEED Enter the dialing speed
	.IFT <EOF> .GOTO FINISH		! User typed CTRL/Z to exit.
	.IFT <ESCAPE> .GOTO SPEEDH	! If true, give user some help.

.SP10:	.IF P3 <> "" .GOTO DE10		! If NE, delay specified.
	.IFF $DLG .GOTO DELAYQ		! If false, skip long dialogue.
.DELAYH:
;
;	The next question requests the call back delay which is the
;	amount of time to delay before calling you back.  You can
;	either specify a numeric value which indicates the number of
;	seconds to delay, or a time/date string to be used with the
;	SUBMIT /AFTER switch.
;
;	The format of the time/date string is:
;
;		hh:mm:dd-mmm-yy
;
;	If you omit the date field, the current date is used.  If you
;	omit the time field, the colons "::" must still be specified.
;
.DELAYQ:.ASKS [::DLYDEF] DELAY Enter the call back delay
	.IFT <EOF> .GOTO FINISH		! User typed CTRL/Z to exit.
	.IFT <ESCAPE> .GOTO DELAYH	! If true, give user some help.
.;
.;	If the string has a colon in it, presume /AFTER string.
.;
.DE10:	.SETS AFTER ""			! Presume no after string.
	.TEST DELAY ":"			! Was /AFTER string specified ?
	.IF <STRLEN> = 0 .GOTO DE20	! If EQ, no.
	.SETS AFTER "/AFTER:'DELAY'"	! Yes, copy the after string.
	.SETS DELAY "0"			! Set for no callback delay.
.DE20:
.;
.;	.ASKN [::TRYDEF] TRYS Enter the response retrys
.;	.IFT <EOF> .GOTO FINISH		! User typed CTRL/Z to exit.
	.SETN TRYS TRYDEF		! Set the default retry count.
.;
.;	Create the command file and submit it to batch.
.;
	.OPEN #0 '<LOGUIC>'DMB.CMD
.ENABLE DATA #0
	.ENABLE SUBSTITUTION
;
; File: 	DMB.CMD
; Author:	Robin Miller
; Date: 	'<DATE>'
;
; Description:
;
;	This command file is used to program the Hayes modem to dial
; a phone number.
;
;------------------------------------------------------------------------------
;
; Delay to give the user enough time to logoff before we dial them back.
;
	.DELAY 'DELAY'.S
;
; If the CLI is set to DCL, set it to MCR so commands will work.
;
	.IF <CLI> = "DCL" SET TERMINAL/MCR
;
; See if the remote terminal is available.
;
	CHECK RM0:			! Check for availability.
	.IF <EXSTAT> = 1 .GOTO CH10	! If EQ, modem available.
;
; The remote terminal is either attached or a user is logged on.
; Therefore, this command procedure will now exit.  *** Bye ***.
;
	.GOTO DONE			! Exit the command file.
.CH10:
;
; Setup the terminal characteristics to prevent echo back.
;
	SET /FDX=RM0:
	.IF <EXSTAT> <> 1 .GOTO DONE	! If NE, SET terminal error.
	SET /SLAVE=RM0:
	SET /NOECHO=RM0:
	SET /TYPEAHEAD=RM0:
	SET /SPEED=RM0:'SPEED':'SPEED'
;
; Set the speed and parity and reset the modem.
;
	.SETS CMD "ATZ"			! Set the Hayes command string.
	.GOSUB DOCMD			! Send the Hayes the command.
;
; Disable the Hayes echo.
;
	.SETS CMD "ATE0"		! Set the Hayes command string.
	.GOSUB DOCMD			! Send the Hayes the command.
;
; Enable extended respones.
;
	.SETS CMD "ATX1"		! Set the Hayes command string.
	.GOSUB DOCMD			! Send the Hayes the command.
.;
.; Change the wait for carrier from 30 to 45 seconds.
.;
.;	.SETS CMD "ATS7=45"		! Set the Hayes command string.
.;	.GOSUB DOCMD			! Send the Hayes the command.
;
; Change the escape code to "~"
;
	.SETS CMD "ATS2=126"		! Set the Hayes command string.
	.GOSUB DOCMD			! Send the Hayes the command.
;
; Dial the phone number.
;
; The next commands send the phone number to the Hayes, and then
; waits for the "CONNECT" message.  If this message is not received,
; the port is not set interactive to prevent loopback problems with
; the modem.
;
; The plus sign "+" echoes the data read from the modem.
;
	.SETN RETRYS 'TRYS'		! Set the maximum retrys.
.PHONE:	SEND RM0:ATDT'PHONE'+
	WAIT/D:30 RM0:CONNECT+
	.IF <EXSTAT> = 1 .GOTO ONLINE	! If EQ, we are online.
	.DEC RETRYS			! Adjust the retry count,
	.IF RETRYS = 0 .GOTO NOCON	! If EQ, retrys exceeded.
;
; Did not get the CONNECT message so retry the phone number.
;
	.DELAY 5S			! Wait for a little while.
	.GOTO PHONE			! Else, redial the number.
;
; At this point the terminal is still set no echo and slave.
;
.ONLINE:
;
; Send the escape code three times to break back into command mode.
;
; The "++" causes the characters to be sent without carriage control.
;
	.SETN RETRYS 'TRYS'		! Set the maximum retrys.
.ON10:	SEND RM0:~~~++
	WAIT/D:2 RM0:OK+
	.IF <EXSTAT> = 1 .GOTO ON20	! If EQ, got "OK" response.
	.DEC RETRYS			! Adjust the retry count.
	.IF RETRYS = 0 .GOTO ON50	! If EQ, retrys exceeded.
	.GOTO ON10			! Else, retry the command.
;
; Send the command to disable command codes (Q1).
;
.ON20:	SEND RM0:ATQ1+
.;	.DELAY 1S			! Wait for previous command.
;
; Now setup the terminal characteristics to allow login.
;
.ON50:	SET /BRO=RM0:
	SET /ECHO=RM0:
	SET /LOWER=RM0:
	SET /VT100=RM0:
;
; Now we can go back online to let the user login.  Since command
; codes have been disabled, we can not check for a response.
;
	.SETN RETRYS 'TRYS'		! Set the maximum retrys.
.ON60:	SEND RM0:ATO+
	.DELAY 1S			! Wait for the last command.
	SEND RM0:"Press the RETURN key in 2 second intervals to login."
	WAIT/D:5 RM0:
	.IF <EXSTAT> = 1 .GOTO ON70	! If EQ, something entered.
	.DEC RETRYS			! Adjust the retry count,
	.IF RETRYS <> 0 .GOTO ON60	! If NE, retry the command.

.ON70:	SET /NOSLAVE=RM0:
	.EXIT				! Exit, we are all finished.
.;+
.;
.; DOCMD - Do a Hayes command.
.;
.; This routine is used to send the Hayes a command code and then wait
.; for the "OK" response code.  The routine will retry the command up
.; to the retry limit if the "OK" response is not received.  If the
.; "OK" response is not received, we jump to the error routine.
.;
.; Inputs:
.;	CMD = The command to send the Hayes.
.;
.;-
.DOCMD:
	.SETN RETRYS 'TRYS'		! Set the maximum retrys.
.DISABLE DATA
	.DISABLE SUBSTITUTION
	.DATA #0 .DO10:	SEND RM0:'CMD'+
	.ENABLE SUBSTITUTION
.ENABLE DATA #0
	WAIT RM0:OK+
	.IF <EXSTAT> = 1 .GOTO DO20	! If EQ, received the "OK".
	.INC RETRYS			! Else, adjust the retry counter.
	.IF RETRYS <> 0 .GOTO DO10	! If NE, retry the last command.
;
; Did not receive the "OK" response from the Hayes modem.
;
	.EXIT				! Exit the command file.

.DO20:	.RETURN
.;+
.;
.; NOCON - No "CONNECT" message received.
.;
.; This routine is entered when the connect message is not received
.; from the Hayes modem.  It simply hangs up the modem and then exits.
.;
.;-
.NOCON:	HANGUP RM0:
	.DELAY 5S			! Delay for several seconds.
;
; Send the command to disable command codes (Q1).
;
	SEND RM0:ATQ1+
	WAIT/D:2 RM0:OK+
;
; Did not receive the "CONNECT" response from the Hayes.
;
.DONE:	.EXIT				! Exit the command file.
.DISABLE DATA
	.CLOSE #0
.;
.;	The batch command file is built, now generate the batch job.
.;
	.OPEN #0 '<LOGUIC>'CALLBACK.BAT
.ENABLE DATA #0
$JOB SYSTEM '<LOGUIC>'
$@'<LOGUIC>'DMB.CMD
$EOJ
.DISABLE DATA
	.CLOSE #0
.;
.;	All files generated, cleanup and submit the batch job.
.;
	PIP '<LOGUIC>'DMB.*/PU:2/NM,CALLBACK.BAT,.LOG
	SUBMIT CALLBACK/NOPRINT'AFTER'='<LOGUIC>'CALLBACK.BAT
	QUE /FU:BATCH
.;
.;	We come here when we are finished.  Reset CLI if changed.
.;
.FINISH:.IF CLI <> "MCR" SET /DCL=TI:
