	PAGE 59, 132

	TITLE MsIntrfc -- Interface between generic and machine-specific code

; Update 6 Jan 86

IF1
 %OUT >> Starting pass 1
ELSE
 %OUT >> Starting pass 2
ENDIF

	PUBLIC Count, XofSnt, Source, SrcPnt, Preload_buffer, Preload_flag
	PUBLIC Get_Set_Key_table_size, Simulate_port_char
	PUBLIC Type_to_screen, Parse_for_Set_Key

	.LALL			; Show the macro expansions
	.LFCOND			; List false conditionals

	INCLUDE MsDefs.H

DataS	SEGMENT PUBLIC 'DataS'

	EXTRN PC_Type:BYTE, SetKTab_PC:BYTE, SetKHlp_PC:BYTE

Preload_flag DB 0		; Flag to say we have preloaded a command
Preload_buffer DB 256 DUP (?)	; Buffer to hold a preloaded command

IF RB_Flag
	EXTRN SetKTab_RB:BYTE, SetKHlp_RB:BYTE
ENDIF

Count	DW 0			; Count of chars in port buffer
XofSnt	DB 0			; Flag that an XOFF has been sent
SrcPnt	DW 0			; Pointer into buffer (DI)

Source	DB BufSiz DUP(?)	; Buffer for data from port

DataS	ENDS

Code	SEGMENT PUBLIC

	EXTRN Comnd:NEAR

	ASSUME cs:Code, ds:DataS, es:DataS

Rtn	MACRO NamRtn

	PUBLIC NamRtn
NamRtn:

IF RB_Flag
	call Check_type 	; Is machine type Rainbow?
	 je NamRtn&_is_RB	;  Yes
ENDIF

	EXTRN NamRtn&_PC:NEAR
	jmp NamRtn&_PC		; Default to IBM PC

IF RB_Flag
	EXTRN NamRtn&_RB:NEAR
NamRtn&_is_RB:
	jmp NamRtn&_RB	; Type is DEC Rainbow
ENDIF

	ENDM

Check_type PROC

	push ax			; Save a reg
	mov al, PC_Type		; Get machine type
	cmp al, 2		; Rainbow?
	pop ax			; Restore reg
	ret			; Return with Z flag set if Rainbow

Check_type ENDP

Routines PROC

	Rtn Term		; Entry to terminal emulator
	Rtn SerIni
	Rtn SerRst
	Rtn Drop_DTR
	Rtn ClrBuf
	Rtn OutChr
	Rtn Coms
;	Rtn VTS
	Rtn DoDel
	Rtn CtlU
	Rtn CmBlnk
	Rtn Locate
	Rtn LclIni

 %OUT >> About half way through source file

	Rtn PrtChr
	Rtn DoBaud
	Rtn ClearL
	Rtn DoDisk
	Rtn GetBaud
	Rtn Beep
	Rtn PutHlp
	Rtn PutMod
	Rtn ClrMod
	Rtn PosCur
	Rtn SendBr
	Rtn ShowKey
	Rtn Close_screen
	Rtn Set_up_script_processor

; Routine to parse for the SET KEY command, which is machine-specific

Parse_for_Set_Key:

IF RB_Flag
	mov dx, OFFSET SetKTab_RB ; Assume Rainbow for now
	mov bx, OFFSET SetKHlp_RB

	call Check_type		; Are we running on a Rainbow?
	 je PRS_1		;  Yes ...
ENDIF

	mov dx, OFFSET SetKTab_PC ; No, default to IBM
	mov bx, OFFSET SetKHlp_PC

PRS_1:	mov ah, CmKey
	call Comnd
	 ret			; Failure -- return non-skip
	 nop
	 nop

	pop bp			; Return skip
	add bp, 3
	push bp
        ret

; Routine to return size of Set Key table, machine-specific

Get_Set_Key_table_size:

IF RB_Flag
	mov al, SetKTab_RB	; Assume Rainbow for now

	call Check_type		; Are we running on a Rainbow?
	 je GSK_1		;  Yes ...
ENDIF

	mov al, SetKTab_PC	; No, default to IBM

GSK_1:	ret			; Done here

Routines ENDP


; Simulate receiving a char from port -- used by script's PRINT command (and
;  others)
;
; Call with char in al reg

Simulate_port_char PROC

	cmp Count, BufSiz	; Room for another character?
	 jl SPC_0		;  Yes

	ret			; No room, do nothing

SPC_0:	push di			; Save a reg
	mov di, SrcPnt		; Registers for storing data
	cld			; Forwards
	stosb			; Store the character in the buffer
	cmp di, OFFSET Source + BufSiz ; At end of buffer?
	 jb SPC_1		;  Not yet

	mov di, OFFSET Source	; Wrap buffer around

SPC_1:	inc Count		; Bump up the count
	mov SrcPnt, di		; Store the updated pointer
	pop di			; Restore reg
	ret			; That's it

Simulate_port_char ENDP

Type_to_screen PROC

	call Simulate_port_char	; Cheat
	cmp al, Cr		; Was it a Cr?
	 jne R			;  No

	push ax			; Save old value

	mov al, Lf		; Yes, load up an Lf
	call Simulate_port_char	; Turn screen Cr's into CrLf's

	pop ax			; Get back original char

R:	ret			; Done here

Type_to_screen ENDP


Code	ENDS

	END

